/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.jena.RdfXmlParser;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class CommonTest {
    private RdfSerializerBuilder getBasicSerializer() {
        return RdfSerializer.create().sq().useWhitespace(false).set("RdfCommon.jena.rdfXml.allowBadURIs.b", (Object)true).set("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b", (Object)false).set("RdfCommon.jena.rdfXml.showXmlDeclaration.s", (Object)false);
    }

    private String strip(String s) {
        return s.replaceFirst("<rdf:RDF[^>]+>\\s*", "").replaceAll("</rdf:RDF>$", "").trim().replaceAll("[\\r\\n]", "");
    }

    @Test
    public void testTrimNullsFromBeans() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        A t1 = A.create();
        s.trimNullProperties(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:s1 rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><jp:s2>s2</jp:s2></rdf:Description>", (Object)this.strip(r));
        A t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimNullProperties(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:s2>s2</jp:s2></rdf:Description>", (Object)this.strip(r));
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
    }

    @Test
    public void testTrimEmptyMaps() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        B t1 = B.create();
        s.trimEmptyMaps(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f1 rdf:parseType='Resource'></jp:f1><jp:f2 rdf:parseType='Resource'><jp:f2a rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><jp:f2b rdf:parseType='Resource'><jp:s2>s2</jp:s2></jp:f2b></jp:f2></rdf:Description>", (Object)this.strip(r));
        B t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyMaps(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f2 rdf:parseType='Resource'><jp:f2a rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><jp:f2b rdf:parseType='Resource'><jp:s2>s2</jp:s2></jp:f2b></jp:f2></rdf:Description>", (Object)this.strip(r));
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
        s.trimEmptyMaps();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f2 rdf:parseType='Resource'><jp:f2a rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><jp:f2b rdf:parseType='Resource'><jp:s2>s2</jp:s2></jp:f2b></jp:f2></rdf:Description>", (Object)this.strip(r));
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
    }

    @Test
    public void testTrimEmptyLists() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        C t1 = C.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f1><rdf:Seq/></jp:f1><jp:f2><rdf:Seq><rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><rdf:li rdf:parseType='Resource'><jp:s2>s2</jp:s2></rdf:li></rdf:Seq></jp:f2></rdf:Description>", (Object)this.strip(r));
        C t2 = (C)p.parse(r, C.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f2><rdf:Seq><rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><rdf:li rdf:parseType='Resource'><jp:s2>s2</jp:s2></rdf:li></rdf:Seq></jp:f2></rdf:Description>", (Object)this.strip(r));
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
        t2 = (C)p.parse(r, C.class);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f2><rdf:Seq><rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><rdf:li rdf:parseType='Resource'><jp:s2>s2</jp:s2></rdf:li></rdf:Seq></jp:f2></rdf:Description>", (Object)this.strip(r));
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
        t2 = (C)p.parse(r, C.class);
    }

    @Test
    public void testTrimEmptyArrays() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        D t1 = D.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f1><rdf:Seq/></jp:f1><jp:f2><rdf:Seq><rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><rdf:li rdf:parseType='Resource'><jp:s2>s2</jp:s2></rdf:li></rdf:Seq></jp:f2></rdf:Description>", (Object)this.strip(r));
        D t2 = (D)p.parse(r, D.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f2><rdf:Seq><rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><rdf:li rdf:parseType='Resource'><jp:s2>s2</jp:s2></rdf:li></rdf:Seq></jp:f2></rdf:Description>", (Object)this.strip(r));
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:f2><rdf:Seq><rdf:li rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/><rdf:li rdf:parseType='Resource'><jp:s2>s2</jp:s2></rdf:li></rdf:Seq></jp:f2></rdf:Description>", (Object)this.strip(r));
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
    }

    @Test
    public void testBeanPropertyProperties() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        E1 t1 = E1.create();
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<rdf:Description><jp:x1 rdf:parseType='Resource'><jp:f1>1</jp:f1></jp:x1><jp:x2 rdf:parseType='Resource'><jp:f1>1</jp:f1></jp:x2><jp:x3><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:f1>1</jp:f1></rdf:li></rdf:Seq></jp:x3><jp:x4><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:f1>1</jp:f1></rdf:li></rdf:Seq></jp:x4><jp:x5><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:f1>1</jp:f1></rdf:li></rdf:Seq></jp:x5><jp:x6><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:f1>1</jp:f1></rdf:li></rdf:Seq></jp:x6></rdf:Description>", (Object)this.strip(r));
        E1 t2 = (E1)p.parse(r, E1.class);
        TestUtils.assertEqualObjects(t1, t2);
    }

    @Test
    public void testBeanPropertyProperiesOnListOfBeans() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        LinkedList<F> l1 = new LinkedList<F>();
        F t = F.create();
        t.x1.add(F.create());
        l1.add(t);
        String r = s.build().serialize(l1);
        Assert.assertEquals((Object)"<rdf:Seq><rdf:li rdf:parseType='Resource'><jp:x1><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:x2>2</jp:x2></rdf:li></rdf:Seq></jp:x1><jp:x2>2</jp:x2></rdf:li></rdf:Seq>", (Object)this.strip(r));
        List l2 = (List)p.parse(r, LinkedList.class, new Type[]{F.class});
        TestUtils.assertEqualObjects(l1, l2);
    }

    @Test
    public void testURIAttr() throws Exception {
        RdfSerializerBuilder s = this.getBasicSerializer();
        RdfXmlParser p = RdfXmlParser.DEFAULT;
        G t = new G();
        t.uri = new URI("http://uri");
        t.f1 = new URI("http://f1");
        t.f2 = new URL("http://f2");
        String xml = s.build().serialize((Object)t);
        t = (G)p.parse(xml, G.class);
        Assert.assertEquals((Object)"http://uri", (Object)t.uri.toString());
        Assert.assertEquals((Object)"http://f1", (Object)t.f1.toString());
        Assert.assertEquals((Object)"http://f2", (Object)t.f2.toString());
    }

    @Test
    public void testRecursion() throws Exception {
        String msg;
        RdfSerializerBuilder s = RdfSerializer.create().xmlabbrev().sq();
        R1 r1 = new R1();
        R2 r2 = new R2();
        R3 r3 = new R3();
        r1.r2 = r2;
        r2.r3 = r3;
        r3.r1 = r1;
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            TestUtils.assertContains(msg, "It's recommended you use the BeanTraverseContext.BEANTRAVERSE_detectRecursions setting to help locate the loop.");
        }
        s.detectRecursions();
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            Assert.assertTrue((boolean)msg.contains("[0] root:org.apache.juneau.jena.CommonTest$R1"));
            Assert.assertTrue((boolean)msg.contains("->[1] r2:org.apache.juneau.jena.CommonTest$R2"));
            Assert.assertTrue((boolean)msg.contains("->[2] r3:org.apache.juneau.jena.CommonTest$R3"));
            Assert.assertTrue((boolean)msg.contains("->[3] r1:org.apache.juneau.jena.CommonTest$R1"));
        }
        s.ignoreRecursions();
        String r = s.build().serialize((Object)r1).replace("\r", "");
        Assert.assertTrue((boolean)r.contains("<rdf:Description>\n<jp:name>foo</jp:name>\n<jp:r2 rdf:parseType='Resource'>\n<jp:name>bar</jp:name>\n<jp:r3 rdf:parseType='Resource'>\n<jp:name>baz</jp:name>\n</jp:r3>\n</jp:r2>\n</rdf:Description>\n</rdf:RDF>\n"));
        Assert.assertTrue((boolean)r.contains("xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        Assert.assertTrue((boolean)r.contains("xmlns:j='http://www.apache.org/juneau/"));
        Assert.assertTrue((boolean)r.contains("xmlns:jp='http://www.apache.org/juneaubp/"));
    }

    public static class R3 {
        public String name = "baz";
        public R1 r1;
    }

    public static class R2 {
        public String name = "bar";
        public R3 r3;
    }

    public static class R1 {
        public String name = "foo";
        public R2 r2;
    }

    public static class G {
        @Rdf(beanUri=true)
        public URI uri;
        public URI f1;
        public URL f2;
    }

    public static class F {
        @Beanp(properties="x2")
        public List<F> x1;
        public int x2;

        public static F create() {
            F t = new F();
            t.x1 = new LinkedList<F>();
            t.x2 = 2;
            return t;
        }
    }

    public static class E2 {
        public int f1 = 1;
        public int f2 = 2;
    }

    public static class E1 {
        @Beanp(properties="f1")
        public E2 x1;
        @Beanp(properties="f1")
        public Map<String, Integer> x2;
        @Beanp(properties="f1")
        public E2[] x3;
        @Beanp(properties="f1")
        public List<E2> x4;
        @Beanp(properties="f1")
        public ObjectMap[] x5;
        @Beanp(properties="f1")
        public List<ObjectMap> x6;

        public static E1 create() {
            E1 t = new E1();
            t.x1 = new E2();
            t.x2 = new AMap().append((Object)"f1", (Object)1).append((Object)"f2", (Object)2);
            t.x3 = new E2[]{new E2()};
            t.x4 = new AList().append((Object)new E2());
            t.x5 = new ObjectMap[]{new ObjectMap().append("f1", (Object)"1").append("f2", (Object)"2")};
            t.x6 = new AList().append((Object)new ObjectMap().append("f1", (Object)"1").append("f2", (Object)"2"));
            return t;
        }
    }

    public static class D {
        public A[] f1;
        public A[] f2;

        public static D create() {
            D t = new D();
            t.f1 = new A[0];
            t.f2 = new A[]{null, A.create()};
            return t;
        }
    }

    public static class C {
        public List<A> f1;
        public List<A> f2;

        public static C create() {
            C t = new C();
            t.f1 = new AList();
            t.f2 = new AList().append(null).append((Object)A.create());
            return t;
        }
    }

    public static class B {
        public TreeMap<String, A> f1;
        public TreeMap<String, A> f2;

        public static B create() {
            B t = new B();
            t.f1 = new TreeMap();
            t.f2 = new TreeMap<String, A>(){
                {
                    this.put("f2a", null);
                    this.put("f2b", A.create());
                }
            };
            return t;
        }
    }

    public static class A {
        public String s1;
        public String s2;

        public static A create() {
            A t = new A();
            t.s2 = "s2";
            return t;
        }
    }
}

