/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSession;
import org.junit.Assert;
import org.junit.Test;

public class CommonParserTest {
    private String wrap(String in) {
        return "<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:j='http://www.apache.org/juneau/' xmlns:jp='http://www.apache.org/juneaubp/'>" + in + "</rdf:RDF>";
    }

    private String strip(String s) {
        return s.replaceFirst("<rdf:RDF[^>]+>\\s*", "").replaceAll("</rdf:RDF>$", "").trim().replaceAll("[\\r\\n]", "");
    }

    private RdfSerializerBuilder getBasicSerializer() {
        return RdfSerializer.create().sq().addLiteralTypes().useWhitespace(false).set("RdfCommon.jena.rdfXml.allowBadURIs.b", (Object)true).set("RdfCommon.jena.rdfXml.showDoctypeDeclaration.b", (Object)false).set("RdfCommon.jena.rdfXml.showXmlDeclaration.s", (Object)false);
    }

    @Test
    public void testFromSerializer() throws Exception {
        RdfSerializer s = this.getBasicSerializer().build();
        RdfParser p = RdfParser.create().xml().trimWhitespace().build();
        Map m = null;
        Integer one = 1;
        String in = this.wrap("<rdf:Description><jp:a rdf:datatype='http://www.w3.org/2001/XMLSchema#int'>1</jp:a></rdf:Description>");
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)one, m.get("a"));
        in = this.wrap("<rdf:Description><jp:a rdf:datatype='http://www.w3.org/2001/XMLSchema#int'>1</jp:a><jp:b>foo bar</jp:b><jp:c rdf:datatype='http://www.w3.org/2001/XMLSchema#boolean'>false</jp:c></rdf:Description>");
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)one, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        in = this.wrap("<rdf:Description><jp:a rdf:datatype='http://www.w3.org/2001/XMLSchema#int'> 1 </jp:a><jp:b> foo bar </jp:b><jp:c rdf:datatype='http://www.w3.org/2001/XMLSchema#boolean'> false </jp:c></rdf:Description>");
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)one, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        Assert.assertEquals((Object)false, m.get("c"));
        in = this.wrap("<rdf:Description><jp:x>org.apache.juneau.test.Person</jp:x><jp:addresses><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:x>org.apache.juneau.test.Address</jp:x><jp:city>city A</jp:city><jp:state>state A</jp:state><jp:street>street A</jp:street><jp:zip rdf:datatype='http://www.w3.org/2001/XMLSchema#int'>12345</jp:zip></rdf:li></rdf:Seq></jp:addresses></rdf:Description>");
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)"org.apache.juneau.test.Person", m.get("x"));
        List l = (List)m.get("addresses");
        Assert.assertNotNull((Object)l);
        m = (Map)l.get(0);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"org.apache.juneau.test.Address", m.get("x"));
        Assert.assertEquals((Object)"city A", m.get("city"));
        Assert.assertEquals((Object)"state A", m.get("state"));
        Assert.assertEquals((Object)"street A", m.get("street"));
        Assert.assertEquals((Object)12345, m.get("zip"));
        in = this.wrap("<rdf:Seq><rdf:li rdf:parseType='Resource'><jp:attribute>value</jp:attribute></rdf:li><rdf:li rdf:parseType='Resource'><jp:attribute>value</jp:attribute></rdf:li></rdf:Seq>");
        ObjectList jl = (ObjectList)p.parse(in, Object.class);
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(0).getString("attribute"));
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(1).getString("attribute"));
        Assert.assertNull((Object)p.parse((Object)null, Object.class));
        Assert.assertNull((Object)p.parse(this.wrap(""), Object.class));
        Assert.assertNull((Object)p.parse(this.wrap("   "), Object.class));
        Assert.assertNull((Object)p.parse(this.wrap("   \t"), Object.class));
        Assert.assertNull((Object)p.parse(this.wrap("   <!--foo-->"), Object.class));
        Assert.assertNull((Object)p.parse(this.wrap("   <!--foo-->   "), Object.class));
        Assert.assertNull((Object)p.parse(this.wrap("   //foo   "), Object.class));
        A1 t1 = new A1();
        A2 t2 = new A2();
        t2.add(new A3("name0", "value0"));
        t2.add(new A3("name1", "value1"));
        t1.list = t2;
        s = this.getBasicSerializer().addBeanTypes(true).addRootType().build();
        in = this.strip(s.serialize((Object)t1));
        Assert.assertEquals((Object)"<rdf:Description><jp:_type>A1</jp:_type><jp:list><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:name>name0</jp:name><jp:value>value0</jp:value></rdf:li><rdf:li rdf:parseType='Resource'><jp:name>name1</jp:name><jp:value>value1</jp:value></rdf:li></rdf:Seq></jp:list></rdf:Description>", (Object)in);
        in = this.wrap(in);
        t1 = (A1)p.parse(in, A1.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)t1.list.get((int)1)).value);
    }

    @Test
    public void testCorrectHandlingOfUnknownProperties() throws Exception {
        RdfParser p = RdfParser.create().xml().ignoreUnknownBeanProperties().build();
        String in = this.wrap("<rdf:Description><jp:a rdf:datatype='http://www.w3.org/2001/XMLSchema#int'>1</jp:a><jp:unknownProperty>foo</jp:unknownProperty><jp:b rdf:datatype='http://www.w3.org/2001/XMLSchema#int'>2</jp:b></rdf:Description>");
        B t = (B)p.parse(in, B.class);
        Assert.assertEquals((long)t.a, (long)1L);
        Assert.assertEquals((long)t.b, (long)2L);
        try {
            p = RdfParser.create().xml().build();
            p.parse(in, B.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testCollectionPropertiesWithNoSetters() throws Exception {
        RdfParser p = RdfParser.create().xml().build();
        String in = this.wrap("<rdf:Description><jp:ints><rdf:Seq><rdf:li>1</rdf:li><rdf:li>2</rdf:li></rdf:Seq></jp:ints><jp:beans><rdf:Seq><rdf:li rdf:parseType='Resource'><jp:a>1</jp:a><jp:b>2</jp:b></rdf:li></rdf:Seq></jp:beans></rdf:Description>");
        C t = (C)p.parse(in, C.class);
        Assert.assertEquals((long)t.getInts().size(), (long)2L);
        Assert.assertEquals((long)t.getBeans().get((int)0).b, (long)2L);
    }

    @Test
    public void testParserListeners() throws Exception {
        RdfParser p = RdfParser.create().xml().ignoreUnknownBeanProperties().listener(MyParserListener.class).build();
        String in = this.wrap("<rdf:Description><jp:a rdf:datatype='http://www.w3.org/2001/XMLSchema#int'>1</jp:a><jp:unknownProperty>foo</jp:unknownProperty><jp:b rdf:datatype='http://www.w3.org/2001/XMLSchema#int'>2</jp:b></rdf:Description>");
        p.parse(in, B.class);
        Assert.assertEquals((long)1L, (long)MyParserListener.events.size());
        Assert.assertEquals((Object)"unknownProperty, line 1, column 0", (Object)MyParserListener.events.get(0));
    }

    public static class MyParserListener
    extends ParserListener {
        static final List<String> events = new LinkedList<String>();

        public <T> void onUnknownBeanProperty(ParserSession session, String propertyName, Class<T> beanClass, T bean) {
            events.add(propertyName + ", " + session.getPosition());
        }
    }

    public static class C {
        private Collection<Integer> ints = new LinkedList<Integer>();
        private List<B> beans = new LinkedList<B>();

        public Collection<Integer> getInts() {
            return this.ints;
        }

        public List<B> getBeans() {
            return this.beans;
        }
    }

    public static class B {
        public int a;
        public int b;
    }

    public static class A3 {
        public String name;
        public String value;

        public A3() {
        }

        public A3(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class A2
    extends LinkedList<A3> {
    }

    @Bean(typeName="A1")
    public static class A1 {
        public A2 list;
    }
}

