/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.Arrays;
import java.util.Collection;
import org.apache.juneau.internal.VersionRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VersionRangeTest {
    private VersionRange range;
    private String version;
    private boolean shouldMatch;

    @Parameterized.Parameters
    public static Collection<Object[]> getPairs() {
        return Arrays.asList({"1.1", "1.1.3", true}, {"1.1", "1.1", true}, {"1.1", "1.1.0", true}, {"1.1", "1.0", false}, {"1.1", "1.0.9", false}, {"[1.0,2.0)", ".9", false}, {"[1.0,2.0)", "1", true}, {"[1.0,2.0)", "1.0", true}, {"[1.0,2.0)", "1.0.0", true}, {"[1.0,2.0)", "1.1", true}, {"[1.0,2.0)", "2.0", false}, {"[1.0,2.0)", "2", false}, {"(1.0,2.0]", "2", true}, {"(1.0,2.0]", "2.0", true}, {"(1.0,2.0]", "2.0.1", true}, {"(1.0,2.0]", "2.1", false}, {"(.5.0,.6]", ".5", false}, {"(.5.0,.6]", ".5.1", true}, {"(.5.0,.6]", ".6", true}, {"(.5.0,.6]", ".6.1", true}, {"(.5.0,.6]", ".7", false}, {"[1.1,2.0)", "1", false});
    }

    public VersionRangeTest(String range, String version, boolean shouldMatch) {
        this.version = version;
        this.range = new VersionRange(range);
        this.shouldMatch = shouldMatch;
    }

    @Test
    public void test() throws Exception {
        Assert.assertEquals((Object)this.shouldMatch, (Object)this.range.matches(this.version));
    }
}

