/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.https;

import java.util.Arrays;
import java.util.Collection;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ContentTypeTest {
    private String label;
    private String contentType;
    private String mediaTypes;
    private int expected;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({"SimpleMatch-1", "text/json", "['text/json']", 0}, {"SimpleMatch-2", "text/json", "['text/json','text/foo']", 0}, {"SimpleMatch-3", "text/json", "['text/foo','text/json']", 1}, {"SimpleNoMatch-1", "text/jsonx", "['text/json']", -1}, {"SimpleNoMatch-2", "text/jso", "['text/json']", -1}, {"SimpleNoMatch-3", "text/json", "['application/json']", -1}, {"SimpleNoMatch-4", "text/json", "[]", -1}, {"XmlAndRdf-1", "text/xml+rdf", "['text/xml','text/xml+rdf']", 1}, {"XmlAndRdf-2", "text/xml+rdf", "['text/xml+rdf','text/xml']", 0}, {"Fuzzy-1", "text/1+2", "['text/1+2']", 0}, {"Fuzzy-2", "text/2+1", "['text/1+2']", 0}, {"Fuzzy-3", "text/1+2", "['text/1']", 0}, {"Fuzzy-4", "text/1", "['text/1+2']", -1}, {"Fuzzy-5", "text/1+2", "['text/1','text/1+3']", 0}, {"Fuzzy-6", "text/1+2", "['text/1','text/1+2','text/1+2+3']", 1}, {"Fuzzy-7", "text/1+2", "['text/1+2+3','text/1','text/1+2']", 2}, {"Fuzzy-8", "text/1+2", "['text/3+2+1','text/1','text/2+1']", 2}, {"Fuzzy-9", "text/1+2+3+4", "['text/1+2','text/1+2+3']", 1}, {"Fuzzy-10", "text/1+2+3+4", "['text/1+2+3','text/1+2']", 0}, {"Fuzzy-11", "text/4+2+3+1", "['text/1+2+3','text/1+2']", 0}, {"Fuzzy-12", "text/4+2+3+1", "['text/1+2','text/1+2+3']", 1});
    }

    public ContentTypeTest(String label, String contentType, String mediaTypes, int expected) {
        this.label = label;
        this.contentType = contentType;
        this.mediaTypes = mediaTypes;
        this.expected = expected;
    }

    @Test
    public void test() throws Exception {
        ContentType ct = ContentType.forString((String)this.contentType);
        MediaType[] mt = (MediaType[])JsonParser.DEFAULT.parse(this.mediaTypes, MediaType[].class);
        int r = ct.findMatch(mt);
        TestUtils.assertEquals(this.expected, r, "{0} failed", this.label);
    }
}

