/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.https;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.juneau.http.Accept;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AcceptTest {
    private String label;
    private String accept;
    private String mediaTypes;
    private int expected;
    private int expectedReverse;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({"SimpleMatch-1", "text/json", "['text/json']", 0, 0}, {"SimpleMatch-2", "text/json", "['text/json','text/foo']", 0, 0}, {"SimpleMatch-3", "text/json", "['text/foo','text/json']", 1, 1}, {"SimpleNoMatch-1", "text/jsonx", "['text/json']", -1, -1}, {"SimpleNoMatch-2", "text/jso", "['text/json']", -1, -1}, {"SimpleNoMatch-3", "text/json", "['application/json']", -1, -1}, {"SimpleNoMatch-4", "text/json", "[]", -1, -1}, {"MetaMatch-1", "text/*", "['text/a','text/b+c','text/b+d+e']", 0, 2}, {"MetaMatch-2", "text/b+*", "['text/a','text/b+c','text/b+d+e']", 1, 2}, {"MetaMatch-3", "text/c+*", "['text/a','text/b+c','text/b+d+e']", 1, 1}, {"MetaMatch-4", "text/b+d+e", "['text/a','text/b+c','text/b+d']", -1, -1}, {"MetaMatch-5", "text/b+*", "['text/a','text/b+c','text/b+d+e']", 1, 2}, {"MetaMatch-6", "text/d+e+*", "['text/a','text/b+c','text/b+d+e']", 2, 2}, {"MetaMatch-7", "*/a", "['text/a','application/b']", 0, 0}, {"MetaMatch-8", "*/*", "['text/a','text/b+c']", 0, 1}, {"MetaMatch-9", "*/*", "['text/b+c','text/a']", 0, 1}, {"RevMetaMatch-1", "text/a", "['text/*']", 0, 0}, {"RevMetaMatch-2", "text/a", "['*/a']", 0, 0}, {"RevMetaMatch-3", "text/a", "['*/*']", 0, 0}, {"MixedMetaMatch-1", "text/*", "['text/*','text/a','text/a+b','text/b+c','text/d+*']", 0, 0}, {"MixedMetaMatch-2", "*/a", "['text/*','text/a','text/a+b','text/b+c','text/d+*']", 1, 1}, {"MixedMetaMatch-3", "*/*", "['text/*','text/a','text/a+b','text/b+c','text/d+*']", 0, 0}, {"MixedMetaMatch-4", "text/a+*", "['text/*','text/a','text/a+b','text/b+c','text/d+*']", 1, 2}, {"MixedMetaMatch-5", "text/c+*", "['text/*','text/a','text/a+b','text/b+c','text/d+*']", 3, 3}, {"MixedMetaMatch-6", "text/d+*", "['text/*','text/a','text/a+b','text/b+c','text/d+*']", 4, 4}, {"Fuzzy-1", "text/1+2", "['text/1+2']", 0, 0}, {"Fuzzy-2", "text/2+1", "['text/1+2']", 0, 0}, {"Fuzzy-3", "text/json+foo", "['text/json+*']", 0, 0}, {"Fuzzy-4", "text/json", "['text/json+lax']", -1, -1}, {"Fuzzy-5", "text/1+2", "['text/1','text/1+3']", -1, -1}, {"Fuzzy-6", "text/1+2", "['text/1','text/1+2','text/1+2+3']", 1, 1}, {"Fuzzy-7", "text/1+2", "['text/1+2+3','text/1','text/1+2']", 2, 2}, {"Fuzzy-8", "text/1+2", "['text/3+2+1','text/1','text/2+1']", 2, 2}, {"Fuzzy-9", "text/1+2+3+4", "['text/1+2','text/1+2+3']", -1, -1}, {"Fuzzy-10", "text/1+2+3+4", "['text/1+2+3','text/1+2']", -1, -1}, {"Fuzzy-11", "text/4+2+3+1", "['text/1+2+3','text/1+2']", -1, -1}, {"Fuzzy-12", "text/4+2+3+1", "['text/1+2','text/1+2+3']", -1, -1}, {"Q-1", "text/A;q=0.9,text/B;q=0.1", "['text/A','text/B']", 0, 0}, {"Q-2", "text/A;q=0.9,text/B;q=0.1", "['text/B','text/A']", 1, 1}, {"Q-3", "text/A+1;q=0.9,text/B;q=0.1", "['text/A','text/B']", 1, 1}, {"Q-4", "text/A;q=0.9,text/B+1;q=0.1", "['text/A','text/B+1']", 0, 0}, {"Q-5", "text/A;q=0.9,text/A+1;q=0.1", "['text/A+1','text/A']", 1, 1}, {"Q0-1", "text/A;q=0,text/B;q=0.1", "['text/A','text/B']", 1, 1}, {"Q0-2", "text/A;q=0,text/B;q=0.1", "['text/A','text/A+1']", -1, -1}, {"Parms-1", "text/A", "['text/A;foo=bar','text/B']", 0, 0}, {"Parms-2", "text/A;foo=bar", "['text/A','text/B']", 0, 0}, {"Json-1a", "text/json", "['text/json','text/json+*','text/*','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-1b", "text/json", "['text/json+*','text/*','text/json+lax','text/json+lax+*','text/foo','text/json']", 5, 5}, {"Json-1c", "text/json", "['text/json+*','text/*','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-1d", "text/json", "['text/*','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-1e", "text/json", "['text/json+lax','text/json+lax+*','text/foo']", -1, -1}, {"Json-2a", "text/json+lax", "['text/json+lax','text/json+lax+*','text/json+*','text/lax+*','text/*','text/json','text/lax']", 0, 0}, {"Json-2b", "text/json+lax", "['text/json+lax+*','text/json+*','text/lax+*','text/*','text/json','text/lax']", 0, 0}, {"Json-2c", "text/json+lax", "['text/json+*','text/lax+foo+*','text/*','text/json','text/lax']", 0, 0}, {"Json-2d", "text/json+lax", "['text/lax+*','text/*','text/json','text/lax']", 0, 0}, {"Json-2e", "text/json+lax", "['text/*','text/json','text/lax']", 0, 0}, {"Json-2f", "text/json+lax", "['text/json','text/lax']", -1, -1}, {"Json-3a", "text/json+activity", "['text/json+activity','text/activity+json','text/json+activity+*','text/json+*','text/*','text/json','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-3b", "text/json+activity", "['text/activity+json','text/json+activity+*','text/json+*','text/*','text/json','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-3c", "text/json+activity", "['text/json+activity+*','text/json+*','text/*','text/json','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-3d", "text/json+activity", "['text/json+*','text/*','text/json','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-3e", "text/json+activity", "['text/*','text/json','text/json+lax','text/json+lax+*','text/foo']", 0, 0}, {"Json-3f", "text/json+activity", "['text/json','text/json+lax','text/json+lax+*','text/foo']", -1, -1}, {"Xml-1a", "text/xml", "['text/xml','text/xml+*','text/xml+rdf','text/foo']", 0, 0}, {"Xml-1b", "text/xml", "['text/xml+*','text/xml+rdf','text/foo']", 0, 0}, {"Xml-1c", "text/xml", "['text/xml+rdf','text/foo']", -1, -1}, {"Xml-1d", "text/xml", "['text/foo']", -1, -1}, {"Xml-2a", "text/xml+id", "['text/xml+*','text/xml','text/xml+rdf']", 0, 0}, {"Xml-2b", "text/xml+id", "['text/xml','text/xml+rdf']", -1, -1}, {"Xml-2c", "text/xml+id", "['text/xml+rdf']", -1, -1}, {"Rdf-1a", "text/xml+rdf", "['text/xml+rdf','text/xml+*','text/xml']", 0, 0}, {"Rdf-1b", "text/xml+rdf", "['text/xml+*','text/xml']", 0, 0}, {"Rdf-1c", "text/xml+rdf", "['text/xml']", -1, -1});
    }

    public AcceptTest(String label, String accept, String mediaTypes, int expected, int expectedReverse) {
        this.label = label;
        this.accept = accept;
        this.mediaTypes = mediaTypes;
        this.expected = expected;
        this.expectedReverse = expectedReverse;
    }

    @Test
    public void test() throws Exception {
        Accept accept = Accept.forString((String)this.accept);
        MediaType[] mt = (MediaType[])JsonParser.DEFAULT.parse(this.mediaTypes, MediaType[].class);
        int r = accept.findMatch(mt);
        TestUtils.assertEquals(this.expected, r, "{0} failed", this.label);
    }

    @Test
    public void testReversed() throws Exception {
        Accept accept = Accept.forString((String)this.accept);
        MediaType[] mt = (MediaType[])JsonParser.DEFAULT.parse(this.mediaTypes, MediaType[].class);
        Collections.reverse(Arrays.asList(mt));
        int r = accept.findMatch(mt);
        int expected2 = this.expectedReverse == -1 ? -1 : mt.length - this.expectedReverse - 1;
        TestUtils.assertEquals(expected2, r, "{0} failed", this.label);
    }
}

