/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.https;

import org.apache.juneau.http.Accept;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class AcceptExtensionsTest {
    @Test
    public void testExtensions() throws Exception {
        Accept accept = Accept.forString((String)"text/json");
        MediaTypeRange mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("text/json", mr);
        TestUtils.assertTextEquals("text/json", mr.getMediaType());
        TestUtils.assertObjectEquals("{}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("1.0", mr.getQValue());
        TestUtils.assertObjectEquals("{}", mr.getExtensions());
        accept = Accept.forString((String)"foo,bar");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("foo", mr);
        TestUtils.assertTextEquals("foo", mr.getMediaType());
        TestUtils.assertObjectEquals("{}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("1.0", mr.getQValue());
        TestUtils.assertObjectEquals("{}", mr.getExtensions());
        accept = Accept.forString((String)" foo , bar ");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("foo", mr);
        TestUtils.assertTextEquals("foo", mr.getMediaType());
        TestUtils.assertObjectEquals("{}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("1.0", mr.getQValue());
        TestUtils.assertObjectEquals("{}", mr.getExtensions());
        accept = Accept.forString((String)"text/json;a=1;q=0.9;b=2");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("text/json;a=1;q=0.9;b=2", mr);
        TestUtils.assertTextEquals("text/json;a=1", mr.getMediaType());
        TestUtils.assertObjectEquals("{a:['1']}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("0.9", mr.getQValue());
        TestUtils.assertObjectEquals("{b:['2']}", mr.getExtensions());
        accept = Accept.forString((String)"text/json;a=1;a=2;q=0.9;b=3;b=4");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("text/json;a=1;a=2;q=0.9;b=3;b=4", mr);
        TestUtils.assertTextEquals("text/json;a=1;a=2", mr.getMediaType());
        TestUtils.assertObjectEquals("{a:['1','2']}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("0.9", mr.getQValue());
        TestUtils.assertObjectEquals("{b:['3','4']}", mr.getExtensions());
        accept = Accept.forString((String)"text/json;a=1");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("text/json;a=1", mr);
        TestUtils.assertTextEquals("text/json;a=1", mr.getMediaType());
        TestUtils.assertObjectEquals("{a:['1']}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("1.0", mr.getQValue());
        TestUtils.assertObjectEquals("{}", mr.getExtensions());
        accept = Accept.forString((String)"text/json;a=1;");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("text/json;a=1", mr);
        TestUtils.assertTextEquals("text/json;a=1", mr.getMediaType());
        TestUtils.assertObjectEquals("{a:['1']}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("1.0", mr.getQValue());
        TestUtils.assertObjectEquals("{}", mr.getExtensions());
        accept = Accept.forString((String)"text/json;q=0.9");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("text/json;q=0.9", mr);
        TestUtils.assertTextEquals("text/json", mr.getMediaType());
        TestUtils.assertObjectEquals("{}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("0.9", mr.getQValue());
        TestUtils.assertObjectEquals("{}", mr.getExtensions());
        accept = Accept.forString((String)"text/json;q=0.9;");
        mr = (MediaTypeRange)accept.asRanges().get(0);
        TestUtils.assertTextEquals("text/json;q=0.9", mr);
        TestUtils.assertTextEquals("text/json", mr.getMediaType());
        TestUtils.assertObjectEquals("{}", mr.getMediaType().getParameters());
        TestUtils.assertTextEquals("0.9", mr.getQValue());
        TestUtils.assertObjectEquals("{}", mr.getExtensions());
    }

    @Test
    public void testHasSubtypePart() {
        Accept accept = Accept.forString((String)"text/json+x,text/foo+y;q=0.0");
        Assert.assertTrue((boolean)accept.hasSubtypePart("json"));
        Assert.assertTrue((boolean)accept.hasSubtypePart("x"));
        Assert.assertFalse((boolean)accept.hasSubtypePart("foo"));
        Assert.assertFalse((boolean)accept.hasSubtypePart("y"));
    }
}

