/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonParserSession;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class UonPartParserTest {
    static UonParserSession p = UonParser.DEFAULT.createSession();
    static BeanSession bs = p;

    @Test
    public void testBasic() throws Exception {
        String t = "a";
        Assert.assertEquals((Object)"a", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"a", (Object)p.parse(null, t, bs.string()));
        t = "'a'";
        Assert.assertEquals((Object)"a", (Object)p.parse(null, t, bs.string()));
        Assert.assertEquals((Object)"a", (Object)p.parse(null, t, bs.object()));
        t = " 'a' ";
        Assert.assertEquals((Object)"a", (Object)p.parse(null, t, bs.string()));
        t = "(a=b,c=123,d=false,e=true,f=%00)";
        Map m = (Map)p.parse(null, t, bs.getClassMeta(Map.class));
        Assert.assertEquals((Object)"b", m.get("a"));
        Assert.assertTrue((boolean)(m.get("c") instanceof Number));
        Assert.assertEquals((Object)123, m.get("c"));
        Assert.assertTrue((boolean)(m.get("d") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.FALSE, m.get("d"));
        Assert.assertTrue((boolean)(m.get("e") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.TRUE, m.get("e"));
        Assert.assertEquals((Object)"%00", m.get("f"));
        t = "(a=b,c=123,d=false,e=true,f=null)";
        m = (Map)p.parse(null, t, bs.getClassMeta(Map.class));
        Assert.assertTrue((boolean)m.containsKey("f"));
        Assert.assertNull(m.get("f"));
        t = "null";
        Assert.assertNull((Object)p.parse(null, t, bs.object()));
        t = "@()";
        List l = (List)p.parse(null, t, bs.object());
        Assert.assertTrue((boolean)l.isEmpty());
        t = " @( ) ";
        l = (List)p.parse(null, t, bs.getClassMeta(List.class));
        Assert.assertTrue((boolean)l.isEmpty());
        t = "@(@())";
        l = (List)p.parse(null, t, bs.object());
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        l = (List)l.get(0);
        Assert.assertTrue((boolean)l.isEmpty());
        t = "@(@())";
        l = (List)p.parse(null, t, bs.getClassMeta(LinkedList.class, new Type[]{List.class}));
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        l = (List)l.get(0);
        Assert.assertTrue((boolean)l.isEmpty());
        t = "@('')";
        l = (List)p.parse(null, t, bs.object());
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        t = "@('')";
        l = (List)p.parse(null, t, bs.getClassMeta(List.class, new Type[]{String.class}));
        Assert.assertTrue((l.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        t = "@('','','')";
        l = (List)p.parse(null, t, bs.object());
        Assert.assertTrue((l.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        Assert.assertEquals((Object)"", l.get(1));
        Assert.assertEquals((Object)"", l.get(2));
        t = "@('','','')";
        l = (List)p.parse(null, t, bs.getClassMeta(List.class, new Type[]{Object.class}));
        Assert.assertTrue((l.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", l.get(0));
        Assert.assertEquals((Object)"", l.get(1));
        Assert.assertEquals((Object)"", l.get(2));
        t = "'\u0000'";
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(null, t, bs.object()));
        t = "'\u0000'";
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(null, t, bs.string()));
        Assert.assertEquals((Object)"\u0000", (Object)p.parse(null, t, bs.object()));
        t = "_value=false";
        Boolean b = false;
        t = "false";
        b = (Boolean)p.parse(null, t, bs.object());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        b = (Boolean)p.parse(null, t, bs.getClassMeta(Boolean.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        t = "false";
        b = (Boolean)p.parse(null, t, bs.getClassMeta(Boolean.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)b);
        t = "123";
        Integer i = -1;
        Double d = -1.0;
        Float f = Float.valueOf(-1.0f);
        i = (Integer)p.parse(null, t, bs.object());
        Assert.assertEquals((long)123L, (long)i.intValue());
        i = (Integer)p.parse(null, t, bs.getClassMeta(Integer.class));
        Assert.assertEquals((long)123L, (long)i.intValue());
        d = (Double)p.parse(null, t, bs.getClassMeta(Double.class));
        Assert.assertEquals((long)123L, (long)d.intValue());
        f = (Float)p.parse(null, t, bs.getClassMeta(Float.class));
        Assert.assertEquals((long)123L, (long)f.intValue());
        t = "123";
        i = (Integer)p.parse(null, t, bs.getClassMeta(Integer.class));
        Assert.assertEquals((long)123L, (long)i.intValue());
        t = "x;/?:@-_.!*'";
        Assert.assertEquals((Object)"x;/?:@-_.!*'", (Object)p.parse(null, t, bs.object()));
        t = "x{}|\\^[]`<>#%\"&+";
        Assert.assertEquals((Object)"x{}|\\^[]`<>#%\"&+", (Object)p.parse(null, t, bs.object()));
        t = "x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B";
        Assert.assertEquals((Object)"x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"x%7B%7D%7C%5C%5E%5B%5D%60%3C%3E%23%25%22%26%2B", (Object)p.parse(null, t, bs.string()));
        t = "'x$,()'";
        Assert.assertEquals((Object)"x$,()", (Object)p.parse(null, t, bs.object()));
        t = "'x='";
        Assert.assertEquals((Object)"x=", (Object)p.parse(null, t, bs.object()));
        t = "'x%3D'";
        Assert.assertEquals((Object)"x%3D", (Object)p.parse(null, t, bs.object()));
        t = "'()'";
        Assert.assertEquals((Object)"()", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"()", (Object)p.parse(null, t, bs.string()));
        t = "$a";
        Assert.assertEquals((Object)"$a", (Object)p.parse(null, t, bs.object()));
        t = "$a";
        Assert.assertEquals((Object)"$a", (Object)p.parse(null, t, bs.object()));
        t = "";
        Assert.assertEquals((Object)"", (Object)p.parse(null, t, bs.object()));
        t = "'%0A'";
        Assert.assertEquals((Object)"%0A", (Object)p.parse(null, t, bs.object()));
        t = "'\n'";
        Assert.assertEquals((Object)"\n", (Object)p.parse(null, t, bs.object()));
    }

    @Test
    public void testUnicodeChars() throws Exception {
        String t = "\u00a2";
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"\u00a2", (Object)p.parse(null, t, bs.string()));
        t = "%C2%A2";
        Assert.assertEquals((Object)"%C2%A2", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"%C2%A2", (Object)p.parse(null, t, bs.string()));
        t = "\u20ac";
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"\u20ac", (Object)p.parse(null, t, bs.string()));
        t = "%E2%82%AC";
        Assert.assertEquals((Object)"%E2%82%AC", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"%E2%82%AC", (Object)p.parse(null, t, bs.string()));
        t = "\ud852\udf62";
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"\ud852\udf62", (Object)p.parse(null, t, bs.string()));
        t = "%F0%A4%AD%A2";
        Assert.assertEquals((Object)"%F0%A4%AD%A2", (Object)p.parse(null, t, bs.object()));
        Assert.assertEquals((Object)"%F0%A4%AD%A2", (Object)p.parse(null, t, bs.string()));
    }

    @Test
    public void testSimpleBean() throws Exception {
        UonParserSession p = UonParser.DEFAULT.createSession();
        String s = null;
        s = "(f1=foo,f2=123)";
        A t = (A)p.parse(null, s, bs.getClassMeta(A.class));
        Assert.assertEquals((Object)"foo", (Object)t.f1);
        Assert.assertEquals((long)123L, (long)t.f2);
        s = "('f1'='foo','f2'=123)";
        t = (A)p.parse(null, s, bs.getClassMeta(A.class));
        Assert.assertEquals((Object)"foo", (Object)t.f1);
        Assert.assertEquals((long)123L, (long)t.f2);
    }

    @Test
    public void testParseParameterObjectMap() throws Exception {
        String in = "(name='foo bar')";
        ObjectMap r = (ObjectMap)UonParser.DEFAULT.createSession().parse(null, in, BeanContext.DEFAULT.createSession().getClassMeta(ObjectMap.class));
        Assert.assertEquals((Object)"{name:'foo bar'}", (Object)SimpleJsonSerializer.DEFAULT.toString((Object)r));
    }

    public static class A {
        public String f1;
        public int f2;
    }
}

