/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Set;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSchemaBuilder;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.oapi.OpenApiSerializerSession;
import org.apache.juneau.utils.AList;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OpenApiPartSerializerTest {
    static OpenApiSerializerSession s = OpenApiSerializer.DEFAULT.createSession();

    @Test
    public void a01_outputValidations_nullOutput() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema().build();
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        ps = OpenApiPartSerializerTest.schema().required(Boolean.valueOf(false)).build();
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        ps = OpenApiPartSerializerTest.schema().required().build();
        try {
            s.serialize(ps, null);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Required value not provided.", (Object)e.getMessage());
        }
        ps = OpenApiPartSerializerTest.schema().required(Boolean.valueOf(true)).build();
        try {
            s.serialize(ps, null);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Required value not provided.", (Object)e.getMessage());
        }
    }

    @Test
    public void a02_outputValidations_emptyOutput() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema().allowEmptyValue().build();
        Assert.assertEquals((Object)"", (Object)s.serialize(ps, (Object)""));
        ps = OpenApiPartSerializerTest.schema().allowEmptyValue().build();
        Assert.assertEquals((Object)"", (Object)s.serialize(ps, (Object)""));
        ps = OpenApiPartSerializerTest.schema().allowEmptyValue(Boolean.valueOf(false)).build();
        try {
            s.serialize(ps, (Object)"");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Empty value not allowed.", (Object)e.getMessage());
        }
        try {
            s.serialize(ps, (Object)"");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Empty value not allowed.", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)" ", (Object)s.serialize(ps, (Object)" "));
    }

    @Test
    public void a03_outputValidations_pattern() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema().pattern("x.*").allowEmptyValue().build();
        Assert.assertEquals((Object)"x", (Object)s.serialize(ps, (Object)"x"));
        Assert.assertEquals((Object)"xx", (Object)s.serialize(ps, (Object)"xx"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        try {
            s.serialize(ps, (Object)"y");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match expected pattern.  Must match pattern: x.*", (Object)e.getMessage());
        }
        try {
            s.serialize(ps, (Object)"");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match expected pattern.  Must match pattern: x.*", (Object)e.getMessage());
        }
        ps = OpenApiPartSerializerTest.schema().pattern("").allowEmptyValue().build();
        Assert.assertEquals((Object)"x", (Object)s.serialize(ps, (Object)"x"));
        ps = OpenApiPartSerializerTest.schema().pattern(null).allowEmptyValue().build();
        Assert.assertEquals((Object)"x", (Object)s.serialize(ps, (Object)"x"));
    }

    @Test
    public void a04_outputValidations_enum() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema()._enum(new String[]{"foo"}).allowEmptyValue().build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        try {
            s.serialize(ps, (Object)"bar");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['foo']", (Object)e.getMessage());
        }
        try {
            s.serialize(ps, (Object)"");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['foo']", (Object)e.getMessage());
        }
        ps = OpenApiPartSerializerTest.schema()._enum((Set)null).build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
        ps = OpenApiPartSerializerTest.schema()._enum((Set)null).allowEmptyValue().build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
        ps = OpenApiPartSerializerTest.schema()._enum(new String[]{"foo", "foo"}).build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
    }

    @Test
    public void a05_outputValidations_minMaxLength() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema().minLength(Long.valueOf(1L)).maxLength(Long.valueOf(2L)).allowEmptyValue().build();
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)"1"));
        Assert.assertEquals((Object)"12", (Object)s.serialize(ps, (Object)"12"));
        try {
            s.serialize(ps, (Object)"");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Minimum length of value not met.", (Object)e.getMessage());
        }
        try {
            s.serialize(ps, (Object)"123");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Maximum length of value exceeded.", (Object)e.getMessage());
        }
    }

    @Test
    public void c01_stringType_simple() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string").build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
    }

    @Test
    public void c02_stringType_default() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string")._default("x").build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
        Assert.assertEquals((Object)"x", (Object)s.serialize(ps, null));
    }

    @Test
    public void c03_stringType_byteFormat() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string", "byte").build();
        byte[] foob = "foo".getBytes();
        String expected = StringUtils.base64Encode((byte[])foob);
        Assert.assertEquals((Object)expected, (Object)s.serialize(ps, (Object)foob));
        Assert.assertEquals((Object)expected, (Object)s.serialize(ps, (Object)new C1(foob)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new C1(null)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void c04_stringType_binaryFormat() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string", "binary").build();
        byte[] foob = "foo".getBytes();
        String expected = StringUtils.toHex((byte[])foob);
        Assert.assertEquals((Object)expected, (Object)s.serialize(ps, (Object)foob));
        Assert.assertEquals((Object)expected, (Object)s.serialize(ps, (Object)new C1(foob)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new C1(null)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void c05_stringType_binarySpacedFormat() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string", "binary-spaced").build();
        byte[] foob = "foo".getBytes();
        String expected = StringUtils.toSpacedHex((byte[])foob);
        Assert.assertEquals((Object)expected, (Object)s.serialize(ps, (Object)foob));
        Assert.assertEquals((Object)expected, (Object)s.serialize(ps, (Object)new C1(foob)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new C1(null)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void c06_stringType_dateFormat() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string", "date").build();
        Calendar in = StringUtils.parseIsoCalendar((String)"2012-12-21");
        Assert.assertTrue((boolean)s.serialize(ps, (Object)in).contains("2012"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void c07_stringType_dateTimeFormat() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string", "date-time").build();
        Calendar in = StringUtils.parseIsoCalendar((String)"2012-12-21T12:34:56.789");
        Assert.assertTrue((boolean)s.serialize(ps, (Object)in).contains("2012"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void c08_stringType_uonFormat() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string", "uon").build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
        Assert.assertEquals((Object)"'foo'", (Object)s.serialize(ps, (Object)"'foo'"));
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)new C2("foo")));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new C2(null)));
        Assert.assertEquals((Object)"'null'", (Object)s.serialize(ps, (Object)new C2("null")));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void c09_stringType_noneFormat() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string").build();
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)"foo"));
        Assert.assertEquals((Object)"'foo'", (Object)s.serialize(ps, (Object)"'foo'"));
        Assert.assertEquals((Object)"foo", (Object)s.serialize(ps, (Object)new C2("foo")));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new C2(null)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new C2("null")));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void c10_stringType_noneFormat_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string")).build();
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)new C2[]{new C2("foo"), new C2("bar"), new C2(null), null}));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new C2[]{new C2("foo"), new C2("bar"), new C2(null), null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new C3("foo", "bar", null)));
    }

    @Test
    public void c11_stringType_noneFormat_3d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string"))).build();
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)new String[][]{{"foo", "bar"}, {"baz", null}, null}));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[][]{{"foo", "bar"}, {"baz", null}, null})));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"foo", "bar"}), AList.create((Object[])new String[]{"baz", null}), null})));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)new Object[][]{{"foo", "bar"}, {"baz", null}, null}));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{"foo", "bar"}, {"baz", null}, null})));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{"foo", "bar"}), AList.create((Object[])new Object[]{"baz", null}), null})));
        Assert.assertEquals((Object)"foo,bar|baz,null,null|null", (Object)s.serialize(ps, (Object)new C2[][]{{new C2("foo"), new C2("bar")}, {new C2("baz"), new C2(null), null}, null}));
        Assert.assertEquals((Object)"foo,bar|baz,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new C2[][]{{new C2("foo"), new C2("bar")}, {new C2("baz"), new C2(null), null}, null})));
        Assert.assertEquals((Object)"foo,bar|baz,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new C2[]{new C2("foo"), new C2("bar")}), AList.create((Object[])new C2[]{new C2("baz"), new C2(null), null}), null})));
        Assert.assertEquals((Object)"foo,bar|baz,null|null|null", (Object)s.serialize(ps, (Object)new C3[]{new C3("foo", "bar"), new C3("baz", null), new C3(new String[]{null}), null}));
        Assert.assertEquals((Object)"foo,bar|baz,null|null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new C3[]{new C3("foo", "bar"), new C3("baz", null), new C3(new String[]{null}), null})));
    }

    @Test
    public void c12_stringType_uonKeywords_plain() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string").build();
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)"true"));
        Assert.assertEquals((Object)"false", (Object)s.serialize(ps, (Object)"false"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)"null"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"123", (Object)s.serialize(ps, (Object)"123"));
        Assert.assertEquals((Object)"1.23", (Object)s.serialize(ps, (Object)"1.23"));
    }

    @Test
    public void c13_stringType_uonKeywords_uon() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("string", "uon").build();
        Assert.assertEquals((Object)"'true'", (Object)s.serialize(ps, (Object)"true"));
        Assert.assertEquals((Object)"'false'", (Object)s.serialize(ps, (Object)"false"));
        Assert.assertEquals((Object)"'null'", (Object)s.serialize(ps, (Object)"null"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"'123'", (Object)s.serialize(ps, (Object)"123"));
        Assert.assertEquals((Object)"'1.23'", (Object)s.serialize(ps, (Object)"1.23"));
    }

    @Test
    public void d01_arrayType_collectionFormatCsv() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("csv").build();
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)new D[]{new D("foo"), new D("bar"), new D(null), null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new D[]{new D("foo"), new D("bar"), new D(null), null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new ObjectList().append(new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo\\,bar,null", (Object)s.serialize(ps, (Object)new String[]{"foo,bar", null}));
    }

    @Test
    public void d02_arrayType_collectionFormatPipes() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").build();
        Assert.assertEquals((Object)"foo|bar|null", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo|bar|null", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo|bar|null|null", (Object)s.serialize(ps, (Object)new D[]{new D("foo"), new D("bar"), new D(null), null}));
        Assert.assertEquals((Object)"foo|bar|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo|bar|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo|bar|null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new D[]{new D("foo"), new D("bar"), new D(null), null})));
        Assert.assertEquals((Object)"foo|bar|null", (Object)s.serialize(ps, (Object)new ObjectList().append(new Object[]{"foo", "bar", null})));
    }

    @Test
    public void d03_arrayType_collectionFormatSsv() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("ssv").build();
        Assert.assertEquals((Object)"foo bar null", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo bar null", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo bar null null", (Object)s.serialize(ps, (Object)new D[]{new D("foo"), new D("bar"), new D(null), null}));
        Assert.assertEquals((Object)"foo bar null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo bar null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo bar null null", (Object)s.serialize(ps, (Object)AList.create((Object[])new D[]{new D("foo"), new D("bar"), new D(null), null})));
        Assert.assertEquals((Object)"foo bar null", (Object)s.serialize(ps, (Object)new ObjectList().append(new Object[]{"foo", "bar", null})));
    }

    @Test
    public void d04_arrayType_collectionFormatTsv() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("tsv").build();
        Assert.assertEquals((Object)"foo\tbar\tnull", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo\tbar\tnull", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo\tbar\tnull\tnull", (Object)s.serialize(ps, (Object)new D[]{new D("foo"), new D("bar"), new D(null), null}));
        Assert.assertEquals((Object)"foo\tbar\tnull", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo\tbar\tnull", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo\tbar\tnull\tnull", (Object)s.serialize(ps, (Object)AList.create((Object[])new D[]{new D("foo"), new D("bar"), new D(null), null})));
        Assert.assertEquals((Object)"foo\tbar\tnull", (Object)s.serialize(ps, (Object)new ObjectList().append(new Object[]{"foo", "bar", null})));
    }

    @Test
    public void d05_arrayType_collectionFormatUon() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("uon").build();
        Assert.assertEquals((Object)"@(foo,bar,'null',null)", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", "null", null}));
        Assert.assertEquals((Object)"@(foo,bar,'null',null)", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", "null", null}));
        Assert.assertEquals((Object)"@(foo,bar,'null',null)", (Object)s.serialize(ps, (Object)new D[]{new D("foo"), new D("bar"), new D("null"), null}));
        Assert.assertEquals((Object)"@(foo,bar,'null',null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", "null", null})));
        Assert.assertEquals((Object)"@(foo,bar,'null',null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", "null", null})));
        Assert.assertEquals((Object)"@(foo,bar,'null',null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new D[]{new D("foo"), new D("bar"), new D("null"), null})));
        Assert.assertEquals((Object)"@(foo,bar,'null',null)", (Object)s.serialize(ps, (Object)new ObjectList().append(new Object[]{"foo", "bar", "null", null})));
    }

    @Test
    public void d06a_arrayType_collectionFormatNone() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").build();
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)new D[]{new D("foo"), new D("bar"), new D(null), null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new D[]{new D("foo"), new D("bar"), new D(null), null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new ObjectList().append(new Object[]{"foo", "bar", null})));
    }

    @Test
    public void d07_arrayType_collectionFormatMulti() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("multi").build();
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new String[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new Object[]{"foo", "bar", null}));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)new D[]{new D("foo"), new D("bar"), new D(null), null}));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{"foo", "bar", null})));
        Assert.assertEquals((Object)"foo,bar,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new D[]{new D("foo"), new D("bar"), new D(null), null})));
        Assert.assertEquals((Object)"foo,bar,null", (Object)s.serialize(ps, (Object)new ObjectList().append(new Object[]{"foo", "bar", null})));
    }

    @Test
    public void d08_arrayType_collectionFormatCsvAndPipes() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").collectionFormat("csv")).build();
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)new String[][]{{"foo", "bar"}, {"baz", null}, null}));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)new Object[][]{{"foo", "bar"}, {"baz", null}, null}));
        Assert.assertEquals((Object)"foo,bar|baz,null,null|null", (Object)s.serialize(ps, (Object)new D[][]{{new D("foo"), new D("bar")}, {new D("baz"), new D(null), null}, null}));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"foo", "bar"}), AList.create((Object[])new String[]{"baz", null}), null})));
        Assert.assertEquals((Object)"foo,bar|baz,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{"foo", "bar"}), AList.create((Object[])new Object[]{"baz", null}), null})));
        Assert.assertEquals((Object)"foo,bar|baz,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new D[]{new D("foo"), new D("bar")}), AList.create((Object[])new D[]{new D("baz"), new D(null), null}), null})));
    }

    @Test
    public void d09_arrayType_itemsInteger() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("csv").items(OpenApiPartSerializerTest.schema("integer")).build();
        Assert.assertEquals((Object)"1,2", (Object)s.serialize(ps, (Object)new int[]{1, 2}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Integer[]{1, 2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Object[]{1, 2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Integer[]{1, 2, null})));
    }

    @Test
    public void d10_arrayType_itemsInteger_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").collectionFormat("csv").allowEmptyValue().items(OpenApiPartSerializerTest.schema("integer"))).build();
        Assert.assertEquals((Object)"1,2||null", (Object)s.serialize(ps, (Object)new int[][]{{1, 2}, new int[0], null}));
        Assert.assertEquals((Object)"1,2,null||null", (Object)s.serialize(ps, (Object)new Integer[][]{{1, 2, null}, new Integer[0], null}));
        Assert.assertEquals((Object)"1,2,null||null", (Object)s.serialize(ps, (Object)new Object[][]{{1, 2, null}, new Object[0], null}));
        Assert.assertEquals((Object)"1,2,null||null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Integer[]{1, 2, null}), AList.create((Object[])new Object[0]), null})));
    }

    @Test
    public void e01_booleanType() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("boolean").build();
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)true));
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)"true"));
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)new E1(true)));
        Assert.assertEquals((Object)"false", (Object)s.serialize(ps, (Object)false));
        Assert.assertEquals((Object)"false", (Object)s.serialize(ps, (Object)"false"));
        Assert.assertEquals((Object)"false", (Object)s.serialize(ps, (Object)new E1(false)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)"null"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new E1(null)));
    }

    @Test
    public void e02_booleanType_uon() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("boolean", "uon").build();
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)true));
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)"true"));
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)new E1(true)));
        Assert.assertEquals((Object)"false", (Object)s.serialize(ps, (Object)false));
        Assert.assertEquals((Object)"false", (Object)s.serialize(ps, (Object)"false"));
        Assert.assertEquals((Object)"false", (Object)s.serialize(ps, (Object)new E1(false)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)"null"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new E1(null)));
    }

    @Test
    public void e03_booleanType_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("boolean")).build();
        Assert.assertEquals((Object)"true", (Object)s.serialize(ps, (Object)new boolean[]{true}));
        Assert.assertEquals((Object)"true,null", (Object)s.serialize(ps, (Object)new Boolean[]{true, null}));
        Assert.assertEquals((Object)"true,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Boolean[]{true, null})));
        Assert.assertEquals((Object)"true,null", (Object)s.serialize(ps, (Object)new String[]{"true", null}));
        Assert.assertEquals((Object)"true,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"true", null})));
        Assert.assertEquals((Object)"true,null", (Object)s.serialize(ps, (Object)new Object[]{true, null}));
        Assert.assertEquals((Object)"true,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{true, null})));
        Assert.assertEquals((Object)"true,null,null", (Object)s.serialize(ps, (Object)new E1[]{new E1(true), new E1(null), null}));
        Assert.assertEquals((Object)"true,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new E1[]{new E1(true), new E1(null), null})));
        Assert.assertEquals((Object)"true,null", (Object)s.serialize(ps, (Object)new E2(true, null)));
    }

    @Test
    public void e04_booleanType_3d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("boolean"))).build();
        Assert.assertEquals((Object)"true,true|false", (Object)s.serialize(ps, (Object)new boolean[][]{{true, true}, {false}}));
        Assert.assertEquals((Object)"true,true|false", (Object)s.serialize(ps, (Object)AList.create((Object[])new boolean[][]{{true, true}, {false}})));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)new Boolean[][]{{true, true}, {false, null}}));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Boolean[][]{{true, true}, {false, null}})));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Boolean[]{true, true}), AList.create((Object[])new Boolean[]{false, null})})));
        Assert.assertEquals((Object)"true,true|false,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"true", "true"}), AList.create((Object[])new String[]{"false", "null", null})})));
        Assert.assertEquals((Object)"true,true|false,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[][]{{"true", "true"}, {"false", "null", null}})));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)new Object[][]{{true, true}, {false, null}}));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{true, true}), AList.create((Object[])new Object[]{false, null})})));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{true, true}, {false, null}})));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)new E1[][]{{new E1(true), new E1(true)}, {new E1(false), new E1(null)}}));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new E1[]{new E1(true), new E1(true)}), AList.create((Object[])new E1[]{new E1(false), new E1(null)})})));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new E1[][]{{new E1(true), new E1(true)}, {new E1(false), new E1(null)}})));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)new E2[]{new E2(true, true), new E2(false, null)}));
        Assert.assertEquals((Object)"true,true|false,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new E2[]{new E2(true, true), new E2(false, null)})));
    }

    @Test
    public void f01_integerType_int32() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("integer", "int32").build();
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)1));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new Integer(1)));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)1));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new Short(1)));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)1L));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new Long(1L)));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)"1"));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new F1(1)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)"null"));
    }

    @Test
    public void f02_integerType_int32_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("integer", "int32")).build();
        Assert.assertEquals((Object)"1,2", (Object)s.serialize(ps, (Object)new int[]{1, 2}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Integer[]{1, 2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Integer[]{1, 2, null})));
        Assert.assertEquals((Object)"1,2", (Object)s.serialize(ps, (Object)new short[]{1, 2}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Short[]{(short)1, (short)2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Short[]{new Short(1), new Short(2), null})));
        Assert.assertEquals((Object)"1,2", (Object)s.serialize(ps, (Object)new long[]{1L, 2L}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Long[]{1L, 2L, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Long[]{1L, 2L, null})));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)new String[]{"1", "2", "null", null}));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"1", "2", "null", null})));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Object[]{1, 2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{1, 2, null})));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)new F1[]{new F1(1), new F1(2), new F1(null), null}));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new F1[]{new F1(1), new F1(2), new F1(null), null})));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new F2(1, 2, null)));
    }

    @Test
    public void f03_integerType_int32_3d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("integer", "int32"))).build();
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)new int[][]{{1, 2}, {3}, null}));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new int[][]{{1, 2}, {3}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Integer[][]{{1, 2}, {3, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Integer[][]{{1, 2}, {3, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Integer[]{1, 2}), AList.create((Object[])new Integer[]{3, null}), null})));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)new short[][]{{1, 2}, {3}, null}));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new short[][]{{1, 2}, {3}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Short[][]{{(short)1, (short)2}, {(short)3, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Short[][]{{(short)1, (short)2}, {(short)3, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Short[]{new Short(1), new Short(2)}), AList.create((Object[])new Short[]{new Short(3), null}), null})));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)new long[][]{{1L, 2L}, {3L}, null}));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new long[][]{{1L, 2L}, {3L}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Long[][]{{1L, 2L}, {3L, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Long[][]{{1L, 2L}, {3L, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Long[]{new Long(1L), new Long(2L)}), AList.create((Object[])new Long[]{new Long(3L), null}), null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)new String[][]{{"1", "2"}, {"3", "null", null}, null}));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[][]{{"1", "2"}, {"3", "null", null}, null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"1", "2"}), AList.create((Object[])new String[]{"3", "null", null}), null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Object[][]{{1, 2}, {3, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{1, 2}, {3, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{1, 2}), AList.create((Object[])new Object[]{3, null}), null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)new F1[][]{{new F1(1), new F1(2)}, {new F1(3), new F1(null), null}, null}));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new F1[][]{{new F1(1), new F1(2)}, {new F1(3), new F1(null), null}, null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new F1[]{new F1(1), new F1(2)}), AList.create((Object[])new F1[]{new F1(3), new F1(null), null}), null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new F2[]{new F2(1, 2), new F2(3, null), null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new F2[]{new F2(1, 2), new F2(3, null), null})));
    }

    @Test
    public void f04_integerType_int64() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("integer", "int64").build();
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)1));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new Integer(1)));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)1));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new Short(1)));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)1L));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new Long(1L)));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)"1"));
        Assert.assertEquals((Object)"1", (Object)s.serialize(ps, (Object)new F3(1L)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)"null"));
    }

    @Test
    public void f05_integerType_int64_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("integer", "int64")).build();
        Assert.assertEquals((Object)"1,2", (Object)s.serialize(ps, (Object)new int[]{1, 2}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Integer[]{1, 2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Integer[]{1, 2, null})));
        Assert.assertEquals((Object)"1,2", (Object)s.serialize(ps, (Object)new short[]{1, 2}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Short[]{(short)1, (short)2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Short[]{(short)1, (short)2, null})));
        Assert.assertEquals((Object)"1,2", (Object)s.serialize(ps, (Object)new long[]{1L, 2L}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Long[]{1L, 2L, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Long[]{1L, 2L, null})));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)new String[]{"1", "2", "null", null}));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"1", "2", "null", null})));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new Object[]{1, 2, null}));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{1, 2, null})));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)new F3[]{new F3(1L), new F3(2L), new F3(null), null}));
        Assert.assertEquals((Object)"1,2,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new F3[]{new F3(1L), new F3(2L), new F3(null), null})));
        Assert.assertEquals((Object)"1,2,null", (Object)s.serialize(ps, (Object)new F4(1L, 2L, null)));
    }

    @Test
    public void f06_integerType_int64_3d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("integer", "int64"))).build();
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)new int[][]{{1, 2}, {3}, null}));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new int[][]{{1, 2}, {3}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Integer[][]{{1, 2}, {3, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Integer[][]{{1, 2}, {3, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Integer[]{1, 2}), AList.create((Object[])new Integer[]{3, null}), null})));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)new short[][]{{1, 2}, {3}, null}));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new short[][]{{1, 2}, {3}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Short[][]{{(short)1, (short)2}, {(short)3, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Short[][]{{(short)1, (short)2}, {(short)3, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Short[]{(short)1, (short)2}), AList.create((Object[])new Short[]{(short)3, null}), null})));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)new long[][]{{1L, 2L}, {3L}, null}));
        Assert.assertEquals((Object)"1,2|3|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new long[][]{{1L, 2L}, {3L}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Long[][]{{1L, 2L}, {3L, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Long[][]{{1L, 2L}, {3L, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Long[]{1L, 2L}), AList.create((Object[])new Long[]{3L, null}), null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)new String[][]{{"1", "2"}, {"3", "null", null}, null}));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[][]{{"1", "2"}, {"3", "null", null}, null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"1", "2"}), AList.create((Object[])new String[]{"3", "null", null}), null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new Object[][]{{1, 2}, {3, null}, null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{1, 2}, {3, null}, null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{1, 2}), AList.create((Object[])new Object[]{3, null}), null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)new F3[][]{{new F3(1L), new F3(2L)}, {new F3(3L), new F3(null), null}, null}));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new F3[][]{{new F3(1L), new F3(2L)}, {new F3(3L), new F3(null), null}, null})));
        Assert.assertEquals((Object)"1,2|3,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new F3[]{new F3(1L), new F3(2L)}), AList.create((Object[])new F3[]{new F3(3L), new F3(null), null}), null})));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)new F4[]{new F4(1L, 2L), new F4(3L, null), null}));
        Assert.assertEquals((Object)"1,2|3,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new F4[]{new F4(1L, 2L), new F4(3L, null), null})));
    }

    @Test
    public void g01_numberType_float() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("number", "float").build();
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)new Float(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)1.0));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)new Double(1.0)));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)"1"));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)new G1(Float.valueOf(1.0f))));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)"null"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new G1(null)));
    }

    @Test
    public void g02_numberType_float_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("number", "float")).build();
        Assert.assertEquals((Object)"1.0,2.0", (Object)s.serialize(ps, (Object)new float[]{1.0f, 2.0f}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), null}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), null})));
        Assert.assertEquals((Object)"1.0,2.0", (Object)s.serialize(ps, (Object)new double[]{1.0, 2.0}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)new Double[]{1.0, 2.0, null}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Double[]{1.0, 2.0, null})));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)new String[]{"1", "2", "null", null}));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"1", "2", "null", null})));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)new Object[]{1, 2, null}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{1, 2, null})));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)new G1[]{new G1(Float.valueOf(1.0f)), new G1(Float.valueOf(2.0f)), new G1(null), null}));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new G1[]{new G1(Float.valueOf(1.0f)), new G1(Float.valueOf(2.0f)), new G1(null), null})));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)new G2(Float.valueOf(1.0f), Float.valueOf(2.0f), null)));
    }

    @Test
    public void g03_numberType_float_3d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("number", "float"))).build();
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)new float[][]{{1.0f, 2.0f}, {3.0f}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new float[][]{{1.0f, 2.0f}, {3.0f}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)new Float[][]{{Float.valueOf(1.0f), Float.valueOf(2.0f)}, {Float.valueOf(3.0f), null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Float[][]{{Float.valueOf(1.0f), Float.valueOf(2.0f)}, {Float.valueOf(3.0f), null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}), AList.create((Object[])new Float[]{Float.valueOf(3.0f), null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)new double[][]{{1.0, 2.0}, {3.0}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new double[][]{{1.0, 2.0}, {3.0}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)new Double[][]{{1.0, 2.0}, {3.0, null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Double[][]{{1.0, 2.0}, {3.0, null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Double[]{1.0, 2.0}), AList.create((Object[])new Double[]{3.0, null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)new String[][]{{"1", "2"}, {"3", "null", null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[][]{{"1", "2"}, {"3", "null", null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Double[]{1.0, 2.0}), AList.create((Object[])new Serializable[]{Float.valueOf(3.0f), "null", null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)new Object[][]{{1.0, 2.0}, {Float.valueOf(3.0f), "null", null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{1.0, 2.0}, {Float.valueOf(3.0f), "null", null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Double[]{1.0, 2.0}), AList.create((Object[])new Serializable[]{Float.valueOf(3.0f), "null", null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)new G1[][]{{new G1(Float.valueOf(1.0f)), new G1(Float.valueOf(2.0f))}, {new G1(Float.valueOf(3.0f)), new G1(null), null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new G1[][]{{new G1(Float.valueOf(1.0f)), new G1(Float.valueOf(2.0f))}, {new G1(Float.valueOf(3.0f)), new G1(null), null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new G1[]{new G1(Float.valueOf(1.0f)), new G1(Float.valueOf(2.0f))}), AList.create((Object[])new G1[]{new G1(Float.valueOf(3.0f)), new G1(null), null}), null})));
        Assert.assertEquals((Object)"1.0,2.0,null|null", (Object)s.serialize(ps, (Object)new G2[]{new G2(Float.valueOf(1.0f), Float.valueOf(2.0f), null), null}));
        Assert.assertEquals((Object)"1.0,2.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new G2[]{new G2(Float.valueOf(1.0f), Float.valueOf(2.0f), null), null})));
    }

    @Test
    public void g04_numberType_double() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("number", "double").build();
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)new Float(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)1.0));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)new Double(1.0)));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)"1"));
        Assert.assertEquals((Object)"1.0", (Object)s.serialize(ps, (Object)new G3(1.0)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)"null"));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, (Object)new G3(null)));
    }

    @Test
    public void g05_numberType_double_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("number", "double")).build();
        Assert.assertEquals((Object)"1.0,2.0", (Object)s.serialize(ps, (Object)new float[]{1.0f, 2.0f}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), null}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), null})));
        Assert.assertEquals((Object)"1.0,2.0", (Object)s.serialize(ps, (Object)new double[]{1.0, 2.0}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)new Double[]{1.0, 2.0, null}));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Double[]{1.0, 2.0, null})));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)new String[]{"1", "2", "null", null}));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[]{"1", "2", "null", null})));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)new Object[]{1.0, Float.valueOf(2.0f), "null", null}));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Serializable[]{Double.valueOf(1.0), Float.valueOf(2.0f), "null", null})));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)new G3[]{new G3(1.0), new G3(2.0), new G3(null), null}));
        Assert.assertEquals((Object)"1.0,2.0,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new G3[]{new G3(1.0), new G3(2.0), new G3(null), null})));
        Assert.assertEquals((Object)"1.0,2.0,null", (Object)s.serialize(ps, (Object)new G4(1.0, 2.0, null)));
    }

    @Test
    public void g06_numberType_double_3d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("number", "double"))).build();
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)new float[][]{{1.0f, 2.0f}, {3.0f}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new float[][]{{1.0f, 2.0f}, {3.0f}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)new Float[][]{{Float.valueOf(1.0f), Float.valueOf(2.0f)}, {Float.valueOf(3.0f), null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Float[][]{{Float.valueOf(1.0f), Float.valueOf(2.0f)}, {Float.valueOf(3.0f), null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}), AList.create((Object[])new Float[]{Float.valueOf(3.0f), null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)new double[][]{{1.0, 2.0}, {3.0}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new double[][]{{1.0, 2.0}, {3.0}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)new Double[][]{{1.0, 2.0}, {3.0, null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Double[][]{{1.0, 2.0}, {3.0, null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Double[]{1.0, 2.0}), AList.create((Object[])new Double[]{3.0, null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)new String[][]{{"1", "2"}, {"3", "null", null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new String[][]{{"1", "2"}, {"3", "null", null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new String[]{"1", "2"}), AList.create((Object[])new String[]{"3", "null", null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)new Object[][]{{1.0, 2.0}, {"3", "null", null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{1.0, 2.0}, {"3", "null", null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{AList.create((Object[])new Number[]{1.0, Float.valueOf(2.0f)}), AList.create((Object[])new Serializable[]{Double.valueOf(3.0), "null", null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)new G3[][]{{new G3(1.0), new G3(2.0)}, {new G3(3.0), new G3(null), null}, null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new G3[][]{{new G3(1.0), new G3(2.0)}, {new G3(3.0), new G3(null), null}, null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new G3[]{new G3(1.0), new G3(2.0)}), AList.create((Object[])new G3[]{new G3(3.0), new G3(null), null}), null})));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)new G4[]{new G4(1.0, 2.0), new G4(3.0, null), null}));
        Assert.assertEquals((Object)"1.0,2.0|3.0,null|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new G4[]{new G4(1.0, 2.0), new G4(3.0, null), null})));
    }

    @Test
    public void h01_objectType() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("object").build();
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)", (Object)s.serialize(ps, (Object)new H1("1", 2, true)));
        Assert.assertEquals((Object)"()", (Object)s.serialize(ps, (Object)new H1(null, null, null)));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)", (Object)s.serialize(ps, (Object)new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")));
        Assert.assertEquals((Object)"(f1=null,f2=null,f3=null)", (Object)s.serialize(ps, (Object)new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}")));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void h02_objectType_uon() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("object", "uon").build();
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)", (Object)s.serialize(ps, (Object)new H1("1", 2, true)));
        Assert.assertEquals((Object)"()", (Object)s.serialize(ps, (Object)new H1(null, null, null)));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)", (Object)s.serialize(ps, (Object)new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")));
        Assert.assertEquals((Object)"(f1=null,f2=null,f3=null)", (Object)s.serialize(ps, (Object)new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}")));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
    }

    @Test
    public void h03_objectType_2d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("object")).build();
        Assert.assertEquals((Object)"(f1='1'\\,f2=2\\,f3=true),(),null", (Object)s.serialize(ps, (Object)new H1[]{new H1("1", 2, true), new H1(null, null, null), null}));
        Assert.assertEquals((Object)"(f1='1'\\,f2=2\\,f3=true),(),null", (Object)s.serialize(ps, (Object)AList.create((Object[])new H1[]{new H1("1", 2, true), new H1(null, null, null), null})));
        Assert.assertEquals((Object)"(f1='1'\\,f2=2\\,f3=true),(f1=null\\,f2=null\\,f3=null),null", (Object)s.serialize(ps, (Object)new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}));
        Assert.assertEquals((Object)"(f1='1'\\,f2=2\\,f3=true),(f1=null\\,f2=null\\,f3=null),null", (Object)s.serialize(ps, (Object)AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null})));
        Assert.assertEquals((Object)"(f1='1'\\,f2=2\\,f3=true),(f1='1'\\,f2=2\\,f3=true),null", (Object)s.serialize(ps, (Object)new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), null}));
        Assert.assertEquals((Object)"(f1='1'\\,f2=2\\,f3=true),(f1='1'\\,f2=2\\,f3=true),null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), null})));
    }

    @Test
    public void h03_objectType_2d_pipes() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("object")).build();
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|()|null", (Object)s.serialize(ps, (Object)new H1[]{new H1("1", 2, true), new H1(null, null, null), null}));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|()|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new H1[]{new H1("1", 2, true), new H1(null, null, null), null})));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=null,f2=null,f3=null)|null", (Object)s.serialize(ps, (Object)new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=null,f2=null,f3=null)|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null})));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1='1',f2=2,f3=true)|null", (Object)s.serialize(ps, (Object)new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), null}));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1='1',f2=2,f3=true)|null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), null})));
    }

    @Test
    public void h04_objectType_2d_uon() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("uon").items(OpenApiPartSerializerTest.schema("object")).build();
        Assert.assertEquals((Object)"@((f1='1',f2=2,f3=true),(),null)", (Object)s.serialize(ps, (Object)new H1[]{new H1("1", 2, true), new H1(null, null, null), null}));
        Assert.assertEquals((Object)"@((f1='1',f2=2,f3=true),(),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new H1[]{new H1("1", 2, true), new H1(null, null, null), null})));
        Assert.assertEquals((Object)"@((f1='1',f2=2,f3=true),(f1=null,f2=null,f3=null),null)", (Object)s.serialize(ps, (Object)new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}));
        Assert.assertEquals((Object)"@((f1='1',f2=2,f3=true),(f1=null,f2=null,f3=null),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null})));
        Assert.assertEquals((Object)"@((f1='1',f2=2,f3=true),(f1='1',f2=2,f3=true),null)", (Object)s.serialize(ps, (Object)new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), null}));
        Assert.assertEquals((Object)"@((f1='1',f2=2,f3=true),(f1='1',f2=2,f3=true),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), null})));
    }

    @Test
    public void h03_objectType_3d() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("object"))).build();
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1=x\\\\\\,f2=3\\\\\\,f3=false),()\\,null,null", (Object)s.serialize(ps, (Object)new H1[][]{{new H1("1", 2, true), new H1("x", 3, false)}, {new H1(null, null, null), null}, null}));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1=x\\\\\\,f2=3\\\\\\,f3=false),()\\,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new H1[][]{{new H1("1", 2, true), new H1("x", 3, false)}, {new H1(null, null, null), null}, null})));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1=x\\\\\\,f2=3\\\\\\,f3=false),()\\,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new H1[]{new H1("1", 2, true), new H1("x", 3, false)}), AList.create((Object[])new H1[]{new H1(null, null, null), null}), null})));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1=x\\\\\\,f2=4\\\\\\,f3=false),(f1=null\\\\\\,f2=null\\\\\\,f3=null)\\,null,null", (Object)s.serialize(ps, (Object)new ObjectMap[][]{{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}, {new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null}));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1=x\\\\\\,f2=4\\\\\\,f3=false),(f1=null\\\\\\,f2=null\\\\\\,f3=null)\\,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new ObjectMap[][]{{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}, {new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null})));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1=x\\\\\\,f2=4\\\\\\,f3=false),(f1=null\\\\\\,f2=null\\\\\\,f3=null)\\,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}), AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}), null})));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1='1'\\\\\\,f2=2\\\\\\,f3=true),()\\,(f1=null\\\\\\,f2=null\\\\\\,f3=null)\\,null,null", (Object)s.serialize(ps, (Object)new Object[][]{{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}, {new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null}));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1='1'\\\\\\,f2=2\\\\\\,f3=true),()\\,(f1=null\\\\\\,f2=null\\\\\\,f3=null)\\,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}, {new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null})));
        Assert.assertEquals((Object)"(f1='1'\\\\\\,f2=2\\\\\\,f3=true)\\,(f1='1'\\\\\\,f2=2\\\\\\,f3=true),()\\,(f1=null\\\\\\,f2=null\\\\\\,f3=null)\\,null,null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}), AList.create((Object[])new Object[]{new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}), null})));
    }

    @Test
    public void h03_objectType_3d_ssvAndPipes() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("ssv").items(OpenApiPartSerializerTest.schema("array").collectionFormat("pipes").items(OpenApiPartSerializerTest.schema("object"))).build();
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=x,f2=3,f3=false) ()|null null", (Object)s.serialize(ps, (Object)new H1[][]{{new H1("1", 2, true), new H1("x", 3, false)}, {new H1(null, null, null), null}, null}));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=x,f2=3,f3=false) ()|null null", (Object)s.serialize(ps, (Object)AList.create((Object[])new H1[][]{{new H1("1", 2, true), new H1("x", 3, false)}, {new H1(null, null, null), null}, null})));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=x,f2=3,f3=false) ()|null null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new H1[]{new H1("1", 2, true), new H1("x", 3, false)}), AList.create((Object[])new H1[]{new H1(null, null, null), null}), null})));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=x,f2=4,f3=false) (f1=null,f2=null,f3=null)|null null", (Object)s.serialize(ps, (Object)new ObjectMap[][]{{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}, {new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null}));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=x,f2=4,f3=false) (f1=null,f2=null,f3=null)|null null", (Object)s.serialize(ps, (Object)AList.create((Object[])new ObjectMap[][]{{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}, {new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null})));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1=x,f2=4,f3=false) (f1=null,f2=null,f3=null)|null null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}), AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}), null})));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1='1',f2=2,f3=true) ()|(f1=null,f2=null,f3=null)|null null", (Object)s.serialize(ps, (Object)new Object[][]{{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}, {new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null}));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1='1',f2=2,f3=true) ()|(f1=null,f2=null,f3=null)|null null", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}, {new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null})));
        Assert.assertEquals((Object)"(f1='1',f2=2,f3=true)|(f1='1',f2=2,f3=true) ()|(f1=null,f2=null,f3=null)|null null", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}), AList.create((Object[])new Object[]{new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}), null})));
    }

    @Test
    public void h03_objectType_3d_uon() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("array").collectionFormat("uon").items(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("object"))).build();
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1=x,f2=3,f3=false)),@((),null),null)", (Object)s.serialize(ps, (Object)new H1[][]{{new H1("1", 2, true), new H1("x", 3, false)}, {new H1(null, null, null), null}, null}));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1=x,f2=3,f3=false)),@((),null),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new H1[][]{{new H1("1", 2, true), new H1("x", 3, false)}, {new H1(null, null, null), null}, null})));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1=x,f2=3,f3=false)),@((),null),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new H1[]{new H1("1", 2, true), new H1("x", 3, false)}), AList.create((Object[])new H1[]{new H1(null, null, null), null}), null})));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1=x,f2=4,f3=false)),@((f1=null,f2=null,f3=null),null),null)", (Object)s.serialize(ps, (Object)new ObjectMap[][]{{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}, {new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null}));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1=x,f2=4,f3=false)),@((f1=null,f2=null,f3=null),null),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new ObjectMap[][]{{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}, {new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null})));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1=x,f2=4,f3=false)),@((f1=null,f2=null,f3=null),null),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}"), new ObjectMap((CharSequence)"{f1:'x',f2:4,f3:false}")}), AList.create((Object[])new ObjectMap[]{new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}), null})));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1='1',f2=2,f3=true)),@((),(f1=null,f2=null,f3=null),null),null)", (Object)s.serialize(ps, (Object)new Object[][]{{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}, {new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null}));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1='1',f2=2,f3=true)),@((),(f1=null,f2=null,f3=null),null),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new Object[][]{{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}, {new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}, null})));
        Assert.assertEquals((Object)"@(@((f1='1',f2=2,f3=true),(f1='1',f2=2,f3=true)),@((),(f1=null,f2=null,f3=null),null),null)", (Object)s.serialize(ps, (Object)AList.create((Object[])new AList[]{AList.create((Object[])new Object[]{new H1("1", 2, true), new ObjectMap((CharSequence)"{f1:'1',f2:2,f3:true}")}), AList.create((Object[])new Object[]{new H1(null, null, null), new ObjectMap((CharSequence)"{f1:null,f2:null,f3:null}"), null}), null})));
    }

    @Test
    public void h04_objectType_simpleProperties() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("object").property("f01", OpenApiPartSerializerTest.schema("string")).property("f02", OpenApiPartSerializerTest.schema("string", "byte")).property("f04", OpenApiPartSerializerTest.schema("string", "date-time")).property("f05", OpenApiPartSerializerTest.schema("string", "binary")).property("f06", OpenApiPartSerializerTest.schema("string", "binary-spaced")).property("f07", OpenApiPartSerializerTest.schema("string", "uon")).property("f08", OpenApiPartSerializerTest.schema("integer")).property("f09", OpenApiPartSerializerTest.schema("integer", "int64")).property("f10", OpenApiPartSerializerTest.schema("number")).property("f11", OpenApiPartSerializerTest.schema("number", "double")).property("f12", OpenApiPartSerializerTest.schema("boolean")).additionalProperties(OpenApiPartSerializerTest.schema("integer")).build();
        byte[] foob = "foo".getBytes();
        Assert.assertEquals((Object)"(f01=foo,f02=Zm9v,f04=2012-12-21T12:34:56Z,f05=666F6F,f06='66 6F 6F',f07=foo,f08=1,f09=2,f10=1.0,f11=1.0,f12=true,f99=1)", (Object)s.serialize(ps, (Object)new H2("foo", foob, StringUtils.parseIsoCalendar((String)"2012-12-21T12:34:56Z"), foob, foob, "foo", 1, 2, 1.0, 1.0, true, 1)));
        Assert.assertEquals((Object)"()", (Object)s.serialize(ps, (Object)new H2(null, null, null, null, null, null, null, null, null, null, null, null)));
        Assert.assertEquals((Object)"null", (Object)s.serialize(ps, null));
        Assert.assertEquals((Object)"(f01=foo,f02=Zm9v,f04=2012-12-21T12:34:56Z,f05=666F6F,f06='66 6F 6F',f07=foo,f08=1,f09=2,f10=1.0,f11=1.0,f12=true,f99=1)", (Object)s.serialize(ps, (Object)new ObjectMap().append("f01", (Object)"foo").append("f02", (Object)foob).append("f04", (Object)StringUtils.parseIsoCalendar((String)"2012-12-21T12:34:56Z")).append("f05", (Object)foob).append("f06", (Object)foob).append("f07", (Object)"foo").append("f08", (Object)1).append("f09", (Object)2).append("f10", (Object)1.0).append("f11", (Object)1.0).append("f12", (Object)true).append("f99", (Object)1)));
    }

    @Test
    public void h05_objectType_arrayProperties() throws Exception {
        HttpPartSchema ps = OpenApiPartSerializerTest.schema("object").property("f01", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string"))).property("f02", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string", "byte"))).property("f04", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string", "date-time"))).property("f05", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string", "binary"))).property("f06", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string", "binary-spaced"))).property("f07", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("string", "uon"))).property("f08", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("integer"))).property("f09", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("integer", "int64"))).property("f10", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("number"))).property("f11", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("number", "double"))).property("f12", OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("boolean"))).additionalProperties(OpenApiPartSerializerTest.schema("array").items(OpenApiPartSerializerTest.schema("integer"))).build();
        byte[] foob = "foo".getBytes();
        Assert.assertEquals((Object)"(f01=@('a,b',null),f02=@(Zm9v,null),f04=@(2012-12-21T12:34:56Z,null),f05=@(666F6F,null),f06=@('66 6F 6F',null),f07=@(a,b,null),f08=@(1,2,null),f09=@(3,4,null),f10=@(1.0,2.0,null),f11=@(3.0,4.0,null),f12=@(true,false,null),f99=@(1,x,null))", (Object)s.serialize(ps, (Object)new H2(new String[]{"a,b", null}, new byte[][]{foob, null}, new Calendar[]{StringUtils.parseIsoCalendar((String)"2012-12-21T12:34:56Z"), null}, new byte[][]{foob, null}, new byte[][]{foob, null}, new String[]{"a", "b", null}, new Integer[]{1, 2, null}, new Integer[]{3, 4, null}, new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), null}, new Float[]{Float.valueOf(3.0f), Float.valueOf(4.0f), null}, new Boolean[]{true, false, null}, new Object[]{1, "x", null})));
    }

    @Test
    public void i01a_noSchemaTests_Integer() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        for (Integer v : AList.create((Object[])new Integer[]{new Integer(1), Integer.MAX_VALUE, Integer.MIN_VALUE})) {
            Assert.assertEquals((Object)String.valueOf(v), (Object)s.serialize((HttpPartSchema)null, (Object)v));
        }
    }

    @Test
    public void i01b_noSchemaTests_IntegerArray() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"1,2147483647,-2147483648", (Object)s.serialize((HttpPartSchema)null, (Object)new Integer[]{new Integer(1), Integer.MAX_VALUE, Integer.MIN_VALUE}));
    }

    @Test
    public void i02a_noSchemaTests_Short() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        for (Short v : AList.create((Object[])new Short[]{new Short(1), (short)Short.MAX_VALUE, (short)Short.MIN_VALUE})) {
            Assert.assertEquals((Object)String.valueOf(v), (Object)s.serialize((HttpPartSchema)null, (Object)v));
        }
    }

    @Test
    public void i02b_noSchemaTests_ShortArray() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"1,32767,-32768,null", (Object)s.serialize((HttpPartSchema)null, (Object)new Short[]{new Short(1), (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, null}));
    }

    @Test
    public void i03a_noSchemaTests_Long() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        for (Long v : AList.create((Object[])new Long[]{new Long(1L), Long.MAX_VALUE, Long.MIN_VALUE})) {
            Assert.assertEquals((Object)String.valueOf(v), (Object)s.serialize((HttpPartSchema)null, (Object)v));
        }
    }

    @Test
    public void i03b_noSchemaTests_LongArray() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"1,9223372036854775807,-9223372036854775808,null", (Object)s.serialize((HttpPartSchema)null, (Object)new Long[]{new Long(1L), Long.MAX_VALUE, Long.MIN_VALUE, null}));
    }

    @Test
    public void i04a_noSchemaTests_Float() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        for (Float v : AList.create((Object[])new Float[]{new Float(1.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE)})) {
            Assert.assertEquals((Object)String.valueOf(v), (Object)s.serialize((HttpPartSchema)null, (Object)v));
        }
    }

    @Test
    public void i04b_noSchemaTests_FloatArray() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"1.0,3.4028235E38,1.4E-45", (Object)s.serialize((HttpPartSchema)null, (Object)new Float[]{new Float(1.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE)}));
    }

    @Test
    public void i05a_noSchemaTests_Double() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        for (Double v : AList.create((Object[])new Double[]{new Double(1.0), Double.MAX_VALUE, Double.MIN_VALUE})) {
            Assert.assertEquals((Object)String.valueOf(v), (Object)s.serialize((HttpPartSchema)null, (Object)v));
        }
    }

    @Test
    public void i05b_noSchemaTests_DoubleArray() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"1.0,1.7976931348623157E308,4.9E-324", (Object)s.serialize((HttpPartSchema)null, (Object)new Double[]{new Double(1.0), Double.MAX_VALUE, Double.MIN_VALUE}));
    }

    @Test
    public void i06a_noSchemaTests_Boolean() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        for (Boolean v : AList.create((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE})) {
            Assert.assertEquals((Object)String.valueOf(v), (Object)s.serialize((HttpPartSchema)null, (Object)v));
        }
    }

    @Test
    public void i06b_noSchemaTests_BooleanArray() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"true,false,null", (Object)s.serialize((HttpPartSchema)null, (Object)new Boolean[]{Boolean.TRUE, Boolean.FALSE, null}));
    }

    @Test
    public void i07_noSchemaTests_Null() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"null", (Object)s.serialize((HttpPartSchema)null, null));
    }

    @Test
    public void i08a_noSchemaTests_String() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        for (String v : AList.create((Object[])new String[]{"foo", "", null})) {
            Assert.assertEquals((Object)String.valueOf(v), (Object)s.serialize((HttpPartSchema)null, (Object)v));
        }
    }

    @Test
    public void i08b_noSchemaTests_StringArray() throws Exception {
        OpenApiSerializer s = OpenApiSerializer.DEFAULT;
        Assert.assertEquals((Object)"foo,,null", (Object)s.serialize((HttpPartSchema)null, (Object)new String[]{"foo", "", null}));
    }

    private static HttpPartSchemaBuilder schema() {
        return HttpPartSchema.create();
    }

    private static HttpPartSchemaBuilder schema(String type) {
        return HttpPartSchema.create((String)type);
    }

    private static HttpPartSchemaBuilder schema(String type, String format) {
        return HttpPartSchema.create((String)type, (String)format);
    }

    public static class H2 {
        public Object f01;
        public Object f02;
        public Object f04;
        public Object f05;
        public Object f06;
        public Object f07;
        public Object f08;
        public Object f09;
        public Object f10;
        public Object f11;
        public Object f12;
        public Object f99;

        public H2(Object f01, Object f02, Object f04, Object f05, Object f06, Object f07, Object f08, Object f09, Object f10, Object f11, Object f12, Object f99) {
            this.f01 = f01;
            this.f02 = f02;
            this.f04 = f04;
            this.f05 = f05;
            this.f06 = f06;
            this.f07 = f07;
            this.f08 = f08;
            this.f09 = f09;
            this.f10 = f10;
            this.f11 = f11;
            this.f12 = f12;
            this.f99 = f99;
        }
    }

    public static class H1 {
        public String f1;
        public Integer f2;
        public Boolean f3;

        public H1(String f1, Integer f2, Boolean f3) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }
    }

    public static class G4 {
        private Double[] f;

        public G4(Double ... in) {
            this.f = in;
        }

        public Double[] toDoubleArray() {
            return this.f;
        }
    }

    public static class G3 {
        private Double f;

        public G3(Double in) {
            this.f = in;
        }

        public Double toDouble() {
            return this.f;
        }
    }

    public static class G2 {
        private Float[] f;

        public G2(Float ... in) {
            this.f = in;
        }

        public Float[] toFloatArray() {
            return this.f;
        }
    }

    public static class G1 {
        private Float f;

        public G1(Float in) {
            this.f = in;
        }

        public Float toFloat() {
            return this.f;
        }
    }

    public static class F4 {
        private Long[] f;

        public F4(Long ... in) {
            this.f = in;
        }

        public Long[] toLongArray() {
            return this.f;
        }
    }

    public static class F3 {
        private Long f;

        public F3(Long in) {
            this.f = in;
        }

        public Long toLong() {
            return this.f;
        }
    }

    public static class F2 {
        private Integer[] f;

        public F2(Integer ... in) {
            this.f = in;
        }

        public Integer[] toIntegerArray() {
            return this.f;
        }
    }

    public static class F1 {
        private Integer f;

        public F1(Integer in) {
            this.f = in;
        }

        public Integer toInteger() {
            return this.f;
        }
    }

    public static class E2 {
        private Boolean[] f;

        public E2(Boolean ... in) {
            this.f = in;
        }

        public Boolean[] toBooleanArray() {
            return this.f;
        }
    }

    public static class E1 {
        private Boolean f;

        public E1(Boolean in) {
            this.f = in;
        }

        public Boolean toBoolean() {
            return this.f;
        }
    }

    public static class D {
        private String f;

        public D(String in) {
            this.f = in;
        }

        public String toString() {
            return this.f;
        }
    }

    public static class C3 {
        private String[] f;

        public C3(String ... in) {
            this.f = in;
        }

        public String[] toStringArray() {
            return this.f;
        }
    }

    public static class C2 {
        private String f;

        public C2(String s) {
            this.f = s;
        }

        public String toString() {
            return this.f;
        }
    }

    public static class C1 {
        private byte[] f;

        public C1(byte[] f) {
            this.f = f;
        }

        public byte[] toByteArray() {
            return this.f;
        }
    }
}

