/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSchemaBuilder;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiParserSession;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OpenApiPartParserTest {
    static OpenApiParserSession p = OpenApiParser.DEFAULT.createSession();

    @Test
    public void a01_inputValidations_nullInput() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema().build();
        Assert.assertNull((Object)p.parse(s, null, String.class));
        s = OpenApiPartParserTest.schema().required(Boolean.valueOf(false)).build();
        Assert.assertNull((Object)p.parse(s, null, String.class));
        s = OpenApiPartParserTest.schema().required().build();
        try {
            p.parse(s, null, String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"No value specified.", (Object)e.getMessage());
        }
        s = OpenApiPartParserTest.schema().required(Boolean.valueOf(true)).build();
        try {
            p.parse(s, null, String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"No value specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void a02_inputValidations_emptyInput() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema().allowEmptyValue().build();
        Assert.assertEquals((Object)"", (Object)p.parse(s, "", String.class));
        s = OpenApiPartParserTest.schema().allowEmptyValue().build();
        Assert.assertEquals((Object)"", (Object)p.parse(s, "", String.class));
        s = OpenApiPartParserTest.schema().allowEmptyValue(Boolean.valueOf(false)).build();
        try {
            p.parse(s, "", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Empty value not allowed.", (Object)e.getMessage());
        }
        try {
            p.parse(s, "", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Empty value not allowed.", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)" ", (Object)p.parse(s, " ", String.class));
    }

    @Test
    public void a03_inputValidations_pattern() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema().pattern("x.*").allowEmptyValue().build();
        Assert.assertEquals((Object)"x", (Object)p.parse(s, "x", String.class));
        Assert.assertEquals((Object)"xx", (Object)p.parse(s, "xx", String.class));
        Assert.assertEquals(null, (Object)p.parse(s, null, String.class));
        try {
            p.parse(s, "y", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match expected pattern.  Must match pattern: x.*", (Object)e.getMessage());
        }
        try {
            p.parse(s, "", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match expected pattern.  Must match pattern: x.*", (Object)e.getMessage());
        }
        s = OpenApiPartParserTest.schema().pattern("").allowEmptyValue().build();
        Assert.assertEquals((Object)"x", (Object)p.parse(s, "x", String.class));
        s = OpenApiPartParserTest.schema().pattern(null).allowEmptyValue().build();
        Assert.assertEquals((Object)"x", (Object)p.parse(s, "x", String.class));
    }

    @Test
    public void a04_inputValidations_enum() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema()._enum(new String[]{"foo"}).allowEmptyValue().build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
        Assert.assertEquals(null, (Object)p.parse(s, null, String.class));
        try {
            p.parse(s, "bar", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['foo']", (Object)e.getMessage());
        }
        try {
            p.parse(s, "", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['foo']", (Object)e.getMessage());
        }
        s = OpenApiPartParserTest.schema()._enum((Set)null).build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
        s = OpenApiPartParserTest.schema()._enum((Set)null).allowEmptyValue().build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
        s = OpenApiPartParserTest.schema()._enum(new String[]{"foo", "foo"}).build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
    }

    @Test
    public void a05_inputValidations_minMaxLength() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema().minLength(Long.valueOf(1L)).maxLength(Long.valueOf(2L)).allowEmptyValue().build();
        Assert.assertEquals(null, (Object)p.parse(s, null, String.class));
        Assert.assertEquals((Object)"1", (Object)p.parse(s, "1", String.class));
        Assert.assertEquals((Object)"12", (Object)p.parse(s, "12", String.class));
        try {
            p.parse(s, "", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Minimum length of value not met.", (Object)e.getMessage());
        }
        try {
            p.parse(s, "123", String.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Maximum length of value exceeded.", (Object)e.getMessage());
        }
        try {
            s = OpenApiPartParserTest.schema().minLength(Long.valueOf(2L)).maxLength(Long.valueOf(1L)).build();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("maxLength cannot be less than minLength."));
        }
        try {
            s = OpenApiPartParserTest.schema().minLength(Long.valueOf(-2L)).build();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("minLength cannot be less than zero."));
        }
        try {
            s = OpenApiPartParserTest.schema().maxLength(Long.valueOf(-2L)).build();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("maxLength cannot be less than zero."));
        }
    }

    @Test
    public void b01_primitiveDefaults() throws Exception {
        Assert.assertEquals(null, (Object)p.parse(null, null, Boolean.class));
        Assert.assertEquals((Object)false, (Object)p.parse(null, null, Boolean.TYPE));
        Assert.assertEquals(null, (Object)p.parse(null, null, Character.class));
        Assert.assertEquals((Object)"\u0000", (Object)((Character)p.parse(null, null, Character.TYPE)).toString());
        Assert.assertEquals(null, (Object)p.parse(null, null, Short.class));
        Assert.assertEquals((long)0L, (long)((Short)p.parse(null, null, Short.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, null, Integer.class));
        Assert.assertEquals((long)0L, (long)((Integer)p.parse(null, null, Integer.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, null, Long.class));
        Assert.assertEquals((long)0L, (long)((Long)p.parse(null, null, Long.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, null, Float.class));
        Assert.assertEquals((long)0L, (long)((Float)p.parse(null, null, Float.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, null, Double.class));
        Assert.assertEquals((long)0L, (long)((Double)p.parse(null, null, Double.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, null, Byte.class));
        Assert.assertEquals((long)0L, (long)((Byte)p.parse(null, null, Byte.TYPE)).intValue());
    }

    @Test
    public void b02_primitiveDefaults_nullKeyword() throws Exception {
        Assert.assertEquals(null, (Object)p.parse(null, "null", Boolean.class));
        Assert.assertEquals((Object)false, (Object)p.parse(null, "null", Boolean.TYPE));
        Assert.assertEquals(null, (Object)p.parse(null, "null", Character.class));
        Assert.assertEquals((Object)"\u0000", (Object)((Character)p.parse(null, "null", Character.TYPE)).toString());
        Assert.assertEquals(null, (Object)p.parse(null, "null", Short.class));
        Assert.assertEquals((long)0L, (long)((Short)p.parse(null, "null", Short.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, "null", Integer.class));
        Assert.assertEquals((long)0L, (long)((Integer)p.parse(null, "null", Integer.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, "null", Long.class));
        Assert.assertEquals((long)0L, (long)((Long)p.parse(null, "null", Long.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, "null", Float.class));
        Assert.assertEquals((long)0L, (long)((Float)p.parse(null, "null", Float.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, "null", Double.class));
        Assert.assertEquals((long)0L, (long)((Double)p.parse(null, "null", Double.TYPE)).intValue());
        Assert.assertEquals(null, (Object)p.parse(null, "null", Byte.class));
        Assert.assertEquals((long)0L, (long)((Byte)p.parse(null, "null", Byte.TYPE)).intValue());
    }

    @Test
    public void c01_stringType_simple() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string").build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
    }

    @Test
    public void c02_stringType_default() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string")._default("x").build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
        Assert.assertEquals((Object)"x", (Object)p.parse(s, null, String.class));
    }

    @Test
    public void c03_stringType_byteFormat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string", "byte").build();
        String in = StringUtils.base64Encode((byte[])"foo".getBytes());
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, in, String.class));
        Assert.assertEquals((Object)"foo", (Object)IOUtils.read((InputStream)((InputStream)p.parse(s, in, InputStream.class))));
        Assert.assertEquals((Object)"foo", (Object)IOUtils.read((Reader)((Reader)p.parse(s, in, Reader.class))));
        Assert.assertEquals((Object)"C1-foo", (Object)((C1)p.parse(s, in, C1.class)).toString());
    }

    @Test
    public void c04_stringType_binaryFormat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string", "binary").build();
        String in = StringUtils.toHex((byte[])"foo".getBytes());
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, in, String.class));
        Assert.assertEquals((Object)"foo", (Object)IOUtils.read((InputStream)((InputStream)p.parse(s, in, InputStream.class))));
        Assert.assertEquals((Object)"foo", (Object)IOUtils.read((Reader)((Reader)p.parse(s, in, Reader.class))));
        Assert.assertEquals((Object)"C1-foo", (Object)((C1)p.parse(s, in, C1.class)).toString());
    }

    @Test
    public void c05_stringType_binarySpacedFormat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string", "binary-spaced").build();
        String in = StringUtils.toSpacedHex((byte[])"foo".getBytes());
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, in, String.class));
        Assert.assertEquals((Object)"foo", (Object)IOUtils.read((InputStream)((InputStream)p.parse(s, in, InputStream.class))));
        Assert.assertEquals((Object)"foo", (Object)IOUtils.read((Reader)((Reader)p.parse(s, in, Reader.class))));
        Assert.assertEquals((Object)"C1-foo", (Object)((C1)p.parse(s, in, C1.class)).toString());
    }

    @Test
    public void c06_stringType_dateFormat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string", "date").build();
        String in = "2012-12-21";
        Assert.assertTrue((boolean)((String)p.parse(s, in, String.class)).contains("2012"));
        Assert.assertTrue((boolean)((Date)p.parse(s, in, Date.class)).toString().contains("2012"));
        Assert.assertEquals((long)2012L, (long)((Calendar)p.parse(s, in, Calendar.class)).get(1));
        Assert.assertEquals((long)2012L, (long)((GregorianCalendar)p.parse(s, in, GregorianCalendar.class)).get(1));
    }

    @Test
    public void c07_stringType_dateTimeFormat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string", "date-time").build();
        String in = "2012-12-21T12:34:56.789";
        Assert.assertTrue((boolean)((String)p.parse(s, in, String.class)).contains("2012"));
        Assert.assertTrue((boolean)((Date)p.parse(s, in, Date.class)).toString().contains("2012"));
        Assert.assertEquals((long)2012L, (long)((Calendar)p.parse(s, in, Calendar.class)).get(1));
        Assert.assertEquals((long)2012L, (long)((GregorianCalendar)p.parse(s, in, GregorianCalendar.class)).get(1));
    }

    @Test
    public void c08_stringType_uonFormat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string", "uon").build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "'foo'", String.class));
        Assert.assertEquals((Object)"C2-foo", (Object)((C2)p.parse(s, "'foo'", C2.class)).toString());
    }

    @Test
    public void c09_stringType_noneFormat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string").build();
        Assert.assertEquals((Object)"foo", (Object)p.parse(s, "foo", String.class));
        Assert.assertEquals((Object)"'foo'", (Object)p.parse(s, "'foo'", String.class));
        Assert.assertEquals((Object)"C2-foo", (Object)((C2)p.parse(s, "foo", C2.class)).toString());
    }

    @Test
    public void c10_stringType_noneFormat_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string")).build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", Object[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", List.class, new Type[]{Object.class}));
        Object o = p.parse(s, "foo,bar", Object.class);
        TestUtils.assertObjectEquals("['foo','bar']", o);
        TestUtils.assertClass(ObjectList.class, o);
        TestUtils.assertObjectEquals("['C2-foo','C2-bar']", p.parse(s, "foo,bar", C2[].class));
        TestUtils.assertObjectEquals("['C2-foo','C2-bar']", p.parse(s, "foo,bar", List.class, new Type[]{C2.class}));
        Assert.assertEquals((Object)"C3-['foo','bar']", (Object)((C3)p.parse(s, "foo,bar", C3.class)).toString());
    }

    @Test
    public void c11_stringType_noneFormat_3d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string"))).build();
        TestUtils.assertObjectEquals("[['foo','bar'],['baz']]", p.parse(s, "foo,bar|baz", String[][].class));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz']]", p.parse(s, "foo,bar|baz", List.class, new Type[]{String[].class}));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz']]", p.parse(s, "foo,bar|baz", List.class, new Type[]{List.class, String.class}));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz']]", p.parse(s, "foo,bar|baz", Object[][].class));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz']]", p.parse(s, "foo,bar|baz", List.class, new Type[]{Object[].class}));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz']]", p.parse(s, "foo,bar|baz", List.class, new Type[]{List.class, Object.class}));
        Object o = p.parse(s, "foo,bar|baz", Object.class);
        TestUtils.assertObjectEquals("[['foo','bar'],['baz']]", o);
        TestUtils.assertClass(ObjectList.class, o);
        TestUtils.assertObjectEquals("[['C2-foo','C2-bar'],['C2-baz']]", p.parse(s, "foo,bar|baz", C2[][].class));
        TestUtils.assertObjectEquals("[['C2-foo','C2-bar'],['C2-baz']]", p.parse(s, "foo,bar|baz", List.class, new Type[]{C2[].class}));
        TestUtils.assertObjectEquals("[['C2-foo','C2-bar'],['C2-baz']]", p.parse(s, "foo,bar|baz", List.class, new Type[]{List.class, C2.class}));
        TestUtils.assertObjectEquals("['C3-[\\'foo\\',\\'bar\\']','C3-[\\'baz\\']']", p.parse(s, "foo,bar|baz", C3[].class));
        TestUtils.assertObjectEquals("['C3-[\\'foo\\',\\'bar\\']','C3-[\\'baz\\']']", p.parse(s, "foo,bar|baz", List.class, new Type[]{C3.class}));
    }

    @Test
    public void c12a_stringType_nullKeyword_plain() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string").build();
        Assert.assertEquals((Object)"null", (Object)p.parse(s, "null", String.class));
    }

    @Test
    public void c12b_stringType_nullKeyword_plain_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string")).build();
        TestUtils.assertObjectEquals("['null']", p.parse(s, "null", String[].class));
        TestUtils.assertObjectEquals("[null]", p.parse(s, "@(null)", String[].class));
    }

    @Test
    public void c12c_stringType_nullKeyword_uon() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("string", "uon").build();
        Assert.assertEquals(null, (Object)p.parse(s, "null", String.class));
        Assert.assertEquals((Object)"null", (Object)p.parse(s, "'null'", String.class));
    }

    @Test
    public void c12d_stringType_nullKeyword_uon_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string", "uon")).build();
        TestUtils.assertObjectEquals("[null,'x']", p.parse(s, "null,x", String[].class));
        TestUtils.assertObjectEquals("[null]", p.parse(s, "null", String[].class));
        TestUtils.assertObjectEquals("[null]", p.parse(s, "@(null)", String[].class));
        TestUtils.assertObjectEquals("['null']", p.parse(s, "'null'", String[].class));
        TestUtils.assertObjectEquals("['null']", p.parse(s, "@('null')", String[].class));
    }

    @Test
    public void d01_arrayType_collectionFormatCsv() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("csv").build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", Object[].class));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo,bar", D[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo,bar", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", Object.class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", ObjectList.class));
    }

    @Test
    public void d02_arrayType_collectionFormatPipes() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo|bar", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo|bar", Object[].class));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo|bar", D[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo|bar", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo|bar", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo|bar", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo|bar", Object.class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo|bar", ObjectList.class));
    }

    @Test
    public void d03_arrayType_collectionFormatSsv() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("ssv").build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo bar", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo bar", Object[].class));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo bar", D[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo bar", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo bar", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo bar", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo bar", Object.class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo bar", ObjectList.class));
    }

    @Test
    public void d04_arrayType_collectionFormatTsv() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("tsv").build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo\tbar", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo\tbar", Object[].class));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo\tbar", D[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo\tbar", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo\tbar", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo\tbar", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo\tbar", Object.class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo\tbar", ObjectList.class));
    }

    @Test
    public void d05_arrayType_collectionFormatUon() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("uon").build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", Object[].class));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "@(foo,bar)", D[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "@(foo,bar)", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", Object.class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", ObjectList.class));
    }

    @Test
    public void d06a_arrayType_collectionFormatNone() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", Object[].class));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo,bar", D[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "foo,bar", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "foo,bar", Object.class));
    }

    @Test
    public void d06b_arrayType_collectionFormatNone_autoDetectUon() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").build();
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", String[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", Object[].class));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "@(foo,bar)", D[].class));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo','D-bar']", p.parse(s, "@(foo,bar)", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo','bar']", p.parse(s, "@(foo,bar)", Object.class));
    }

    @Test
    public void d07_arrayType_collectionFormatMulti() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("multi").build();
        TestUtils.assertObjectEquals("['foo,bar']", p.parse(s, "foo,bar", String[].class));
        TestUtils.assertObjectEquals("['foo,bar']", p.parse(s, "foo,bar", Object[].class));
        TestUtils.assertObjectEquals("['D-foo,bar']", p.parse(s, "foo,bar", D[].class));
        TestUtils.assertObjectEquals("['foo,bar']", p.parse(s, "foo,bar", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("['foo,bar']", p.parse(s, "foo,bar", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['D-foo,bar']", p.parse(s, "foo,bar", List.class, new Type[]{D.class}));
        TestUtils.assertObjectEquals("['foo,bar']", p.parse(s, "foo,bar", Object.class));
    }

    @Test
    public void d08_arrayType_collectionFormatCsvAndPipes() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("array").collectionFormat("csv")).build();
        TestUtils.assertObjectEquals("[['foo','bar'],['baz','qux']]", p.parse(s, "foo,bar|baz,qux", String[][].class));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz','qux']]", p.parse(s, "foo,bar|baz,qux", Object[][].class));
        TestUtils.assertObjectEquals("[['D-foo','D-bar'],['D-baz','D-qux']]", p.parse(s, "foo,bar|baz,qux", D[][].class));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz','qux']]", p.parse(s, "foo,bar|baz,qux", List.class, new Type[]{List.class, String.class}));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz','qux']]", p.parse(s, "foo,bar|baz,qux", List.class, new Type[]{List.class, Object.class}));
        TestUtils.assertObjectEquals("[['D-foo','D-bar'],['D-baz','D-qux']]", p.parse(s, "foo,bar|baz,qux", List.class, new Type[]{List.class, D.class}));
        TestUtils.assertObjectEquals("[['foo','bar'],['baz','qux']]", p.parse(s, "foo,bar|baz,qux", Object.class));
    }

    @Test
    public void d09_arrayType_itemsBoolean() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("csv").items(OpenApiPartParserTest.schema("boolean")).build();
        TestUtils.assertObjectEquals("[true,false]", p.parse(s, "true,false", boolean[].class));
        TestUtils.assertObjectEquals("[true,false,null]", p.parse(s, "true,false,null", Boolean[].class));
        TestUtils.assertObjectEquals("[true,false,null]", p.parse(s, "true,false,null", Object[].class));
        TestUtils.assertObjectEquals("[true,false,null]", p.parse(s, "true,false,null", List.class, new Type[]{Boolean.class}));
        TestUtils.assertObjectEquals("[true,false,null]", p.parse(s, "true,false,null", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("[true,false,null]", p.parse(s, "true,false,null", Object.class));
    }

    @Test
    public void d10_arrayType_itemsInteger() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("csv").items(OpenApiPartParserTest.schema("integer")).build();
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", int[].class));
        TestUtils.assertObjectEquals("[1,2,null]", p.parse(s, "1,2,null", Integer[].class));
        TestUtils.assertObjectEquals("[1,2,null]", p.parse(s, "1,2,null", Object[].class));
        TestUtils.assertObjectEquals("[1,2,null]", p.parse(s, "1,2,null", List.class, new Type[]{Integer.class}));
        TestUtils.assertObjectEquals("[1,2,null]", p.parse(s, "1,2,null", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("[1,2,null]", p.parse(s, "1,2,null", Object.class));
    }

    @Test
    public void d11_arrayType_itemsFloat() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("csv").items(OpenApiPartParserTest.schema("number")).build();
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1.0,2.0", float[].class));
        TestUtils.assertObjectEquals("[1.0,2.0,null]", p.parse(s, "1.0,2.0,null", Float[].class));
        TestUtils.assertObjectEquals("[1.0,2.0,null]", p.parse(s, "1.0,2.0,null", Object[].class));
        TestUtils.assertObjectEquals("[1.0,2.0,null]", p.parse(s, "1.0,2.0,null", List.class, new Type[]{Float.class}));
        TestUtils.assertObjectEquals("[1.0,2.0,null]", p.parse(s, "1.0,2.0,null", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("[1.0,2.0,null]", p.parse(s, "1.0,2.0,null", Object.class));
    }

    @Test
    public void e01_booleanType() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("boolean").build();
        Assert.assertEquals((Object)true, (Object)p.parse(s, "true", Boolean.TYPE));
        Assert.assertEquals((Object)true, (Object)p.parse(s, "true", Boolean.class));
        Assert.assertNull((Object)p.parse(s, "null", Boolean.class));
        Assert.assertEquals((Object)true, (Object)p.parse(s, "True", Boolean.TYPE));
        Assert.assertEquals((Object)true, (Object)p.parse(s, "TRUE", Boolean.TYPE));
        Assert.assertEquals((Object)"true", (Object)p.parse(s, "true", String.class));
        Assert.assertNull((Object)p.parse(s, "null", String.class));
        Assert.assertEquals((Object)true, (Object)p.parse(s, "true", Object.class));
        Assert.assertNull((Object)p.parse(s, "null", Object.class));
        TestUtils.assertObjectEquals("'E1-true'", p.parse(s, "true", E1.class));
        Assert.assertNull((Object)p.parse(s, "null", E1.class));
    }

    @Test
    public void e02_booleanType_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("boolean")).build();
        TestUtils.assertObjectEquals("[true,true]", p.parse(s, "true,true", boolean[].class));
        TestUtils.assertObjectEquals("[true,true,null]", p.parse(s, "true,true,null", Boolean[].class));
        TestUtils.assertObjectEquals("[true,true,null]", p.parse(s, "true,true,null", List.class, new Type[]{Boolean.class}));
        TestUtils.assertObjectEquals("['true','true',null]", p.parse(s, "true,true,null", String[].class));
        TestUtils.assertObjectEquals("['true','true',null]", p.parse(s, "true,true,null", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("[true,true,null]", p.parse(s, "true,true,null", Object[].class));
        TestUtils.assertObjectEquals("[true,true,null]", p.parse(s, "true,true,null", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['E1-true','E1-true',null]", p.parse(s, "true,true,null", E1[].class));
        TestUtils.assertObjectEquals("['E1-true','E1-true',null]", p.parse(s, "true,true,null", List.class, new Type[]{E1.class}));
        TestUtils.assertObjectEquals("'E2-[true,true,null]'", p.parse(s, "true,true,null", E2.class));
        TestUtils.assertObjectEquals("[true,true]", p.parse(s, "True,true", boolean[].class));
        TestUtils.assertObjectEquals("[true,true]", p.parse(s, "TRUE,true", boolean[].class));
    }

    @Test
    public void e03_booleanType_3d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("boolean"))).build();
        TestUtils.assertObjectEquals("[[true,true],[false]]", p.parse(s, "true,true|false", boolean[][].class));
        TestUtils.assertObjectEquals("[[true,true],[false]]", p.parse(s, "true,true|false", List.class, new Type[]{boolean[].class}));
        TestUtils.assertObjectEquals("[[true,true],[false,null]]", p.parse(s, "true,true|false,null", Boolean[][].class));
        TestUtils.assertObjectEquals("[[true,true],[false,null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{Boolean[].class}));
        TestUtils.assertObjectEquals("[[true,true],[false,null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{List.class, Boolean.class}));
        TestUtils.assertObjectEquals("[['true','true'],['false',null]]", p.parse(s, "true,true|false,null", String[][].class));
        TestUtils.assertObjectEquals("[['true','true'],['false',null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{List.class, String.class}));
        TestUtils.assertObjectEquals("[['true','true'],['false',null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{String[].class}));
        TestUtils.assertObjectEquals("[[true,true],[false,null]]", p.parse(s, "true,true|false,null", Object[][].class));
        TestUtils.assertObjectEquals("[[true,true],[false,null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{List.class, Object.class}));
        TestUtils.assertObjectEquals("[[true,true],[false,null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{Object[].class}));
        TestUtils.assertObjectEquals("[['E1-true','E1-true'],['E1-false',null]]", p.parse(s, "true,true|false,null", E1[][].class));
        TestUtils.assertObjectEquals("[['E1-true','E1-true'],['E1-false',null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{List.class, E1.class}));
        TestUtils.assertObjectEquals("[['E1-true','E1-true'],['E1-false',null]]", p.parse(s, "true,true|false,null", List.class, new Type[]{E1[].class}));
        TestUtils.assertObjectEquals("['E2-[true,true]','E2-[false,null]']", p.parse(s, "true,true|false,null", E2[].class));
        TestUtils.assertObjectEquals("['E2-[true,true]','E2-[false,null]']", p.parse(s, "true,true|false,null", List.class, new Type[]{E2.class}));
        TestUtils.assertObjectEquals("[[true,true],[false]]", p.parse(s, "True,true|false", boolean[][].class));
        TestUtils.assertObjectEquals("[[true,true],[false]]", p.parse(s, "TRUE,true|false", boolean[][].class));
    }

    @Test
    public void f01_integerType_int32() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("integer", "int32").build();
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Integer.TYPE));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Integer.class));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Short.TYPE));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Short.class));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Long.TYPE));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Long.class));
        TestUtils.assertObjectEquals("'1'", p.parse(s, "1", String.class));
        Object o = p.parse(s, "1", Object.class);
        TestUtils.assertObjectEquals("1", o);
        TestUtils.assertClass(Integer.class, o);
        TestUtils.assertObjectEquals("'F1-1'", p.parse(s, "1", F1.class));
    }

    @Test
    public void f02_integerType_int32_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("integer", "int32")).build();
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", int[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Integer[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Integer.class}));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", short[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Short[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Short.class}));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", long[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Long[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Long.class}));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", String[].class));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Object[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("['F1-1','F1-2']", p.parse(s, "1,2", F1[].class));
        TestUtils.assertObjectEquals("['F1-1','F1-2']", p.parse(s, "1,2", List.class, new Type[]{F1.class}));
        TestUtils.assertObjectEquals("'F2-[1,2]'", p.parse(s, "1,2", F2.class));
    }

    @Test
    public void f03_integerType_int32_3d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("integer", "int32"))).build();
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", int[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{int[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Integer[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Integer[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Integer.class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", short[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{short[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Short[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Short[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Short.class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", long[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{long[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Long[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Long[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Long.class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", String[][].class));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{String[].class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, String.class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Object[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Object[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Object.class}));
        TestUtils.assertObjectEquals("[['F1-1','F1-2'],['F1-3']]", p.parse(s, "1,2|3", F1[][].class));
        TestUtils.assertObjectEquals("[['F1-1','F1-2'],['F1-3']]", p.parse(s, "1,2|3", List.class, new Type[]{F1[].class}));
        TestUtils.assertObjectEquals("[['F1-1','F1-2'],['F1-3']]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, F1.class}));
        TestUtils.assertObjectEquals("['F2-[1,2]','F2-[3]']", p.parse(s, "1,2|3", F2[].class));
        TestUtils.assertObjectEquals("['F2-[1,2]','F2-[3]']", p.parse(s, "1,2|3", List.class, new Type[]{F2.class}));
    }

    @Test
    public void f04_integerType_int64() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("integer", "int64").build();
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Integer.TYPE));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Integer.class));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Short.TYPE));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Short.class));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Long.TYPE));
        TestUtils.assertObjectEquals("1", p.parse(s, "1", Long.class));
        TestUtils.assertObjectEquals("'1'", p.parse(s, "1", String.class));
        Object o = p.parse(s, "1", Object.class);
        TestUtils.assertObjectEquals("1", o);
        TestUtils.assertClass(Long.class, o);
        TestUtils.assertObjectEquals("1", p.parse(s, "1", F3.class));
    }

    @Test
    public void f05_integerType_int64_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("integer", "int64")).build();
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", int[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Integer[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Integer.class}));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", short[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Short[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Short.class}));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", long[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Long[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Long.class}));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", String[].class));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", Object[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", F3[].class));
        TestUtils.assertObjectEquals("[1,2]", p.parse(s, "1,2", List.class, new Type[]{F3.class}));
        TestUtils.assertObjectEquals("'F4-[1,2]'", p.parse(s, "1,2", F4.class));
    }

    @Test
    public void f06_integerType_int64_3d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("integer", "int64"))).build();
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", int[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{int[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Integer[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Integer[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Integer.class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", short[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{short[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Short[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Short[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Short.class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", long[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{long[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Long[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Long[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Long.class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", String[][].class));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{String[].class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, String.class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", Object[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{Object[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Object.class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", F3[][].class));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{F3[].class}));
        TestUtils.assertObjectEquals("[[1,2],[3]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, F3.class}));
        TestUtils.assertObjectEquals("['F4-[1,2]','F4-[3]']", p.parse(s, "1,2|3", F4[].class));
        TestUtils.assertObjectEquals("['F4-[1,2]','F4-[3]']", p.parse(s, "1,2|3", List.class, new Type[]{F4.class}));
    }

    @Test
    public void g01_numberType_float() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("number", "float").build();
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Float.TYPE));
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Float.class));
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Double.TYPE));
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Double.class));
        TestUtils.assertObjectEquals("'1'", p.parse(s, "1", String.class));
        Object o = p.parse(s, "1", Object.class);
        TestUtils.assertObjectEquals("1.0", o);
        TestUtils.assertClass(Float.class, o);
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", G1.class));
    }

    @Test
    public void g02_numberType_float_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("number", "float")).build();
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", float[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", Float[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{Float.class}));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", double[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", Double[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{Double.class}));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", String[].class));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", Object[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", G1[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{G1.class}));
        TestUtils.assertObjectEquals("'G2-[1.0,2.0]'", p.parse(s, "1,2", G2.class));
    }

    @Test
    public void g03_numberType_float_3d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("number", "float"))).build();
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", float[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{float[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", Float[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{Float[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Float.class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", double[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{double[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", Double[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{Double[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Double.class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", String[][].class));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{String[].class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, String.class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", Object[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{Object[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Object.class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", G1[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{G1[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, G1.class}));
        TestUtils.assertObjectEquals("['G2-[1.0,2.0]','G2-[3.0]']", p.parse(s, "1,2|3", G2[].class));
        TestUtils.assertObjectEquals("['G2-[1.0,2.0]','G2-[3.0]']", p.parse(s, "1,2|3", List.class, new Type[]{G2.class}));
    }

    @Test
    public void g04_numberType_double() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("number", "double").build();
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Float.TYPE));
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Float.class));
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Double.TYPE));
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", Double.class));
        TestUtils.assertObjectEquals("'1'", p.parse(s, "1", String.class));
        Object o = p.parse(s, "1", Object.class);
        TestUtils.assertObjectEquals("1.0", o);
        TestUtils.assertClass(Double.class, o);
        TestUtils.assertObjectEquals("1.0", p.parse(s, "1", G3.class));
    }

    @Test
    public void g05_numberType_double_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("number", "double")).build();
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", float[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", Float[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{Float.class}));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", double[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", Double[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{Double.class}));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", String[].class));
        TestUtils.assertObjectEquals("['1','2']", p.parse(s, "1,2", List.class, new Type[]{String.class}));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", Object[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{Object.class}));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", G3[].class));
        TestUtils.assertObjectEquals("[1.0,2.0]", p.parse(s, "1,2", List.class, new Type[]{G3.class}));
        TestUtils.assertObjectEquals("'G4-[1.0,2.0]'", p.parse(s, "1,2", G4.class));
    }

    @Test
    public void g06_numberType_double_3d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("number", "double"))).build();
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", float[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{float[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", Float[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{Float[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Float.class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", double[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{double[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", Double[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{Double[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Double.class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", String[][].class));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{String[].class}));
        TestUtils.assertObjectEquals("[['1','2'],['3']]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, String.class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", Object[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{Object[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, Object.class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", G3[][].class));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{G3[].class}));
        TestUtils.assertObjectEquals("[[1.0,2.0],[3.0]]", p.parse(s, "1,2|3", List.class, new Type[]{List.class, G3.class}));
        TestUtils.assertObjectEquals("['G4-[1.0,2.0]','G4-[3.0]']", p.parse(s, "1,2|3", G4[].class));
        TestUtils.assertObjectEquals("['G4-[1.0,2.0]','G4-[3.0]']", p.parse(s, "1,2|3", List.class, new Type[]{G4.class}));
    }

    @Test
    public void h01_objectType() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().type("object").build();
        TestUtils.assertObjectEquals("{f:1}", p.parse(s, "(f=1)", H1.class));
        TestUtils.assertObjectEquals("{f:1}", p.parse(s, "(f=1)", ObjectMap.class));
        Object o = p.parse(s, "(f=1)", Object.class);
        TestUtils.assertObjectEquals("{f:1}", o);
        TestUtils.assertClass(ObjectMap.class, o);
    }

    @Test
    public void h02_objectType_2d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").format("uon").items(OpenApiPartParserTest.schema("object")).build();
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", p.parse(s, "@((f=1),(f=2))", H1[].class));
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", p.parse(s, "@((f=1),(f=2))", List.class, new Type[]{H1.class}));
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", p.parse(s, "@((f=1),(f=2))", ObjectMap[].class));
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", p.parse(s, "@((f=1),(f=2))", List.class, new Type[]{ObjectMap.class}));
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", p.parse(s, "@((f=1),(f=2))", Object[].class));
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", p.parse(s, "@((f=1),(f=2))", List.class, new Type[]{Object.class}));
        Object o = p.parse(s, "@((f=1),(f=2))", Object.class);
        TestUtils.assertObjectEquals("[{f:1},{f:2}]", o);
        TestUtils.assertClass(ObjectList.class, o);
    }

    @Test
    public void h03_objectType_3d() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("array").format("uon").items(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("object"))).build();
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", H1[][].class));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", List.class, new Type[]{H1[].class}));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", List.class, new Type[]{List.class, H1.class}));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", ObjectMap[][].class));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", List.class, new Type[]{ObjectMap[].class}));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", List.class, new Type[]{List.class, ObjectMap.class}));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", Object[][].class));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", List.class, new Type[]{Object[].class}));
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", List.class, new Type[]{List.class, Object.class}));
        Object o = p.parse(s, "@(@((f=1),(f=2)),@((f=3)))", Object.class);
        TestUtils.assertObjectEquals("[[{f:1},{f:2}],[{f:3}]]", o);
        TestUtils.assertClass(ObjectList.class, o);
    }

    @Test
    public void h04_objectType_simpleProperties() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("object").property("f01", OpenApiPartParserTest.schema("string")).property("f02", OpenApiPartParserTest.schema("string", "byte")).property("f04", OpenApiPartParserTest.schema("string", "date-time")).property("f05", OpenApiPartParserTest.schema("string", "binary")).property("f06", OpenApiPartParserTest.schema("string", "binary-spaced")).property("f07", OpenApiPartParserTest.schema("string", "uon")).property("f08", OpenApiPartParserTest.schema("integer")).property("f09", OpenApiPartParserTest.schema("integer", "int64")).property("f10", OpenApiPartParserTest.schema("number")).property("f11", OpenApiPartParserTest.schema("number", "double")).property("f12", OpenApiPartParserTest.schema("boolean")).additionalProperties(OpenApiPartParserTest.schema("integer")).build();
        byte[] foob = "foo".getBytes();
        String in = "(f01=foo,f02=" + StringUtils.base64Encode((byte[])foob) + ",f04=2012-12-21T12:34:56Z,f05=" + StringUtils.toHex((byte[])foob) + ",f06='" + StringUtils.toSpacedHex((byte[])foob) + "',f07=foo,f08=1,f09=1,f10=1,f11=1,f12=true,f99=1)";
        H2 h2 = (H2)p.parse(s, in, H2.class);
        TestUtils.assertObjectEquals("{f01:'foo',f02:[102,111,111],f04:'2012-12-21T12:34:56Z',f05:[102,111,111],f06:[102,111,111],f07:'foo',f08:1,f09:1,f10:1.0,f11:1.0,f12:true,f99:1}", h2);
        TestUtils.assertClass(String.class, h2.f01);
        TestUtils.assertClass(byte[].class, h2.f02);
        TestUtils.assertClass(GregorianCalendar.class, h2.f04);
        TestUtils.assertClass(byte[].class, h2.f05);
        TestUtils.assertClass(byte[].class, h2.f06);
        TestUtils.assertClass(String.class, h2.f07);
        TestUtils.assertClass(Integer.class, h2.f08);
        TestUtils.assertClass(Long.class, h2.f09);
        TestUtils.assertClass(Float.class, h2.f10);
        TestUtils.assertClass(Double.class, h2.f11);
        TestUtils.assertClass(Boolean.class, h2.f12);
        TestUtils.assertClass(Integer.class, h2.f99);
        ObjectMap om = (ObjectMap)p.parse(s, in, ObjectMap.class);
        TestUtils.assertObjectEquals("{f01:'foo',f02:[102,111,111],f04:'2012-12-21T12:34:56Z',f05:[102,111,111],f06:[102,111,111],f07:'foo',f08:1,f09:1,f10:1.0,f11:1.0,f12:true,f99:1}", om);
        TestUtils.assertClass(String.class, om.get((Object)"f01"));
        TestUtils.assertClass(byte[].class, om.get((Object)"f02"));
        TestUtils.assertClass(GregorianCalendar.class, om.get((Object)"f04"));
        TestUtils.assertClass(byte[].class, om.get((Object)"f05"));
        TestUtils.assertClass(byte[].class, om.get((Object)"f06"));
        TestUtils.assertClass(String.class, om.get((Object)"f07"));
        TestUtils.assertClass(Integer.class, om.get((Object)"f08"));
        TestUtils.assertClass(Long.class, om.get((Object)"f09"));
        TestUtils.assertClass(Float.class, om.get((Object)"f10"));
        TestUtils.assertClass(Double.class, om.get((Object)"f11"));
        TestUtils.assertClass(Boolean.class, om.get((Object)"f12"));
        TestUtils.assertClass(Integer.class, om.get((Object)"f99"));
        om = (ObjectMap)p.parse(s, in, Object.class);
        TestUtils.assertObjectEquals("{f01:'foo',f02:[102,111,111],f04:'2012-12-21T12:34:56Z',f05:[102,111,111],f06:[102,111,111],f07:'foo',f08:1,f09:1,f10:1.0,f11:1.0,f12:true,f99:1}", om);
        TestUtils.assertClass(String.class, om.get((Object)"f01"));
        TestUtils.assertClass(byte[].class, om.get((Object)"f02"));
        TestUtils.assertClass(GregorianCalendar.class, om.get((Object)"f04"));
        TestUtils.assertClass(byte[].class, om.get((Object)"f05"));
        TestUtils.assertClass(byte[].class, om.get((Object)"f06"));
        TestUtils.assertClass(String.class, om.get((Object)"f07"));
        TestUtils.assertClass(Integer.class, om.get((Object)"f08"));
        TestUtils.assertClass(Long.class, om.get((Object)"f09"));
        TestUtils.assertClass(Float.class, om.get((Object)"f10"));
        TestUtils.assertClass(Double.class, om.get((Object)"f11"));
        TestUtils.assertClass(Boolean.class, om.get((Object)"f12"));
        TestUtils.assertClass(Integer.class, om.get((Object)"f99"));
    }

    @Test
    public void h05_objectType_arrayProperties() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("object").property("f01", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string"))).property("f02", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string", "byte"))).property("f04", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string", "date-time"))).property("f05", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string", "binary"))).property("f06", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string", "binary-spaced"))).property("f07", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("string", "uon"))).property("f08", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("integer"))).property("f09", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("integer", "int64"))).property("f10", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("number"))).property("f11", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("number", "double"))).property("f12", OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("boolean"))).additionalProperties(OpenApiPartParserTest.schema("array").items(OpenApiPartParserTest.schema("integer"))).build();
        byte[] foob = "foo".getBytes();
        String in = "(f01=foo,f02=" + StringUtils.base64Encode((byte[])foob) + ",f04=2012-12-21T12:34:56Z,f05=" + StringUtils.toHex((byte[])foob) + ",f06='" + StringUtils.toSpacedHex((byte[])foob) + "',f07=foo,f08=1,f09=1,f10=1,f11=1,f12=true,f99=1)";
        H2 h2 = (H2)p.parse(s, in, H2.class);
        TestUtils.assertObjectEquals("{f01:['foo'],f02:[[102,111,111]],f04:['2012-12-21T12:34:56Z'],f05:[[102,111,111]],f06:[[102,111,111]],f07:['foo'],f08:[1],f09:[1],f10:[1.0],f11:[1.0],f12:[true],f99:[1]}", h2);
        ObjectMap om = (ObjectMap)p.parse(s, in, ObjectMap.class);
        TestUtils.assertObjectEquals("{f01:['foo'],f02:[[102,111,111]],f04:['2012-12-21T12:34:56Z'],f05:[[102,111,111]],f06:[[102,111,111]],f07:['foo'],f08:[1],f09:[1],f10:[1.0],f11:[1.0],f12:[true],f99:[1]}", om);
        om = (ObjectMap)p.parse(s, in, Object.class);
        TestUtils.assertObjectEquals("{f01:['foo'],f02:[[102,111,111]],f04:['2012-12-21T12:34:56Z'],f05:[[102,111,111]],f06:[[102,111,111]],f07:['foo'],f08:[1],f09:[1],f10:[1.0],f11:[1.0],f12:[true],f99:[1]}", om);
    }

    @Test
    public void h06_objectType_arrayProperties_pipes() throws Exception {
        HttpPartSchema s = OpenApiPartParserTest.schema("object").property("f01", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("string"))).property("f02", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("string", "byte"))).property("f04", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("string", "date-time"))).property("f05", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("string", "binary"))).property("f06", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("string", "binary-spaced"))).property("f07", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("string", "uon"))).property("f08", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("integer"))).property("f09", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("integer", "int64"))).property("f10", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("number"))).property("f11", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("number", "double"))).property("f12", OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("boolean"))).additionalProperties(OpenApiPartParserTest.schema("array").collectionFormat("pipes").items(OpenApiPartParserTest.schema("integer"))).build();
        byte[] foob = "foo".getBytes();
        byte[] barb = "bar".getBytes();
        String in = "(f01=foo|bar,f02=" + StringUtils.base64Encode((byte[])foob) + "|" + StringUtils.base64Encode((byte[])barb) + ",f04=2012-12-21T12:34:56Z|2012-12-21T12:34:56Z,f05=" + StringUtils.toHex((byte[])foob) + "|" + StringUtils.toHex((byte[])barb) + ",f06='" + StringUtils.toSpacedHex((byte[])foob) + "|" + StringUtils.toSpacedHex((byte[])barb) + "',f07=foo|bar,f08=1|2,f09=1|2,f10=1|2,f11=1|2,f12=true|true,f99=1|2)";
        H2 h2 = (H2)p.parse(s, in, H2.class);
        TestUtils.assertObjectEquals("{f01:['foo','bar'],f02:[[102,111,111],[98,97,114]],f04:['2012-12-21T12:34:56Z','2012-12-21T12:34:56Z'],f05:[[102,111,111],[98,97,114]],f06:[[102,111,111],[98,97,114]],f07:['foo','bar'],f08:[1,2],f09:[1,2],f10:[1.0,2.0],f11:[1.0,2.0],f12:[true,true],f99:[1,2]}", h2);
        ObjectMap om = (ObjectMap)p.parse(s, in, ObjectMap.class);
        TestUtils.assertObjectEquals("{f01:['foo','bar'],f02:[[102,111,111],[98,97,114]],f04:['2012-12-21T12:34:56Z','2012-12-21T12:34:56Z'],f05:[[102,111,111],[98,97,114]],f06:[[102,111,111],[98,97,114]],f07:['foo','bar'],f08:[1,2],f09:[1,2],f10:[1.0,2.0],f11:[1.0,2.0],f12:[true,true],f99:[1,2]}", om);
        om = (ObjectMap)p.parse(s, in, Object.class);
        TestUtils.assertObjectEquals("{f01:['foo','bar'],f02:[[102,111,111],[98,97,114]],f04:['2012-12-21T12:34:56Z','2012-12-21T12:34:56Z'],f05:[[102,111,111],[98,97,114]],f06:[[102,111,111],[98,97,114]],f07:['foo','bar'],f08:[1,2],f09:[1,2],f10:[1.0,2.0],f11:[1.0,2.0],f12:[true,true],f99:[1,2]}", om);
    }

    private static HttpPartSchemaBuilder schema() {
        return HttpPartSchema.create();
    }

    private static HttpPartSchemaBuilder schema(String type) {
        return HttpPartSchema.create((String)type);
    }

    private static HttpPartSchemaBuilder schema(String type, String format) {
        return HttpPartSchema.create((String)type, (String)format);
    }

    public static class H2 {
        public Object f01;
        public Object f02;
        public Object f03;
        public Object f04;
        public Object f05;
        public Object f06;
        public Object f07;
        public Object f08;
        public Object f09;
        public Object f10;
        public Object f11;
        public Object f12;
        public Object f99;
    }

    public static class H1 {
        public int f;
    }

    public static class G4 {
        private String f;

        public G4(Double[] in) {
            this.f = "G4-" + SimpleJsonSerializer.DEFAULT.toString((Object)in);
        }

        public String toString() {
            return this.f;
        }
    }

    public static class G3 {
        private Double f;

        public G3(double in) {
            this.f = in;
        }

        public double toDouble() {
            return this.f;
        }
    }

    public static class G2 {
        private String f;

        public G2(Float[] in) {
            this.f = "G2-" + SimpleJsonSerializer.DEFAULT.toString((Object)in);
        }

        public String toString() {
            return this.f;
        }
    }

    public static class G1 {
        private float f;

        public G1(float in) {
            this.f = in;
        }

        public float toFloat() {
            return this.f;
        }
    }

    public static class F4 {
        private String f;

        public F4(Long[] in) {
            this.f = "F4-" + SimpleJsonSerializer.DEFAULT.toString((Object)in);
        }

        public String toString() {
            return this.f;
        }
    }

    public static class F3 {
        private Long f;

        public F3(Long in) {
            this.f = in;
        }

        public Long toLong() {
            return this.f;
        }
    }

    public static class F2 {
        private String f;

        public F2(Integer[] in) {
            this.f = "F2-" + SimpleJsonSerializer.DEFAULT.toString((Object)in);
        }

        public String toString() {
            return this.f;
        }
    }

    public static class F1 {
        private String f;

        public F1(Integer in) {
            this.f = "F1-" + in.toString();
        }

        public String toString() {
            return this.f;
        }
    }

    public static class E2 {
        private String f;

        public E2(Boolean[] in) {
            this.f = "E2-" + SimpleJsonSerializer.DEFAULT.toString((Object)in);
        }

        public String toString() {
            return this.f;
        }
    }

    public static class E1 {
        private String f;

        public E1(Boolean in) {
            this.f = "E1-" + in.toString();
        }

        public String toString() {
            return this.f;
        }
    }

    public static class D {
        private String f;

        public D(String in) {
            this.f = "D-" + in;
        }

        public String toString() {
            return this.f;
        }
    }

    public static class C3 {
        private String f;

        public C3(String[] in) {
            this.f = "C3-" + SimpleJsonSerializer.DEFAULT.toString((Object)in);
        }

        public String toString() {
            return this.f;
        }
    }

    public static class C2 {
        private String f;

        public C2(String s) {
            this.f = "C2-" + s;
        }

        public String toString() {
            return this.f;
        }
    }

    public static class C1 {
        private String f;

        public C1(byte[] b) {
            this.f = "C1-" + new String(b);
        }

        public String toString() {
            return this.f;
        }
    }
}

