/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.reflect.Method;
import org.apache.juneau.BeanContext;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class HttpPartSchemaTest_FormData {
    @Test
    public void testBasic() throws Exception {
        HttpPartSchema.create().build();
    }

    @Test
    public void a01_value() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, A01.class).build();
        Assert.assertEquals((Object)"x", (Object)s.getName());
    }

    @Test
    public void a02_basic_onClass() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, A02.class).noValidate().build();
        Assert.assertEquals((Object)"x", (Object)s.getName());
        Assert.assertEquals((Object)HttpPartSchema.Type.NUMBER, (Object)s.getType());
        Assert.assertEquals((Object)HttpPartSchema.Format.INT32, (Object)s.getFormat());
        Assert.assertEquals((Object)HttpPartSchema.CollectionFormat.CSV, (Object)s.getCollectionFormat());
        Assert.assertEquals((Object)1, (Object)s.getMaximum());
        Assert.assertEquals((Object)2, (Object)s.getMinimum());
        Assert.assertEquals((Object)3, (Object)s.getMultipleOf());
        Assert.assertEquals((Object)"4", (Object)s.getPattern().pattern());
        Assert.assertEquals((long)1L, (long)s.getMaxLength());
        Assert.assertEquals((long)2L, (long)s.getMinLength());
        Assert.assertEquals((long)3L, (long)s.getMaxItems());
        Assert.assertEquals((long)4L, (long)s.getMinItems());
        Assert.assertTrue((boolean)s.isExclusiveMaximum());
        Assert.assertTrue((boolean)s.isExclusiveMinimum());
        Assert.assertTrue((boolean)s.isUniqueItems());
        Assert.assertTrue((boolean)s.isRequired());
        Assert.assertTrue((boolean)s.isSkipIfEmpty());
        TestUtils.assertObjectEquals("['e1','e2','e3']", s.getEnum());
        Assert.assertEquals((Object)"c1\nc2", (Object)s.getDefault());
    }

    @Test
    public void a03_basic_onParameter() throws Exception {
        ParamInfo mpi = MethodInfo.of((Method)A03.class.getMethod("a", String.class)).getParam(0);
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, mpi).noValidate().build();
        Assert.assertEquals((Object)"x", (Object)s.getName());
        Assert.assertEquals((Object)HttpPartSchema.Type.NUMBER, (Object)s.getType());
        Assert.assertEquals((Object)HttpPartSchema.Format.INT32, (Object)s.getFormat());
        Assert.assertEquals((Object)HttpPartSchema.CollectionFormat.CSV, (Object)s.getCollectionFormat());
        Assert.assertEquals((Object)1, (Object)s.getMaximum());
        Assert.assertEquals((Object)2, (Object)s.getMinimum());
        Assert.assertEquals((Object)3, (Object)s.getMultipleOf());
        Assert.assertEquals((Object)"4", (Object)s.getPattern().pattern());
        Assert.assertEquals((long)1L, (long)s.getMaxLength());
        Assert.assertEquals((long)2L, (long)s.getMinLength());
        Assert.assertEquals((long)3L, (long)s.getMaxItems());
        Assert.assertEquals((long)4L, (long)s.getMinItems());
        Assert.assertTrue((boolean)s.isExclusiveMaximum());
        Assert.assertTrue((boolean)s.isExclusiveMinimum());
        Assert.assertTrue((boolean)s.isUniqueItems());
        Assert.assertTrue((boolean)s.isRequired());
        Assert.assertTrue((boolean)s.isSkipIfEmpty());
        TestUtils.assertObjectEquals("['e1','e2','e3']", s.getEnum());
        Assert.assertEquals((Object)"c1\nc2", (Object)s.getDefault());
    }

    @Test
    public void a04_basic_onParameterAndClass() throws Exception {
        ParamInfo mpi = MethodInfo.of((Method)A04.class.getMethod("a", A01.class)).getParam(0);
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, mpi).noValidate().build();
        Assert.assertEquals((Object)"y", (Object)s.getName());
        Assert.assertEquals((Object)HttpPartSchema.Type.INTEGER, (Object)s.getType());
        Assert.assertEquals((Object)HttpPartSchema.Format.INT64, (Object)s.getFormat());
        Assert.assertEquals((Object)HttpPartSchema.CollectionFormat.SSV, (Object)s.getCollectionFormat());
        Assert.assertEquals((Object)5, (Object)s.getMaximum());
        Assert.assertEquals((Object)6, (Object)s.getMinimum());
        Assert.assertEquals((Object)7, (Object)s.getMultipleOf());
        Assert.assertEquals((Object)"8", (Object)s.getPattern().pattern());
        Assert.assertEquals((long)5L, (long)s.getMaxLength());
        Assert.assertEquals((long)6L, (long)s.getMinLength());
        Assert.assertEquals((long)7L, (long)s.getMaxItems());
        Assert.assertEquals((long)8L, (long)s.getMinItems());
        Assert.assertFalse((boolean)s.isExclusiveMaximum());
        Assert.assertFalse((boolean)s.isExclusiveMinimum());
        Assert.assertFalse((boolean)s.isUniqueItems());
        Assert.assertFalse((boolean)s.isRequired());
        Assert.assertFalse((boolean)s.isSkipIfEmpty());
        TestUtils.assertObjectEquals("['e4','e5','e6']", s.getEnum());
        Assert.assertEquals((Object)"c3\nc4", (Object)s.getDefault());
    }

    @Test
    public void a05_basic_nestedItems_onClass() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, A05.class).noValidate().build();
        Assert.assertEquals((Object)"x", (Object)s.getName());
        HttpPartSchema items = s.getItems();
        Assert.assertEquals((Object)HttpPartSchema.Type.NUMBER, (Object)items.getType());
        Assert.assertEquals((Object)HttpPartSchema.Format.INT32, (Object)items.getFormat());
        Assert.assertEquals((Object)HttpPartSchema.CollectionFormat.CSV, (Object)items.getCollectionFormat());
        Assert.assertEquals((Object)1, (Object)items.getMaximum());
        Assert.assertEquals((Object)2, (Object)items.getMinimum());
        Assert.assertEquals((Object)3, (Object)items.getMultipleOf());
        Assert.assertEquals((Object)"4", (Object)items.getPattern().pattern());
        Assert.assertEquals((long)1L, (long)items.getMaxLength());
        Assert.assertEquals((long)2L, (long)items.getMinLength());
        Assert.assertEquals((long)3L, (long)items.getMaxItems());
        Assert.assertEquals((long)4L, (long)items.getMinItems());
        Assert.assertTrue((boolean)items.isExclusiveMaximum());
        Assert.assertTrue((boolean)items.isExclusiveMinimum());
        Assert.assertTrue((boolean)items.isUniqueItems());
        TestUtils.assertObjectEquals("['e1','e2']", items.getEnum());
        Assert.assertEquals((Object)"c1\nc2", (Object)items.getDefault());
        items = items.getItems();
        Assert.assertEquals((Object)HttpPartSchema.Type.INTEGER, (Object)items.getType());
        Assert.assertEquals((Object)HttpPartSchema.Format.INT64, (Object)items.getFormat());
        Assert.assertEquals((Object)HttpPartSchema.CollectionFormat.SSV, (Object)items.getCollectionFormat());
        Assert.assertEquals((Object)5, (Object)items.getMaximum());
        Assert.assertEquals((Object)6, (Object)items.getMinimum());
        Assert.assertEquals((Object)7, (Object)items.getMultipleOf());
        Assert.assertEquals((Object)"8", (Object)items.getPattern().pattern());
        Assert.assertEquals((long)5L, (long)items.getMaxLength());
        Assert.assertEquals((long)6L, (long)items.getMinLength());
        Assert.assertEquals((long)7L, (long)items.getMaxItems());
        Assert.assertEquals((long)8L, (long)items.getMinItems());
        Assert.assertFalse((boolean)items.isExclusiveMaximum());
        Assert.assertFalse((boolean)items.isExclusiveMinimum());
        Assert.assertFalse((boolean)items.isUniqueItems());
        TestUtils.assertObjectEquals("['e3','e4']", items.getEnum());
        Assert.assertEquals((Object)"c3\nc4", (Object)items.getDefault());
        items = items.getItems();
        Assert.assertEquals((Object)HttpPartSchema.Type.STRING, (Object)items.getType());
        Assert.assertEquals((Object)HttpPartSchema.Format.FLOAT, (Object)items.getFormat());
        Assert.assertEquals((Object)HttpPartSchema.CollectionFormat.TSV, (Object)items.getCollectionFormat());
        Assert.assertEquals((Object)9, (Object)items.getMaximum());
        Assert.assertEquals((Object)10, (Object)items.getMinimum());
        Assert.assertEquals((Object)11, (Object)items.getMultipleOf());
        Assert.assertEquals((Object)"12", (Object)items.getPattern().pattern());
        Assert.assertEquals((long)9L, (long)items.getMaxLength());
        Assert.assertEquals((long)10L, (long)items.getMinLength());
        Assert.assertEquals((long)11L, (long)items.getMaxItems());
        Assert.assertEquals((long)12L, (long)items.getMinItems());
        Assert.assertTrue((boolean)items.isExclusiveMaximum());
        Assert.assertTrue((boolean)items.isExclusiveMinimum());
        Assert.assertTrue((boolean)items.isUniqueItems());
        TestUtils.assertObjectEquals("['e5','e6']", items.getEnum());
        Assert.assertEquals((Object)"c5\nc6", (Object)items.getDefault());
        items = items.getItems();
        Assert.assertEquals((Object)HttpPartSchema.Type.ARRAY, (Object)items.getType());
        Assert.assertEquals((Object)HttpPartSchema.Format.DOUBLE, (Object)items.getFormat());
        Assert.assertEquals((Object)HttpPartSchema.CollectionFormat.PIPES, (Object)items.getCollectionFormat());
        Assert.assertEquals((Object)13, (Object)items.getMaximum());
        Assert.assertEquals((Object)14, (Object)items.getMinimum());
        Assert.assertEquals((Object)15, (Object)items.getMultipleOf());
        Assert.assertEquals((Object)"16", (Object)items.getPattern().pattern());
        Assert.assertEquals((long)13L, (long)items.getMaxLength());
        Assert.assertEquals((long)14L, (long)items.getMinLength());
        Assert.assertEquals((long)15L, (long)items.getMaxItems());
        Assert.assertEquals((long)16L, (long)items.getMinItems());
        Assert.assertFalse((boolean)items.isExclusiveMaximum());
        Assert.assertFalse((boolean)items.isExclusiveMinimum());
        Assert.assertFalse((boolean)items.isUniqueItems());
        TestUtils.assertObjectEquals("['e7','e8']", items.getEnum());
        Assert.assertEquals((Object)"c7\nc8", (Object)items.getDefault());
    }

    @Test
    public void b01a_required() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B01a.class).build();
        s.validateInput("x");
        try {
            s.validateInput(null);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"No value specified.", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateInput("");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Empty value not allowed.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b01b_allowEmptyValue() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B01b.class).build();
        s.validateInput("");
        s.validateInput(null);
    }

    @Test
    public void b01b_required_allowEmptyValue() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B01c.class).build();
        s.validateInput("");
        try {
            s.validateInput(null);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"No value specified.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b02a_pattern() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B02a.class).build();
        s.validateInput("x");
        s.validateInput("xx");
        try {
            s.validateInput("y");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match expected pattern.  Must match pattern: x.*", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateInput("yx");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match expected pattern.  Must match pattern: x.*", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateInput("");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Empty value not allowed.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b03a_length() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B03a.class).build();
        s.validateInput("12");
        s.validateInput("123");
        s.validateInput(null);
        try {
            s.validateInput("1");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum length of value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateInput("1234");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum length of value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b03b_length_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B03b.class).build();
        s.getItems().validateInput("12");
        s.getItems().getItems().validateInput("123");
        s.getItems().getItems().getItems().validateInput("1234");
        s.getItems().getItems().getItems().getItems().validateInput("12345");
        s.getItems().validateInput("123");
        s.getItems().getItems().validateInput("1234");
        s.getItems().getItems().getItems().validateInput("12345");
        s.getItems().getItems().getItems().getItems().validateInput("123456");
        s.getItems().validateInput(null);
        s.getItems().getItems().validateInput(null);
        s.getItems().getItems().getItems().validateInput(null);
        s.getItems().getItems().getItems().getItems().validateInput(null);
        try {
            s.getItems().validateInput("1");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum length of value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateInput("12");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum length of value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateInput("123");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum length of value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateInput("1234");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum length of value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().validateInput("1234");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum length of value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateInput("12345");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum length of value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateInput("123456");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum length of value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateInput("1234567");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum length of value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b04a_enum() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B04a.class).build();
        s.validateInput("X");
        s.validateInput("Y");
        s.validateInput(null);
        try {
            s.validateInput("Z");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['X','Y']", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b04b_enum() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B04b.class).build();
        s.validateInput("X");
        s.validateInput("Y");
        s.validateInput(null);
        try {
            s.validateInput("Z");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['X','Y']", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b04c_enum_json() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B04c.class).build();
        s.validateInput("X");
        s.validateInput("Y");
        s.validateInput(null);
        try {
            s.validateInput("Z");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['X','Y']", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void b04d_enum_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, B04d.class).build();
        s.getItems().validateInput("W");
        s.getItems().getItems().validateInput("X");
        s.getItems().getItems().getItems().validateInput("Y");
        s.getItems().getItems().getItems().getItems().validateInput("Z");
        try {
            s.getItems().validateInput("V");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['W']", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateInput("V");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['X']", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateInput("V");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['Y']", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateInput("V");
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Value does not match one of the expected values.  Must be one of the following: ['Z']", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c01a_minmax_ints() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C01a.class).build();
        s.validateOutput((Object)10, BeanContext.DEFAULT);
        s.validateOutput((Object)100, BeanContext.DEFAULT);
        s.validateOutput(null, BeanContext.DEFAULT);
        try {
            s.validateOutput((Object)9, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateOutput((Object)101, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c01b_minmax_ints_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C01b.class).build();
        s.getItems().validateOutput((Object)10, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)100, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)1000, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)10000, BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)100, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)1000, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)10000, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)100000, BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)9, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)99, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)999, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)9999, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().validateOutput((Object)101, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)1001, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)10001, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)100001, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c02a_minmax_exclusive() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C02a.class).build();
        s.validateOutput((Object)11, BeanContext.DEFAULT);
        s.validateOutput((Object)99, BeanContext.DEFAULT);
        s.validateOutput(null, BeanContext.DEFAULT);
        try {
            s.validateOutput((Object)10, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateOutput((Object)100, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c02b_minmax_exclusive_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C02b.class).build();
        s.getItems().validateOutput((Object)11, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)101, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)1001, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)10001, BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)99, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)999, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)9999, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)99999, BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)10, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)100, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)1000, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)10000, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().validateOutput((Object)100, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)1000, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)10000, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)100000, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c03_minmax_floats() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C03a.class).build();
        s.validateOutput((Object)Float.valueOf(10.1f), BeanContext.DEFAULT);
        s.validateOutput((Object)Float.valueOf(100.1f), BeanContext.DEFAULT);
        s.validateOutput(null, BeanContext.DEFAULT);
        try {
            s.validateOutput((Object)Float.valueOf(10.0f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateOutput((Object)Float.valueOf(100.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c03b_minmax_floats_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C03b.class).build();
        s.getItems().validateOutput((Object)Float.valueOf(10.1f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(100.1f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(1000.1f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.1f), BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)Float.valueOf(100.1f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(1000.1f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.1f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(100000.1f), BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)Float.valueOf(10.0f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)Float.valueOf(100.0f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(1000.0f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.0f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().validateOutput((Object)Float.valueOf(100.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)Float.valueOf(1000.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(100000.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c04a_minmax_floats_exclusive() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C04a.class).build();
        s.validateOutput((Object)Float.valueOf(10.2f), BeanContext.DEFAULT);
        s.validateOutput((Object)Float.valueOf(100.0f), BeanContext.DEFAULT);
        s.validateOutput(null, BeanContext.DEFAULT);
        try {
            s.validateOutput((Object)Float.valueOf(10.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.validateOutput((Object)Float.valueOf(100.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c04b_minmax_floats_exclusive_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C04b.class).build();
        s.getItems().validateOutput((Object)Float.valueOf(10.2f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(100.2f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(1000.2f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.2f), BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)Float.valueOf(100.0f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(1000.0f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.0f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(100000.0f), BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)Float.valueOf(10.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)Float.valueOf(100.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(1000.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum value not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().validateOutput((Object)Float.valueOf(100.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)Float.valueOf(1000.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(100000.1f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum value exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c05a_multipleOf() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C05a.class).build();
        s.validateOutput((Object)0, BeanContext.DEFAULT);
        s.validateOutput((Object)10, BeanContext.DEFAULT);
        s.validateOutput((Object)20, BeanContext.DEFAULT);
        s.validateOutput((Object)Float.valueOf(10.0f), BeanContext.DEFAULT);
        s.validateOutput((Object)Float.valueOf(20.0f), BeanContext.DEFAULT);
        s.validateOutput(null, BeanContext.DEFAULT);
        try {
            s.validateOutput((Object)11, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c05b_multipleOf_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C05b.class).build();
        s.getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)10, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)100, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)1000, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)10000, BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)20, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)200, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)2000, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)20000, BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)Float.valueOf(10.0f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(100.0f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(1000.0f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.0f), BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)Float.valueOf(20.0f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(200.0f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(2000.0f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(20000.0f), BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)11, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)101, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)1001, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)10001, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c06a_multipleOf_floats() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C06a.class).build();
        s.validateOutput((Object)0, BeanContext.DEFAULT);
        s.validateOutput((Object)Float.valueOf(10.1f), BeanContext.DEFAULT);
        s.validateOutput((Object)Float.valueOf(20.2f), BeanContext.DEFAULT);
        s.validateOutput(null, BeanContext.DEFAULT);
        try {
            s.validateOutput((Object)Float.valueOf(10.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void c06b_multipleOf_floats_items() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, C06b.class).build();
        s.getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)0, BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)Float.valueOf(10.1f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(100.1f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(1000.1f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.1f), BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)Float.valueOf(20.2f), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)Float.valueOf(200.2f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(2000.2f), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(20000.2f), BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)Float.valueOf(10.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)Float.valueOf(100.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)Float.valueOf(1000.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)Float.valueOf(10000.2f), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Multiple-of not met.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void d01a_uniqueItems_arrays() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, D01.class).build();
        String[] good = StringUtils.split((String)"a,b");
        String[] bad = StringUtils.split((String)"a,a");
        s.getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().validateOutput(null, BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void d01b_uniqueItems_collections() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, D01.class).build();
        AList good = new AList().appendAll((Object[])StringUtils.split((String)"a,b"));
        AList bad = new AList().appendAll((Object[])StringUtils.split((String)"a,a"));
        s.getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)good, BeanContext.DEFAULT);
        s.getItems().validateOutput(null, BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)bad, BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Duplicate items not allowed.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void d02a_minMaxItems_arrays() throws Exception {
        HttpPartSchema s = HttpPartSchema.create().apply(FormData.class, D02.class).build();
        s.getItems().validateOutput((Object)StringUtils.split((String)"1"), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2"), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3"), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3,4"), BeanContext.DEFAULT);
        s.getItems().validateOutput((Object)StringUtils.split((String)"1,2"), BeanContext.DEFAULT);
        s.getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3"), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3,4"), BeanContext.DEFAULT);
        s.getItems().getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3,4,5"), BeanContext.DEFAULT);
        try {
            s.getItems().validateOutput((Object)new String[0], BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum number of items not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)StringUtils.split((String)"1"), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum number of items not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2"), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum number of items not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3"), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Minimum number of items not met.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().validateOutput((Object)StringUtils.split((String)"1,2,3"), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum number of items exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3,4"), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum number of items exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3,4,5"), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum number of items exceeded.", (Object)e.getLocalizedMessage());
        }
        try {
            s.getItems().getItems().getItems().getItems().validateOutput((Object)StringUtils.split((String)"1,2,3,4,5,6"), BeanContext.DEFAULT);
            Assert.fail();
        }
        catch (SchemaValidationException e) {
            Assert.assertEquals((Object)"Maximum number of items exceeded.", (Object)e.getLocalizedMessage());
        }
    }

    @FormData(items=@Items(minItems=1L, maxItems=2L, items=@SubItems(minItems=2L, maxItems=3L, items={"minItems:3,maxItems:4,", "items:{minItems:4,maxItems:5}"})))
    public static class D02 {
    }

    @FormData(items=@Items(uniqueItems=true, items=@SubItems(uniqueItems=true, items={"uniqueItems:true,", "items:{uniqueItems:true}"})))
    public static class D01 {
    }

    @FormData(items=@Items(multipleOf="10.1", items=@SubItems(multipleOf="100.1", items={"multipleOf:1000.1,", "items:{multipleOf:10000.1}"})))
    public static class C06b {
    }

    @FormData(multipleOf="10.1")
    public static class C06a {
    }

    @FormData(items=@Items(multipleOf="10", items=@SubItems(multipleOf="100", items={"multipleOf:1000,", "items:{multipleOf:10000}"})))
    public static class C05b {
    }

    @FormData(multipleOf="10")
    public static class C05a {
    }

    @FormData(items=@Items(minimum="10.1", maximum="100.1", exclusiveMinimum=true, exclusiveMaximum=true, items=@SubItems(minimum="100.1", maximum="1000.1", exclusiveMinimum=true, exclusiveMaximum=true, items={"minimum:1000.1,maximum:10000.1,exclusiveMinimum:true,exclusiveMaximum:true,", "items:{minimum:10000.1,maximum:100000.1,exclusiveMinimum:true,exclusiveMaximum:true}"})))
    public static class C04b {
    }

    @FormData(minimum="10.1", maximum="100.1", exclusiveMinimum=true, exclusiveMaximum=true)
    public static class C04a {
    }

    @FormData(items=@Items(minimum="10.1", maximum="100.1", items=@SubItems(minimum="100.1", maximum="1000.1", items={"minimum:1000.1,maximum:10000.1,", "items:{minimum:10000.1,maximum:100000.1}"})))
    public static class C03b {
    }

    @FormData(minimum="10.1", maximum="100.1")
    public static class C03a {
    }

    @FormData(items=@Items(minimum="10", maximum="100", exclusiveMinimum=true, exclusiveMaximum=true, items=@SubItems(minimum="100", maximum="1000", exclusiveMinimum=true, exclusiveMaximum=true, items={"minimum:1000,maximum:10000,exclusiveMinimum:true,exclusiveMaximum:true,", "items:{minimum:10000,maximum:100000,exclusiveMinimum:true,exclusiveMaximum:true}"})))
    public static class C02b {
    }

    @FormData(minimum="10", maximum="100", exclusiveMinimum=true, exclusiveMaximum=true)
    public static class C02a {
    }

    @FormData(items=@Items(minimum="10", maximum="100", items=@SubItems(minimum="100", maximum="1000", items={"minimum:1000,maximum:10000,", "items:{minimum:10000,maximum:100000}"})))
    public static class C01b {
    }

    @FormData(minimum="10", maximum="100")
    public static class C01a {
    }

    @FormData(items=@Items(_enum={"['W']"}, items=@SubItems(_enum={"['X']"}, items={"enum:['Y'],", "items:{enum:['Z']}"})))
    public static class B04d {
    }

    @FormData(_enum={"['X','Y']"})
    public static class B04c {
    }

    @FormData(_enum={" X , Y "})
    public static class B04b {
    }

    @FormData(_enum={"X,Y"})
    public static class B04a {
    }

    @FormData(items=@Items(minLength=2L, maxLength=3L, items=@SubItems(minLength=3L, maxLength=4L, items={"minLength:4,maxLength:5,", "items:{minLength:5,maxLength:6}"})))
    public static class B03b {
    }

    @FormData(minLength=2L, maxLength=3L)
    public static class B03a {
    }

    @FormData(pattern="x.*")
    public static class B02a {
    }

    @FormData(required=true, allowEmptyValue=true)
    public static class B01c {
    }

    @FormData(allowEmptyValue=true)
    public static class B01b {
    }

    @FormData(required=true)
    public static class B01a {
    }

    @FormData(name="x", items=@Items(type="number", format="int32", collectionFormat="csv", maximum="1", minimum="2", multipleOf="3", pattern="4", maxLength=1L, minLength=2L, maxItems=3L, minItems=4L, exclusiveMaximum=true, exclusiveMinimum=true, uniqueItems=true, _default={"c1", "c2"}, _enum={"e1,e2"}, items=@SubItems(type="integer", format="int64", collectionFormat="ssv", maximum="5", minimum="6", multipleOf="7", pattern="8", maxLength=5L, minLength=6L, maxItems=7L, minItems=8L, exclusiveMaximum=false, exclusiveMinimum=false, uniqueItems=false, _default={"c3", "c4"}, _enum={"e3,e4"}, items={"type:'string',", "format:'float',", "collectionFormat:'tsv',", "maximum:'9',", "minimum:'10',", "multipleOf:'11',", "pattern:'12',", "maxLength:9,", "minLength:10,", "maxItems:11,", "minItems:12,", "exclusiveMaximum:true,", "exclusiveMinimum:true,", "uniqueItems:true,", "default:'c5\\nc6',", "enum:['e5','e6'],", "items:{", "type:'array',", "format:'double',", "collectionFormat:'pipes',", "maximum:'13',", "minimum:'14',", "multipleOf:'15',", "pattern:'16',", "maxLength:13,", "minLength:14,", "maxItems:15,", "minItems:16,", "exclusiveMaximum:false,", "exclusiveMinimum:false,", "uniqueItems:false,", "default:'c7\\nc8',", "enum:['e7','e8']", "}"})))
    public static class A05 {
    }

    public static class A04 {
        public void a(@FormData(name="y", type="integer", format="int64", collectionFormat="ssv", maximum="5", minimum="6", multipleOf="7", pattern="8", maxLength=5L, minLength=6L, maxItems=7L, minItems=8L, exclusiveMaximum=false, exclusiveMinimum=false, uniqueItems=false, required=false, skipIfEmpty=false, description={"b3", "b3"}, _default={"c3", "c4"}, items=@Items($ref="d2"), _enum={"e4,e5,e6"}, example={"f2"}, api={"{g2:true}"}) A01 x) {
        }
    }

    public static class A03 {
        public void a(@FormData(name="x", type="number", format="int32", collectionFormat="csv", maximum="1", minimum="2", multipleOf="3", pattern="4", maxLength=1L, minLength=2L, maxItems=3L, minItems=4L, exclusiveMaximum=true, exclusiveMinimum=true, uniqueItems=true, required=true, skipIfEmpty=true, description={"b1", "b2"}, _default={"c1", "c2"}, items=@Items($ref="d1"), _enum={"e1,e2,e3"}, example={"f1"}, api={"{g1:true}"}) String x) {
        }
    }

    @FormData(name="x", type="number", format="int32", collectionFormat="csv", maximum="1", minimum="2", multipleOf="3", pattern="4", maxLength=1L, minLength=2L, maxItems=3L, minItems=4L, exclusiveMaximum=true, exclusiveMinimum=true, uniqueItems=true, required=true, skipIfEmpty=true, description={"b1", "b2"}, _default={"c1", "c2"}, items=@Items($ref="d1"), _enum={"e1,e2,e3"}, example={"f1"}, api={"{g1:true}"})
    public static class A02 {
    }

    @FormData(value="x")
    public static class A01 {
    }
}

