/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.juneau.http.annotation.AnnotationUtils;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AnnotationUtilsTest {
    @Test
    public void testEmpty() throws Exception {
        Assert.assertTrue((boolean)AnnotationUtils.empty((Body)A01.class.getAnnotation(Body.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Response)A01.class.getAnnotation(Response.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((ResponseHeader)A01.class.getAnnotation(ResponseHeader.class)));
        X x = A01.class.getAnnotation(X.class);
        Assert.assertTrue((boolean)AnnotationUtils.empty((Contact)x.x1()));
        Assert.assertTrue((boolean)AnnotationUtils.empty((ExternalDocs)x.x2()));
        Assert.assertTrue((boolean)AnnotationUtils.empty((License)x.x3()));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Schema)x.x4()));
        Assert.assertTrue((boolean)AnnotationUtils.empty((SubItems)x.x5()));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Items)x.x6()));
        Field f = A01.class.getField("f1");
        Assert.assertTrue((boolean)AnnotationUtils.empty((Query)f.getAnnotation(Query.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Header)f.getAnnotation(Header.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((FormData)f.getAnnotation(FormData.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Path)f.getAnnotation(Path.class)));
    }

    @Test
    public void testEmptyNonExistent() throws Exception {
        Assert.assertTrue((boolean)AnnotationUtils.empty((Body)B01.class.getAnnotation(Body.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Response)B01.class.getAnnotation(Response.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((ResponseHeader)B01.class.getAnnotation(ResponseHeader.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Contact)null));
        Assert.assertTrue((boolean)AnnotationUtils.empty((ExternalDocs)null));
        Assert.assertTrue((boolean)AnnotationUtils.empty((License)null));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Schema)null));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Items)null));
        Assert.assertTrue((boolean)AnnotationUtils.empty((SubItems)null));
        Field f = B01.class.getField("f1");
        Assert.assertTrue((boolean)AnnotationUtils.empty((Query)f.getAnnotation(Query.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Header)f.getAnnotation(Header.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((FormData)f.getAnnotation(FormData.class)));
        Assert.assertTrue((boolean)AnnotationUtils.empty((Path)f.getAnnotation(Path.class)));
    }

    @Test
    public void testAllEmpty1() {
        Assert.assertTrue((boolean)AnnotationUtils.allEmpty((String[])new String[0]));
        Assert.assertTrue((boolean)AnnotationUtils.allEmpty((String[])new String[]{""}));
        Assert.assertTrue((boolean)AnnotationUtils.allEmpty((String[])new String[]{null, ""}));
        Assert.assertFalse((boolean)AnnotationUtils.allEmpty((String[])new String[]{null, "", "x"}));
    }

    @Test
    public void testAllEmpty2() {
        Assert.assertTrue((boolean)AnnotationUtils.allEmpty((String[][])new String[][]{new String[0], new String[0]}));
        Assert.assertTrue((boolean)AnnotationUtils.allEmpty((String[][])new String[][]{null, new String[0]}));
        Assert.assertFalse((boolean)AnnotationUtils.allEmpty((String[][])new String[][]{null, {""}}));
        Assert.assertFalse((boolean)AnnotationUtils.allEmpty((String[][])new String[][]{null, {"x"}}));
    }

    @Test
    public void testAllFalse() {
        Assert.assertTrue((boolean)AnnotationUtils.allFalse((boolean[])new boolean[0]));
        Assert.assertTrue((boolean)AnnotationUtils.allFalse((boolean[])new boolean[]{false}));
        Assert.assertTrue((boolean)AnnotationUtils.allFalse((boolean[])new boolean[]{false, false}));
        Assert.assertFalse((boolean)AnnotationUtils.allFalse((boolean[])new boolean[]{false, true}));
        Assert.assertFalse((boolean)AnnotationUtils.allFalse((boolean[])new boolean[]{true}));
    }

    @Test
    public void testAllMinusOne() {
        Assert.assertTrue((boolean)AnnotationUtils.allMinusOne((long[])new long[0]));
        Assert.assertTrue((boolean)AnnotationUtils.allMinusOne((long[])new long[]{-1L}));
        Assert.assertTrue((boolean)AnnotationUtils.allMinusOne((long[])new long[]{-1L, -1L}));
        Assert.assertFalse((boolean)AnnotationUtils.allMinusOne((long[])new long[]{-1L, 0L}));
        Assert.assertFalse((boolean)AnnotationUtils.allMinusOne((long[])new long[]{0L}));
    }

    @Test
    public void testAllMinusOneLongs() {
        Assert.assertTrue((boolean)AnnotationUtils.allMinusOne((long[])new long[]{-1L}));
        Assert.assertTrue((boolean)AnnotationUtils.allMinusOne((long[])new long[]{-1L, -1L}));
        Assert.assertFalse((boolean)AnnotationUtils.allMinusOne((long[])new long[]{-1L, 0L}));
        Assert.assertFalse((boolean)AnnotationUtils.allMinusOne((long[])new long[]{0L}));
    }

    public static class B01 {
        public int f1;
    }

    @Body
    @Response
    @ResponseHeader
    @X
    public static class A01 {
        @Query
        @Header
        @FormData
        @Path
        @Schema
        public int f1;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface X {
        public Contact x1() default @Contact;

        public ExternalDocs x2() default @ExternalDocs;

        public License x3() default @License;

        public Schema x4() default @Schema;

        public SubItems x5() default @SubItems;

        public Items x6() default @Items;
    }
}

