/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.LinkedHashMap;
import org.apache.juneau.ObjectList;
import org.apache.juneau.UriResolution;
import org.apache.juneau.html.AnchorText;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlSerializerBuilder;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.testutils.pojos.TestURI;
import org.junit.Assert;
import org.junit.Test;

public class HtmlTest {
    @Test
    public void testTables1() throws Exception {
        HtmlSerializer s = HtmlSerializer.DEFAULT_SQ;
        Object[] t = new Object[]{new A1(), new A1()};
        String html = s.serialize((Object)t);
        Assert.assertEquals((Object)"<table _type='array'><tr><th>f1</th></tr><tr><td>f1</td></tr><tr><td>f1</td></tr></table>", (Object)html);
    }

    @Test
    public void testAnchorTextOptions() throws Exception {
        HtmlSerializerBuilder s = HtmlSerializer.create().sq().addKeyValueTableHeaders().uriResolution(UriResolution.NONE);
        TestURI t = new TestURI();
        String expected = null;
        s.uriAnchorText(AnchorText.TO_STRING);
        String r = this.strip(s.build().serialize((Object)t));
        expected = "\n[f0]=<a href='f0/x0'>f0/x0</a>\n[f1]=<a href='f1/x1'>f1/x1</a>\n[f2]=<a href='/f2/x2'>/f2/x2</a>\n[f3]=<a href='http://www.apache.org/f3/x3'>http://www.apache.org/f3/x3</a>\n[f4]=<a href='f4/x4'>f4/x4</a>\n[f5]=<a href='/f5/x5'>/f5/x5</a>\n[f6]=<a href='http://www.apache.org/f6/x6'>http://www.apache.org/f6/x6</a>\n[f7]=<a href='http://www.apache.org/f7/x7'>http://www.apache.org/f7/x7</a>\n[f8]=<a href='f8/x8'>f8/x8</a>\n[f9]=<a href='f9/x9'>f9/x9</a>\n[fa]=<a href='http://www.apache.org/fa/xa#MY_LABEL'>http://www.apache.org/fa/xa#MY_LABEL</a>\n[fb]=<a href='http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar'>MY_LABEL</a>\n[fc]=<a href='http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL'>MY_LABEL</a>\n[fd]=<a href='http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar'>http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar</a>\n[fe]=<a href='http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL'>http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL</a>";
        Assert.assertEquals((Object)expected, (Object)r);
        s.uriAnchorText(AnchorText.URI);
        r = this.strip(s.build().serialize((Object)t));
        expected = "\n[f0]=<a href='f0/x0'>f0/x0</a>\n[f1]=<a href='f1/x1'>f1/x1</a>\n[f2]=<a href='/f2/x2'>/f2/x2</a>\n[f3]=<a href='http://www.apache.org/f3/x3'>http://www.apache.org/f3/x3</a>\n[f4]=<a href='f4/x4'>f4/x4</a>\n[f5]=<a href='/f5/x5'>/f5/x5</a>\n[f6]=<a href='http://www.apache.org/f6/x6'>http://www.apache.org/f6/x6</a>\n[f7]=<a href='http://www.apache.org/f7/x7'>http://www.apache.org/f7/x7</a>\n[f8]=<a href='f8/x8'>f8/x8</a>\n[f9]=<a href='f9/x9'>f9/x9</a>\n[fa]=<a href='http://www.apache.org/fa/xa#MY_LABEL'>http://www.apache.org/fa/xa#MY_LABEL</a>\n[fb]=<a href='http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar'>MY_LABEL</a>\n[fc]=<a href='http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL'>MY_LABEL</a>\n[fd]=<a href='http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar'>http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar</a>\n[fe]=<a href='http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL'>http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL</a>";
        Assert.assertEquals((Object)expected, (Object)r);
        s.uriAnchorText(AnchorText.LAST_TOKEN);
        r = this.strip(s.build().serialize((Object)t));
        expected = "\n[f0]=<a href='f0/x0'>x0</a>\n[f1]=<a href='f1/x1'>x1</a>\n[f2]=<a href='/f2/x2'>x2</a>\n[f3]=<a href='http://www.apache.org/f3/x3'>x3</a>\n[f4]=<a href='f4/x4'>x4</a>\n[f5]=<a href='/f5/x5'>x5</a>\n[f6]=<a href='http://www.apache.org/f6/x6'>x6</a>\n[f7]=<a href='http://www.apache.org/f7/x7'>x7</a>\n[f8]=<a href='f8/x8'>x8</a>\n[f9]=<a href='f9/x9'>x9</a>\n[fa]=<a href='http://www.apache.org/fa/xa#MY_LABEL'>xa</a>\n[fb]=<a href='http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar'>MY_LABEL</a>\n[fc]=<a href='http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL'>MY_LABEL</a>\n[fd]=<a href='http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar'>xd</a>\n[fe]=<a href='http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL'>xe</a>";
        Assert.assertEquals((Object)expected, (Object)r);
        s.uriAnchorText(AnchorText.URI_ANCHOR);
        r = this.strip(s.build().serialize((Object)t));
        expected = "\n[f0]=<a href='f0/x0'>f0/x0</a>\n[f1]=<a href='f1/x1'>f1/x1</a>\n[f2]=<a href='/f2/x2'>/f2/x2</a>\n[f3]=<a href='http://www.apache.org/f3/x3'>http://www.apache.org/f3/x3</a>\n[f4]=<a href='f4/x4'>f4/x4</a>\n[f5]=<a href='/f5/x5'>/f5/x5</a>\n[f6]=<a href='http://www.apache.org/f6/x6'>http://www.apache.org/f6/x6</a>\n[f7]=<a href='http://www.apache.org/f7/x7'>http://www.apache.org/f7/x7</a>\n[f8]=<a href='f8/x8'>f8/x8</a>\n[f9]=<a href='f9/x9'>f9/x9</a>\n[fa]=<a href='http://www.apache.org/fa/xa#MY_LABEL'>MY_LABEL</a>\n[fb]=<a href='http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar'>MY_LABEL</a>\n[fc]=<a href='http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL'>MY_LABEL</a>\n[fd]=<a href='http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar'>http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar</a>\n[fe]=<a href='http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL'>http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL</a>";
        Assert.assertEquals((Object)expected, (Object)r);
        s.labelParameter("label2");
        r = this.strip(s.build().serialize((Object)t));
        expected = "\n[f0]=<a href='f0/x0'>f0/x0</a>\n[f1]=<a href='f1/x1'>f1/x1</a>\n[f2]=<a href='/f2/x2'>/f2/x2</a>\n[f3]=<a href='http://www.apache.org/f3/x3'>http://www.apache.org/f3/x3</a>\n[f4]=<a href='f4/x4'>f4/x4</a>\n[f5]=<a href='/f5/x5'>/f5/x5</a>\n[f6]=<a href='http://www.apache.org/f6/x6'>http://www.apache.org/f6/x6</a>\n[f7]=<a href='http://www.apache.org/f7/x7'>http://www.apache.org/f7/x7</a>\n[f8]=<a href='f8/x8'>f8/x8</a>\n[f9]=<a href='f9/x9'>f9/x9</a>\n[fa]=<a href='http://www.apache.org/fa/xa#MY_LABEL'>MY_LABEL</a>\n[fb]=<a href='http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar'>http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar</a>\n[fc]=<a href='http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL'>http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL</a>\n[fd]=<a href='http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar'>MY_LABEL</a>\n[fe]=<a href='http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL'>MY_LABEL</a>";
        Assert.assertEquals((Object)expected, (Object)r);
        s.detectLinksInStrings(false);
        r = this.strip(s.build().serialize((Object)t));
        expected = "\n[f0]=<a href='f0/x0'>f0/x0</a>\n[f1]=<a href='f1/x1'>f1/x1</a>\n[f2]=<a href='/f2/x2'>/f2/x2</a>\n[f3]=<a href='http://www.apache.org/f3/x3'>http://www.apache.org/f3/x3</a>\n[f4]=<a href='f4/x4'>f4/x4</a>\n[f5]=<a href='/f5/x5'>/f5/x5</a>\n[f6]=<a href='http://www.apache.org/f6/x6'>http://www.apache.org/f6/x6</a>\n[f7]=<a href='http://www.apache.org/f7/x7'>http://www.apache.org/f7/x7</a>\n[f8]=<a href='f8/x8'>f8/x8</a>\n[f9]=<a href='f9/x9'>f9/x9</a>\n[fa]=http://www.apache.org/fa/xa#MY_LABEL\n[fb]=http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar\n[fc]=http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL\n[fd]=http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar\n[fe]=http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL";
        Assert.assertEquals((Object)expected, (Object)r);
        s.detectLinksInStrings(true);
        s.detectLabelParameters(false);
        r = this.strip(s.build().serialize((Object)t));
        expected = "\n[f0]=<a href='f0/x0'>f0/x0</a>\n[f1]=<a href='f1/x1'>f1/x1</a>\n[f2]=<a href='/f2/x2'>/f2/x2</a>\n[f3]=<a href='http://www.apache.org/f3/x3'>http://www.apache.org/f3/x3</a>\n[f4]=<a href='f4/x4'>f4/x4</a>\n[f5]=<a href='/f5/x5'>/f5/x5</a>\n[f6]=<a href='http://www.apache.org/f6/x6'>http://www.apache.org/f6/x6</a>\n[f7]=<a href='http://www.apache.org/f7/x7'>http://www.apache.org/f7/x7</a>\n[f8]=<a href='f8/x8'>f8/x8</a>\n[f9]=<a href='f9/x9'>f9/x9</a>\n[fa]=<a href='http://www.apache.org/fa/xa#MY_LABEL'>MY_LABEL</a>\n[fb]=<a href='http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar'>http://www.apache.org/fb/xb?label=MY_LABEL&amp;foo=bar</a>\n[fc]=<a href='http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL'>http://www.apache.org/fc/xc?foo=bar&amp;label=MY_LABEL</a>\n[fd]=<a href='http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar'>http://www.apache.org/fd/xd?label2=MY_LABEL&amp;foo=bar</a>\n[fe]=<a href='http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL'>http://www.apache.org/fe/xe?foo=bar&amp;label2=MY_LABEL</a>";
        Assert.assertEquals((Object)expected, (Object)r);
    }

    private String strip(String html) {
        return html.replace("<table><tr><th>key</th><th>value</th></tr>", "").replace("</table>", "").replace("<tr><td>", "\n[").replace("</td><td>", "]=").replace("</td></tr>", "");
    }

    @Test
    public void testHtmlAnnotationAsPlainText() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().addKeyValueTableHeaders().build();
        Object o = null;
        o = new B1();
        String r = s.serialize(o);
        Assert.assertEquals((Object)"<test>", (Object)r);
        o = new B2();
        r = s.serialize(o);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td><f1></td></tr></table>", (Object)r);
    }

    @Test
    public void testHtmlAnnotationAsPlainText_usingConfig() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().addKeyValueTableHeaders().applyAnnotations(new Class[]{B3.class}).applyAnnotations(new Class[]{B4.class}).build();
        Object o = null;
        o = new B3();
        String r = s.serialize(o);
        Assert.assertEquals((Object)"<test>", (Object)r);
        o = new B4();
        r = s.serialize(o);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td><f1></td></tr></table>", (Object)r);
    }

    @Test
    public void testHtmlAnnotationAsXml() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().addKeyValueTableHeaders().build();
        Object o = null;
        o = new C1();
        String r = s.serialize(o);
        Assert.assertEquals((Object)"<object><f1>&lt;f1&gt;</f1></object>", (Object)r);
        o = new C2();
        r = s.serialize(o);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td>&lt;f1&gt;</td></tr></table>", (Object)r);
    }

    @Test
    public void testHtmlAnnotationAsXml_usingConfig() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().addKeyValueTableHeaders().applyAnnotations(new Class[]{C3.class}).build();
        Object o = null;
        o = new C3();
        String r = s.serialize(o);
        Assert.assertEquals((Object)"<object><f1>&lt;f1&gt;</f1></object>", (Object)r);
        o = new C4();
        r = s.serialize(o);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td>&lt;f1&gt;</td></tr></table>", (Object)r);
    }

    @Test
    public void testNoTableHeaders() throws Exception {
        HtmlSerializer s = HtmlSerializer.DEFAULT_SQ;
        ObjectList o = null;
        MyMap m = new MyMap();
        m.put("foo", "bar");
        o = new ObjectList().append(new Object[]{m});
        String r = s.serialize((Object)o);
        Assert.assertEquals((Object)"<ul><li><table><tr><td>foo</td><td>bar</td></tr></table></li></ul>", (Object)r);
    }

    @Test
    public void testNoTableHeaders_usingConfig() throws Exception {
        HtmlSerializer s = HtmlSerializer.DEFAULT_SQ.builder().applyAnnotations(new Class[]{MyMap2.class}).build();
        ObjectList o = null;
        MyMap2 m = new MyMap2();
        m.put("foo", "bar");
        o = new ObjectList().append(new Object[]{m});
        String r = s.serialize((Object)o);
        Assert.assertEquals((Object)"<ul><li><table><tr><td>foo</td><td>bar</td></tr></table></li></ul>", (Object)r);
    }

    @HtmlConfig(applyHtml={@Html(on="org.apache.juneau.html.HtmlTest$MyMap2", noTables=true, noTableHeaders=true)})
    public static class MyMap2
    extends LinkedHashMap<String, String> {
    }

    @Html(noTables=true, noTableHeaders=true)
    public static class MyMap
    extends LinkedHashMap<String, String> {
    }

    public static class C4 {
        public String f1 = "<f1>";
    }

    @HtmlConfig(applyHtml={@Html(on="C3,C4.f1", format=HtmlFormat.XML)})
    public static class C3 {
        public String f1 = "<f1>";
    }

    public static class C2 {
        @Html(format=HtmlFormat.XML)
        public String f1 = "<f1>";
    }

    @Html(format=HtmlFormat.XML)
    public static class C1 {
        public String f1 = "<f1>";
    }

    @HtmlConfig(applyHtml={@Html(on="B4.f1", format=HtmlFormat.PLAIN_TEXT)})
    public static class B4 {
        public String f1 = "<f1>";
    }

    @HtmlConfig(applyHtml={@Html(on="B3", format=HtmlFormat.PLAIN_TEXT)})
    public static class B3 {
        public String f1 = "<f1>";

        public String toString() {
            return "<test>";
        }
    }

    public static class B2 {
        @Html(format=HtmlFormat.PLAIN_TEXT)
        public String f1 = "<f1>";
    }

    @Html(format=HtmlFormat.PLAIN_TEXT)
    public static class B1 {
        public String f1 = "<f1>";

        public String toString() {
            return "<test>";
        }
    }

    public static class A1 {
        public String f1 = "f1";
    }
}

