/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Calendar;
import java.util.List;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.html.HtmlSchemaSerializer;
import org.apache.juneau.testutils.pojos.TestEnumToString;
import org.junit.Assert;
import org.junit.Test;

public class HtmlSchemaSerializerTest {
    @Test
    public void simpleObjects() throws Exception {
        HtmlSchemaSerializer s = HtmlSchemaSerializer.DEFAULT_SIMPLE;
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>integer</td></tr><tr><td>format</td><td>int16</td></tr></table>", (Object)s.serialize((Object)1));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>integer</td></tr><tr><td>format</td><td>int32</td></tr></table>", (Object)s.serialize((Object)1));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>integer</td></tr><tr><td>format</td><td>int64</td></tr></table>", (Object)s.serialize((Object)1L));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>number</td></tr><tr><td>format</td><td>float</td></tr></table>", (Object)s.serialize((Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>number</td></tr><tr><td>format</td><td>double</td></tr></table>", (Object)s.serialize((Object)1.0));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>boolean</td></tr></table>", (Object)s.serialize((Object)true));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>string</td></tr></table>", (Object)s.serialize((Object)"foo"));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>string</td></tr></table>", (Object)s.serialize((Object)new StringBuilder("foo")));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>string</td></tr></table>", (Object)s.serialize((Object)Character.valueOf('c')));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>string</td></tr><tr><td>enum</td><td><ul><li>one</li><li>two</li><li>three</li></ul></td></tr></table>", (Object)s.serialize((Object)TestEnumToString.ONE));
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>object</td></tr><tr><td>properties</td><td><table><tr><td>f1</td><td><table><tr><td>type</td><td>string</td></tr></table></td></tr></table></td></tr></table>", (Object)s.serialize((Object)new SimpleBean()));
    }

    @Test
    public void documentationExample() throws Exception {
        HtmlSchemaSerializer s = HtmlSchemaSerializer.DEFAULT_SIMPLE;
        Assert.assertEquals((Object)"<table><tr><td>type</td><td>object</td></tr><tr><td>properties</td><td><table><tr><td>name</td><td><table><tr><td>type</td><td>string</td></tr></table></td></tr><tr><td>birthDate</td><td><table><tr><td>type</td><td>string</td></tr></table></td></tr><tr><td>addresses</td><td><table><tr><td>type</td><td>array</td></tr><tr><td>items</td><td><table><tr><td>type</td><td>object</td></tr><tr><td>properties</td><td><table><tr><td>street</td><td><table><tr><td>type</td><td>string</td></tr></table></td></tr><tr><td>city</td><td><table><tr><td>type</td><td>string</td></tr></table></td></tr><tr><td>state</td><td><table><tr><td>type</td><td>string</td></tr><tr><td>enum</td><td><ul><li>AL</li><li>PA</li><li>NC</li></ul></td></tr></table></td></tr><tr><td>zip</td><td><table><tr><td>type</td><td>integer</td></tr><tr><td>format</td><td>int32</td></tr></table></td></tr><tr><td>isCurrent</td><td><table><tr><td>type</td><td>boolean</td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table></td></tr></table>", (Object)s.serialize(Person.class));
    }

    public static enum StateEnum {
        AL,
        PA,
        NC;

    }

    @Bean(bpi="street,city,state,zip,isCurrent")
    public static class Address {
        public String street;
        public String city;
        public StateEnum state;
        public int zip;
        public boolean isCurrent;
    }

    @Bean(bpi="name,birthDate,addresses")
    public static class Person {
        public String name;
        public Calendar birthDate;
        public List<Address> addresses;
    }

    public static class SimpleBean {
        public String f1;
    }
}

