/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.juneau.XVar;
import org.apache.juneau.html.BasicHtmlDocTemplate;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class HtmlDocConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t.getClass().isArray()) {
                return this.apply(ArrayUtils.toList((Object)t, Object.class));
            }
            if (t instanceof Collection) {
                return ((Collection)t).stream().map(TO_STRING).collect(Collectors.joining(","));
            }
            if (t instanceof HtmlDocTemplate) {
                return ((HtmlDocTemplate)t).getClass().getSimpleName();
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);
    static ClassInfo d1 = ClassInfo.of(D1.class);
    static ClassInfo d2 = ClassInfo.of(D2.class);
    static ClassInfo d3 = ClassInfo.of(D3.class);
    static ClassInfo d4 = ClassInfo.of(D4.class);
    static ClassInfo e = ClassInfo.of(E.class);
    static ClassInfo f1 = ClassInfo.of(F1.class);
    static ClassInfo f2 = ClassInfo.of(F2.class);
    static ClassInfo f3 = ClassInfo.of(F3.class);
    static ClassInfo f4 = ClassInfo.of(F4.class);
    static ClassInfo f5 = ClassInfo.of(F5.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basic() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("foo", x.getAside());
        HtmlDocConfigAnnotationTest.check("foo", x.getFooter());
        HtmlDocConfigAnnotationTest.check("foo", x.getHead());
        HtmlDocConfigAnnotationTest.check("foo", x.getHeader());
        HtmlDocConfigAnnotationTest.check("foo", x.getNav());
        HtmlDocConfigAnnotationTest.check("foo1", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("foo", x.getNoResultsMessage());
        HtmlDocConfigAnnotationTest.check("true", x.isNowrap());
        HtmlDocConfigAnnotationTest.check("foo1", x.getScript());
        HtmlDocConfigAnnotationTest.check("foo1", x.getStyle());
        HtmlDocConfigAnnotationTest.check("foo1", x.getStylesheet());
        HtmlDocConfigAnnotationTest.check("BasicHtmlDocTemplate", x.getTemplate());
    }

    @Test
    public void defaults() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("", x.getAside());
        HtmlDocConfigAnnotationTest.check("", x.getFooter());
        HtmlDocConfigAnnotationTest.check("", x.getHead());
        HtmlDocConfigAnnotationTest.check("", x.getHeader());
        HtmlDocConfigAnnotationTest.check("", x.getNav());
        HtmlDocConfigAnnotationTest.check("", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("<p>no results</p>", x.getNoResultsMessage());
        HtmlDocConfigAnnotationTest.check("false", x.isNowrap());
        HtmlDocConfigAnnotationTest.check("", x.getScript());
        HtmlDocConfigAnnotationTest.check("", x.getStyle());
        HtmlDocConfigAnnotationTest.check("", x.getStylesheet());
        HtmlDocConfigAnnotationTest.check("BasicHtmlDocTemplate", x.getTemplate());
    }

    @Test
    public void noAnnotation() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("", x.getAside());
        HtmlDocConfigAnnotationTest.check("", x.getFooter());
        HtmlDocConfigAnnotationTest.check("", x.getHead());
        HtmlDocConfigAnnotationTest.check("", x.getHeader());
        HtmlDocConfigAnnotationTest.check("", x.getNav());
        HtmlDocConfigAnnotationTest.check("", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("<p>no results</p>", x.getNoResultsMessage());
        HtmlDocConfigAnnotationTest.check("false", x.isNowrap());
        HtmlDocConfigAnnotationTest.check("", x.getScript());
        HtmlDocConfigAnnotationTest.check("", x.getStyle());
        HtmlDocConfigAnnotationTest.check("", x.getStylesheet());
        HtmlDocConfigAnnotationTest.check("BasicHtmlDocTemplate", x.getTemplate());
    }

    @Test
    public void inheritance1() throws Exception {
        AnnotationList al = d1.getAnnotationListParentFirst(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("foo2,foo", x.getAside());
        HtmlDocConfigAnnotationTest.check("foo2,foo", x.getFooter());
        HtmlDocConfigAnnotationTest.check("foo2,foo", x.getHead());
        HtmlDocConfigAnnotationTest.check("foo2,foo", x.getHeader());
        HtmlDocConfigAnnotationTest.check("foo2,foo", x.getNav());
        HtmlDocConfigAnnotationTest.check("foo2,foo1", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("foo2,foo1", x.getScript());
        HtmlDocConfigAnnotationTest.check("foo2,foo1", x.getStyle());
        HtmlDocConfigAnnotationTest.check("foo2,foo1", x.getStylesheet());
    }

    @Test
    public void inheritance2() throws Exception {
        AnnotationList al = d2.getAnnotationListParentFirst(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("foo,foo2", x.getAside());
        HtmlDocConfigAnnotationTest.check("foo,foo2", x.getFooter());
        HtmlDocConfigAnnotationTest.check("foo,foo2", x.getHead());
        HtmlDocConfigAnnotationTest.check("foo,foo2", x.getHeader());
        HtmlDocConfigAnnotationTest.check("foo,foo2", x.getNav());
        HtmlDocConfigAnnotationTest.check("foo1,foo2", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("foo1,foo2", x.getScript());
        HtmlDocConfigAnnotationTest.check("foo1,foo2", x.getStyle());
        HtmlDocConfigAnnotationTest.check("foo1,foo2", x.getStylesheet());
    }

    @Test
    public void inheritance3() throws Exception {
        AnnotationList al = d3.getAnnotationListParentFirst(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("foo2", x.getAside());
        HtmlDocConfigAnnotationTest.check("foo2", x.getFooter());
        HtmlDocConfigAnnotationTest.check("foo2", x.getHead());
        HtmlDocConfigAnnotationTest.check("foo2", x.getHeader());
        HtmlDocConfigAnnotationTest.check("foo2", x.getNav());
        HtmlDocConfigAnnotationTest.check("foo2", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("foo2", x.getScript());
        HtmlDocConfigAnnotationTest.check("foo2", x.getStyle());
        HtmlDocConfigAnnotationTest.check("foo2", x.getStylesheet());
    }

    @Test
    public void inheritance4() throws Exception {
        AnnotationList al = d4.getAnnotationListParentFirst(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("", x.getAside());
        HtmlDocConfigAnnotationTest.check("", x.getFooter());
        HtmlDocConfigAnnotationTest.check("", x.getHead());
        HtmlDocConfigAnnotationTest.check("", x.getHeader());
        HtmlDocConfigAnnotationTest.check("", x.getNav());
        HtmlDocConfigAnnotationTest.check("", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("", x.getScript());
        HtmlDocConfigAnnotationTest.check("", x.getStyle());
        HtmlDocConfigAnnotationTest.check("", x.getStylesheet());
    }

    @Test
    public void widgets_basic() throws Exception {
        AnnotationList al = e.getAnnotationListParentFirst(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getAside());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getFooter());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getHead());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getHeader());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getNav());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getNavlinks());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getNoResultsMessage());
        HtmlDocConfigAnnotationTest.check("false", x.isNowrap());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getScript());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getStyle());
        HtmlDocConfigAnnotationTest.check("$W{E}", x.getStylesheet());
        HtmlDocConfigAnnotationTest.check("BasicHtmlDocTemplate", x.getTemplate());
    }

    @Test
    public void widgets_resolution() throws Exception {
        AnnotationList al = e.getAnnotationListParentFirst(null);
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        String r = x.serialize(null).replaceAll("[\r\n]+", "|");
        TestUtils.assertContains(r, "<aside>xxx</aside>", "<footer>xxx</footer>", "<head>xxx", "<style>@import \"xxx\"; xxx zzz</style>", "<nav><ol><li>xxx</li></ol>xxx</nav>", "<script>xxx| yyy|</script>");
    }

    @Test
    public void e01_rankedAnnotations_f1() throws Exception {
        AnnotationList al = f1.getAnnotationListParentFirst(null).sort();
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("f1", x.getAside());
    }

    @Test
    public void e02_rankedAnnotations_f2() throws Exception {
        AnnotationList al = f2.getAnnotationListParentFirst(null).sort();
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("f1", x.getAside());
    }

    @Test
    public void e03_rankedAnnotations_f3() throws Exception {
        AnnotationList al = f3.getAnnotationListParentFirst(null).sort();
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("f3", x.getAside());
    }

    @Test
    public void e04_rankedAnnotations_f4() throws Exception {
        AnnotationList al = f4.getAnnotationListParentFirst(null).sort();
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("f3", x.getAside());
    }

    @Test
    public void e05_rankedAnnotations_f5() throws Exception {
        AnnotationList al = f5.getAnnotationListParentFirst(null).sort();
        HtmlDocSerializerSession x = HtmlDocSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlDocConfigAnnotationTest.check("f5", x.getAside());
    }

    @HtmlDocConfig(rank=3, aside={"f5"})
    static class F5
    extends F4 {
        F5() {
        }
    }

    @HtmlDocConfig(rank=2, aside={"f4"})
    static class F4
    extends F3 {
        F4() {
        }
    }

    @HtmlDocConfig(rank=3, aside={"f3"})
    static class F3
    extends F2 {
        F3() {
        }
    }

    @HtmlDocConfig(aside={"f2"})
    static class F2
    extends F1 {
        F2() {
        }
    }

    @HtmlDocConfig(rank=1, aside={"f1"})
    static class F1 {
        F1() {
        }
    }

    public static class EWidget
    implements HtmlWidget {
        public String getName() {
            return "E";
        }

        public String getHtml(VarResolverSession session) throws Exception {
            return "xxx";
        }

        public String getScript(VarResolverSession session) throws Exception {
            return "yyy";
        }

        public String getStyle(VarResolverSession session) throws Exception {
            return "zzz";
        }
    }

    @HtmlDocConfig(aside={"$W{E}"}, footer={"$W{E}"}, head={"$W{E}"}, header={"$W{E}"}, nav={"$W{E}"}, navlinks={"$W{E}"}, noResultsMessage="$W{E}", nowrap="$W{E}", script={"$W{E}"}, style={"$W{E}"}, stylesheet={"$W{E}"}, widgets={EWidget.class})
    static class E {
        E() {
        }
    }

    @HtmlDocConfig(aside={"NONE"}, footer={"NONE"}, head={"NONE"}, header={"NONE"}, nav={"NONE"}, navlinks={"NONE"}, script={"NONE"}, style={"NONE"}, stylesheet={"NONE"})
    static class D4
    extends A {
        D4() {
        }
    }

    @HtmlDocConfig(aside={"$X{foo2}"}, footer={"$X{foo2}"}, head={"$X{foo2}"}, header={"$X{foo2}"}, nav={"$X{foo2}"}, navlinks={"$X{foo2}"}, script={"$X{foo2}"}, style={"$X{foo2}"}, stylesheet={"$X{foo2}"})
    static class D3
    extends A {
        D3() {
        }
    }

    @HtmlDocConfig(aside={"$X{INHERIT}", "$X{foo2}"}, footer={"$X{INHERIT}", "$X{foo2}"}, head={"$X{INHERIT}", "$X{foo2}"}, header={"$X{INHERIT}", "$X{foo2}"}, nav={"$X{INHERIT}", "$X{foo2}"}, navlinks={"$X{INHERIT}", "$X{foo2}"}, script={"$X{INHERIT}", "$X{foo2}"}, style={"$X{INHERIT}", "$X{foo2}"}, stylesheet={"$X{INHERIT}", "$X{foo2}"})
    static class D2
    extends A {
        D2() {
        }
    }

    @HtmlDocConfig(aside={"$X{foo2}", "$X{INHERIT}"}, footer={"$X{foo2}", "$X{INHERIT}"}, head={"$X{foo2}", "$X{INHERIT}"}, header={"$X{foo2}", "$X{INHERIT}"}, nav={"$X{foo2}", "$X{INHERIT}"}, navlinks={"$X{foo2}", "$X{INHERIT}"}, script={"$X{foo2}", "$X{INHERIT}"}, style={"$X{foo2}", "$X{INHERIT}"}, stylesheet={"$X{foo2}", "$X{INHERIT}"})
    static class D1
    extends A {
        D1() {
        }
    }

    static class C {
        C() {
        }
    }

    @HtmlDocConfig
    static class B {
        B() {
        }
    }

    @HtmlDocConfig(aside={"$X{foo}"}, footer={"$X{foo}"}, head={"$X{foo}"}, header={"$X{foo}"}, nav={"$X{foo}"}, navlinks={"$X{foo1}"}, noResultsMessage="$X{foo}", nowrap="$X{true}", script={"$X{foo1}"}, style={"$X{foo1}"}, stylesheet={"$X{foo1}"}, template=BasicHtmlDocTemplate.class)
    static class A {
        A() {
        }
    }
}

