/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.function.Function;
import org.apache.juneau.XVar;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.junit.Assert;
import org.junit.Test;

public class HtmlConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basicSerializer() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        HtmlSerializerSession x = HtmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlConfigAnnotationTest.check("true", x.isAddBeanTypes());
        HtmlConfigAnnotationTest.check("true", x.isAddKeyValueTableHeaders());
        HtmlConfigAnnotationTest.check("true", x.isDetectLabelParameters());
        HtmlConfigAnnotationTest.check("true", x.isDetectLinksInStrings());
        HtmlConfigAnnotationTest.check("foo", x.getLabelParameter());
        HtmlConfigAnnotationTest.check("TO_STRING", x.getUriAnchorText());
    }

    @Test
    public void basicParser() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        HtmlParser.create().applyAnnotations(al, sr).build().createSession();
    }

    @Test
    public void defaultsSerializer() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        HtmlSerializerSession x = HtmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlConfigAnnotationTest.check("false", x.isAddBeanTypes());
        HtmlConfigAnnotationTest.check("false", x.isAddKeyValueTableHeaders());
        HtmlConfigAnnotationTest.check("true", x.isDetectLabelParameters());
        HtmlConfigAnnotationTest.check("true", x.isDetectLinksInStrings());
        HtmlConfigAnnotationTest.check("label", x.getLabelParameter());
        HtmlConfigAnnotationTest.check("TO_STRING", x.getUriAnchorText());
    }

    @Test
    public void defaultsParser() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        HtmlParser.create().applyAnnotations(al, sr).build().createSession();
    }

    @Test
    public void noAnnotationSerializer() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        HtmlSerializerSession x = HtmlSerializer.create().applyAnnotations(al, sr).build().createSession();
        HtmlConfigAnnotationTest.check("false", x.isAddBeanTypes());
        HtmlConfigAnnotationTest.check("false", x.isAddKeyValueTableHeaders());
        HtmlConfigAnnotationTest.check("true", x.isDetectLabelParameters());
        HtmlConfigAnnotationTest.check("true", x.isDetectLinksInStrings());
        HtmlConfigAnnotationTest.check("label", x.getLabelParameter());
        HtmlConfigAnnotationTest.check("TO_STRING", x.getUriAnchorText());
    }

    @Test
    public void noAnnotationParser() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        HtmlParser.create().applyAnnotations(al, sr).build().createSession();
    }

    static class C {
        C() {
        }
    }

    @HtmlConfig
    static class B {
        B() {
        }
    }

    @HtmlConfig(addBeanTypes="$X{true}", addKeyValueTableHeaders="$X{true}", detectLabelParameters="$X{true}", detectLinksInStrings="$X{true}", labelParameter="$X{foo}", uriAnchorText="$X{TO_STRING}")
    static class A {
        A() {
        }
    }
}

