/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlSerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class CommonTest {
    @Test
    public void testTrimNullsFromBeans() throws Exception {
        HtmlSerializerBuilder s = HtmlSerializer.create().sq().addKeyValueTableHeaders();
        HtmlParser p = HtmlParser.DEFAULT;
        A t1 = A.create();
        s.trimNullProperties(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>s1</td><td><null/></td></tr><tr><td>s2</td><td>s2</td></tr></table>", (Object)r);
        A t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimNullProperties(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>s2</td><td>s2</td></tr></table>", (Object)r);
        t2 = (A)p.parse(r, A.class);
        TestUtils.assertEqualObjects(t1, t2);
    }

    @Test
    public void testTrimEmptyMaps() throws Exception {
        HtmlSerializerBuilder s = HtmlSerializer.create().sq().addKeyValueTableHeaders();
        HtmlParser p = HtmlParser.DEFAULT;
        B t1 = B.create();
        s.trimEmptyMaps(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td><table><tr><th>key</th><th>value</th></tr></table></td></tr><tr><td>f2</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>f2a</td><td><null/></td></tr><tr><td>f2b</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>s2</td><td>s2</td></tr></table></td></tr></table></td></tr></table>", (Object)r);
        B t2 = (B)p.parse(r, B.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyMaps(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f2</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>f2a</td><td><null/></td></tr><tr><td>f2b</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>s2</td><td>s2</td></tr></table></td></tr></table></td></tr></table>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
        s.trimEmptyMaps();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f2</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>f2a</td><td><null/></td></tr><tr><td>f2b</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>s2</td><td>s2</td></tr></table></td></tr></table></td></tr></table>", (Object)r);
        t2 = (B)p.parse(r, B.class);
        Assert.assertNull(t2.f1);
    }

    @Test
    public void testTrimEmptyLists() throws Exception {
        HtmlSerializerBuilder s = HtmlSerializer.create().sq().addKeyValueTableHeaders();
        HtmlParser p = HtmlParser.DEFAULT;
        C t1 = C.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td><ul></ul></td></tr><tr><td>f2</td><td><table _type='array'><tr><th>s2</th></tr><tr><null/></tr><tr><td>s2</td></tr></table></td></tr></table>", (Object)r);
        C t2 = (C)p.parse(r, C.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f2</td><td><table _type='array'><tr><th>s2</th></tr><tr><null/></tr><tr><td>s2</td></tr></table></td></tr></table>", (Object)r);
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f2</td><td><table _type='array'><tr><th>s2</th></tr><tr><null/></tr><tr><td>s2</td></tr></table></td></tr></table>", (Object)r);
        t2 = (C)p.parse(r, C.class);
        Assert.assertNull(t2.f1);
    }

    @Test
    public void testTrimEmptyArrays() throws Exception {
        HtmlSerializerBuilder s = HtmlSerializer.create().sq().addKeyValueTableHeaders();
        HtmlParser p = HtmlParser.DEFAULT;
        D t1 = D.create();
        s.trimEmptyCollections(false);
        String r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td><ul></ul></td></tr><tr><td>f2</td><td><table _type='array'><tr><th>s2</th></tr><tr><null/></tr><tr><td>s2</td></tr></table></td></tr></table>", (Object)r);
        D t2 = (D)p.parse(r, D.class);
        TestUtils.assertEqualObjects(t1, t2);
        s.trimEmptyCollections(true);
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f2</td><td><table _type='array'><tr><th>s2</th></tr><tr><null/></tr><tr><td>s2</td></tr></table></td></tr></table>", (Object)r);
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
        s.trimEmptyCollections();
        r = s.build().serialize((Object)t1);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f2</td><td><table _type='array'><tr><th>s2</th></tr><tr><null/></tr><tr><td>s2</td></tr></table></td></tr></table>", (Object)r);
        t2 = (D)p.parse(r, D.class);
        Assert.assertNull((Object)t2.f1);
    }

    @Test
    public void testBeanPropertyProperties() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().addKeyValueTableHeaders().build();
        E1 t = new E1();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>x1</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td>1</td></tr></table></td></tr><tr><td>x2</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td>3</td></tr></table></td></tr><tr><td>x3</td><td><table _type='array'><tr><th>f1</th></tr><tr><td>1</td></tr></table></td></tr><tr><td>x4</td><td><table _type='array'><tr><th>f1</th></tr><tr><td>1</td></tr></table></td></tr><tr><td>x5</td><td><table _type='array'><tr><th>f1</th></tr><tr><td><number>5</number></td></tr></table></td></tr><tr><td>x6</td><td><table _type='array'><tr><th>f1</th></tr><tr><td><number>7</number></td></tr></table></td></tr></table>", (Object)r);
        r = s.getSchemaSerializer().serialize((Object)new E1());
        Assert.assertTrue((r.indexOf("f2") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testBeanPropertyPropertiesOnListOfBeans() throws Exception {
        HtmlSerializer s = HtmlSerializer.DEFAULT_SQ;
        LinkedList<F> l = new LinkedList<F>();
        F t = new F();
        t.x1.add(new F());
        l.add(t);
        String html = s.serialize(l);
        Assert.assertEquals((Object)"<table _type='array'><tr><th>x1</th><th>x2</th></tr><tr><td><table _type='array'><tr><th>x2</th></tr><tr><td>2</td></tr></table></td><td>2</td></tr></table>", (Object)html);
    }

    @Test
    public void testURIAttr() throws Exception {
        HtmlSerializer s = HtmlSerializer.DEFAULT_SQ;
        HtmlParser p = HtmlParser.DEFAULT;
        G t = new G();
        t.uri = new URI("http://uri");
        t.f1 = new URI("http://f1");
        t.f2 = new URL("http://f2");
        String html = s.serialize((Object)t);
        t = (G)p.parse(html, G.class);
        Assert.assertEquals((Object)"http://uri", (Object)t.uri.toString());
        Assert.assertEquals((Object)"http://f1", (Object)t.f1.toString());
        Assert.assertEquals((Object)"http://f2", (Object)t.f2.toString());
    }

    @Test
    public void testRecursion() throws Exception {
        String msg;
        HtmlSerializerBuilder s = HtmlSerializer.create().sq().addKeyValueTableHeaders();
        R1 r1 = new R1();
        R2 r2 = new R2();
        R3 r3 = new R3();
        r1.r2 = r2;
        r2.r3 = r3;
        r3.r1 = r1;
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            TestUtils.assertContains(msg, "It's recommended you use the BeanTraverseContext.BEANTRAVERSE_detectRecursions setting to help locate the loop.");
        }
        s.detectRecursions();
        try {
            s.build().serialize((Object)r1);
            Assert.fail((String)"Exception expected!");
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
            Assert.assertTrue((boolean)msg.contains("[0] <noname>:org.apache.juneau.html.CommonTest$R1"));
            Assert.assertTrue((boolean)msg.contains("->[1] r2:org.apache.juneau.html.CommonTest$R2"));
            Assert.assertTrue((boolean)msg.contains("->[2] r3:org.apache.juneau.html.CommonTest$R3"));
            Assert.assertTrue((boolean)msg.contains("->[3] r1:org.apache.juneau.html.CommonTest$R1"));
        }
        s.ignoreRecursions();
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>name</td><td>foo</td></tr><tr><td>r2</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>name</td><td>bar</td></tr><tr><td>r3</td><td><table><tr><th>key</th><th>value</th></tr><tr><td>name</td><td>baz</td></tr></table></td></tr></table></td></tr></table>", (Object)s.build().serialize((Object)r1));
        s.build().getSchemaSerializer().serialize((Object)r1);
    }

    @Test
    public void testBasicBean() throws Exception {
        HtmlSerializer s = HtmlSerializer.create().sq().trimNullProperties(false).sortProperties().addKeyValueTableHeaders().build();
        J a = new J();
        a.setF1("J");
        a.setF2(100);
        a.setF3(true);
        Assert.assertEquals((Object)"<table><tr><th>key</th><th>value</th></tr><tr><td>f1</td><td>J</td></tr><tr><td>f2</td><td>100</td></tr><tr><td>f3</td><td>true</td></tr></table>", (Object)s.serialize((Object)a));
    }

    public static class J {
        private String f1 = null;
        private int f2 = -1;
        private boolean f3 = false;

        public String getF1() {
            return this.f1;
        }

        public void setF1(String f1) {
            this.f1 = f1;
        }

        public int getF2() {
            return this.f2;
        }

        public void setF2(int f2) {
            this.f2 = f2;
        }

        public boolean isF3() {
            return this.f3;
        }

        public void setF3(boolean f3) {
            this.f3 = f3;
        }

        public String toString() {
            return "J(f1: " + this.getF1() + ", f2: " + this.getF2() + ")";
        }
    }

    public static class R3 {
        public String name = "baz";
        public R1 r1;
    }

    public static class R2 {
        public String name = "bar";
        public R3 r3;
    }

    public static class R1 {
        public String name = "foo";
        public R2 r2;
    }

    public static class G {
        public URI uri;
        public URI f1;
        public URL f2;
    }

    public static class F {
        @Beanp(properties="x2")
        public List<F> x1 = new LinkedList<F>();
        public int x2 = 2;
    }

    public static class E2 {
        public int f1 = 1;
        public int f2 = 2;
    }

    public static class E1 {
        @Beanp(properties="f1")
        public E2 x1 = new E2();
        @Beanp(properties="f1")
        public Map<String, Integer> x2 = new AMap().append((Object)"f1", (Object)3).append((Object)"f2", (Object)4);
        @Beanp(properties="f1")
        public E2[] x3 = new E2[]{new E2()};
        @Beanp(properties="f1")
        public List<E2> x4 = new AList().append((Object)new E2());
        @Beanp(properties="f1")
        public ObjectMap[] x5 = new ObjectMap[]{new ObjectMap().append("f1", (Object)5).append("f2", (Object)6)};
        @Beanp(properties="f1")
        public List<ObjectMap> x6 = new AList().append((Object)new ObjectMap().append("f1", (Object)7).append("f2", (Object)8));
    }

    public static class D {
        public A[] f1;
        public A[] f2;

        public static D create() {
            D t = new D();
            t.f1 = new A[0];
            t.f2 = new A[]{null, A.create()};
            return t;
        }
    }

    public static class C {
        public List<A> f1;
        public List<A> f2;

        public static C create() {
            C t = new C();
            t.f1 = new AList();
            t.f2 = new AList().append(null).append((Object)A.create());
            return t;
        }
    }

    public static class B {
        public TreeMap<String, A> f1;
        public TreeMap<String, A> f2;

        public static B create() {
            B t = new B();
            t.f1 = new TreeMap();
            t.f2 = new TreeMap<String, A>(){
                {
                    this.put("f2a", null);
                    this.put("f2b", A.create());
                }
            };
            return t;
        }
    }

    public static class A {
        public String s1;
        public String s2;

        public static A create() {
            A t = new A();
            t.s2 = "s2";
            return t;
        }
    }
}

