/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSession;
import org.junit.Assert;
import org.junit.Test;

public class CommonParserTest {
    @Test
    public void testFromSerializer() throws Exception {
        HtmlParser p = HtmlParser.create().dictionary(new Class[]{A1.class}).build();
        Map m = null;
        String in = "<table _type='object'><tr><th><string>key</string></th><th><string>value</string></th></tr><tr><td><string>a</string></td><td><number>1</number></td></tr></table>";
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        in = "<table _type='object'><tr><th><string>key</string></th><th><string>value</string></th></tr><tr><td><string>a</string></td><td><number>1</number></td></tr><tr><td><string>b</string></td><td><string>foo bar</string></td></tr></table>";
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo bar", m.get("b"));
        in = "<table _type='object'><tr><th><string>key</string></th><th><string>value</string></th></tr><tr><td><string>a</string></td><td><number>1</number></td></tr><tr><td><string>b</string></td><td><string>foo bar</string></td></tr><tr><td><string>c</string></td><td><boolean>false</boolean></td></tr></table>";
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)false, m.get("c"));
        in = " <table _type='object'> <tr> <th> <string> key </string> </th> <th> <string> value </string> </th> </tr> <tr> <td> <string> a </string> </td> <td> <number> 1 </number> </td> </tr> <tr> <td> <string> b </string> </td> <td> <string> foo </string> </td> </tr> <tr> <td> <string> c </string> </td> <td> <boolean> false </boolean> </td> </tr> </table> ";
        m = (Map)p.parse(in, Object.class);
        Assert.assertEquals((Object)1, m.get("a"));
        Assert.assertEquals((Object)"foo", m.get("b"));
        Assert.assertEquals((Object)false, m.get("c"));
        in = "<table _type='array'><tr><th>attribute</th></tr><tr><td><string>value</string></td></tr><tr><td><string>value</string></td></tr></table>";
        ObjectList jl = (ObjectList)p.parse(in, Object.class);
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(0).getString("attribute"));
        Assert.assertEquals((Object)"value", (Object)jl.getObjectMap(1).getString("attribute"));
        A1 t1 = new A1();
        A2 t2 = new A2();
        t2.add(new A3("name0", "value0"));
        t2.add(new A3("name1", "value1"));
        t1.list = t2;
        in = HtmlSerializer.create().addBeanTypes(true).addRootType().build().serialize((Object)t1);
        t1 = (A1)p.parse(in, Object.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)t1.list.get((int)1)).value);
        in = HtmlSerializer.DEFAULT.serialize((Object)t1);
        t1 = (A1)p.parse(in, A1.class);
        Assert.assertEquals((Object)"value1", (Object)((A3)t1.list.get((int)1)).value);
    }

    @Test
    public void testCorrectHandlingOfUnknownProperties() throws Exception {
        HtmlParser p = HtmlParser.create().ignoreUnknownBeanProperties().build();
        String in = "<table _type='object'><tr><th><string>key</string></th><th><string>value</string></th></tr><tr><td><string>a</string></td><td><number>1</number></td></tr><tr><td><string>unknown</string></td><td><number>1</number></td></tr><tr><td><string>b</string></td><td><number>2</number></td></tr></table>";
        B t = (B)p.parse(in, B.class);
        Assert.assertEquals((long)t.a, (long)1L);
        Assert.assertEquals((long)t.b, (long)2L);
        try {
            p = HtmlParser.DEFAULT;
            p.parse(in, B.class);
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testCollectionPropertiesWithNoSetters() throws Exception {
        HtmlParser p = HtmlParser.DEFAULT;
        String in = "<table _type='object'><tr><th><string>key</string></th><th><string>value</string></th></tr><tr><td><string>ints</string></td><td><ul><li><number>1</number></li><li><number>2</number></li><li><number>3</number></li></ul></td></tr><tr><td><string>beans</string></td><td><table _type='array'><tr><th>a</th><th>b</th></tr><tr><td><number>1</number></td><td><number>2</number></td></tr></table></td></tr></table>";
        C t = (C)p.parse(in, C.class);
        Assert.assertEquals((long)t.getInts().size(), (long)3L);
        Assert.assertEquals((long)t.getBeans().get((int)0).b, (long)2L);
    }

    @Test
    public void testParserListeners() throws Exception {
        HtmlParser p = HtmlParser.create().ignoreUnknownBeanProperties().listener(MyParserListener.class).build();
        String in = "<table _type='object'><tr><th><string>key</string></th><th><string>value</string></th></tr><tr><td><string>a</string></td><td><number>1</number></td></tr><tr><td><string>unknown</string></td><td><string>/foo</string></td></tr><tr><td><string>b</string></td><td><number>2</number></td></tr></table>";
        p.parse(in, B.class);
        Assert.assertEquals((long)1L, (long)MyParserListener.events.size());
    }

    public static class MyParserListener
    extends ParserListener {
        static final List<String> events = new LinkedList<String>();

        public <T> void onUnknownBeanProperty(ParserSession session, String propertyName, Class<T> beanClass, T bean) {
            events.add(propertyName + ", " + session.getPosition());
        }
    }

    public static class C {
        private Collection<Integer> ints = new LinkedList<Integer>();
        private List<B> beans = new LinkedList<B>();

        public Collection<Integer> getInts() {
            return this.ints;
        }

        public List<B> getBeans() {
            return this.beans;
        }
    }

    public static class B {
        public int a;
        public int b;
    }

    public static class A3 {
        public String name;
        public String value;

        public A3() {
        }

        public A3(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class A2
    extends LinkedList<A3> {
    }

    @Bean(typeName="A1")
    public static class A1 {
        public A2 list;
    }
}

