/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlConfig;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class BasicHtmlTest {
    private static final Class<?>[] ANNOTATED_CLASSES = new Class[]{BeanWithWhitespaceTextFields2.class, BeanWithWhitespaceTextPwsFields2.class, BeanWithWhitespaceMixedFields2.class, BeanWithWhitespaceMixedPwsFields2.class, LinkBeanC.class};
    private static final HtmlSerializer s1 = HtmlSerializer.DEFAULT_SQ.builder().addRootType().applyAnnotations((Class[])ANNOTATED_CLASSES).build();
    private static final HtmlSerializer s2 = HtmlSerializer.DEFAULT_SQ_READABLE.builder().addRootType().applyAnnotations((Class[])ANNOTATED_CLASSES).build();
    private static final HtmlSerializer s3 = HtmlSerializer.DEFAULT_SQ.builder().applyAnnotations((Class[])ANNOTATED_CLASSES).build();
    private static final HtmlParser parser = HtmlParser.DEFAULT.builder().applyAnnotations((Class[])ANNOTATED_CLASSES).build();
    private Input input;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new Input<String>("SimpleTypes-1", String.class, "foo", "<string>foo</string>", "<string>foo</string>", "<string>foo</string>"){

            @Override
            public void verify(String o) {
                TestUtils.assertInstanceOf(String.class, o);
            }
        }}, {new Input<Boolean>("SimpleTypes-2", Boolean.TYPE, Boolean.valueOf(true), "<boolean>true</boolean>", "<boolean>true</boolean>", "<boolean>true</boolean>"){

            @Override
            public void verify(Boolean o) {
                TestUtils.assertInstanceOf(Boolean.class, o);
            }
        }}, {new Input<Integer>("SimpleTypes-3", Integer.TYPE, Integer.valueOf(123), "<number>123</number>", "<number>123</number>", "<number>123</number>"){

            @Override
            public void verify(Integer o) {
                TestUtils.assertInstanceOf(Integer.class, o);
            }
        }}, {new Input<Float>("SimpleTypes-4", Float.TYPE, Float.valueOf(1.23f), "<number>1.23</number>", "<number>1.23</number>", "<number>1.23</number>"){

            @Override
            public void verify(Float o) {
                TestUtils.assertInstanceOf(Float.class, o);
            }
        }}, {new Input<Object>("SimpleTypes-5", (Type)((Object)String.class), null, "<null/>", "<null/>", "<null/>")}, {new Input<String[]>("Arrays-1", String[].class, new String[]{"foo"}, "<ul><li>foo</li></ul>", "<ul>\n\t<li>foo</li>\n</ul>\n", "<ul><li>foo</li></ul>"){

            @Override
            public void verify(String[] o) {
                TestUtils.assertInstanceOf(String.class, o[0]);
            }
        }}, {new Input<String[]>("Arrays-2", (Type)((Object)String[].class), new String[]{null}, "<ul><li><null/></li></ul>", "<ul>\n\t<li><null/></li>\n</ul>\n", "<ul><li><null/></li></ul>")}, {new Input<Object[]>("Arrays-3", Object[].class, new Object[]{"foo", 123, true}, "<ul><li>foo</li><li><number>123</number></li><li><boolean>true</boolean></li></ul>", "<ul>\n\t<li>foo</li>\n\t<li><number>123</number></li>\n\t<li><boolean>true</boolean></li>\n</ul>\n", "<ul><li>foo</li><li><number>123</number></li><li><boolean>true</boolean></li></ul>"){

            @Override
            public void verify(Object[] o) {
                TestUtils.assertInstanceOf(String.class, o[0]);
                TestUtils.assertInstanceOf(Integer.class, o[1]);
                TestUtils.assertInstanceOf(Boolean.class, o[2]);
            }
        }}, {new Input<int[]>("Arrays-4", int[].class, new int[]{123}, "<ul><li><number>123</number></li></ul>", "<ul>\n\t<li><number>123</number></li>\n</ul>\n", "<ul><li>123</li></ul>"){

            @Override
            public void verify(int[] o) {
                TestUtils.assertInstanceOf(int[].class, o);
            }
        }}, {new Input<boolean[]>("Arrays-5", boolean[].class, new boolean[]{true}, "<ul><li><boolean>true</boolean></li></ul>", "<ul>\n\t<li><boolean>true</boolean></li>\n</ul>\n", "<ul><li>true</li></ul>"){

            @Override
            public void verify(boolean[] o) {
                TestUtils.assertInstanceOf(boolean[].class, o);
            }
        }}, {new Input<String[][]>("Arrays-6", String[][].class, (String[][])new String[][]{{"foo"}}, "<ul><li><ul><li>foo</li></ul></li></ul>", "<ul>\n\t<li>\n\t\t<ul>\n\t\t\t<li>foo</li>\n\t\t</ul>\n\t</li>\n</ul>\n", "<ul><li><ul><li>foo</li></ul></li></ul>"){

            @Override
            public void verify(String[][] o) {
                TestUtils.assertInstanceOf(String[][].class, o);
            }
        }}, {new Input<Map<String, String>>("MapWithStrings", MapWithStrings.class, (Map)new MapWithStrings().append("k1", "v1").append("k2", null), "<table><tr><td>k1</td><td>v1</td></tr><tr><td>k2</td><td><null/></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>k1</td>\n\t\t<td>v1</td>\n\t</tr>\n\t<tr>\n\t\t<td>k2</td>\n\t\t<td><null/></td>\n\t</tr>\n</table>\n", "<table><tr><td>k1</td><td>v1</td></tr><tr><td>k2</td><td><null/></td></tr></table>"){

            @Override
            public void verify(Map<String, String> o) {
                TestUtils.assertInstanceOf(String.class, o.get("k1"));
            }
        }}, {new Input<Map<String, Number>>("MapsWithNumbers", MapWithNumbers.class, (Map)new MapWithNumbers().append("k1", 123).append("k2", 1.23).append("k3", null), "<table><tr><td>k1</td><td><number>123</number></td></tr><tr><td>k2</td><td><number>1.23</number></td></tr><tr><td>k3</td><td><null/></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>k1</td>\n\t\t<td><number>123</number></td>\n\t</tr>\n\t<tr>\n\t\t<td>k2</td>\n\t\t<td><number>1.23</number></td>\n\t</tr>\n\t<tr>\n\t\t<td>k3</td>\n\t\t<td><null/></td>\n\t</tr>\n</table>\n", "<table><tr><td>k1</td><td>123</td></tr><tr><td>k2</td><td>1.23</td></tr><tr><td>k3</td><td><null/></td></tr></table>"){

            @Override
            public void verify(Map<String, Number> o) {
                TestUtils.assertInstanceOf(Number.class, o.get("k1"));
            }
        }}, {new Input<Map<String, Object>>("MapWithObjects", TestUtils.getType(Map.class, new Type[]{String.class, Object.class}), (Map)new MapWithObjects().append("k1", "v1").append("k2", 123).append("k3", 1.23).append("k4", true).append("k5", null), "<table><tr><td>k1</td><td>v1</td></tr><tr><td>k2</td><td><number>123</number></td></tr><tr><td>k3</td><td><number>1.23</number></td></tr><tr><td>k4</td><td><boolean>true</boolean></td></tr><tr><td>k5</td><td><null/></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>k1</td>\n\t\t<td>v1</td>\n\t</tr>\n\t<tr>\n\t\t<td>k2</td>\n\t\t<td><number>123</number></td>\n\t</tr>\n\t<tr>\n\t\t<td>k3</td>\n\t\t<td><number>1.23</number></td>\n\t</tr>\n\t<tr>\n\t\t<td>k4</td>\n\t\t<td><boolean>true</boolean></td>\n\t</tr>\n\t<tr>\n\t\t<td>k5</td>\n\t\t<td><null/></td>\n\t</tr>\n</table>\n", "<table><tr><td>k1</td><td>v1</td></tr><tr><td>k2</td><td><number>123</number></td></tr><tr><td>k3</td><td><number>1.23</number></td></tr><tr><td>k4</td><td><boolean>true</boolean></td></tr><tr><td>k5</td><td><null/></td></tr></table>"){

            @Override
            public void verify(Map<String, Object> o) {
                TestUtils.assertInstanceOf(String.class, o.get("k1"));
                TestUtils.assertInstanceOf(Integer.class, o.get("k2"));
                TestUtils.assertInstanceOf(Float.class, o.get("k3"));
                TestUtils.assertInstanceOf(Boolean.class, o.get("k4"));
            }
        }}, {new Input<List<String>>("ListWithStrings", TestUtils.getType(List.class, new Type[]{String.class}), (List)new ListWithStrings().append("foo").append(null), "<ul><li>foo</li><li><null/></li></ul>", "<ul>\n\t<li>foo</li>\n\t<li><null/></li>\n</ul>\n", "<ul><li>foo</li><li><null/></li></ul>"){

            @Override
            public void verify(List<String> o) {
                TestUtils.assertInstanceOf(String.class, o.get(0));
            }
        }}, {new Input<List<Number>>("ListWithNumbers", ListWithNumbers.class, (List)new ListWithNumbers().append(123).append(1.23).append(null), "<ul><li><number>123</number></li><li><number>1.23</number></li><li><null/></li></ul>", "<ul>\n\t<li><number>123</number></li>\n\t<li><number>1.23</number></li>\n\t<li><null/></li>\n</ul>\n", "<ul><li>123</li><li>1.23</li><li><null/></li></ul>"){

            @Override
            public void verify(List<Number> o) {
                TestUtils.assertInstanceOf(Integer.class, o.get(0));
                TestUtils.assertInstanceOf(Float.class, o.get(1));
            }
        }}, {new Input<List<Object>>("ListWithObjects", TestUtils.getType(List.class, new Type[]{Object.class}), (List)new ListWithObjects().append("foo").append(123).append(1.23).append(true).append(null), "<ul><li>foo</li><li><number>123</number></li><li><number>1.23</number></li><li><boolean>true</boolean></li><li><null/></li></ul>", "<ul>\n\t<li>foo</li>\n\t<li><number>123</number></li>\n\t<li><number>1.23</number></li>\n\t<li><boolean>true</boolean></li>\n\t<li><null/></li>\n</ul>\n", "<ul><li>foo</li><li><number>123</number></li><li><number>1.23</number></li><li><boolean>true</boolean></li><li><null/></li></ul>"){

            @Override
            public void verify(List<Object> o) {
                TestUtils.assertInstanceOf(String.class, o.get(0));
                TestUtils.assertInstanceOf(Integer.class, o.get(1));
                TestUtils.assertInstanceOf(Float.class, o.get(2));
                TestUtils.assertInstanceOf(Boolean.class, o.get(3));
            }
        }}, {new Input<BeanWithNormalProperties>("BeanWithNormalProperties", BeanWithNormalProperties.class, new BeanWithNormalProperties().init(), "<table><tr><td>a</td><td>foo</td></tr><tr><td>b</td><td>123</td></tr><tr><td>c</td><td>bar</td></tr><tr><td>d</td><td><number>456</number></td></tr><tr><td>e</td><td><table><tr><td>h</td><td>qux</td></tr></table></td></tr><tr><td>f</td><td><ul><li>baz</li></ul></td></tr><tr><td>g</td><td><ul><li>789</li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>foo</td>\n\t</tr>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>123</td>\n\t</tr>\n\t<tr>\n\t\t<td>c</td>\n\t\t<td>bar</td>\n\t</tr>\n\t<tr>\n\t\t<td>d</td>\n\t\t<td><number>456</number></td>\n\t</tr>\n\t<tr>\n\t\t<td>e</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>h</td>\n\t\t\t\t\t<td>qux</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>f</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>baz</li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>g</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>789</li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td>foo</td></tr><tr><td>b</td><td>123</td></tr><tr><td>c</td><td>bar</td></tr><tr><td>d</td><td><number>456</number></td></tr><tr><td>e</td><td><table><tr><td>h</td><td>qux</td></tr></table></td></tr><tr><td>f</td><td><ul><li>baz</li></ul></td></tr><tr><td>g</td><td><ul><li>789</li></ul></td></tr></table>"){

            @Override
            public void verify(BeanWithNormalProperties o) {
                TestUtils.assertInstanceOf(String.class, o.c);
                TestUtils.assertInstanceOf(Integer.class, o.d);
                TestUtils.assertInstanceOf(Bean1a.class, o.e);
            }
        }}, {new Input<BeanWithMapProperties>("BeanWithMapProperties", BeanWithMapProperties.class, new BeanWithMapProperties().init(), "<table><tr><td>a</td><td><table><tr><td>k1</td><td>foo</td></tr></table></td></tr><tr><td>b</td><td><table><tr><td>k2</td><td>123</td></tr></table></td></tr><tr><td>c</td><td><table><tr><td>k3</td><td>bar</td></tr><tr><td>k4</td><td><number>456</number></td></tr><tr><td>k5</td><td><boolean>true</boolean></td></tr><tr><td>k6</td><td><null/></td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k1</td>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k2</td>\n\t\t\t\t\t<td>123</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>c</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k3</td>\n\t\t\t\t\t<td>bar</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k4</td>\n\t\t\t\t\t<td><number>456</number></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k5</td>\n\t\t\t\t\t<td><boolean>true</boolean></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k6</td>\n\t\t\t\t\t<td><null/></td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><table><tr><td>k1</td><td>foo</td></tr></table></td></tr><tr><td>b</td><td><table><tr><td>k2</td><td>123</td></tr></table></td></tr><tr><td>c</td><td><table><tr><td>k3</td><td>bar</td></tr><tr><td>k4</td><td><number>456</number></td></tr><tr><td>k5</td><td><boolean>true</boolean></td></tr><tr><td>k6</td><td><null/></td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithMapProperties o) {
                TestUtils.assertInstanceOf(String.class, o.a.get("k1"));
                TestUtils.assertInstanceOf(Integer.class, o.b.get("k2"));
                TestUtils.assertInstanceOf(String.class, o.c.get("k3"));
                TestUtils.assertInstanceOf(Integer.class, o.c.get("k4"));
                TestUtils.assertInstanceOf(Boolean.class, o.c.get("k5"));
            }
        }}, {new Input<BeanWithTypeName>("BeanWithTypeName", BeanWithTypeName.class, new BeanWithTypeName().init(), "<table _type='X'><tr><td>a</td><td>123</td></tr><tr><td>b</td><td>foo</td></tr></table>", "<table _type='X'>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>123</td>\n\t</tr>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>foo</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td>123</td></tr><tr><td>b</td><td>foo</td></tr></table>"){

            @Override
            public void verify(BeanWithTypeName o) {
                TestUtils.assertInstanceOf(BeanWithTypeName.class, o);
            }
        }}, {new Input<BeanWithPropertiesWithTypeNames>("BeanWithPropertiesWithTypeNames", BeanWithPropertiesWithTypeNames.class, new BeanWithPropertiesWithTypeNames().init(), "<table><tr><td>b1</td><td><table><tr><td>b</td><td>foo</td></tr></table></td></tr><tr><td>b2</td><td><table _type='B'><tr><td>b</td><td>foo</td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>b1</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>b</td>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b2</td>\n\t\t<td>\n\t\t\t<table _type='B'>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>b</td>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>b1</td><td><table><tr><td>b</td><td>foo</td></tr></table></td></tr><tr><td>b2</td><td><table _type='B'><tr><td>b</td><td>foo</td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithPropertiesWithTypeNames o) {
                TestUtils.assertInstanceOf(B.class, o.b2);
            }
        }}, {new Input<BeanWithPropertiesWithArrayTypeNames>("BeanWithPropertiesWithArrayTypeNames", BeanWithPropertiesWithArrayTypeNames.class, new BeanWithPropertiesWithArrayTypeNames().init(), "<table><tr><td>b1</td><td><table _type='array'><tr><th>b</th></tr><tr><td>foo</td></tr></table></td></tr><tr><td>b2</td><td><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></td></tr><tr><td>b3</td><td><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>b1</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>b</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b2</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>b</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='B'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b3</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>b</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='B'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>b1</td><td><table _type='array'><tr><th>b</th></tr><tr><td>foo</td></tr></table></td></tr><tr><td>b2</td><td><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></td></tr><tr><td>b3</td><td><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithPropertiesWithArrayTypeNames o) {
                TestUtils.assertInstanceOf(B.class, o.b2[0]);
                TestUtils.assertInstanceOf(B.class, o.b3[0]);
            }
        }}, {new Input<BeanWithPropertiesWith2dArrayTypeNames>("BeanWithPropertiesWith2dArrayTypeNames", BeanWithPropertiesWith2dArrayTypeNames.class, new BeanWithPropertiesWith2dArrayTypeNames().init(), "<table><tr><td>b1</td><td><ul><li><table _type='array'><tr><th>b</th></tr><tr><td>foo</td></tr></table></li></ul></td></tr><tr><td>b2</td><td><ul><li><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></li></ul></td></tr><tr><td>b3</td><td><ul><li><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>b1</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<table _type='array'>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<th>b</th>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b2</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<table _type='array'>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<th>b</th>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr _type='B'>\n\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b3</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>\n\t\t\t\t\t<table _type='array'>\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<th>b</th>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t<tr _type='B'>\n\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>b1</td><td><ul><li><table _type='array'><tr><th>b</th></tr><tr><td>foo</td></tr></table></li></ul></td></tr><tr><td>b2</td><td><ul><li><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></li></ul></td></tr><tr><td>b3</td><td><ul><li><table _type='array'><tr><th>b</th></tr><tr _type='B'><td>foo</td></tr></table></li></ul></td></tr></table>"){

            @Override
            public void verify(BeanWithPropertiesWith2dArrayTypeNames o) {
                TestUtils.assertInstanceOf(B.class, o.b2[0][0]);
                TestUtils.assertInstanceOf(B.class, o.b3[0][0]);
            }
        }}, {new Input<BeanWithPropertiesWithMapTypeNames>("BeanWithPropertiesWithMapTypeNames", BeanWithPropertiesWithMapTypeNames.class, new BeanWithPropertiesWithMapTypeNames().init(), "<table><tr><td>b1</td><td><table><tr><td>k1</td><td><table><tr><td>b</td><td>foo</td></tr></table></td></tr></table></td></tr><tr><td>b2</td><td><table><tr><td>k2</td><td><table _type='B'><tr><td>b</td><td>foo</td></tr></table></td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>b1</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k1</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b2</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k2</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table _type='B'>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>b</td>\n\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>b1</td><td><table><tr><td>k1</td><td><table><tr><td>b</td><td>foo</td></tr></table></td></tr></table></td></tr><tr><td>b2</td><td><table><tr><td>k2</td><td><table _type='B'><tr><td>b</td><td>foo</td></tr></table></td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithPropertiesWithMapTypeNames o) {
                TestUtils.assertInstanceOf(B.class, o.b1.get("k1"));
                TestUtils.assertInstanceOf(B.class, o.b2.get("k2"));
            }
        }}, {new Input<LinkBean>("LinkBean-1", LinkBean.class, new LinkBean().init(), "<a href='http://apache.org'>foo</a>", "<a href='http://apache.org'>foo</a>", "<a href='http://apache.org'>foo</a>"){

            @Override
            public void verify(LinkBean o) {
                TestUtils.assertInstanceOf(LinkBean.class, o);
            }
        }}, {new Input<LinkBean[]>("LinkBean-2", LinkBean[].class, new LinkBean[]{new LinkBean().init(), new LinkBean().init()}, "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>", "<ul>\n\t<li><a href='http://apache.org'>foo</a></li>\n\t<li><a href='http://apache.org'>foo</a></li>\n</ul>\n", "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>"){

            @Override
            public void verify(LinkBean[] o) {
                TestUtils.assertInstanceOf(LinkBean.class, o[0]);
            }
        }}, {new Input<List<LinkBean>>("ListWithLinkBeans", ListWithLinkBeans.class, (List)new ListWithLinkBeans().append(new LinkBean().init()).append(new LinkBean().init()), "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>", "<ul>\n\t<li><a href='http://apache.org'>foo</a></li>\n\t<li><a href='http://apache.org'>foo</a></li>\n</ul>\n", "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>"){

            @Override
            public void verify(List<LinkBean> o) {
                TestUtils.assertInstanceOf(LinkBean.class, o.get(0));
            }
        }}, {new Input<BeanWithLinkBeanProperties>("BeanWithLinkBeanProperties", BeanWithLinkBeanProperties.class, new BeanWithLinkBeanProperties().init(), "<table><tr><td>a</td><td><a href='http://apache.org'>foo</a></td></tr><tr><td>b</td><td><ul><li><a href='http://apache.org'>foo</a></li></ul></td></tr><tr><td>c</td><td><table><tr><td>c1</td><td><a href='http://apache.org'>foo</a></td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td><a href='http://apache.org'>foo</a></td>\n\t</tr>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li><a href='http://apache.org'>foo</a></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>c</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>c1</td>\n\t\t\t\t\t<td><a href='http://apache.org'>foo</a></td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><a href='http://apache.org'>foo</a></td></tr><tr><td>b</td><td><ul><li><a href='http://apache.org'>foo</a></li></ul></td></tr><tr><td>c</td><td><table><tr><td>c1</td><td><a href='http://apache.org'>foo</a></td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithLinkBeanProperties o) {
                TestUtils.assertInstanceOf(LinkBean.class, o.a);
                TestUtils.assertInstanceOf(LinkBean.class, o.b.get(0));
                TestUtils.assertInstanceOf(LinkBean.class, o.c.get("c1"));
            }
        }}, {new Input<LinkBeanC>("LinkBeanC-1", LinkBeanC.class, new LinkBeanC().init(), "<a href='http://apache.org'>foo</a>", "<a href='http://apache.org'>foo</a>", "<a href='http://apache.org'>foo</a>"){

            @Override
            public void verify(LinkBeanC o) {
                TestUtils.assertInstanceOf(LinkBeanC.class, o);
            }
        }}, {new Input<LinkBeanC[]>("LinkBeanC-2", LinkBeanC[].class, new LinkBeanC[]{new LinkBeanC().init(), new LinkBeanC().init()}, "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>", "<ul>\n\t<li><a href='http://apache.org'>foo</a></li>\n\t<li><a href='http://apache.org'>foo</a></li>\n</ul>\n", "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>"){

            @Override
            public void verify(LinkBeanC[] o) {
                TestUtils.assertInstanceOf(LinkBeanC.class, o[0]);
            }
        }}, {new Input<List<LinkBeanC>>("ListWithLinkBeansC", ListWithLinkBeansC.class, (List)new ListWithLinkBeansC().append(new LinkBeanC().init()).append(new LinkBeanC().init()), "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>", "<ul>\n\t<li><a href='http://apache.org'>foo</a></li>\n\t<li><a href='http://apache.org'>foo</a></li>\n</ul>\n", "<ul><li><a href='http://apache.org'>foo</a></li><li><a href='http://apache.org'>foo</a></li></ul>"){

            @Override
            public void verify(List<LinkBeanC> o) {
                TestUtils.assertInstanceOf(LinkBeanC.class, o.get(0));
            }
        }}, {new Input<BeanWithLinkBeanPropertiesC>("BeanWithLinkBeanPropertiesC", BeanWithLinkBeanPropertiesC.class, new BeanWithLinkBeanPropertiesC().init(), "<table><tr><td>a</td><td><a href='http://apache.org'>foo</a></td></tr><tr><td>b</td><td><ul><li><a href='http://apache.org'>foo</a></li></ul></td></tr><tr><td>c</td><td><table><tr><td>c1</td><td><a href='http://apache.org'>foo</a></td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td><a href='http://apache.org'>foo</a></td>\n\t</tr>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li><a href='http://apache.org'>foo</a></li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>c</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>c1</td>\n\t\t\t\t\t<td><a href='http://apache.org'>foo</a></td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><a href='http://apache.org'>foo</a></td></tr><tr><td>b</td><td><ul><li><a href='http://apache.org'>foo</a></li></ul></td></tr><tr><td>c</td><td><table><tr><td>c1</td><td><a href='http://apache.org'>foo</a></td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithLinkBeanPropertiesC o) {
                TestUtils.assertInstanceOf(LinkBeanC.class, o.a);
                TestUtils.assertInstanceOf(LinkBeanC.class, o.b.get(0));
                TestUtils.assertInstanceOf(LinkBeanC.class, o.c.get("c1"));
            }
        }}, {new Input<BeanWithSpecialCharacters>("BeanWithSpecialCharacters", BeanWithSpecialCharacters.class, new BeanWithSpecialCharacters().init(), "<table><tr><td>a</td><td><sp> </sp> <bs/><ff/><br/><sp>&#x2003;</sp>&#13; <sp> </sp></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td><sp> </sp> <bs/><ff/><br/><sp>&#x2003;</sp>&#13; <sp> </sp></td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><sp> </sp> <bs/><ff/><br/><sp>&#x2003;</sp>&#13; <sp> </sp></td></tr></table>"){

            @Override
            public void verify(BeanWithSpecialCharacters o) {
                TestUtils.assertInstanceOf(BeanWithSpecialCharacters.class, o);
            }
        }}, {new Input<BeanWithSpecialCharacters>("BeanWithSpecialCharacters-2", BeanWithSpecialCharacters.class, new BeanWithSpecialCharacters().init(), "<table><tr><td>a</td><td><sp> </sp> <bs/><ff/><br/><sp>&#x2003;</sp>&#13; <sp> </sp></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td><sp> </sp> <bs/><ff/><br/><sp>&#x2003;</sp>&#13; <sp> </sp></td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><sp> </sp> <bs/><ff/><br/><sp>&#x2003;</sp>&#13; <sp> </sp></td></tr></table>"){

            @Override
            public void verify(BeanWithSpecialCharacters o) {
                TestUtils.assertInstanceOf(BeanWithSpecialCharacters.class, o);
            }
        }}, {new Input<BeanWithNullProperties>("BeanWithNullProperties", BeanWithNullProperties.class, new BeanWithNullProperties(), "<table></table>", "<table>\n</table>\n", "<table></table>"){

            @Override
            public void verify(BeanWithNullProperties o) {
                TestUtils.assertInstanceOf(BeanWithNullProperties.class, o);
            }
        }}, {new Input<BeanWithAbstractFields>("BeanWithAbstractFields", BeanWithAbstractFields.class, new BeanWithAbstractFields().init(), "<table><tr><td>a</td><td><table><tr><td>a</td><td>foo</td></tr></table></td></tr><tr><td>ia</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr><tr><td>aa</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr><tr><td>o</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>a</td>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>ia</td>\n\t\t<td>\n\t\t\t<table _type='A'>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>a</td>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>aa</td>\n\t\t<td>\n\t\t\t<table _type='A'>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>a</td>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>o</td>\n\t\t<td>\n\t\t\t<table _type='A'>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>a</td>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><table><tr><td>a</td><td>foo</td></tr></table></td></tr><tr><td>ia</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr><tr><td>aa</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr><tr><td>o</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithAbstractFields o) {
                TestUtils.assertInstanceOf(A.class, o.a);
                TestUtils.assertInstanceOf(A.class, o.ia);
                TestUtils.assertInstanceOf(A.class, o.aa);
                TestUtils.assertInstanceOf(A.class, o.o);
            }
        }}, {new Input<BeanWithAbstractArrayFields>("BeanWithAbstractArrayFields", BeanWithAbstractArrayFields.class, new BeanWithAbstractArrayFields().init(), "<table><tr><td>a</td><td><table _type='array'><tr><th>a</th></tr><tr><td>foo</td></tr></table></td></tr><tr><td>ia1</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>ia2</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>aa1</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>aa2</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>o1</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>o2</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>a</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>ia1</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>a</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='A'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>ia2</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>a</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='A'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>aa1</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>a</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='A'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>aa2</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>a</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='A'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>o1</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>a</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='A'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>o2</td>\n\t\t<td>\n\t\t\t<table _type='array'>\n\t\t\t\t<tr>\n\t\t\t\t\t<th>a</th>\n\t\t\t\t</tr>\n\t\t\t\t<tr _type='A'>\n\t\t\t\t\t<td>foo</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><table _type='array'><tr><th>a</th></tr><tr><td>foo</td></tr></table></td></tr><tr><td>ia1</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>ia2</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>aa1</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>aa2</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>o1</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr><tr><td>o2</td><td><table _type='array'><tr><th>a</th></tr><tr _type='A'><td>foo</td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithAbstractArrayFields o) {
                TestUtils.assertInstanceOf(A.class, o.a[0]);
                TestUtils.assertInstanceOf(A.class, o.ia1[0]);
                TestUtils.assertInstanceOf(A.class, o.ia2[0]);
                TestUtils.assertInstanceOf(A.class, o.aa1[0]);
                TestUtils.assertInstanceOf(A.class, o.aa2[0]);
                TestUtils.assertInstanceOf(A.class, o.o1[0]);
                TestUtils.assertInstanceOf(A.class, o.o2[0]);
            }
        }}, {new Input<BeanWithAbstractMapFields>("BeanWithAbstractMapFields", BeanWithAbstractMapFields.class, new BeanWithAbstractMapFields().init(), "<table><tr><td>a</td><td><table><tr><td>k1</td><td><table><tr><td>a</td><td>foo</td></tr></table></td></tr></table></td></tr><tr><td>b</td><td><table><tr><td>k2</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr></table></td></tr><tr><td>c</td><td><table><tr><td>k3</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr></table></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k1</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k2</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n\t<tr>\n\t\t<td>c</td>\n\t\t<td>\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>k3</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<table _type='A'>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<td>a</td>\n\t\t\t\t\t\t\t\t<td>foo</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\n</table>\n", "<table><tr><td>a</td><td><table><tr><td>k1</td><td><table><tr><td>a</td><td>foo</td></tr></table></td></tr></table></td></tr><tr><td>b</td><td><table><tr><td>k2</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr></table></td></tr><tr><td>c</td><td><table><tr><td>k3</td><td><table _type='A'><tr><td>a</td><td>foo</td></tr></table></td></tr></table></td></tr></table>"){

            @Override
            public void verify(BeanWithAbstractMapFields o) {
                TestUtils.assertInstanceOf(A.class, o.a.get("k1"));
                TestUtils.assertInstanceOf(A.class, o.b.get("k2"));
                TestUtils.assertInstanceOf(A.class, o.c.get("k3"));
            }
        }}, {new Input<BeanWithWhitespaceTextFields>("BeanWithWhitespaceTextFields-1", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields>("BeanWithWhitespaceTextFields-2", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init(""), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields>("BeanWithWhitespaceTextFields-3", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init(" "), "<object><sp> </sp></object>", "<object><sp> </sp></object>\n", "<object><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields>("BeanWithWhitespaceTextFields-4", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init("  "), "<object><sp> </sp><sp> </sp></object>", "<object><sp> </sp><sp> </sp></object>\n", "<object><sp> </sp><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields>("BeanWithWhitespaceTextFields-5", BeanWithWhitespaceTextFields.class, new BeanWithWhitespaceTextFields().init("  foobar  "), "<object><sp> </sp> foobar <sp> </sp></object>", "<object><sp> </sp> foobar <sp> </sp></object>\n", "<object><sp> </sp> foobar <sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields>("BeanWithWhitespaceTextPwsFields-1", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields>("BeanWithWhitespaceTextPwsFields-2", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init(""), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields>("BeanWithWhitespaceTextPwsFields-3", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init(" "), "<object> </object>", "<object> </object>\n", "<object> </object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields>("BeanWithWhitespaceTextPwsFields-4", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init("  "), "<object>  </object>", "<object>  </object>\n", "<object>  </object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields>("BeanWithWhitespaceTextPwsFields-5", BeanWithWhitespaceTextPwsFields.class, new BeanWithWhitespaceTextPwsFields().init("  foobar  "), "<object>  foobar  </object>", "<object>  foobar  </object>\n", "<object>  foobar  </object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields>("BeanWithWhitespaceMixedFields-1", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields>("BeanWithWhitespaceMixedFields-2", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[0]), "<object></object>", "<object></object>\n", "<object></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields>("BeanWithWhitespaceMixedFields-3", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{""}), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields>("BeanWithWhitespaceMixedFields-4", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{" "}), "<object><sp> </sp></object>", "<object><sp> </sp></object>\n", "<object><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields>("BeanWithWhitespaceMixedFields-5", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{"  "}), "<object><sp> </sp><sp> </sp></object>", "<object><sp> </sp><sp> </sp></object>\n", "<object><sp> </sp><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields>("BeanWithWhitespaceMixedFields-6", BeanWithWhitespaceMixedFields.class, new BeanWithWhitespaceMixedFields().init(new String[]{"  foobar  "}), "<object><sp> </sp> foobar <sp> </sp></object>", "<object><sp> </sp> foobar <sp> </sp></object>\n", "<object><sp> </sp> foobar <sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields>("BeanWithWhitespaceMixedPwsFields-1", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields>("BeanWithWhitespaceMixedPwsFields-2", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[0]), "<object></object>", "<object></object>\n", "<object></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields>("BeanWithWhitespaceMixedPwsFields-3", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{""}), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields>("BeanWithWhitespaceMixedPwsFields-4", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{" "}), "<object> </object>", "<object> </object>\n", "<object> </object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields>("BeanWithWhitespaceMixedPwsFields-5", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{"  "}), "<object>  </object>", "<object>  </object>\n", "<object>  </object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields>("BeanWithWhitespaceMixedPwsFields-6", BeanWithWhitespaceMixedPwsFields.class, new BeanWithWhitespaceMixedPwsFields().init(new String[]{"  foobar  "}), "<object>  foobar  </object>", "<object>  foobar  </object>\n", "<object>  foobar  </object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields2>("BeanWithWhitespaceTextFields2-1", BeanWithWhitespaceTextFields2.class, new BeanWithWhitespaceTextFields2().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields2>("BeanWithWhitespaceTextFields2-2", BeanWithWhitespaceTextFields2.class, new BeanWithWhitespaceTextFields2().init(""), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields2>("BeanWithWhitespaceTextFields2-3", BeanWithWhitespaceTextFields2.class, new BeanWithWhitespaceTextFields2().init(" "), "<object><sp> </sp></object>", "<object><sp> </sp></object>\n", "<object><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields2>("BeanWithWhitespaceTextFields2-4", BeanWithWhitespaceTextFields2.class, new BeanWithWhitespaceTextFields2().init("  "), "<object><sp> </sp><sp> </sp></object>", "<object><sp> </sp><sp> </sp></object>\n", "<object><sp> </sp><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextFields2>("BeanWithWhitespaceTextFields2-5", BeanWithWhitespaceTextFields2.class, new BeanWithWhitespaceTextFields2().init("  foobar  "), "<object><sp> </sp> foobar <sp> </sp></object>", "<object><sp> </sp> foobar <sp> </sp></object>\n", "<object><sp> </sp> foobar <sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields2>("BeanWithWhitespaceTextPwsFields2-1", BeanWithWhitespaceTextPwsFields2.class, new BeanWithWhitespaceTextPwsFields2().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields2>("BeanWithWhitespaceTextPwsFields2-2", BeanWithWhitespaceTextPwsFields2.class, new BeanWithWhitespaceTextPwsFields2().init(""), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields2>("BeanWithWhitespaceTextPwsFields2-3", BeanWithWhitespaceTextPwsFields2.class, new BeanWithWhitespaceTextPwsFields2().init(" "), "<object> </object>", "<object> </object>\n", "<object> </object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields2>("BeanWithWhitespaceTextPwsFields2-4", BeanWithWhitespaceTextPwsFields2.class, new BeanWithWhitespaceTextPwsFields2().init("  "), "<object>  </object>", "<object>  </object>\n", "<object>  </object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceTextPwsFields2>("BeanWithWhitespaceTextPwsFields2-5", BeanWithWhitespaceTextPwsFields2.class, new BeanWithWhitespaceTextPwsFields2().init("  foobar  "), "<object>  foobar  </object>", "<object>  foobar  </object>\n", "<object>  foobar  </object>"){

            @Override
            public void verify(BeanWithWhitespaceTextPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceTextPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields2>("BeanWithWhitespaceMixedFields2-1", BeanWithWhitespaceMixedFields2.class, new BeanWithWhitespaceMixedFields2().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields2>("BeanWithWhitespaceMixedFields2-2", BeanWithWhitespaceMixedFields2.class, new BeanWithWhitespaceMixedFields2().init(new String[0]), "<object></object>", "<object></object>\n", "<object></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields2>("BeanWithWhitespaceMixedFields2-3", BeanWithWhitespaceMixedFields2.class, new BeanWithWhitespaceMixedFields2().init(new String[]{""}), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields2>("BeanWithWhitespaceMixedFields2-4", BeanWithWhitespaceMixedFields2.class, new BeanWithWhitespaceMixedFields2().init(new String[]{" "}), "<object><sp> </sp></object>", "<object><sp> </sp></object>\n", "<object><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields2>("BeanWithWhitespaceMixedFields2-5", BeanWithWhitespaceMixedFields2.class, new BeanWithWhitespaceMixedFields2().init(new String[]{"  "}), "<object><sp> </sp><sp> </sp></object>", "<object><sp> </sp><sp> </sp></object>\n", "<object><sp> </sp><sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedFields2>("BeanWithWhitespaceMixedFields2-6", BeanWithWhitespaceMixedFields2.class, new BeanWithWhitespaceMixedFields2().init(new String[]{"  foobar  "}), "<object><sp> </sp> foobar <sp> </sp></object>", "<object><sp> </sp> foobar <sp> </sp></object>\n", "<object><sp> </sp> foobar <sp> </sp></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields2>("BeanWithWhitespaceMixedPwsFields2-1", BeanWithWhitespaceMixedPwsFields2.class, new BeanWithWhitespaceMixedPwsFields2().init(null), "<object nil='true'></object>", "<object nil='true'>\n</object>\n", "<object nil='true'></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields2>("BeanWithWhitespaceMixedPwsFields2-2", BeanWithWhitespaceMixedPwsFields2.class, new BeanWithWhitespaceMixedPwsFields2().init(new String[0]), "<object></object>", "<object></object>\n", "<object></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields2>("BeanWithWhitespaceMixedPwsFields2-3", BeanWithWhitespaceMixedPwsFields2.class, new BeanWithWhitespaceMixedPwsFields2().init(new String[]{""}), "<object><sp/></object>", "<object><sp/></object>\n", "<object><sp/></object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields2>("BeanWithWhitespaceMixedPwsFields2-4", BeanWithWhitespaceMixedPwsFields2.class, new BeanWithWhitespaceMixedPwsFields2().init(new String[]{" "}), "<object> </object>", "<object> </object>\n", "<object> </object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields2>("BeanWithWhitespaceMixedPwsFields2-5", BeanWithWhitespaceMixedPwsFields2.class, new BeanWithWhitespaceMixedPwsFields2().init(new String[]{"  "}), "<object>  </object>", "<object>  </object>\n", "<object>  </object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields2.class, o);
            }
        }}, {new Input<BeanWithWhitespaceMixedPwsFields2>("BeanWithWhitespaceMixedPwsFields2-6", BeanWithWhitespaceMixedPwsFields2.class, new BeanWithWhitespaceMixedPwsFields2().init(new String[]{"  foobar  "}), "<object>  foobar  </object>", "<object>  foobar  </object>\n", "<object>  foobar  </object>"){

            @Override
            public void verify(BeanWithWhitespaceMixedPwsFields2 o) {
                TestUtils.assertInstanceOf(BeanWithWhitespaceMixedPwsFields2.class, o);
            }
        }});
    }

    public BasicHtmlTest(Input input) throws Exception {
        this.input = input;
    }

    @Test
    public void a1_serializeNormal() {
        try {
            String r = s1.serialize(this.input.in);
            Assert.assertEquals((String)(this.input.label + " serialize-normal failed"), (Object)this.input.e1, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void a2_parseNormal() {
        try {
            String r = s1.serialize(this.input.in);
            Object o = parser.parse(r, this.input.type, new Type[0]);
            r = s1.serialize(o);
            Assert.assertEquals((String)(this.input.label + " parse-normal failed"), (Object)this.input.e1, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void a3_verifyNormal() {
        try {
            String r = s1.serialize(this.input.in);
            Object o = parser.parse(r, this.input.type, new Type[0]);
            this.input.verify(o);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void b1_serializeReadable() {
        try {
            String r = s2.serialize(this.input.in);
            Assert.assertEquals((String)(this.input.label + " serialize-readable failed"), (Object)this.input.e2, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void b2_parseReadable() {
        try {
            String r = s2.serialize(this.input.in);
            Object o = parser.parse(r, this.input.type, new Type[0]);
            r = s2.serialize(o);
            Assert.assertEquals((String)(this.input.label + " parse-readable failed"), (Object)this.input.e2, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void b3_verifyReadable() {
        try {
            String r = s2.serialize(this.input.in);
            Object o = parser.parse(r, this.input.type, new Type[0]);
            this.input.verify(o);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void c1_serializeAbridged() {
        try {
            String r = s3.serialize(this.input.in);
            Assert.assertEquals((String)(this.input.label + " serialize-addRootType failed"), (Object)this.input.e3, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void c2_parseAbridged() {
        try {
            String r = s3.serialize(this.input.in);
            Object o = parser.parse(r, this.input.type, new Type[0]);
            r = s3.serialize(o);
            Assert.assertEquals((String)(this.input.label + " parse-addRootType failed"), (Object)this.input.e3, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @Test
    public void c3_verifyAbridged() {
        try {
            String r = s3.serialize(this.input.in);
            Object o = parser.parse(r, this.input.type, new Type[0]);
            this.input.verify(o);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(this.input.label + " test failed", e);
        }
    }

    @HtmlConfig(applyHtml={@Html(on="BeanWithWhitespaceMixedPwsFields2", format=HtmlFormat.XML)})
    @XmlConfig(applyXml={@Xml(on="BeanWithWhitespaceMixedPwsFields2.a", format=XmlFormat.MIXED_PWS)})
    @Html(format=HtmlFormat.XML)
    public static class BeanWithWhitespaceMixedPwsFields2 {
        public String[] a;

        public BeanWithWhitespaceMixedPwsFields2 init(String[] s) {
            this.a = s;
            return this;
        }
    }

    @HtmlConfig(applyHtml={@Html(on="BeanWithWhitespaceMixedFields2", format=HtmlFormat.XML)})
    @XmlConfig(applyXml={@Xml(on="BeanWithWhitespaceMixedFields2.a", format=XmlFormat.MIXED)})
    public static class BeanWithWhitespaceMixedFields2 {
        public String[] a;

        public BeanWithWhitespaceMixedFields2 init(String[] s) {
            this.a = s;
            return this;
        }
    }

    @HtmlConfig(applyHtml={@Html(on="BeanWithWhitespaceTextPwsFields2", format=HtmlFormat.XML)})
    @XmlConfig(applyXml={@Xml(on="BeanWithWhitespaceTextPwsFields2.a", format=XmlFormat.TEXT_PWS)})
    public static class BeanWithWhitespaceTextPwsFields2 {
        public String a;

        public BeanWithWhitespaceTextPwsFields2 init(String s) {
            this.a = s;
            return this;
        }
    }

    @HtmlConfig(applyHtml={@Html(on="BeanWithWhitespaceTextFields2", format=HtmlFormat.XML)})
    @XmlConfig(applyXml={@Xml(on="BeanWithWhitespaceTextFields2.a", format=XmlFormat.TEXT)})
    public static class BeanWithWhitespaceTextFields2 {
        public String a;

        public BeanWithWhitespaceTextFields2 init(String s) {
            this.a = s;
            return this;
        }
    }

    @Html(format=HtmlFormat.XML)
    public static class BeanWithWhitespaceMixedPwsFields {
        @Xml(format=XmlFormat.MIXED_PWS)
        public String[] a;

        public BeanWithWhitespaceMixedPwsFields init(String[] s) {
            this.a = s;
            return this;
        }
    }

    @Html(format=HtmlFormat.XML)
    public static class BeanWithWhitespaceMixedFields {
        @Xml(format=XmlFormat.MIXED)
        public String[] a;

        public BeanWithWhitespaceMixedFields init(String[] s) {
            this.a = s;
            return this;
        }
    }

    @Html(format=HtmlFormat.XML)
    public static class BeanWithWhitespaceTextPwsFields {
        @Xml(format=XmlFormat.TEXT_PWS)
        public String a;

        public BeanWithWhitespaceTextPwsFields init(String s) {
            this.a = s;
            return this;
        }
    }

    @Html(format=HtmlFormat.XML)
    public static class BeanWithWhitespaceTextFields {
        @Xml(format=XmlFormat.TEXT)
        public String a;

        public BeanWithWhitespaceTextFields init(String s) {
            this.a = s;
            return this;
        }
    }

    @Bean(typeName="A")
    public static class A
    extends AA {
        private String a;

        @Override
        public String getA() {
            return this.a;
        }

        @Override
        public void setA(String a) {
            this.a = a;
        }

        A init() {
            this.a = "foo";
            return this;
        }
    }

    public static abstract class AA
    implements IA {
    }

    public static interface IA {
        public String getA();

        public void setA(String var1);
    }

    @Bean(dictionary={A.class})
    public static class BeanWithAbstractMapFields {
        public Map<String, A> a;
        public Map<String, AA> b;
        public Map<String, Object> c;

        BeanWithAbstractMapFields init() {
            this.a = new HashMap<String, A>();
            this.b = new HashMap<String, AA>();
            this.c = new HashMap<String, Object>();
            this.a.put("k1", new A().init());
            this.b.put("k2", new A().init());
            this.c.put("k3", new A().init());
            return this;
        }
    }

    @Bean(dictionary={A.class}, bpi="a,ia1,ia2,aa1,aa2,o1,o2")
    public static class BeanWithAbstractArrayFields {
        public A[] a;
        public IA[] ia1;
        public IA[] ia2;
        public AA[] aa1;
        public AA[] aa2;
        public Object[] o1;
        public Object[] o2;

        BeanWithAbstractArrayFields init() {
            this.a = new A[]{new A().init()};
            this.ia1 = new A[]{new A().init()};
            this.aa1 = new A[]{new A().init()};
            this.o1 = new A[]{new A().init()};
            this.ia2 = new IA[]{new A().init()};
            this.aa2 = new AA[]{new A().init()};
            this.o2 = new Object[]{new A().init()};
            return this;
        }
    }

    @Bean(dictionary={A.class}, bpi="a,ia,aa,o")
    public static class BeanWithAbstractFields {
        public A a;
        public IA ia;
        public AA aa;
        public Object o;

        BeanWithAbstractFields init() {
            this.ia = new A().init();
            this.aa = new A().init();
            this.a = new A().init();
            this.o = new A().init();
            return this;
        }
    }

    public static class BeanWithNullProperties {
        public String a;
        public String[] b;
    }

    @Bean(typeName="  \b\f\n\t\r  ")
    public static class BeanWithSpecialCharacters2 {
        @Beanp(name="  \b\f\n\t\r  ")
        public String a;

        BeanWithSpecialCharacters2 init() {
            this.a = "  \b\f\n\t\r  ";
            return this;
        }
    }

    public static class BeanWithSpecialCharacters {
        public String a;

        BeanWithSpecialCharacters init() {
            this.a = "  \b\f\n\t\r  ";
            return this;
        }
    }

    public static class BeanWithLinkBeanPropertiesC {
        public LinkBeanC a;
        public List<LinkBeanC> b;
        public Map<String, LinkBeanC> c;

        BeanWithLinkBeanPropertiesC init() {
            this.a = new LinkBeanC().init();
            this.b = new ListWithLinkBeansC().append(new LinkBeanC().init());
            this.c = new LinkedHashMap<String, LinkBeanC>();
            this.c.put("c1", new LinkBeanC().init());
            return this;
        }
    }

    public static class ListWithLinkBeansC
    extends ArrayList<LinkBeanC> {
        public ListWithLinkBeansC append(LinkBeanC value) {
            this.add(value);
            return this;
        }
    }

    @HtmlConfig(applyHtmlLink={@HtmlLink(on="LinkBeanC", nameProperty="a", uriProperty="b")})
    public static class LinkBeanC {
        public String a;
        public String b;

        LinkBeanC init() {
            this.a = "foo";
            this.b = "http://apache.org";
            return this;
        }
    }

    public static class BeanWithLinkBeanProperties {
        public LinkBean a;
        public List<LinkBean> b;
        public Map<String, LinkBean> c;

        BeanWithLinkBeanProperties init() {
            this.a = new LinkBean().init();
            this.b = new ListWithLinkBeans().append(new LinkBean().init());
            this.c = new LinkedHashMap<String, LinkBean>();
            this.c.put("c1", new LinkBean().init());
            return this;
        }
    }

    public static class ListWithLinkBeans
    extends ArrayList<LinkBean> {
        public ListWithLinkBeans append(LinkBean value) {
            this.add(value);
            return this;
        }
    }

    @HtmlLink(nameProperty="a", uriProperty="b")
    public static class LinkBean {
        public String a;
        public String b;

        LinkBean init() {
            this.a = "foo";
            this.b = "http://apache.org";
            return this;
        }
    }

    @Bean(typeName="B")
    public static class B {
        public String b;

        B init() {
            this.b = "foo";
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithMapTypeNames {
        public Map<String, B> b1;
        public Map<String, Object> b2;

        BeanWithPropertiesWithMapTypeNames init() {
            this.b1 = new HashMap<String, B>();
            this.b1.put("k1", new B().init());
            this.b2 = new HashMap<String, Object>();
            this.b2.put("k2", new B().init());
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWith2dArrayTypeNames {
        public B[][] b1;
        public Object[][] b2;
        public Object[][] b3;

        BeanWithPropertiesWith2dArrayTypeNames init() {
            this.b1 = new B[][]{{new B().init()}};
            this.b2 = new B[][]{{new B().init()}};
            this.b3 = new Object[][]{{new B().init()}};
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithArrayTypeNames {
        public B[] b1;
        public Object[] b2;
        public Object[] b3;

        BeanWithPropertiesWithArrayTypeNames init() {
            this.b1 = new B[]{new B().init()};
            this.b2 = new B[]{new B().init()};
            this.b3 = new Object[]{new B().init()};
            return this;
        }
    }

    @Bean(dictionary={B.class})
    public static class BeanWithPropertiesWithTypeNames {
        public B b1;
        public Object b2;

        BeanWithPropertiesWithTypeNames init() {
            this.b1 = new B().init();
            this.b2 = new B().init();
            return this;
        }
    }

    @Bean(typeName="X")
    public static class BeanWithTypeName {
        public int a;
        public String b;

        BeanWithTypeName init() {
            this.a = 123;
            this.b = "foo";
            return this;
        }
    }

    public static class BeanWithMapProperties {
        @Beanp(type=MapWithStrings.class)
        public Map<String, String> a;
        @Beanp(type=MapWithNumbers.class)
        public Map<String, Number> b;
        @Beanp(type=MapWithObjects.class)
        public Map<String, Object> c;

        BeanWithMapProperties init() {
            this.a = new MapWithStrings().append("k1", "foo");
            this.b = new MapWithNumbers().append("k2", 123);
            this.c = new MapWithObjects().append("k3", "bar").append("k4", 456).append("k5", true).append("k6", null);
            return this;
        }
    }

    public static class Bean1a {
        public String h;

        Bean1a init() {
            this.h = "qux";
            return this;
        }
    }

    public static class BeanWithNormalProperties {
        public String a;
        public int b;
        public Object c;
        public Object d;
        public Bean1a e;
        public String[] f;
        public int[] g;

        BeanWithNormalProperties init() {
            this.a = "foo";
            this.b = 123;
            this.c = "bar";
            this.d = 456;
            this.e = new Bean1a().init();
            this.f = new String[]{"baz"};
            this.g = new int[]{789};
            return this;
        }
    }

    public static class ListWithObjects
    extends ArrayList<Object> {
        public ListWithObjects append(Object value) {
            this.add(value);
            return this;
        }
    }

    public static class ListWithNumbers
    extends ArrayList<Number> {
        public ListWithNumbers append(Number value) {
            this.add(value);
            return this;
        }
    }

    public static class ListWithStrings
    extends ArrayList<String> {
        public ListWithStrings append(String value) {
            this.add(value);
            return this;
        }
    }

    public static class MapWithObjects
    extends LinkedHashMap<String, Object> {
        public MapWithObjects append(String key, Object value) {
            this.put(key, value);
            return this;
        }
    }

    public static class MapWithNumbers
    extends LinkedHashMap<String, Number> {
        public MapWithNumbers append(String key, Number value) {
            this.put(key, value);
            return this;
        }
    }

    public static class MapWithStrings
    extends LinkedHashMap<String, String> {
        public MapWithStrings append(String key, String value) {
            this.put(key, value);
            return this;
        }
    }

    public static class Input<T> {
        private final String label;
        private final String e1;
        private final String e2;
        private final String e3;
        private final Type type;
        private final Object in;

        public Input(String label, Type type, T in, String e1, String e2, String e3) {
            this.label = label;
            this.type = type;
            this.in = in;
            this.e1 = e1;
            this.e2 = e2;
            this.e3 = e3;
        }

        public void verify(T o) {
        }
    }
}

