/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.EncoderGroupBuilder;
import org.apache.juneau.encoders.GzipEncoder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class EncoderGroupTest {
    @Test
    public void testEncoderGroupMatching() throws Exception {
        EncoderGroup g = EncoderGroup.create().append(new Class[]{Encoder1.class, Encoder2.class, Encoder3.class}).build();
        TestUtils.assertInstanceOf(Encoder1.class, g.getEncoder("gzip1"));
        TestUtils.assertInstanceOf(Encoder2.class, g.getEncoder("gzip2"));
        TestUtils.assertInstanceOf(Encoder2.class, g.getEncoder("gzip2a"));
        TestUtils.assertInstanceOf(Encoder3.class, g.getEncoder("gzip3"));
        TestUtils.assertInstanceOf(Encoder3.class, g.getEncoder("gzip3a"));
        TestUtils.assertInstanceOf(Encoder3.class, g.getEncoder("gzip3,gzip2,gzip1"));
        TestUtils.assertInstanceOf(Encoder1.class, g.getEncoder("gzip3;q=0.9,gzip2;q=0.1,gzip1"));
        TestUtils.assertInstanceOf(Encoder3.class, g.getEncoder("gzip2;q=0.9,gzip1;q=0.1,gzip3"));
        TestUtils.assertInstanceOf(Encoder2.class, g.getEncoder("gzip1;q=0.9,gzip3;q=0.1,gzip2"));
    }

    @Test
    public void testInheritence() throws Exception {
        EncoderGroupBuilder gb = null;
        EncoderGroup g = null;
        gb = EncoderGroup.create().append(new Class[]{E1.class, E2.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['E1','E2','E2a']", g.getSupportedEncodings());
        gb = g.builder().append(new Class[]{E3.class, E4.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['E3','E4','E4a','E1','E2','E2a']", g.getSupportedEncodings());
        gb = g.builder().append(new Class[]{E5.class});
        g = gb.build();
        TestUtils.assertObjectEquals("['E5','E3','E4','E4a','E1','E2','E2a']", g.getSupportedEncodings());
    }

    public static class E5
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"E5"};
        }
    }

    public static class E4
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"E4", "E4a"};
        }
    }

    public static class E3
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"E3"};
        }
    }

    public static class E2
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"E2", "E2a"};
        }
    }

    public static class E1
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"E1"};
        }
    }

    public static class Encoder3
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"gzip3", "gzip3a"};
        }
    }

    public static class Encoder2
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"gzip2", "gzip2a"};
        }
    }

    public static class Encoder1
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"gzip1"};
        }
    }
}

