/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import org.apache.juneau.dto.swagger.Xml;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class XmlTest {
    @Test
    public void testName() {
        Xml t = new Xml();
        t.name((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        t.name((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        TestUtils.assertInstanceOf(String.class, t.getName());
        t.name(null);
        Assert.assertNull((Object)t.getName());
    }

    @Test
    public void testNamespace() {
        Xml t = new Xml();
        t.namespace((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getNamespace());
        t.namespace((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getNamespace());
        TestUtils.assertInstanceOf(String.class, t.getNamespace());
        t.namespace(null);
        Assert.assertNull((Object)t.getNamespace());
    }

    @Test
    public void testPrefix() {
        Xml t = new Xml();
        t.prefix((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getPrefix());
        t.prefix((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getPrefix());
        TestUtils.assertInstanceOf(String.class, t.getPrefix());
        t.prefix(null);
        Assert.assertNull((Object)t.getPrefix());
    }

    @Test
    public void testAttribute() {
        Xml t = new Xml();
        t.attribute((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getAttribute());
        TestUtils.assertInstanceOf(Boolean.class, t.getAttribute());
        t.attribute((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getAttribute());
        TestUtils.assertInstanceOf(Boolean.class, t.getAttribute());
        t.attribute((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getAttribute());
        TestUtils.assertInstanceOf(Boolean.class, t.getAttribute());
        t.attribute(null);
        Assert.assertNull((Object)t.getAttribute());
    }

    @Test
    public void testWrapped() {
        Xml t = new Xml();
        t.wrapped((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getWrapped());
        TestUtils.assertInstanceOf(Boolean.class, t.getWrapped());
        t.wrapped((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getWrapped());
        TestUtils.assertInstanceOf(Boolean.class, t.getWrapped());
        t.wrapped((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getWrapped());
        TestUtils.assertInstanceOf(Boolean.class, t.getWrapped());
        t.wrapped(null);
        Assert.assertNull((Object)t.getWrapped());
    }

    @Test
    public void testSet() throws Exception {
        Xml t = new Xml();
        t.set("attribute", (Object)true).set("name", (Object)"a").set("namespace", (Object)"b").set("prefix", (Object)"c").set("wrapped", (Object)true).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{name:'a',namespace:'b',prefix:'c',attribute:true,wrapped:true,'$ref':'ref'}", t);
        t.set("attribute", (Object)"true").set("name", (Object)"a").set("namespace", (Object)"b").set("prefix", (Object)"c").set("wrapped", (Object)"true").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{name:'a',namespace:'b',prefix:'c',attribute:true,wrapped:true,'$ref':'ref'}", t);
        t.set("attribute", (Object)new StringBuilder("true")).set("name", (Object)new StringBuilder("a")).set("namespace", (Object)new StringBuilder("b")).set("prefix", (Object)new StringBuilder("c")).set("wrapped", (Object)new StringBuilder("true")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{name:'a',namespace:'b',prefix:'c',attribute:true,wrapped:true,'$ref':'ref'}", t);
        Assert.assertEquals((Object)"true", (Object)t.get("attribute", String.class));
        Assert.assertEquals((Object)"a", (Object)t.get("name", String.class));
        Assert.assertEquals((Object)"b", (Object)t.get("namespace", String.class));
        Assert.assertEquals((Object)"c", (Object)t.get("prefix", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("wrapped", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("attribute", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("name", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("namespace", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("prefix", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("wrapped", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{name:'a',namespace:'b',prefix:'c',attribute:true,wrapped:true,'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, Xml.class));
    }
}

