/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TagTest {
    @Test
    public void testName() {
        Tag t = new Tag();
        t.name((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        t.name((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        TestUtils.assertInstanceOf(String.class, t.getName());
        t.name(null);
        Assert.assertNull((Object)t.getName());
    }

    @Test
    public void testDescription() {
        Tag t = new Tag();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testExternalDocs() {
        Tag t = new Tag();
        t.externalDocs((Object)SwaggerBuilder.externalDocumentation((Object)"foo"));
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        t.externalDocs((Object)"{url:'foo'}");
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.getExternalDocs());
        t.externalDocs(null);
        Assert.assertNull((Object)t.getExternalDocs());
    }

    @Test
    public void testSet() throws Exception {
        Tag t = new Tag();
        t.set("description", (Object)"a").set("externalDocs", (Object)SwaggerBuilder.externalDocumentation((Object)"b")).set("name", (Object)"c").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{name:'c',description:'a',externalDocs:{url:'b'},'$ref':'ref'}", t);
        t.set("description", (Object)"a").set("externalDocs", (Object)"{url:'b'}").set("name", (Object)"c").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{name:'c',description:'a',externalDocs:{url:'b'},'$ref':'ref'}", t);
        t.set("description", (Object)new StringBuilder("a")).set("externalDocs", (Object)new StringBuilder("{url:'b'}")).set("name", (Object)new StringBuilder("c")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{name:'c',description:'a',externalDocs:{url:'b'},'$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"{url:'b'}", (Object)t.get("externalDocs", String.class));
        Assert.assertEquals((Object)"c", (Object)t.get("name", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.get("externalDocs", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("name", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{name:'c',description:'a',externalDocs:{url:'b'},'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, Tag.class));
    }
}

