/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.OperationMap;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SecurityScheme;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class SwaggerTest {
    @Test
    public void testSwagger() {
        Swagger t = new Swagger();
        t.swagger((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getSwagger());
        t.swagger((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getSwagger());
        TestUtils.assertInstanceOf(String.class, t.getSwagger());
        t.swagger(null);
        Assert.assertNull((Object)t.getSwagger());
    }

    @Test
    public void testInfo() {
        Swagger t = new Swagger();
        t.info((Object)SwaggerBuilder.info((String)"foo", (String)"bar"));
        TestUtils.assertObjectEquals("{title:'foo',version:'bar'}", t.getInfo());
        t.info((Object)"{title:'foo',version:'bar'}");
        TestUtils.assertObjectEquals("{title:'foo',version:'bar'}", t.getInfo());
        TestUtils.assertInstanceOf(Info.class, t.getInfo());
        t.info(null);
        Assert.assertNull((Object)t.getInfo());
    }

    @Test
    public void testHost() {
        Swagger t = new Swagger();
        t.host((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getHost());
        t.host((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getHost());
        TestUtils.assertInstanceOf(String.class, t.getHost());
        t.host(null);
        Assert.assertNull((Object)t.getHost());
    }

    @Test
    public void testBasePath() {
        Swagger t = new Swagger();
        t.basePath((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getBasePath());
        t.basePath((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getBasePath());
        TestUtils.assertInstanceOf(String.class, t.getBasePath());
        t.basePath(null);
        Assert.assertNull((Object)t.getBasePath());
    }

    @Test
    public void testSetSchemes() {
        Swagger t = new Swagger();
        t.setSchemes((Collection)new ASet().appendAll((Object[])new String[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.setSchemes((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.setSchemes(null);
        Assert.assertNull((Object)t.getSchemes());
    }

    @Test
    public void testAddSchemes() {
        Swagger t = new Swagger();
        t.addSchemes((Collection)new ASet().appendAll((Object[])new String[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.addSchemes((Collection)new ASet());
        TestUtils.assertObjectEquals("['foo','bar']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.addSchemes(null);
        TestUtils.assertObjectEquals("['foo','bar']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
    }

    @Test
    public void testSchemes() {
        Swagger t = new Swagger();
        t.schemes(new Object[]{new ASet().appendAll((Object[])new String[]{"foo"})});
        t.schemes(new Object[]{new ASet().appendAll(new Object[]{new StringBuilder("bar")})});
        t.schemes(new Object[]{new String[]{"baz"}});
        t.schemes(new Object[]{"['qux']"});
        t.schemes(new Object[]{"quux"});
        t.schemes(new Object[]{"[]"});
        t.schemes(new Object[]{null});
        TestUtils.assertObjectEquals("['foo','bar','baz','qux','quux']", t.getSchemes());
    }

    @Test
    public void testSetConsumes() {
        Swagger t = new Swagger();
        t.setConsumes((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.setConsumes((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.setConsumes(null);
        Assert.assertNull((Object)t.getConsumes());
    }

    @Test
    public void testAddConsumes() {
        Swagger t = new Swagger();
        t.addConsumes((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.addConsumes((Collection)new ASet());
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.addConsumes(null);
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
    }

    @Test
    public void testConsumes() {
        Swagger t = new Swagger();
        t.consumes(new Object[]{new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")})});
        t.consumes(new Object[]{MediaType.forString((String)"text/bar")});
        t.consumes(new Object[]{"text/baz"});
        t.consumes(new Object[]{new StringBuilder("text/qux")});
        t.consumes(new Object[]{new String[]{"text/quux"}});
        t.consumes(new Object[]{new ASet().append((Object)"text/quuux")});
        t.consumes(new Object[]{"['text/quuuux']"});
        t.consumes(new Object[]{"[]"});
        t.consumes(new Object[]{null});
        TestUtils.assertObjectEquals("['text/foo','text/bar','text/baz','text/qux','text/quux','text/quuux','text/quuuux']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        for (MediaType mt : t.getConsumes()) {
            TestUtils.assertInstanceOf(MediaType.class, mt);
        }
    }

    @Test
    public void testSetProduces() {
        Swagger t = new Swagger();
        t.setProduces((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.setProduces((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.setProduces(null);
        Assert.assertNull((Object)t.getProduces());
    }

    @Test
    public void testAddProduces() {
        Swagger t = new Swagger();
        t.addProduces((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.addProduces((Collection)new ASet());
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.addProduces(null);
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
    }

    @Test
    public void testProduces() {
        Swagger t = new Swagger();
        t.produces(new Object[]{new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")})});
        t.produces(new Object[]{MediaType.forString((String)"text/bar")});
        t.produces(new Object[]{"text/baz"});
        t.produces(new Object[]{new StringBuilder("text/qux")});
        t.produces(new Object[]{new String[]{"text/quux"}});
        t.produces(new Object[]{new ASet().append((Object)"text/quuux")});
        t.produces(new Object[]{"['text/quuuux']"});
        t.produces(new Object[]{"[]"});
        t.produces(new Object[]{null});
        TestUtils.assertObjectEquals("['text/foo','text/bar','text/baz','text/qux','text/quux','text/quuux','text/quuuux']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        for (MediaType mt : t.getProduces()) {
            TestUtils.assertInstanceOf(MediaType.class, mt);
        }
    }

    @Test
    public void testSetPaths() {
        Swagger t = new Swagger();
        t.setPaths((Map)new AMap().append((Object)"foo", (Object)new OperationMap().append("bar", SwaggerBuilder.operation().summary((Object)"baz"))));
        TestUtils.assertObjectEquals("{foo:{bar:{summary:'baz'}}}", t.getPaths());
        TestUtils.assertInstanceOf(Map.class, t.getPaths());
        t.setPaths((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getPaths());
        TestUtils.assertInstanceOf(Map.class, t.getPaths());
        t.setPaths(null);
        Assert.assertNull((Object)t.getPaths());
    }

    @Test
    public void testAddPaths() {
        Swagger t = new Swagger();
        t.addPaths((Map)new AMap().append((Object)"foo", (Object)new OperationMap().append("bar", SwaggerBuilder.operation().summary((Object)"baz"))));
        TestUtils.assertObjectEquals("{foo:{bar:{summary:'baz'}}}", t.getPaths());
        TestUtils.assertInstanceOf(Map.class, t.getPaths());
        t.addPaths((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:{bar:{summary:'baz'}}}", t.getPaths());
        TestUtils.assertInstanceOf(Map.class, t.getPaths());
        t.addPaths(null);
        TestUtils.assertObjectEquals("{foo:{bar:{summary:'baz'}}}", t.getPaths());
        TestUtils.assertInstanceOf(Map.class, t.getPaths());
    }

    @Test
    public void testPath() {
        Swagger t = new Swagger();
        t.path("a", "a1", SwaggerBuilder.operation().description((Object)"a2"));
        t.path("b", null, null);
        TestUtils.assertObjectEquals("{a:{a1:{description:'a2'}},b:{null:null}}", t.getPaths());
    }

    @Test
    public void testPaths() {
        Swagger t = new Swagger();
        t.paths(new Object[]{new AMap().append((Object)"a", (Object)new AMap().append((Object)"a1", (Object)SwaggerBuilder.operation().operationId((Object)"a2")))});
        t.paths(new Object[]{new AMap().append((Object)"b", (Object)new AMap().append((Object)"b1", (Object)"{operationId:'b2'}"))});
        t.paths(new Object[]{new AMap().append((Object)"c", (Object)"{c1:{operationId:'c2'}}")});
        t.paths(new Object[]{"{d:{d1:{operationId:'d2'}}}"});
        t.paths(new Object[]{"{}"});
        t.paths((Object[])null);
        TestUtils.assertObjectEquals("{a:{a1:{operationId:'a2'}},b:{b1:{operationId:'b2'}},c:{c1:{operationId:'c2'}},d:{d1:{operationId:'d2'}}}", t.getPaths());
        for (Map m : t.getPaths().values()) {
            for (Operation o : m.values()) {
                TestUtils.assertInstanceOf(Operation.class, o);
            }
        }
    }

    @Test
    public void testSetDefinitions() {
        Swagger t = new Swagger();
        t.setDefinitions((Map)new AMap().append((Object)"foo", (Object)new ObjectMap().append("type", (Object)"bar")));
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getDefinitions());
        t.setDefinitions((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getDefinitions());
        t.setDefinitions(null);
        Assert.assertNull((Object)t.getDefinitions());
    }

    @Test
    public void testAddDefinitions() {
        Swagger t = new Swagger();
        t.addDefinitions((Map)new AMap().append((Object)"foo", (Object)new ObjectMap().append("type", (Object)"bar")));
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getDefinitions());
        t.addDefinitions((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getDefinitions());
        t.addDefinitions(null);
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getDefinitions());
    }

    @Test
    public void testDefinition() {
        Swagger t = new Swagger();
        t.definition("a", new ObjectMap().append("type", (Object)"a1"));
        t.definition("b", (ObjectMap)null);
        t.definition(null, new ObjectMap().append("type", (Object)"c1"));
        TestUtils.assertObjectEquals("{a:{type:'a1'},b:null,null:{type:'c1'}}", t.getDefinitions());
    }

    @Test
    public void testDefinitions() {
        Swagger t = new Swagger();
        t.definitions(new Object[]{new AMap().append((Object)"a", (Object)SwaggerBuilder.schemaInfo().type((Object)"a1"))});
        t.definitions(new Object[]{new AMap().append((Object)"b", (Object)"{type:'b1'}")});
        t.definitions(new Object[]{"{c:{type:'c1'}}"});
        t.definitions(new Object[]{"{}"});
        t.definitions((Object[])null);
        TestUtils.assertObjectEquals("{a:{type:'a1'},b:{type:'b1'},c:{type:'c1'}}", t.getDefinitions());
    }

    @Test
    public void testSetParameters() {
        Swagger t = new Swagger();
        t.setParameters((Map)new AMap().append((Object)"foo", (Object)SwaggerBuilder.parameterInfo().name((Object)"bar")));
        TestUtils.assertObjectEquals("{foo:{name:'bar'}}", t.getParameters());
        TestUtils.assertInstanceOf(Map.class, t.getParameters());
        t.setParameters((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getParameters());
        TestUtils.assertInstanceOf(Map.class, t.getParameters());
        t.setParameters(null);
        Assert.assertNull((Object)t.getParameters());
    }

    @Test
    public void testAddParameters() {
        Swagger t = new Swagger();
        t.addParameters((Map)new AMap().append((Object)"foo", (Object)SwaggerBuilder.parameterInfo().name((Object)"bar")));
        TestUtils.assertObjectEquals("{foo:{name:'bar'}}", t.getParameters());
        TestUtils.assertInstanceOf(Map.class, t.getParameters());
        t.addParameters((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:{name:'bar'}}", t.getParameters());
        TestUtils.assertInstanceOf(Map.class, t.getParameters());
        t.addParameters(null);
        TestUtils.assertObjectEquals("{foo:{name:'bar'}}", t.getParameters());
        TestUtils.assertInstanceOf(Map.class, t.getParameters());
    }

    @Test
    public void testParameter() {
        Swagger t = new Swagger();
        t.parameter("a", SwaggerBuilder.parameterInfo().in((Object)"a1"));
        t.parameter("b", null);
        t.parameter(null, SwaggerBuilder.parameterInfo().in((Object)"c1"));
        TestUtils.assertObjectEquals("{a:{'in':'a1'},b:null,null:{'in':'c1'}}", t.getParameters());
    }

    @Test
    public void testParameters() {
        Swagger t = new Swagger();
        t.parameters(new Object[]{new AMap().append((Object)"a", (Object)SwaggerBuilder.parameterInfo((String)"a1", (String)"a2"))});
        t.parameters(new Object[]{new AMap().append((Object)"b", (Object)"{in:'b1',name:'b2'}")});
        t.parameters(new Object[]{"{c:{in:'c1',name:'c2'}}"});
        t.parameters(new Object[]{"{}"});
        t.parameters((Object[])null);
        TestUtils.assertObjectEquals("{a:{'in':'a1',name:'a2'},b:{'in':'b1',name:'b2'},c:{'in':'c1',name:'c2'}}", t.getParameters());
    }

    @Test
    public void testSetResponses() {
        Swagger t = new Swagger();
        t.setResponses((Map)new AMap().append((Object)"123", (Object)SwaggerBuilder.responseInfo((String)"bar")));
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.setResponses((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.setResponses(null);
        Assert.assertNull((Object)t.getResponses());
    }

    @Test
    public void testAddResponses() {
        Swagger t = new Swagger();
        t.addResponses((Map)new AMap().append((Object)"123", (Object)SwaggerBuilder.responseInfo((String)"bar")));
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.addResponses((Map)new AMap());
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.addResponses(null);
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
    }

    @Test
    public void testResponse() {
        Swagger t = new Swagger();
        t.response("a", SwaggerBuilder.responseInfo((String)"a1"));
        t.response(null, SwaggerBuilder.responseInfo((String)"b1"));
        t.response("c", null);
        TestUtils.assertObjectEquals("{a:{description:'a1'},null:{description:'b1'},c:null}", t.getResponses());
    }

    @Test
    public void testResponses() {
        Swagger t = new Swagger();
        t.responses(new Object[]{new AMap().append((Object)"a", (Object)SwaggerBuilder.responseInfo((String)"a1"))});
        t.responses(new Object[]{new AMap().append((Object)"b", (Object)"{description:'b1'}")});
        t.responses(new Object[]{"{c:{description:'c1'}}"});
        t.responses(new Object[]{"{}"});
        t.responses((Object[])null);
        TestUtils.assertObjectEquals("{a:{description:'a1'},b:{description:'b1'},c:{description:'c1'}}", t.getResponses());
        for (ResponseInfo ri : t.getResponses().values()) {
            TestUtils.assertInstanceOf(ResponseInfo.class, ri);
        }
    }

    @Test
    public void testSetSecurityDefinitions() {
        Swagger t = new Swagger();
        t.setSecurityDefinitions((Map)new AMap().append((Object)"foo", (Object)SwaggerBuilder.securityScheme((String)"bar")));
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getSecurityDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getSecurityDefinitions());
        t.setSecurityDefinitions((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getSecurityDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getSecurityDefinitions());
        t.setSecurityDefinitions(null);
        Assert.assertNull((Object)t.getSecurityDefinitions());
    }

    @Test
    public void testAddSecurityDefinitions() {
        Swagger t = new Swagger();
        t.addSecurityDefinitions((Map)new AMap().append((Object)"foo", (Object)SwaggerBuilder.securityScheme((String)"bar")));
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getSecurityDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getSecurityDefinitions());
        t.addSecurityDefinitions((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getSecurityDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getSecurityDefinitions());
        t.addSecurityDefinitions(null);
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getSecurityDefinitions());
        TestUtils.assertInstanceOf(Map.class, t.getSecurityDefinitions());
    }

    @Test
    public void testSecurityDefinition() {
        Swagger t = new Swagger();
        t.securityDefinition("a", SwaggerBuilder.securityScheme((String)"a1"));
        t.securityDefinition("b", null);
        t.securityDefinition(null, SwaggerBuilder.securityScheme((String)"c1"));
        TestUtils.assertObjectEquals("{a:{type:'a1'},b:null,null:{type:'c1'}}", t.getSecurityDefinitions());
    }

    @Test
    public void testSecurityDefinitions() {
        Swagger t = new Swagger();
        t.securityDefinitions(new Object[]{new AMap().append((Object)"a", (Object)SwaggerBuilder.securityScheme((String)"a1"))});
        t.securityDefinitions(new Object[]{new AMap().append((Object)"b", (Object)"{type:'b1'}")});
        t.securityDefinitions(new Object[]{"{c:{type:'c1'}}"});
        t.securityDefinitions(new Object[]{"{}"});
        t.securityDefinitions((Object[])null);
        TestUtils.assertObjectEquals("{a:{type:'a1'},b:{type:'b1'},c:{type:'c1'}}", t.getSecurityDefinitions());
        for (SecurityScheme ss : t.getSecurityDefinitions().values()) {
            TestUtils.assertInstanceOf(SecurityScheme.class, ss);
        }
    }

    @Test
    public void testSetSecurity() {
        Swagger t = new Swagger();
        t.setSecurity((Collection)new ASet().append((Object)new AMap().append((Object)"foo", (Object)new AList().append((Object)"bar"))));
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.setSecurity((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.setSecurity(null);
        Assert.assertNull((Object)t.getSecurity());
    }

    @Test
    public void testAddSecurity() {
        Swagger t = new Swagger();
        t.addSecurity((Collection)new ASet().append((Object)new AMap().append((Object)"foo", (Object)new AList().append((Object)"bar"))));
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.addSecurity((Collection)new ASet());
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.addSecurity(null);
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
    }

    @Test
    public void testSecurity() {
        Swagger t = new Swagger();
        t.security("a", new String[]{"a1", "a2"});
        t.security("b", new String[]{null});
        t.security("c", new String[0]);
        t.security(null, new String[]{"d1", "d2"});
        TestUtils.assertObjectEquals("[{a:['a1','a2']},{b:[null]},{c:[]},{null:['d1','d2']}]", t.getSecurity());
    }

    @Test
    public void testSecurities() {
        Swagger t = new Swagger();
        t.securities(new Object[]{new ASet().append((Object)new AMap().append((Object)"a1", (Object)new AList().append((Object)"a2")))});
        t.securities(new Object[]{new AMap().append((Object)"b1", (Object)new AList().append((Object)"b2"))});
        t.securities(new Object[]{"{c1:['c2']}"});
        t.securities(new Object[]{new StringBuilder("{d1:['d2']}")});
        t.securities(new Object[]{new String[]{"{e1:['e2']}"}});
        t.securities(new Object[]{new ASet().append((Object)"{f1:['f2']}")});
        t.securities(new Object[]{"[{g1:['g2']}]"});
        t.securities(new Object[]{"[]"});
        t.securities(new Object[]{null});
        TestUtils.assertObjectEquals("[{a1:['a2']},{b1:['b2']},{c1:['c2']},{d1:['d2']},{e1:['e2']},{f1:['f2']},{g1:['g2']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
    }

    @Test
    public void testSetTags() {
        Swagger t = new Swagger();
        t.setTags((Collection)new ASet().appendAll((Object[])new Tag[]{SwaggerBuilder.tag((String)"foo")}));
        TestUtils.assertObjectEquals("[{name:'foo'}]", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.setTags((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.setTags(null);
        Assert.assertNull((Object)t.getTags());
    }

    @Test
    public void testAddTags() {
        Swagger t = new Swagger();
        t.addTags((Collection)new ASet().appendAll((Object[])new Tag[]{SwaggerBuilder.tag((String)"foo")}));
        TestUtils.assertObjectEquals("[{name:'foo'}]", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.addTags((Collection)new ASet());
        TestUtils.assertObjectEquals("[{name:'foo'}]", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.addTags(null);
        TestUtils.assertObjectEquals("[{name:'foo'}]", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
    }

    @Test
    public void testTags() {
        Swagger t = new Swagger();
        t.tags(new Object[]{new ASet().appendAll((Object[])new Tag[]{SwaggerBuilder.tag((String)"a")})});
        t.tags(new Object[]{new ASet().appendAll((Object[])new String[]{"{name:'b'}"})});
        t.tags(new Object[]{new Tag[]{SwaggerBuilder.tag((String)"c")}});
        t.tags(new Object[]{new String[]{"{name:'d'}"}});
        t.tags(new Object[]{"{name:'e'}"});
        t.tags(new Object[]{new StringBuilder("{name:'f'}")});
        t.tags(new Object[]{"[{name:'g'}]"});
        t.tags(new Object[]{"[]"});
        t.tags(new Object[]{null});
        TestUtils.assertObjectEquals("[{name:'a'},{name:'b'},{name:'c'},{name:'d'},{name:'e'},{name:'f'},{name:'g'}]", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        for (Tag tag : t.getTags()) {
            TestUtils.assertInstanceOf(Tag.class, tag);
        }
    }

    @Test
    public void testExternalDocs() {
        Swagger t = new Swagger();
        t.externalDocs((Object)SwaggerBuilder.externalDocumentation((Object)"foo"));
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        t.externalDocs((Object)"{url:'foo'}");
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.getExternalDocs());
        t.externalDocs(null);
        Assert.assertNull((Object)t.getExternalDocs());
    }

    @Test
    public void testSet() throws Exception {
        Swagger t = new Swagger();
        t.set("basePath", (Object)"a").set("consumes", (Object)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/b")})).set("definitions", (Object)new AMap().append((Object)"c", (Object)SwaggerBuilder.schemaInfo().type((Object)"c1"))).set("externalDocs", (Object)SwaggerBuilder.externalDocumentation((Object)"d")).set("host", (Object)"e").set("info", (Object)SwaggerBuilder.info((String)"f1", (String)"f2")).set("parameters", (Object)new AMap().append((Object)"g", (Object)SwaggerBuilder.parameterInfo((String)"g1", (String)"g2"))).set("paths", (Object)new AMap().append((Object)"h", (Object)new AMap().append((Object)"h1", (Object)SwaggerBuilder.operation().operationId((Object)"h2")))).set("produces", (Object)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/i")})).set("responses", (Object)new AMap().append((Object)"j", (Object)SwaggerBuilder.responseInfo((String)"j1"))).set("schemes", (Object)new ASet().appendAll((Object[])new String[]{"k1"})).set("security", (Object)new ASet().append((Object)new AMap().append((Object)"l1", (Object)new AList().append((Object)"l2")))).set("securityDefinitions", (Object)new AMap().append((Object)"m", (Object)SwaggerBuilder.securityScheme((String)"m1"))).set("swagger", (Object)"n").set("tags", (Object)new ASet().appendAll((Object[])new Tag[]{SwaggerBuilder.tag((String)"o")})).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{swagger:'n',info:{title:'f1',version:'f2'},tags:[{name:'o'}],externalDocs:{url:'d'},basePath:'a',schemes:['k1'],consumes:['text/b'],produces:['text/i'],paths:{h:{h1:{operationId:'h2'}}},definitions:{c:{type:'c1'}},parameters:{g:{'in':'g1',name:'g2'}},responses:{j:{description:'j1'}},securityDefinitions:{m:{type:'m1'}},security:[{l1:['l2']}],'$ref':'ref'}", t);
        t.set("basePath", (Object)"a").set("consumes", (Object)"['text/b']").set("definitions", (Object)"{c:{type:'c1'}}").set("externalDocs", (Object)"{url:'d'}").set("host", (Object)"e").set("info", (Object)"{title:'f1',version:'f2'}").set("parameters", (Object)"{g:{'in':'g1',name:'g2'}}").set("paths", (Object)"{h:{h1:{operationId:'h2'}}}").set("produces", (Object)"['text/i']").set("responses", (Object)"{j:{description:'j1'}}").set("schemes", (Object)"['k1']").set("security", (Object)"[{l1:['l2']}]").set("securityDefinitions", (Object)"{m:{type:'m1'}}").set("swagger", (Object)"n").set("tags", (Object)"[{name:'o'}]").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{swagger:'n',info:{title:'f1',version:'f2'},tags:[{name:'o'}],externalDocs:{url:'d'},basePath:'a',schemes:['k1'],consumes:['text/b'],produces:['text/i'],paths:{h:{h1:{operationId:'h2'}}},definitions:{c:{type:'c1'}},parameters:{g:{'in':'g1',name:'g2'}},responses:{j:{description:'j1'}},securityDefinitions:{m:{type:'m1'}},security:[{l1:['l2']}],'$ref':'ref'}", t);
        t.set("basePath", (Object)new StringBuilder("a")).set("consumes", (Object)new StringBuilder("['text/b']")).set("definitions", (Object)new StringBuilder("{c:{type:'c1'}}")).set("externalDocs", (Object)new StringBuilder("{url:'d'}")).set("host", (Object)new StringBuilder("e")).set("info", (Object)new StringBuilder("{title:'f1',version:'f2'}")).set("parameters", (Object)new StringBuilder("{g:{'in':'g1',name:'g2'}}")).set("paths", (Object)new StringBuilder("{h:{h1:{operationId:'h2'}}}")).set("produces", (Object)new StringBuilder("['text/i']")).set("responses", (Object)new StringBuilder("{j:{description:'j1'}}")).set("schemes", (Object)new StringBuilder("['k1']")).set("security", (Object)new StringBuilder("[{l1:['l2']}]")).set("securityDefinitions", (Object)new StringBuilder("{m:{type:'m1'}}")).set("swagger", (Object)new StringBuilder("n")).set("tags", (Object)new StringBuilder("[{name:'o'}]")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{swagger:'n',info:{title:'f1',version:'f2'},tags:[{name:'o'}],externalDocs:{url:'d'},basePath:'a',schemes:['k1'],consumes:['text/b'],produces:['text/i'],paths:{h:{h1:{operationId:'h2'}}},definitions:{c:{type:'c1'}},parameters:{g:{'in':'g1',name:'g2'}},responses:{j:{description:'j1'}},securityDefinitions:{m:{type:'m1'}},security:[{l1:['l2']}],'$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("basePath", String.class));
        Assert.assertEquals((Object)"['text/b']", (Object)t.get("consumes", String.class));
        Assert.assertEquals((Object)"{c:{type:'c1'}}", (Object)t.get("definitions", String.class));
        Assert.assertEquals((Object)"{url:'d'}", (Object)t.get("externalDocs", String.class));
        Assert.assertEquals((Object)"e", (Object)t.get("host", String.class));
        Assert.assertEquals((Object)"{title:'f1',version:'f2'}", (Object)t.get("info", String.class));
        Assert.assertEquals((Object)"{g:{'in':'g1',name:'g2'}}", (Object)t.get("parameters", String.class));
        Assert.assertEquals((Object)"{h:{h1:{operationId:'h2'}}}", (Object)t.get("paths", String.class));
        Assert.assertEquals((Object)"['text/i']", (Object)t.get("produces", String.class));
        Assert.assertEquals((Object)"{j:{description:'j1'}}", (Object)t.get("responses", String.class));
        Assert.assertEquals((Object)"['k1']", (Object)t.get("schemes", String.class));
        Assert.assertEquals((Object)"[{l1:['l2']}]", (Object)t.get("security", String.class));
        Assert.assertEquals((Object)"{m:{type:'m1'}}", (Object)t.get("securityDefinitions", String.class));
        Assert.assertEquals((Object)"n", (Object)t.get("swagger", String.class));
        Assert.assertEquals((Object)"[{name:'o'}]", (Object)t.get("tags", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(String.class, t.get("basePath", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("consumes", Object.class));
        TestUtils.assertInstanceOf(MediaType.class, ((List)t.get("consumes", List.class)).get(0));
        TestUtils.assertInstanceOf(Map.class, t.get("definitions", Object.class));
        TestUtils.assertInstanceOf(ObjectMap.class, ((Map)t.get("definitions", Map.class)).values().iterator().next());
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.get("externalDocs", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("host", Object.class));
        TestUtils.assertInstanceOf(Info.class, t.get("info", Object.class));
        TestUtils.assertInstanceOf(Map.class, t.get("parameters", Object.class));
        TestUtils.assertInstanceOf(ParameterInfo.class, ((Map)t.get("parameters", Map.class)).values().iterator().next());
        TestUtils.assertInstanceOf(Map.class, t.get("paths", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("produces", Object.class));
        TestUtils.assertInstanceOf(MediaType.class, ((List)t.get("consumes", List.class)).get(0));
        TestUtils.assertInstanceOf(Map.class, t.get("responses", Object.class));
        TestUtils.assertInstanceOf(ResponseInfo.class, ((Map)t.get("responses", Map.class)).values().iterator().next());
        TestUtils.assertInstanceOf(List.class, t.get("schemes", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("security", Object.class));
        TestUtils.assertInstanceOf(Map.class, t.get("securityDefinitions", Object.class));
        TestUtils.assertInstanceOf(SecurityScheme.class, ((Map)t.get("securityDefinitions", Map.class)).values().iterator().next());
        TestUtils.assertInstanceOf(String.class, t.get("swagger", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("tags", Object.class));
        TestUtils.assertInstanceOf(Tag.class, ((List)t.get("tags", List.class)).get(0));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{swagger:'n',info:{title:'f1',version:'f2'},tags:[{name:'o'}],externalDocs:{url:'d'},basePath:'a',schemes:['k1'],consumes:['text/b'],produces:['text/i'],paths:{h:{h1:{operationId:'h2'}}},definitions:{c:{type:'c1'}},parameters:{g:{'in':'g1',name:'g2'}},responses:{j:{description:'j1'}},securityDefinitions:{m:{type:'m1'}},security:[{l1:['l2']}],'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, Swagger.class));
    }
}

