/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.SecurityScheme;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.dto.swagger.Xml;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class SwaggerBuilderTest {
    @Test
    public void testContact() {
        Contact t = SwaggerBuilder.contact();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testContactString() {
        Contact t = SwaggerBuilder.contact((String)"foo");
        TestUtils.assertObjectEquals("{name:'foo'}", t);
    }

    @Test
    public void testContactStringObjectString() {
        Contact t = SwaggerBuilder.contact((String)"foo", (Object)"bar", (String)"baz");
        TestUtils.assertObjectEquals("{name:'foo',url:'bar',email:'baz'}", t);
    }

    @Test
    public void testExternalDocumentation() {
        ExternalDocumentation t = SwaggerBuilder.externalDocumentation();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testExternalDocumentationObject() {
        ExternalDocumentation t = SwaggerBuilder.externalDocumentation((Object)"foo");
        TestUtils.assertObjectEquals("{url:'foo'}", t);
    }

    @Test
    public void testExternalDocumentationObjectString() {
        ExternalDocumentation t = SwaggerBuilder.externalDocumentation((Object)"foo", (String)"bar");
        TestUtils.assertObjectEquals("{description:'bar',url:'foo'}", t);
    }

    @Test
    public void testHeaderInfo() {
        HeaderInfo t = SwaggerBuilder.headerInfo();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testHeaderInfoString() {
        HeaderInfo t = SwaggerBuilder.headerInfo((String)"foo");
        TestUtils.assertObjectEquals("{type:'foo'}", t);
    }

    @Test
    public void testHeaderInfoStrict() {
        HeaderInfo t = SwaggerBuilder.headerInfoStrict((String)"string");
        TestUtils.assertObjectEquals("{type:'string'}", t);
        try {
            SwaggerBuilder.headerInfoStrict((String)"foo");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid value passed in to setType(String).  Value='foo', valid values=['string','number','integer','boolean','array']", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testInfo() {
        Info t = SwaggerBuilder.info();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testInfoStringString() {
        Info t = SwaggerBuilder.info((String)"foo", (String)"bar");
        TestUtils.assertObjectEquals("{title:'foo',version:'bar'}", t);
    }

    @Test
    public void testItems() {
        Items t = SwaggerBuilder.items();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testItemsString() {
        Items t = SwaggerBuilder.items((String)"foo");
        TestUtils.assertObjectEquals("{type:'foo'}", t);
    }

    @Test
    public void testItemsStrict() {
        Items t = SwaggerBuilder.itemsStrict((String)"string");
        TestUtils.assertObjectEquals("{type:'string'}", t);
        try {
            SwaggerBuilder.itemsStrict((String)"foo");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid value passed in to setType(String).  Value='foo', valid values=['string','number','integer','boolean','array']", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testLicense() {
        License t = SwaggerBuilder.license();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testLicenseString() {
        License t = SwaggerBuilder.license((String)"foo");
        TestUtils.assertObjectEquals("{name:'foo'}", t);
    }

    @Test
    public void testOperation() {
        Operation t = SwaggerBuilder.operation();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testParameterInfo() {
        ParameterInfo t = SwaggerBuilder.parameterInfo();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testParameterInfoStringString() {
        ParameterInfo t = SwaggerBuilder.parameterInfo((String)"foo", (String)"bar");
        TestUtils.assertObjectEquals("{'in':'foo',name:'bar'}", t);
    }

    @Test
    public void testParameterInfoStrict() {
        ParameterInfo t = SwaggerBuilder.parameterInfoStrict((String)"query", (String)"bar");
        TestUtils.assertObjectEquals("{'in':'query',name:'bar'}", t);
        try {
            SwaggerBuilder.parameterInfoStrict((String)"foo", (String)"bar");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid value passed in to setIn(String).  Value='foo', valid values=['query','header','path','formData','body']", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testResponseInfo() {
        ResponseInfo t = SwaggerBuilder.responseInfo();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testResponseInfoString() {
        ResponseInfo t = SwaggerBuilder.responseInfo((String)"foo");
        TestUtils.assertObjectEquals("{description:'foo'}", t);
    }

    @Test
    public void testSchemaInfo() {
        SchemaInfo t = SwaggerBuilder.schemaInfo();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testSecurityScheme() {
        SecurityScheme t = SwaggerBuilder.securityScheme();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testSecuritySchemeString() {
        SecurityScheme t = SwaggerBuilder.securityScheme((String)"foo");
        TestUtils.assertObjectEquals("{type:'foo'}", t);
    }

    @Test
    public void testSecuritySchemeStrict() {
        SecurityScheme t = SwaggerBuilder.securityScheme((String)"foo");
        TestUtils.assertObjectEquals("{type:'foo'}", t);
    }

    @Test
    public void testSwagger() {
        Swagger t = SwaggerBuilder.swagger();
        TestUtils.assertObjectEquals("{swagger:'2.0'}", t);
    }

    @Test
    public void testSwaggerInfo() {
        Swagger t = SwaggerBuilder.swagger((Info)SwaggerBuilder.info());
        TestUtils.assertObjectEquals("{swagger:'2.0',info:{}}", t);
    }

    @Test
    public void testTag() {
        Tag t = SwaggerBuilder.tag();
        TestUtils.assertObjectEquals("{}", t);
    }

    @Test
    public void testTagString() {
        Tag t = SwaggerBuilder.tag((String)"foo");
        TestUtils.assertObjectEquals("{name:'foo'}", t);
    }

    @Test
    public void testXml() {
        Xml t = SwaggerBuilder.xml();
        TestUtils.assertObjectEquals("{}", t);
    }
}

