/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Map;
import org.apache.juneau.dto.swagger.SecurityScheme;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class SecuritySchemeTest {
    @Test
    public void testType() {
        SecurityScheme t = new SecurityScheme();
        t.type((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        t.type((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        TestUtils.assertInstanceOf(String.class, t.getType());
        t.type(null);
        Assert.assertNull((Object)t.getType());
    }

    @Test
    public void testDescription() {
        SecurityScheme t = new SecurityScheme();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testName() {
        SecurityScheme t = new SecurityScheme();
        t.name((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        t.name((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        TestUtils.assertInstanceOf(String.class, t.getName());
        t.name(null);
        Assert.assertNull((Object)t.getName());
    }

    @Test
    public void testIn() {
        SecurityScheme t = new SecurityScheme();
        t.in((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getIn());
        t.in((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getIn());
        TestUtils.assertInstanceOf(String.class, t.getIn());
        t.in(null);
        Assert.assertNull((Object)t.getIn());
    }

    @Test
    public void testFlow() {
        SecurityScheme t = new SecurityScheme();
        t.flow((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getFlow());
        t.flow((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getFlow());
        TestUtils.assertInstanceOf(String.class, t.getFlow());
        t.flow(null);
        Assert.assertNull((Object)t.getFlow());
    }

    @Test
    public void testAuthorizationUrl() {
        SecurityScheme t = new SecurityScheme();
        t.authorizationUrl((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getAuthorizationUrl());
        t.authorizationUrl((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getAuthorizationUrl());
        TestUtils.assertInstanceOf(String.class, t.getAuthorizationUrl());
        t.authorizationUrl(null);
        Assert.assertNull((Object)t.getAuthorizationUrl());
    }

    @Test
    public void testTokenUrl() {
        SecurityScheme t = new SecurityScheme();
        t.tokenUrl((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getTokenUrl());
        t.tokenUrl((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getTokenUrl());
        TestUtils.assertInstanceOf(String.class, t.getTokenUrl());
        t.tokenUrl(null);
        Assert.assertNull((Object)t.getTokenUrl());
    }

    @Test
    public void testSetScopes() {
        SecurityScheme t = new SecurityScheme();
        t.setScopes((Map)new AMap().append((Object)"foo", (Object)"bar"));
        TestUtils.assertObjectEquals("{foo:'bar'}", t.getScopes());
        TestUtils.assertInstanceOf(Map.class, t.getScopes());
        t.setScopes((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getScopes());
        TestUtils.assertInstanceOf(Map.class, t.getScopes());
        t.setScopes(null);
        Assert.assertNull((Object)t.getScopes());
    }

    @Test
    public void testAddScopes() {
        SecurityScheme t = new SecurityScheme();
        t.addScopes((Map)new AMap().append((Object)"foo", (Object)"bar"));
        TestUtils.assertObjectEquals("{foo:'bar'}", t.getScopes());
        TestUtils.assertInstanceOf(Map.class, t.getScopes());
        t.addScopes((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:'bar'}", t.getScopes());
        TestUtils.assertInstanceOf(Map.class, t.getScopes());
        t.addScopes(null);
        TestUtils.assertObjectEquals("{foo:'bar'}", t.getScopes());
        TestUtils.assertInstanceOf(Map.class, t.getScopes());
    }

    @Test
    public void testScopes() {
        SecurityScheme t = new SecurityScheme();
        t.scopes(new Object[]{new AMap().append((Object)"a", (Object)"a1")});
        t.scopes(new Object[]{"{b:'b1'}"});
        t.scopes(new Object[]{"{}"});
        t.scopes((Object[])null);
        TestUtils.assertObjectEquals("{a:'a1',b:'b1'}", t.getScopes());
    }

    @Test
    public void testSet() throws Exception {
        SecurityScheme t = new SecurityScheme();
        t.set("authorizationUrl", (Object)"a").set("description", (Object)"b").set("flow", (Object)"c").set("in", (Object)"d").set("name", (Object)"e").set("scopes", (Object)new AMap().append((Object)"foo", (Object)"bar")).set("tokenUrl", (Object)"f").set("type", (Object)"g").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{type:'g',description:'b',name:'e','in':'d',flow:'c',authorizationUrl:'a',tokenUrl:'f',scopes:{foo:'bar'},'$ref':'ref'}", t);
        t.set("authorizationUrl", (Object)"a").set("description", (Object)"b").set("flow", (Object)"c").set("in", (Object)"d").set("name", (Object)"e").set("scopes", (Object)"{foo:'bar'}").set("tokenUrl", (Object)"f").set("type", (Object)"g").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{type:'g',description:'b',name:'e','in':'d',flow:'c',authorizationUrl:'a',tokenUrl:'f',scopes:{foo:'bar'},'$ref':'ref'}", t);
        t.set("authorizationUrl", (Object)new StringBuilder("a")).set("description", (Object)new StringBuilder("b")).set("flow", (Object)new StringBuilder("c")).set("in", (Object)new StringBuilder("d")).set("name", (Object)new StringBuilder("e")).set("scopes", (Object)new StringBuilder("{foo:'bar'}")).set("tokenUrl", (Object)new StringBuilder("f")).set("type", (Object)new StringBuilder("g")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{type:'g',description:'b',name:'e','in':'d',flow:'c',authorizationUrl:'a',tokenUrl:'f',scopes:{foo:'bar'},'$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("authorizationUrl", String.class));
        Assert.assertEquals((Object)"b", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"c", (Object)t.get("flow", String.class));
        Assert.assertEquals((Object)"d", (Object)t.get("in", String.class));
        Assert.assertEquals((Object)"e", (Object)t.get("name", String.class));
        Assert.assertEquals((Object)"{foo:'bar'}", (Object)t.get("scopes", String.class));
        Assert.assertEquals((Object)"f", (Object)t.get("tokenUrl", String.class));
        Assert.assertEquals((Object)"g", (Object)t.get("type", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(String.class, t.get("authorizationUrl", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("flow", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("in", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("name", Object.class));
        TestUtils.assertInstanceOf(Map.class, t.get("scopes", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("tokenUrl", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("type", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{type:'g',description:'b',name:'e','in':'d',flow:'c',authorizationUrl:'a',tokenUrl:'f',scopes:{foo:'bar'},'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, SecurityScheme.class));
    }
}

