/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.dto.swagger.Xml;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class SchemaInfoTest {
    @Test
    public void testFormat() {
        SchemaInfo t = new SchemaInfo();
        t.format((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getFormat());
        t.format((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getFormat());
        TestUtils.assertInstanceOf(String.class, t.getFormat());
        t.format(null);
        Assert.assertNull((Object)t.getFormat());
    }

    @Test
    public void testTitle() {
        SchemaInfo t = new SchemaInfo();
        t.title((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getTitle());
        t.title((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getTitle());
        TestUtils.assertInstanceOf(String.class, t.getTitle());
        t.title(null);
        Assert.assertNull((Object)t.getTitle());
    }

    @Test
    public void testDescription() {
        SchemaInfo t = new SchemaInfo();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void test_default() {
        SchemaInfo t = new SchemaInfo();
        t._default((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDefault());
        t._default((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDefault().toString());
        TestUtils.assertInstanceOf(StringBuilder.class, t.getDefault());
        t._default(null);
        Assert.assertNull((Object)t.getDefault());
    }

    @Test
    public void testMultipleOf() {
        SchemaInfo t = new SchemaInfo();
        t.multipleOf((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Float.class, t.getMultipleOf());
        t.multipleOf((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf(null);
        Assert.assertNull((Object)t.getMultipleOf());
    }

    @Test
    public void testMaximum() {
        SchemaInfo t = new SchemaInfo();
        t.maximum((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Float.class, t.getMaximum());
        t.maximum((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum(null);
        Assert.assertNull((Object)t.getMaximum());
    }

    @Test
    public void testExclusiveMaximum() {
        SchemaInfo t = new SchemaInfo();
        t.exclusiveMaximum((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum(null);
        Assert.assertNull((Object)t.getExclusiveMaximum());
    }

    @Test
    public void testMinimum() {
        SchemaInfo t = new SchemaInfo();
        t.minimum((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Float.class, t.getMinimum());
        t.minimum((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum(null);
        Assert.assertNull((Object)t.getMinimum());
    }

    @Test
    public void testExclusiveMinimum() {
        SchemaInfo t = new SchemaInfo();
        t.exclusiveMinimum((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum(null);
        Assert.assertNull((Object)t.getExclusiveMinimum());
    }

    @Test
    public void testMaxLength() {
        SchemaInfo t = new SchemaInfo();
        t.maxLength((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength(null);
        Assert.assertNull((Object)t.getMaxLength());
    }

    @Test
    public void testMinLength() {
        SchemaInfo t = new SchemaInfo();
        t.minLength((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength(null);
        Assert.assertNull((Object)t.getMinLength());
    }

    @Test
    public void testPattern() {
        SchemaInfo t = new SchemaInfo();
        t.pattern((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getPattern());
        t.pattern((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getPattern());
        TestUtils.assertInstanceOf(String.class, t.getPattern());
        t.pattern(null);
        Assert.assertNull((Object)t.getPattern());
    }

    @Test
    public void testMaxItems() {
        SchemaInfo t = new SchemaInfo();
        t.maxItems((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems(null);
        Assert.assertNull((Object)t.getMaxItems());
    }

    @Test
    public void testMinItems() {
        SchemaInfo t = new SchemaInfo();
        t.minItems((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems(null);
        Assert.assertNull((Object)t.getMinItems());
    }

    @Test
    public void testUniqueItems() {
        SchemaInfo t = new SchemaInfo();
        t.uniqueItems((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems(null);
        Assert.assertNull((Object)t.getUniqueItems());
    }

    @Test
    public void testMaxProperties() {
        SchemaInfo t = new SchemaInfo();
        t.maxProperties((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMaxProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxProperties());
        t.maxProperties((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMaxProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxProperties());
        t.maxProperties((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMaxProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxProperties());
        t.maxProperties((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMaxProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxProperties());
        t.maxProperties(null);
        Assert.assertNull((Object)t.getMaxProperties());
    }

    @Test
    public void testMinProperties() {
        SchemaInfo t = new SchemaInfo();
        t.minProperties((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMinProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinProperties());
        t.minProperties((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMinProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinProperties());
        t.minProperties((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMinProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinProperties());
        t.minProperties((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMinProperties().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinProperties());
        t.minProperties(null);
        Assert.assertNull((Object)t.getMinProperties());
    }

    @Test
    public void testRequired() {
        SchemaInfo t = new SchemaInfo();
        t.required(new Object[]{"['x']"});
        Assert.assertEquals((Object)"[x]", (Object)t.getRequired().toString());
        TestUtils.assertInstanceOf(List.class, t.getRequired());
        t.required(new Object[]{"['x']"});
        Assert.assertEquals((Object)"[x, x]", (Object)t.getRequired().toString());
        TestUtils.assertInstanceOf(List.class, t.getRequired());
        t.required(new Object[]{new StringBuilder("['x']")});
        Assert.assertEquals((Object)"[x, x, x]", (Object)t.getRequired().toString());
        TestUtils.assertInstanceOf(List.class, t.getRequired());
        t.setRequired(null);
        Assert.assertNull((Object)t.getRequired());
    }

    @Test
    public void testSetEnum() {
        SchemaInfo t = new SchemaInfo();
        t.setEnum((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum(null);
        Assert.assertNull((Object)t.getEnum());
    }

    @Test
    public void testAddEnum() {
        SchemaInfo t = new SchemaInfo();
        t.addEnum((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.addEnum((Collection)new ASet().appendAll(new Object[]{"baz"}));
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.addEnum(null);
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
    }

    @Test
    public void test_enum() {
        SchemaInfo t = new SchemaInfo();
        t._enum(new Object[]{new ASet().appendAll(new Object[]{"foo", "bar"})});
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t._enum(new Object[]{new ASet().appendAll(new Object[]{"baz"})});
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t._enum((Object[])null);
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum(null);
        t._enum(new Object[]{"foo"})._enum(new Object[]{new StringBuilder("bar")})._enum(new Object[]{"['baz','qux']"})._enum(new Object[]{new String[]{"quux"}});
        TestUtils.assertObjectEquals("['foo','bar','baz','qux','quux']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
    }

    @Test
    public void testType() {
        SchemaInfo t = new SchemaInfo();
        t.type((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        t.type((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        TestUtils.assertInstanceOf(String.class, t.getType());
        t.type(null);
        Assert.assertNull((Object)t.getType());
    }

    @Test
    public void testItems() {
        SchemaInfo t = new SchemaInfo();
        t.items((Object)SwaggerBuilder.items((String)"foo"));
        TestUtils.assertObjectEquals("{type:'foo'}", t.getItems());
        t.items((Object)"{type:'foo'}");
        TestUtils.assertObjectEquals("{type:'foo'}", t.getItems());
        TestUtils.assertInstanceOf(Items.class, t.getItems());
        t.items(null);
        Assert.assertNull((Object)t.getItems());
    }

    @Test
    public void testSetAllOf() {
        SchemaInfo t = new SchemaInfo();
        t.setAllOf((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getAllOf());
        TestUtils.assertInstanceOf(List.class, t.getAllOf());
        t.setAllOf((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getAllOf());
        TestUtils.assertInstanceOf(List.class, t.getAllOf());
        t.setAllOf(null);
        Assert.assertNull((Object)t.getAllOf());
    }

    @Test
    public void testAddAllOf() {
        SchemaInfo t = new SchemaInfo();
        t.addAllOf((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getAllOf());
        TestUtils.assertInstanceOf(List.class, t.getAllOf());
        t.addAllOf((Collection)new ASet());
        TestUtils.assertObjectEquals("['foo','bar']", t.getAllOf());
        TestUtils.assertInstanceOf(List.class, t.getAllOf());
        t.addAllOf(null);
        TestUtils.assertObjectEquals("['foo','bar']", t.getAllOf());
        TestUtils.assertInstanceOf(List.class, t.getAllOf());
    }

    @Test
    public void testAllOf() {
        SchemaInfo t = new SchemaInfo();
        t.allOf(new Object[]{new ASet().appendAll((Object[])new String[]{"a"})});
        t.allOf(new Object[]{new ASet().appendAll(new Object[]{new StringBuilder("b")})});
        t.allOf(new Object[]{new String[]{"c"}});
        t.allOf(new Object[]{new Object[]{new StringBuilder("d")}});
        t.allOf(new Object[]{"e"});
        t.allOf(new Object[]{"['f']"});
        t.allOf(new Object[]{"[]"});
        t.allOf(new Object[]{null});
        TestUtils.assertObjectEquals("['a','b','c','d','e','f']", t.getAllOf());
    }

    @Test
    public void testSetProperties() {
        SchemaInfo t = new SchemaInfo();
        t.setProperties((Map)new AMap().append((Object)"foo", (Object)new SchemaInfo().type((Object)"foo")));
        TestUtils.assertObjectEquals("{foo:{type:'foo'}}", t.getProperties());
        TestUtils.assertInstanceOf(Map.class, t.getProperties());
        t.setProperties((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getProperties());
        TestUtils.assertInstanceOf(Map.class, t.getProperties());
        t.setProperties(null);
        Assert.assertNull((Object)t.getProperties());
    }

    @Test
    public void testAddProperties() {
        SchemaInfo t = new SchemaInfo();
        t.addProperties((Map)new AMap().append((Object)"foo", (Object)new SchemaInfo().type((Object)"foo")));
        TestUtils.assertObjectEquals("{foo:{type:'foo'}}", t.getProperties());
        TestUtils.assertInstanceOf(Map.class, t.getProperties());
        t.addProperties((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:{type:'foo'}}", t.getProperties());
        TestUtils.assertInstanceOf(Map.class, t.getProperties());
        t.addProperties(null);
        TestUtils.assertObjectEquals("{foo:{type:'foo'}}", t.getProperties());
        TestUtils.assertInstanceOf(Map.class, t.getProperties());
    }

    @Test
    public void testProperties() {
        SchemaInfo t = new SchemaInfo();
        t.properties(new Object[]{new AMap().append((Object)"a", (Object)new AMap().append((Object)"type", (Object)"foo"))});
        t.properties(new Object[]{new AMap().append((Object)"b", (Object)"{type:'bar'}")});
        t.properties(new Object[]{"{c:{type:'baz'}}"});
        t.properties(new Object[]{"{}"});
        t.properties((Object[])null);
        TestUtils.assertObjectEquals("{a:{type:'foo'},b:{type:'bar'},c:{type:'baz'}}", t.getProperties());
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getProperties().get("a"));
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getProperties().get("b"));
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getProperties().get("c"));
    }

    @Test
    public void testSetAdditionalProperties() {
        SchemaInfo t = new SchemaInfo();
        t.setAdditionalProperties(new SchemaInfo().type((Object)"foo"));
        TestUtils.assertObjectEquals("{type:'foo'}", t.getAdditionalProperties());
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getAdditionalProperties());
        t.setAdditionalProperties(new SchemaInfo());
        TestUtils.assertObjectEquals("{}", t.getAdditionalProperties());
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getAdditionalProperties());
        t.setAdditionalProperties((SchemaInfo)null);
        Assert.assertNull((Object)t.getAdditionalProperties());
    }

    @Test
    public void testAdditionalProperties() {
        SchemaInfo t = new SchemaInfo();
        t.additionalProperties((Object)new AMap().append((Object)"type", (Object)"foo"));
        TestUtils.assertObjectEquals("{type:'foo'}", t.getAdditionalProperties());
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getAdditionalProperties());
    }

    @Test
    public void testDiscriminator() {
        SchemaInfo t = new SchemaInfo();
        t.discriminator((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDiscriminator());
        t.discriminator((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDiscriminator());
        TestUtils.assertInstanceOf(String.class, t.getDiscriminator());
        t.discriminator(null);
        Assert.assertNull((Object)t.getDiscriminator());
    }

    @Test
    public void testReadOnly() {
        SchemaInfo t = new SchemaInfo();
        t.readOnly((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getReadOnly());
        TestUtils.assertInstanceOf(Boolean.class, t.getReadOnly());
        t.readOnly((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getReadOnly());
        TestUtils.assertInstanceOf(Boolean.class, t.getReadOnly());
        t.readOnly((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getReadOnly());
        TestUtils.assertInstanceOf(Boolean.class, t.getReadOnly());
        t.readOnly(null);
        Assert.assertNull((Object)t.getReadOnly());
    }

    @Test
    public void testXml() {
        SchemaInfo t = new SchemaInfo();
        t.xml((Object)SwaggerBuilder.xml().name((Object)"foo"));
        TestUtils.assertObjectEquals("{name:'foo'}", t.getXml());
        t.xml((Object)"{name:'foo'}");
        TestUtils.assertObjectEquals("{name:'foo'}", t.getXml());
        TestUtils.assertInstanceOf(Xml.class, t.getXml());
        t.xml(null);
        Assert.assertNull((Object)t.getXml());
    }

    @Test
    public void testExternalDocs() {
        SchemaInfo t = new SchemaInfo();
        t.externalDocs((Object)SwaggerBuilder.externalDocumentation((Object)"foo"));
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        t.externalDocs((Object)"{url:'foo'}");
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.getExternalDocs());
        t.externalDocs(null);
        Assert.assertNull((Object)t.getExternalDocs());
    }

    @Test
    public void testExample() {
        SchemaInfo t = new SchemaInfo();
        t.example((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getExample());
        t.example((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getExample());
        t.example(null);
        Assert.assertNull((Object)t.getExample());
    }

    @Test
    public void testSet() throws Exception {
        SchemaInfo t = new SchemaInfo();
        t.set("default", (Object)"a").set("enum", (Object)new ASet().appendAll(new Object[]{"b"})).set("additionalProperties", (Object)new AMap().append((Object)"c", (Object)new AList().append((Object)"c1"))).set("allOf", (Object)new ASet().appendAll((Object[])new String[]{"d"})).set("description", (Object)"e").set("discriminator", (Object)"f").set("example", (Object)"g").set("exclusiveMaximum", (Object)true).set("exclusiveMinimum", (Object)true).set("externalDocs", (Object)SwaggerBuilder.externalDocumentation((Object)"h")).set("format", (Object)"i").set("items", (Object)SwaggerBuilder.items((String)"j")).set("maximum", (Object)Float.valueOf(123.0f)).set("maxItems", (Object)123).set("maxLength", (Object)123).set("maxProperties", (Object)123).set("minimum", (Object)Float.valueOf(123.0f)).set("minItems", (Object)123).set("minLength", (Object)123).set("minProperties", (Object)123).set("multipleOf", (Object)Float.valueOf(123.0f)).set("pattern", (Object)"k").set("properties", (Object)new AMap().append((Object)"l", (Object)new AMap().append((Object)"l1", (Object)1))).set("readOnly", (Object)true).set("required", (Object)new ASet().appendAll((Object[])new String[]{"x"})).set("title", (Object)"m").set("type", (Object)"n").set("uniqueItems", (Object)true).set("xml", (Object)SwaggerBuilder.xml().name((Object)"o")).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{format:'i',title:'m',description:'e','default':'a',multipleOf:123.0,maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'k',maxItems:123,minItems:123,uniqueItems:true,maxProperties:123,minProperties:123,required:['x'],'enum':['b'],type:'n',items:{type:'j'},allOf:['d'],properties:{l:{l1:1}},additionalProperties:{c:['c1']},discriminator:'f',readOnly:true,xml:{name:'o'},externalDocs:{url:'h'},example:'g','$ref':'ref'}", t);
        t.set("default", (Object)"a").set("enum", (Object)"['b']").set("additionalProperties", (Object)"{c:['c1']}").set("allOf", (Object)"['d']").set("description", (Object)"e").set("discriminator", (Object)"f").set("example", (Object)"g").set("exclusiveMaximum", (Object)"true").set("exclusiveMinimum", (Object)"true").set("externalDocs", (Object)"{url:'h'}").set("format", (Object)"i").set("items", (Object)"{type:'j'}").set("maximum", (Object)"123.0").set("maxItems", (Object)"123").set("maxLength", (Object)"123").set("maxProperties", (Object)"123").set("minimum", (Object)"123.0").set("minItems", (Object)"123").set("minLength", (Object)"123").set("minProperties", (Object)"123").set("multipleOf", (Object)"123.0").set("pattern", (Object)"k").set("properties", (Object)"{l:{l1:1}}").set("readOnly", (Object)"true").set("required", (Object)"['x']").set("title", (Object)"m").set("type", (Object)"n").set("uniqueItems", (Object)"true").set("xml", (Object)"{name:'o'}").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{format:'i',title:'m',description:'e','default':'a',multipleOf:123.0,maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'k',maxItems:123,minItems:123,uniqueItems:true,maxProperties:123,minProperties:123,required:['x'],'enum':['b'],type:'n',items:{type:'j'},allOf:['d'],properties:{l:{l1:1}},additionalProperties:{c:['c1']},discriminator:'f',readOnly:true,xml:{name:'o'},externalDocs:{url:'h'},example:'g','$ref':'ref'}", t);
        t.set("default", (Object)new StringBuilder("a")).set("enum", (Object)new StringBuilder("['b']")).set("additionalProperties", (Object)new StringBuilder("{c:['c1']}")).set("allOf", (Object)new StringBuilder("['d']")).set("description", (Object)new StringBuilder("e")).set("discriminator", (Object)new StringBuilder("f")).set("example", (Object)new StringBuilder("g")).set("exclusiveMaximum", (Object)new StringBuilder("true")).set("exclusiveMinimum", (Object)new StringBuilder("true")).set("externalDocs", (Object)new StringBuilder("{url:'h'}")).set("format", (Object)new StringBuilder("i")).set("items", (Object)new StringBuilder("{type:'j'}")).set("maximum", (Object)new StringBuilder("123.0")).set("maxItems", (Object)new StringBuilder("123")).set("maxLength", (Object)new StringBuilder("123")).set("maxProperties", (Object)new StringBuilder("123")).set("minimum", (Object)new StringBuilder("123.0")).set("minItems", (Object)new StringBuilder("123")).set("minLength", (Object)new StringBuilder("123")).set("minProperties", (Object)new StringBuilder("123")).set("multipleOf", (Object)new StringBuilder("123.0")).set("pattern", (Object)new StringBuilder("k")).set("properties", (Object)new StringBuilder("{l:{l1:1}}")).set("readOnly", (Object)new StringBuilder("true")).set("required", (Object)new StringBuilder("['x']")).set("title", (Object)new StringBuilder("m")).set("type", (Object)new StringBuilder("n")).set("uniqueItems", (Object)new StringBuilder("true")).set("xml", (Object)new StringBuilder("{name:'o'}")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{format:'i',title:'m',description:'e','default':'a',multipleOf:123.0,maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'k',maxItems:123,minItems:123,uniqueItems:true,maxProperties:123,minProperties:123,required:['x'],'enum':['b'],type:'n',items:{type:'j'},allOf:['d'],properties:{l:{l1:1}},additionalProperties:{c:['c1']},discriminator:'f',readOnly:true,xml:{name:'o'},externalDocs:{url:'h'},example:'g','$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("default", String.class));
        Assert.assertEquals((Object)"['b']", (Object)t.get("enum", String.class));
        Assert.assertEquals((Object)"{c:['c1']}", (Object)t.get("additionalProperties", String.class));
        Assert.assertEquals((Object)"['d']", (Object)t.get("allOf", String.class));
        Assert.assertEquals((Object)"e", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"f", (Object)t.get("discriminator", String.class));
        Assert.assertEquals((Object)"g", (Object)t.get("example", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("exclusiveMaximum", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("exclusiveMinimum", String.class));
        Assert.assertEquals((Object)"{url:'h'}", (Object)t.get("externalDocs", String.class));
        Assert.assertEquals((Object)"i", (Object)t.get("format", String.class));
        Assert.assertEquals((Object)"{type:'j'}", (Object)t.get("items", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("maximum", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("maxItems", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("maxLength", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("maxProperties", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("minimum", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("minItems", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("minLength", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("minProperties", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("multipleOf", String.class));
        Assert.assertEquals((Object)"k", (Object)t.get("pattern", String.class));
        Assert.assertEquals((Object)"{l:{l1:1}}", (Object)t.get("properties", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("readOnly", String.class));
        Assert.assertEquals((Object)"['x']", (Object)t.get("required", String.class));
        Assert.assertEquals((Object)"m", (Object)t.get("title", String.class));
        Assert.assertEquals((Object)"n", (Object)t.get("type", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("uniqueItems", String.class));
        Assert.assertEquals((Object)"{name:'o'}", (Object)t.get("xml", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("default", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("enum", Object.class));
        TestUtils.assertInstanceOf(SchemaInfo.class, t.get("additionalProperties", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("allOf", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("discriminator", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("example", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("exclusiveMaximum", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("exclusiveMinimum", Object.class));
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.get("externalDocs", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("format", Object.class));
        TestUtils.assertInstanceOf(Items.class, t.get("items", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("maximum", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("maxItems", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("maxLength", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("maxProperties", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("minimum", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("minItems", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("minLength", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("minProperties", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("multipleOf", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("pattern", Object.class));
        TestUtils.assertInstanceOf(Map.class, t.get("properties", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("readOnly", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("required", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("title", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("type", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("uniqueItems", Object.class));
        TestUtils.assertInstanceOf(Xml.class, t.get("xml", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{format:'i',title:'m',description:'e','default':'a',multipleOf:123.0,maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'k',maxItems:123,minItems:123,uniqueItems:true,maxProperties:123,minProperties:123,required:['x'],'enum':['b'],type:'n',items:{type:'j'},allOf:['d'],properties:{l:{l1:1}},additionalProperties:{c:['c1']},discriminator:'f',readOnly:true,xml:{name:'o'},externalDocs:{url:'h'},example:'g','$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, SchemaInfo.class));
    }
}

