/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Map;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class ResponseInfoTest {
    @Test
    public void testDescription() {
        ResponseInfo t = new ResponseInfo();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testSchema() {
        ResponseInfo t = new ResponseInfo();
        t.schema((Object)SwaggerBuilder.schemaInfo().title((Object)"foo"));
        TestUtils.assertObjectEquals("{title:'foo'}", t.getSchema());
        t.schema((Object)"{title:'foo'}");
        TestUtils.assertObjectEquals("{title:'foo'}", t.getSchema());
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getSchema());
        t.schema(null);
        Assert.assertNull((Object)t.getSchema());
    }

    @Test
    public void testSetHeaders() {
        ResponseInfo t = new ResponseInfo();
        t.setHeaders((Map)new AMap().append((Object)"foo", (Object)SwaggerBuilder.headerInfo((String)"bar")));
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getHeaders());
        TestUtils.assertInstanceOf(Map.class, t.getHeaders());
        TestUtils.assertInstanceOf(HeaderInfo.class, t.getHeaders().get("foo"));
        t.setHeaders((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getHeaders());
        TestUtils.assertInstanceOf(Map.class, t.getHeaders());
        t.setHeaders(null);
        Assert.assertNull((Object)t.getExamples());
    }

    @Test
    public void testAddHeaders() {
        ResponseInfo t = new ResponseInfo();
        t.addHeaders((Map)new AMap().append((Object)"foo", (Object)SwaggerBuilder.headerInfo((String)"bar")));
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getHeaders());
        TestUtils.assertInstanceOf(Map.class, t.getHeaders());
        TestUtils.assertInstanceOf(HeaderInfo.class, t.getHeaders().get("foo"));
        t.addHeaders((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getHeaders());
        TestUtils.assertInstanceOf(Map.class, t.getHeaders());
        TestUtils.assertInstanceOf(HeaderInfo.class, t.getHeaders().get("foo"));
        t.addHeaders(null);
        TestUtils.assertObjectEquals("{foo:{type:'bar'}}", t.getHeaders());
        TestUtils.assertInstanceOf(Map.class, t.getHeaders());
        TestUtils.assertInstanceOf(HeaderInfo.class, t.getHeaders().get("foo"));
    }

    @Test
    public void testHeader() {
        ResponseInfo t = new ResponseInfo();
        t.header("a", SwaggerBuilder.headerInfo((String)"a1"));
        t.header("b", null);
        t.header(null, SwaggerBuilder.headerInfo((String)"c1"));
        TestUtils.assertObjectEquals("{a:{type:'a1'},b:null,null:{type:'c1'}}", t.getHeaders());
    }

    @Test
    public void testHeaders() {
        ResponseInfo t = new ResponseInfo();
        t.headers(new Object[]{new AMap().append((Object)"a", (Object)SwaggerBuilder.headerInfo((String)"a1"))});
        t.headers(new Object[]{new AMap().append((Object)"b", (Object)"{type:'b1'}")});
        t.headers(new Object[]{"{c:{type:'c1'}}"});
        t.headers(new Object[]{"{}"});
        t.headers((Object[])null);
        TestUtils.assertObjectEquals("{a:{type:'a1'},b:{type:'b1'},c:{type:'c1'}}", t.getHeaders());
    }

    @Test
    public void testSetExamples() {
        ResponseInfo t = new ResponseInfo();
        t.setExamples((Map)new AMap().append((Object)"foo", (Object)"bar").append((Object)"baz", (Object)new AList().append((Object)"qux")));
        TestUtils.assertObjectEquals("{foo:'bar',baz:['qux']}", t.getExamples());
        TestUtils.assertInstanceOf(Map.class, t.getExamples());
        t.setExamples((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getExamples());
        TestUtils.assertInstanceOf(Map.class, t.getExamples());
        t.setExamples(null);
        Assert.assertNull((Object)t.getExamples());
    }

    @Test
    public void testAddExamples() {
        ResponseInfo t = new ResponseInfo();
        t.addExamples((Map)new AMap().append((Object)"foo", (Object)"bar").append((Object)"baz", (Object)new AList().append((Object)"qux")));
        TestUtils.assertObjectEquals("{foo:'bar',baz:['qux']}", t.getExamples());
        TestUtils.assertInstanceOf(Map.class, t.getExamples());
        t.addExamples((Map)new AMap());
        TestUtils.assertObjectEquals("{foo:'bar',baz:['qux']}", t.getExamples());
        TestUtils.assertInstanceOf(Map.class, t.getExamples());
        t.addExamples(null);
        TestUtils.assertObjectEquals("{foo:'bar',baz:['qux']}", t.getExamples());
        TestUtils.assertInstanceOf(Map.class, t.getExamples());
    }

    @Test
    public void testExample() {
        ResponseInfo t = new ResponseInfo();
        t.example("text/a", (Object)"a");
        t.example("text/b", null);
        t.example(null, (Object)"c");
        TestUtils.assertObjectEquals("{'text/a':'a','text/b':null,null:'c'}", t.getExamples());
    }

    @Test
    public void testExamples() {
        ResponseInfo t = new ResponseInfo();
        t.examples(new Object[]{new AMap().append((Object)"1", (Object)new AList().append((Object)"a"))});
        t.examples(new Object[]{"{2:{c1:'c2'}}"});
        t.examples(new Object[]{"{}"});
        t.examples(new Object[]{null});
        TestUtils.assertObjectEquals("{'1':['a'],'2':{c1:'c2'}}", t.getExamples());
    }

    @Test
    public void testSet() throws Exception {
        ResponseInfo t = new ResponseInfo();
        t.set("description", (Object)"a").set("examples", (Object)new AMap().append((Object)"foo", (Object)"bar").append((Object)"baz", (Object)new AList().append((Object)"qux"))).set("headers", (Object)new AMap().append((Object)"a", (Object)SwaggerBuilder.headerInfo((String)"a1"))).set("schema", (Object)SwaggerBuilder.schemaInfo().type((Object)"d")).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{description:'a',schema:{type:'d'},headers:{a:{type:'a1'}},examples:{foo:'bar',baz:['qux']},'$ref':'ref'}", t);
        t.set("description", (Object)"a").set("examples", (Object)"{foo:'bar',baz:['qux']}").set("headers", (Object)"{a:{type:'a1'}}").set("schema", (Object)"{type:'d'}").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{description:'a',schema:{type:'d'},headers:{a:{type:'a1'}},examples:{foo:'bar',baz:['qux']},'$ref':'ref'}", t);
        t.set("description", (Object)new StringBuilder("a")).set("examples", (Object)new StringBuilder("{foo:'bar',baz:['qux']}")).set("headers", (Object)new StringBuilder("{a:{type:'a1'}}")).set("schema", (Object)new StringBuilder("{type:'d'}")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{description:'a',schema:{type:'d'},headers:{a:{type:'a1'}},examples:{foo:'bar',baz:['qux']},'$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"{foo:'bar',baz:['qux']}", (Object)t.get("examples", String.class));
        Assert.assertEquals((Object)"{a:{type:'a1'}}", (Object)t.get("headers", String.class));
        Assert.assertEquals((Object)"{type:'d'}", (Object)t.get("schema", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(Map.class, t.get("examples", Object.class));
        TestUtils.assertInstanceOf(Map.class, t.get("headers", Object.class));
        TestUtils.assertInstanceOf(HeaderInfo.class, ((Map)t.get("headers", Map.class)).values().iterator().next());
        TestUtils.assertInstanceOf(SchemaInfo.class, t.get("schema", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{description:'a',schema:{type:'d'},headers:{a:{type:'a1'}},examples:{foo:'bar',baz:['qux']},'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, ResponseInfo.class));
    }
}

