/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Collection;
import java.util.List;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class ParameterInfoTest {
    @Test
    public void testName() {
        ParameterInfo t = new ParameterInfo();
        t.name((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        t.name((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        TestUtils.assertInstanceOf(String.class, t.getName());
        t.name(null);
        Assert.assertNull((Object)t.getName());
    }

    @Test
    public void testIn() {
        ParameterInfo t = new ParameterInfo();
        t.in((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getIn());
        t.in((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getIn());
        TestUtils.assertInstanceOf(String.class, t.getIn());
        t.in(null);
        Assert.assertNull((Object)t.getIn());
    }

    @Test
    public void testDescription() {
        ParameterInfo t = new ParameterInfo();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testRequired() {
        ParameterInfo t = new ParameterInfo();
        t.required((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getRequired());
        TestUtils.assertInstanceOf(Boolean.class, t.getRequired());
        t.required((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getRequired());
        TestUtils.assertInstanceOf(Boolean.class, t.getRequired());
        t.required((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getRequired());
        TestUtils.assertInstanceOf(Boolean.class, t.getRequired());
        t.required(null);
        Assert.assertNull((Object)t.getRequired());
    }

    @Test
    public void testSchema() {
        ParameterInfo t = new ParameterInfo();
        t.schema((Object)SwaggerBuilder.schemaInfo().title((Object)"foo"));
        TestUtils.assertObjectEquals("{title:'foo'}", t.getSchema());
        t.schema((Object)"{title:'foo'}");
        TestUtils.assertObjectEquals("{title:'foo'}", t.getSchema());
        TestUtils.assertInstanceOf(SchemaInfo.class, t.getSchema());
        t.schema(null);
        Assert.assertNull((Object)t.getSchema());
    }

    @Test
    public void testType() {
        ParameterInfo t = new ParameterInfo();
        t.type((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        t.type((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        TestUtils.assertInstanceOf(String.class, t.getType());
        t.type(null);
        Assert.assertNull((Object)t.getType());
    }

    @Test
    public void testFormat() {
        ParameterInfo t = new ParameterInfo();
        t.format((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getFormat());
        t.format((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getFormat());
        TestUtils.assertInstanceOf(String.class, t.getFormat());
        t.format(null);
        Assert.assertNull((Object)t.getFormat());
    }

    @Test
    public void testAllowEmptyValue() {
        ParameterInfo t = new ParameterInfo();
        t.allowEmptyValue((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getAllowEmptyValue());
        TestUtils.assertInstanceOf(Boolean.class, t.getAllowEmptyValue());
        t.allowEmptyValue((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getAllowEmptyValue());
        TestUtils.assertInstanceOf(Boolean.class, t.getAllowEmptyValue());
        t.allowEmptyValue((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getAllowEmptyValue());
        TestUtils.assertInstanceOf(Boolean.class, t.getAllowEmptyValue());
        t.allowEmptyValue(null);
        Assert.assertNull((Object)t.getAllowEmptyValue());
    }

    @Test
    public void testItems() {
        ParameterInfo t = new ParameterInfo();
        t.items((Object)SwaggerBuilder.items((String)"foo"));
        TestUtils.assertObjectEquals("{type:'foo'}", t.getItems());
        t.items((Object)"{type:'foo'}");
        TestUtils.assertObjectEquals("{type:'foo'}", t.getItems());
        TestUtils.assertInstanceOf(Items.class, t.getItems());
        t.items(null);
        Assert.assertNull((Object)t.getItems());
    }

    @Test
    public void testCollectionFormat() {
        ParameterInfo t = new ParameterInfo();
        t.collectionFormat((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getCollectionFormat());
        t.collectionFormat((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getCollectionFormat());
        TestUtils.assertInstanceOf(String.class, t.getCollectionFormat());
        t.collectionFormat(null);
        Assert.assertNull((Object)t.getCollectionFormat());
    }

    @Test
    public void test_default() {
        ParameterInfo t = new ParameterInfo();
        t._default((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDefault());
        t._default((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDefault().toString());
        TestUtils.assertInstanceOf(StringBuilder.class, t.getDefault());
        t._default(null);
        Assert.assertNull((Object)t.getDefault());
    }

    @Test
    public void testMaximum() {
        ParameterInfo t = new ParameterInfo();
        t.maximum((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Float.class, t.getMaximum());
        t.maximum((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum(null);
        Assert.assertNull((Object)t.getMaximum());
    }

    @Test
    public void testExclusiveMaximum() {
        ParameterInfo t = new ParameterInfo();
        t.exclusiveMaximum((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum(null);
        Assert.assertNull((Object)t.getExclusiveMaximum());
    }

    @Test
    public void testMinimum() {
        ParameterInfo t = new ParameterInfo();
        t.minimum((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Float.class, t.getMinimum());
        t.minimum((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum(null);
        Assert.assertNull((Object)t.getMinimum());
    }

    @Test
    public void testExclusiveMinimum() {
        ParameterInfo t = new ParameterInfo();
        t.exclusiveMinimum((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum(null);
        Assert.assertNull((Object)t.getExclusiveMinimum());
    }

    @Test
    public void testMaxLength() {
        ParameterInfo t = new ParameterInfo();
        t.maxLength((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength(null);
        Assert.assertNull((Object)t.getMaxLength());
    }

    @Test
    public void testMinLength() {
        ParameterInfo t = new ParameterInfo();
        t.minLength((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength(null);
        Assert.assertNull((Object)t.getMinLength());
    }

    @Test
    public void testPattern() {
        ParameterInfo t = new ParameterInfo();
        t.pattern((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getPattern());
        t.pattern((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getPattern());
        TestUtils.assertInstanceOf(String.class, t.getPattern());
        t.pattern(null);
        Assert.assertNull((Object)t.getPattern());
    }

    @Test
    public void testMaxItems() {
        ParameterInfo t = new ParameterInfo();
        t.maxItems((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems(null);
        Assert.assertNull((Object)t.getMaxItems());
    }

    @Test
    public void testMinItems() {
        ParameterInfo t = new ParameterInfo();
        t.minItems((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems(null);
        Assert.assertNull((Object)t.getMinItems());
    }

    @Test
    public void testUniqueItems() {
        ParameterInfo t = new ParameterInfo();
        t.uniqueItems((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems(null);
        Assert.assertNull((Object)t.getUniqueItems());
    }

    @Test
    public void testSetEnum() {
        ParameterInfo t = new ParameterInfo();
        t.setEnum((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum(null);
        Assert.assertNull((Object)t.getEnum());
    }

    @Test
    public void testAddEnum() {
        ParameterInfo t = new ParameterInfo();
        t.addEnum((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.addEnum((Collection)new ASet().appendAll(new Object[]{"baz"}));
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.addEnum(null);
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
    }

    @Test
    public void test_enum() {
        ParameterInfo t = new ParameterInfo();
        t._enum(new Object[]{new ASet().appendAll(new Object[]{"foo", "bar"})});
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t._enum(new Object[]{new ASet().appendAll(new Object[]{"baz"})});
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t._enum((Object[])null);
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum(null);
        t._enum(new Object[]{"foo"})._enum(new Object[]{new StringBuilder("bar")})._enum(new Object[]{"['baz','qux']"})._enum(new Object[]{new String[]{"quux"}});
        TestUtils.assertObjectEquals("['foo','bar','baz','qux','quux']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
    }

    @Test
    public void testMultipleOf() {
        ParameterInfo t = new ParameterInfo();
        t.multipleOf((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Float.class, t.getMultipleOf());
        t.multipleOf((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf(null);
        Assert.assertNull((Object)t.getMultipleOf());
    }

    @Test
    public void testSet() throws Exception {
        ParameterInfo t = new ParameterInfo();
        t.set("default", (Object)"a").set("enum", (Object)new ASet().appendAll(new Object[]{"b"})).set("allowEmptyValue", (Object)true).set("collectionFormat", (Object)"c").set("description", (Object)"d").set("exclusiveMaximum", (Object)true).set("exclusiveMinimum", (Object)true).set("format", (Object)"e").set("in", (Object)"f").set("items", (Object)SwaggerBuilder.items((String)"g")).set("maximum", (Object)Float.valueOf(123.0f)).set("maxItems", (Object)123).set("maxLength", (Object)123).set("minimum", (Object)Float.valueOf(123.0f)).set("minItems", (Object)123).set("minLength", (Object)123).set("multipleOf", (Object)Float.valueOf(123.0f)).set("name", (Object)"h").set("pattern", (Object)"i").set("required", (Object)true).set("schema", (Object)SwaggerBuilder.schemaInfo().title((Object)"j")).set("type", (Object)"k").set("uniqueItems", (Object)true).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{'in':'f',name:'h',type:'k',description:'d',required:true,schema:{title:'j'},format:'e',allowEmptyValue:true,items:{type:'g'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}", t);
        t.set("default", (Object)"a").set("enum", (Object)"['b']").set("allowEmptyValue", (Object)"true").set("collectionFormat", (Object)"c").set("description", (Object)"d").set("exclusiveMaximum", (Object)"true").set("exclusiveMinimum", (Object)"true").set("format", (Object)"e").set("in", (Object)"f").set("items", (Object)"{type:'g'}").set("maximum", (Object)"123.0").set("maxItems", (Object)"123").set("maxLength", (Object)"123").set("minimum", (Object)"123.0").set("minItems", (Object)"123").set("minLength", (Object)"123").set("multipleOf", (Object)"123.0").set("name", (Object)"h").set("pattern", (Object)"i").set("required", (Object)"true").set("schema", (Object)"{title:'j'}").set("type", (Object)"k").set("uniqueItems", (Object)"true").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{'in':'f',name:'h',type:'k',description:'d',required:true,schema:{title:'j'},format:'e',allowEmptyValue:true,items:{type:'g'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}", t);
        t.set("default", (Object)new StringBuilder("a")).set("enum", (Object)new StringBuilder("['b']")).set("allowEmptyValue", (Object)new StringBuilder("true")).set("collectionFormat", (Object)new StringBuilder("c")).set("description", (Object)new StringBuilder("d")).set("exclusiveMaximum", (Object)new StringBuilder("true")).set("exclusiveMinimum", (Object)new StringBuilder("true")).set("format", (Object)new StringBuilder("e")).set("in", (Object)new StringBuilder("f")).set("items", (Object)new StringBuilder("{type:'g'}")).set("maximum", (Object)new StringBuilder("123.0")).set("maxItems", (Object)new StringBuilder("123")).set("maxLength", (Object)new StringBuilder("123")).set("minimum", (Object)new StringBuilder("123.0")).set("minItems", (Object)new StringBuilder("123")).set("minLength", (Object)new StringBuilder("123")).set("multipleOf", (Object)new StringBuilder("123.0")).set("name", (Object)new StringBuilder("h")).set("pattern", (Object)new StringBuilder("i")).set("required", (Object)new StringBuilder("true")).set("schema", (Object)new StringBuilder("{title:'j'}")).set("type", (Object)new StringBuilder("k")).set("uniqueItems", (Object)new StringBuilder("true")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{'in':'f',name:'h',type:'k',description:'d',required:true,schema:{title:'j'},format:'e',allowEmptyValue:true,items:{type:'g'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("default", String.class));
        Assert.assertEquals((Object)"['b']", (Object)t.get("enum", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("allowEmptyValue", String.class));
        Assert.assertEquals((Object)"c", (Object)t.get("collectionFormat", String.class));
        Assert.assertEquals((Object)"d", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("exclusiveMaximum", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("exclusiveMinimum", String.class));
        Assert.assertEquals((Object)"e", (Object)t.get("format", String.class));
        Assert.assertEquals((Object)"f", (Object)t.get("in", String.class));
        Assert.assertEquals((Object)"{type:'g'}", (Object)t.get("items", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("maximum", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("maxItems", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("maxLength", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("minimum", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("minItems", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("minLength", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("multipleOf", String.class));
        Assert.assertEquals((Object)"h", (Object)t.get("name", String.class));
        Assert.assertEquals((Object)"i", (Object)t.get("pattern", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("required", String.class));
        Assert.assertEquals((Object)"{title:'j'}", (Object)t.get("schema", String.class));
        Assert.assertEquals((Object)"k", (Object)t.get("type", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("uniqueItems", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("default", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("enum", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("allowEmptyValue", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("collectionFormat", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("exclusiveMaximum", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("exclusiveMinimum", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("format", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("in", Object.class));
        TestUtils.assertInstanceOf(Items.class, t.get("items", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("maximum", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("maxItems", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("maxLength", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("minimum", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("minItems", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("minLength", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("multipleOf", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("name", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("pattern", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("required", Object.class));
        TestUtils.assertInstanceOf(SchemaInfo.class, t.get("schema", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("type", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("uniqueItems", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{'in':'f',name:'h',type:'k',description:'d',required:true,schema:{title:'j'},format:'e',allowEmptyValue:true,items:{type:'g'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, ParameterInfo.class));
    }
}

