/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class OperationTest {
    @Test
    public void testSetTags() {
        Operation t = new Operation();
        t.setTags((Collection)new ASet().appendAll((Object[])new String[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.setTags((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.setTags(null);
        Assert.assertNull((Object)t.getTags());
    }

    @Test
    public void testAddTags() {
        Operation t = new Operation();
        t.addTags((Collection)new ASet().appendAll((Object[])new String[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.addTags((Collection)new ASet());
        TestUtils.assertObjectEquals("['foo','bar']", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
        t.addTags(null);
        TestUtils.assertObjectEquals("['foo','bar']", t.getTags());
        TestUtils.assertInstanceOf(List.class, t.getTags());
    }

    @Test
    public void testTags() {
        Operation t = new Operation();
        t.tags(new Object[]{new ASet().appendAll((Object[])new String[]{"a"})});
        t.tags(new Object[]{new ASet().appendAll(new Object[]{new StringBuilder("b")})});
        t.tags(new Object[]{new String[]{"c"}});
        t.tags(new Object[]{new Object[]{new StringBuilder("d")}});
        t.tags(new Object[]{"e"});
        t.tags(new Object[]{"['f']"});
        t.tags(new Object[]{"[]"});
        t.tags(new Object[]{null});
        TestUtils.assertObjectEquals("['a','b','c','d','e','f']", t.getTags());
        for (String s : t.getTags()) {
            TestUtils.assertInstanceOf(String.class, s);
        }
    }

    @Test
    public void testSummary() {
        Operation t = new Operation();
        t.summary((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getSummary());
        t.summary((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getSummary());
        TestUtils.assertInstanceOf(String.class, t.getSummary());
        t.summary(null);
        Assert.assertNull((Object)t.getSummary());
    }

    @Test
    public void testDescription() {
        Operation t = new Operation();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testExternalDocs() {
        Operation t = new Operation();
        t.externalDocs((Object)SwaggerBuilder.externalDocumentation((Object)"foo"));
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        t.externalDocs((Object)"{url:'foo'}");
        TestUtils.assertObjectEquals("{url:'foo'}", t.getExternalDocs());
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.getExternalDocs());
        t.externalDocs(null);
        Assert.assertNull((Object)t.getExternalDocs());
    }

    @Test
    public void testOperationId() {
        Operation t = new Operation();
        t.operationId((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getOperationId());
        t.operationId((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getOperationId());
        TestUtils.assertInstanceOf(String.class, t.getOperationId());
        t.operationId(null);
        Assert.assertNull((Object)t.getOperationId());
    }

    @Test
    public void testSetConsumes() {
        Operation t = new Operation();
        t.setConsumes((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.setConsumes((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.setConsumes(null);
        Assert.assertNull((Object)t.getConsumes());
    }

    @Test
    public void testAddConsumes() {
        Operation t = new Operation();
        t.addConsumes((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.addConsumes((Collection)new ASet());
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        t.addConsumes(null);
        TestUtils.assertObjectEquals("['text/foo']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
    }

    @Test
    public void testConsumes() {
        Operation t = new Operation();
        t.consumes(new Object[]{new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")})});
        t.consumes(new Object[]{MediaType.forString((String)"text/bar")});
        t.consumes(new Object[]{"text/baz"});
        t.consumes(new Object[]{new StringBuilder("text/qux")});
        t.consumes(new Object[]{new String[]{"text/quux"}});
        t.consumes(new Object[]{new ASet().append((Object)"text/quuux")});
        t.consumes(new Object[]{"['text/quuuux']"});
        t.consumes(new Object[]{"[]"});
        t.consumes(new Object[]{null});
        TestUtils.assertObjectEquals("['text/foo','text/bar','text/baz','text/qux','text/quux','text/quuux','text/quuuux']", t.getConsumes());
        TestUtils.assertInstanceOf(List.class, t.getConsumes());
        for (MediaType mt : t.getConsumes()) {
            TestUtils.assertInstanceOf(MediaType.class, mt);
        }
    }

    @Test
    public void testSetProduces() {
        Operation t = new Operation();
        t.setProduces((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.setProduces((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.setProduces(null);
        Assert.assertNull((Object)t.getProduces());
    }

    @Test
    public void testAddProduces() {
        Operation t = new Operation();
        t.addProduces((Collection)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")}));
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.addProduces((Collection)new ASet());
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        t.addProduces(null);
        TestUtils.assertObjectEquals("['text/foo']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
    }

    @Test
    public void testProduces() {
        Operation t = new Operation();
        t.produces(new Object[]{new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/foo")})});
        t.produces(new Object[]{MediaType.forString((String)"text/bar")});
        t.produces(new Object[]{"text/baz"});
        t.produces(new Object[]{new StringBuilder("text/qux")});
        t.produces(new Object[]{new String[]{"text/quux"}});
        t.produces(new Object[]{new ASet().append((Object)"text/quuux")});
        t.produces(new Object[]{"['text/quuuux']"});
        t.produces(new Object[]{"[]"});
        t.produces(new Object[]{null});
        TestUtils.assertObjectEquals("['text/foo','text/bar','text/baz','text/qux','text/quux','text/quuux','text/quuuux']", t.getProduces());
        TestUtils.assertInstanceOf(List.class, t.getProduces());
        for (MediaType mt : t.getProduces()) {
            TestUtils.assertInstanceOf(MediaType.class, mt);
        }
    }

    @Test
    public void testSetParameters() {
        Operation t = new Operation();
        t.setParameters((Collection)new ASet().appendAll((Object[])new ParameterInfo[]{SwaggerBuilder.parameterInfo((String)"foo", (String)"bar")}));
        TestUtils.assertObjectEquals("[{'in':'foo',name:'bar'}]", t.getParameters());
        TestUtils.assertInstanceOf(List.class, t.getParameters());
        t.setParameters((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getParameters());
        TestUtils.assertInstanceOf(List.class, t.getParameters());
        t.setParameters(null);
        Assert.assertNull((Object)t.getParameters());
    }

    @Test
    public void testAddParameters() {
        Operation t = new Operation();
        t.addParameters((Collection)new ASet().appendAll((Object[])new ParameterInfo[]{SwaggerBuilder.parameterInfo((String)"foo", (String)"bar")}));
        TestUtils.assertObjectEquals("[{'in':'foo',name:'bar'}]", t.getParameters());
        TestUtils.assertInstanceOf(List.class, t.getParameters());
        t.addParameters((Collection)new ASet());
        TestUtils.assertObjectEquals("[{'in':'foo',name:'bar'}]", t.getParameters());
        TestUtils.assertInstanceOf(List.class, t.getParameters());
        t.addParameters(null);
        TestUtils.assertObjectEquals("[{'in':'foo',name:'bar'}]", t.getParameters());
        TestUtils.assertInstanceOf(List.class, t.getParameters());
    }

    @Test
    public void testParameters() {
        Operation t = new Operation();
        t.parameters(new Object[]{new ASet().appendAll((Object[])new ParameterInfo[]{SwaggerBuilder.parameterInfo((String)"a1", (String)"a2")})});
        t.parameters(new Object[]{SwaggerBuilder.parameterInfo((String)"b1", (String)"b2")});
        t.parameters(new Object[]{"{in:'c1',name:'c2'}"});
        t.parameters(new Object[]{new StringBuilder("{in:'d1',name:'d2'}")});
        t.parameters(new Object[]{new String[]{"{in:'e1',name:'e2'}"}});
        t.parameters(new Object[]{new ASet().append((Object)"{in:'f1',name:'f2'}")});
        t.parameters(new Object[]{"[{in:'g1',name:'g2'}]"});
        t.parameters(new Object[]{"[]"});
        t.parameters(new Object[]{null});
        TestUtils.assertObjectEquals("[{'in':'a1',name:'a2'},{'in':'b1',name:'b2'},{'in':'c1',name:'c2'},{'in':'d1',name:'d2'},{'in':'e1',name:'e2'},{'in':'f1',name:'f2'},{'in':'g1',name:'g2'}]", t.getParameters());
        TestUtils.assertInstanceOf(List.class, t.getParameters());
        for (ParameterInfo pi : t.getParameters()) {
            TestUtils.assertInstanceOf(ParameterInfo.class, pi);
        }
    }

    @Test
    public void testSetResponses() {
        Operation t = new Operation();
        t.setResponses((Map)new AMap().append((Object)"123", (Object)SwaggerBuilder.responseInfo((String)"bar")));
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.setResponses((Map)new AMap());
        TestUtils.assertObjectEquals("{}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.setResponses(null);
        Assert.assertNull((Object)t.getResponses());
    }

    @Test
    public void testAddResponses() {
        Operation t = new Operation();
        t.addResponses((Map)new AMap().append((Object)"123", (Object)SwaggerBuilder.responseInfo((String)"bar")));
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.addResponses((Map)new AMap());
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
        t.addResponses(null);
        TestUtils.assertObjectEquals("{'123':{description:'bar'}}", t.getResponses());
        TestUtils.assertInstanceOf(Map.class, t.getResponses());
    }

    @Test
    public void testResponse() {
        Operation t = new Operation();
        t.response("1", SwaggerBuilder.responseInfo((String)"foo"));
        t.response((String)null, SwaggerBuilder.responseInfo((String)"bar"));
        t.response("2", null);
        TestUtils.assertObjectEquals("{'1':{description:'foo'},null:{description:'bar'},'2':null}", t.getResponses());
    }

    @Test
    public void testResponses() {
        Operation t = new Operation();
        t.responses(new Object[]{new AMap().append((Object)1, (Object)SwaggerBuilder.responseInfo((String)"a"))});
        t.responses(new Object[]{new AMap().append((Object)"2", (Object)"{description:'b'}")});
        t.responses(new Object[]{"{3:{description:'c'}}"});
        t.responses(new Object[]{"{}"});
        t.responses(new Object[]{null});
        TestUtils.assertObjectEquals("{'1':{description:'a'},'2':{description:'b'},'3':{description:'c'}}", t.getResponses());
        for (Map.Entry e : t.getResponses().entrySet()) {
            TestUtils.assertInstanceOf(String.class, e.getKey());
            TestUtils.assertInstanceOf(ResponseInfo.class, e.getValue());
        }
    }

    @Test
    public void testSetSchemes() {
        Operation t = new Operation();
        t.setSchemes((Collection)new ASet().appendAll((Object[])new String[]{"foo"}));
        TestUtils.assertObjectEquals("['foo']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.setSchemes((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.setSchemes(null);
        Assert.assertNull((Object)t.getSchemes());
    }

    @Test
    public void testSetSecurity() {
        Operation t = new Operation();
        t.setSecurity((Collection)new ASet().append((Object)new AMap().append((Object)"foo", (Object)new AList().append((Object)"bar"))));
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.setSecurity((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.setSecurity(null);
        Assert.assertNull((Object)t.getSecurity());
    }

    @Test
    public void testAddSchemes() {
        Operation t = new Operation();
        t.addSchemes((Collection)new ASet().appendAll((Object[])new String[]{"foo"}));
        TestUtils.assertObjectEquals("['foo']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.addSchemes((Collection)new ASet());
        TestUtils.assertObjectEquals("['foo']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
        t.addSchemes(null);
        TestUtils.assertObjectEquals("['foo']", t.getSchemes());
        TestUtils.assertInstanceOf(List.class, t.getSchemes());
    }

    @Test
    public void testSchemes() {
        Operation t = new Operation();
        t.schemes(new Object[]{new ASet().appendAll((Object[])new String[]{"a"})});
        t.schemes(new Object[]{new ASet().appendAll(new Object[]{new StringBuilder("b")})});
        t.schemes(new Object[]{new String[]{"c"}});
        t.schemes(new Object[]{new Object[]{new StringBuilder("d")}});
        t.schemes(new Object[]{"e"});
        t.schemes(new Object[]{"['f']"});
        t.schemes(new Object[]{"[]"});
        t.schemes(new Object[]{null});
        TestUtils.assertObjectEquals("['a','b','c','d','e','f']", t.getSchemes());
        for (String s : t.getSchemes()) {
            TestUtils.assertInstanceOf(String.class, s);
        }
    }

    @Test
    public void testDeprecated() {
        Operation t = new Operation();
        t.deprecated((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getDeprecated());
        TestUtils.assertInstanceOf(Boolean.class, t.getDeprecated());
        t.deprecated((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getDeprecated());
        TestUtils.assertInstanceOf(Boolean.class, t.getDeprecated());
        t.deprecated((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getDeprecated());
        TestUtils.assertInstanceOf(Boolean.class, t.getDeprecated());
        t.deprecated(null);
        Assert.assertNull((Object)t.getDeprecated());
    }

    @Test
    public void testAddSecurity() {
        Operation t = new Operation();
        t.addSecurity((Collection)new ASet().append((Object)new AMap().append((Object)"foo", (Object)new AList().append((Object)"bar"))));
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.addSecurity((Collection)new ASet());
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
        t.addSecurity(null);
        TestUtils.assertObjectEquals("[{foo:['bar']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
    }

    @Test
    public void testSecurity() {
        Operation t = new Operation();
        t.security("a", new String[]{"a1", "a2"});
        t.security("b", new String[0]);
        t.security("c", new String[]{null});
        t.security(null, new String[]{"d"});
        TestUtils.assertObjectEquals("[{a:['a1','a2']},{b:[]},{c:[null]},{null:['d']}]", t.getSecurity());
    }

    @Test
    public void testSecurities() {
        Operation t = new Operation();
        t.securities(new Object[]{new ASet().append((Object)new AMap().append((Object)"a1", (Object)new AList().append((Object)"a2")))});
        t.securities(new Object[]{new AMap().append((Object)"b1", (Object)new AList().append((Object)"b2"))});
        t.securities(new Object[]{"{c1:['c2']}"});
        t.securities(new Object[]{new StringBuilder("{d1:['d2']}")});
        t.securities(new Object[]{new String[]{"{e1:['e2']}"}});
        t.securities(new Object[]{new ASet().append((Object)"{f1:['f2']}")});
        t.securities(new Object[]{"[{g1:['g2']}]"});
        t.securities(new Object[]{"[]"});
        t.securities(new Object[]{null});
        TestUtils.assertObjectEquals("[{a1:['a2']},{b1:['b2']},{c1:['c2']},{d1:['d2']},{e1:['e2']},{f1:['f2']},{g1:['g2']}]", t.getSecurity());
        TestUtils.assertInstanceOf(List.class, t.getSecurity());
    }

    @Test
    public void testSet() throws Exception {
        Operation t = new Operation();
        t.set("consumes", (Object)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/a")})).set("deprecated", (Object)true).set("description", (Object)"b").set("externalDocs", (Object)SwaggerBuilder.externalDocumentation((Object)"c")).set("operationId", (Object)"d").set("parameters", (Object)new ASet().appendAll((Object[])new ParameterInfo[]{SwaggerBuilder.parameterInfo((String)"e1", (String)"e2")})).set("produces", (Object)new ASet().appendAll((Object[])new MediaType[]{MediaType.forString((String)"text/f")})).set("responses", (Object)new AMap().append((Object)1, (Object)SwaggerBuilder.responseInfo((String)"g"))).set("schemes", (Object)new ASet().appendAll((Object[])new String[]{"h"})).set("security", (Object)new ASet().append((Object)new AMap().append((Object)"i1", (Object)new AList().append((Object)"i2")))).set("summary", (Object)"j").set("tags", (Object)new ASet().appendAll((Object[])new String[]{"k"})).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{operationId:'d',summary:'j',description:'b',tags:['k'],externalDocs:{url:'c'},consumes:['text/a'],produces:['text/f'],parameters:[{'in':'e1',name:'e2'}],responses:{'1':{description:'g'}},schemes:['h'],deprecated:true,security:[{i1:['i2']}],'$ref':'ref'}", t);
        t.set("consumes", (Object)"['text/a']").set("deprecated", (Object)"true").set("description", (Object)"b").set("externalDocs", (Object)"{url:'c'}").set("operationId", (Object)"d").set("parameters", (Object)"[{'in':'e1',name:'e2'}]").set("produces", (Object)"['text/f']").set("responses", (Object)"{'1':{description:'g'}}").set("schemes", (Object)"['h']").set("security", (Object)"[{i1:['i2']}]").set("summary", (Object)"j").set("tags", (Object)"['k']").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{operationId:'d',summary:'j',description:'b',tags:['k'],externalDocs:{url:'c'},consumes:['text/a'],produces:['text/f'],parameters:[{'in':'e1',name:'e2'}],responses:{'1':{description:'g'}},schemes:['h'],deprecated:true,security:[{i1:['i2']}],'$ref':'ref'}", t);
        t.set("consumes", (Object)new StringBuilder("['text/a']")).set("deprecated", (Object)new StringBuilder("true")).set("description", (Object)new StringBuilder("b")).set("externalDocs", (Object)new StringBuilder("{url:'c'}")).set("operationId", (Object)new StringBuilder("d")).set("parameters", (Object)new StringBuilder("[{'in':'e1',name:'e2'}]")).set("produces", (Object)new StringBuilder("['text/f']")).set("responses", (Object)new StringBuilder("{'1':{description:'g'}}")).set("schemes", (Object)new StringBuilder("['h']")).set("security", (Object)new StringBuilder("[{i1:['i2']}]")).set("summary", (Object)new StringBuilder("j")).set("tags", (Object)new StringBuilder("['k']")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{operationId:'d',summary:'j',description:'b',tags:['k'],externalDocs:{url:'c'},consumes:['text/a'],produces:['text/f'],parameters:[{'in':'e1',name:'e2'}],responses:{'1':{description:'g'}},schemes:['h'],deprecated:true,security:[{i1:['i2']}],'$ref':'ref'}", t);
        Assert.assertEquals((Object)"['text/a']", (Object)t.get("consumes", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("deprecated", String.class));
        Assert.assertEquals((Object)"b", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"{url:'c'}", (Object)t.get("externalDocs", String.class));
        Assert.assertEquals((Object)"d", (Object)t.get("operationId", String.class));
        Assert.assertEquals((Object)"[{'in':'e1',name:'e2'}]", (Object)t.get("parameters", String.class));
        Assert.assertEquals((Object)"['text/f']", (Object)t.get("produces", String.class));
        Assert.assertEquals((Object)"{'1':{description:'g'}}", (Object)t.get("responses", String.class));
        Assert.assertEquals((Object)"['h']", (Object)t.get("schemes", String.class));
        Assert.assertEquals((Object)"[{i1:['i2']}]", (Object)t.get("security", String.class));
        Assert.assertEquals((Object)"j", (Object)t.get("summary", String.class));
        Assert.assertEquals((Object)"['k']", (Object)t.get("tags", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(List.class, t.get("consumes", Object.class));
        TestUtils.assertInstanceOf(MediaType.class, ((List)t.get("consumes", List.class)).get(0));
        TestUtils.assertInstanceOf(Boolean.class, t.get("deprecated", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(ExternalDocumentation.class, t.get("externalDocs", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("operationId", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("parameters", Object.class));
        TestUtils.assertInstanceOf(ParameterInfo.class, ((List)t.get("parameters", List.class)).get(0));
        TestUtils.assertInstanceOf(List.class, t.get("produces", Object.class));
        TestUtils.assertInstanceOf(MediaType.class, ((List)t.get("produces", List.class)).get(0));
        TestUtils.assertInstanceOf(Map.class, t.get("responses", Object.class));
        TestUtils.assertInstanceOf(String.class, ((Map)t.get("responses", Map.class)).keySet().iterator().next());
        TestUtils.assertInstanceOf(ResponseInfo.class, ((Map)t.get("responses", Map.class)).values().iterator().next());
        TestUtils.assertInstanceOf(List.class, t.get("schemes", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("security", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("summary", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("tags", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{operationId:'d',summary:'j',description:'b',tags:['k'],externalDocs:{url:'c'},consumes:['text/a'],produces:['text/f'],parameters:[{'in':'e1',name:'e2'}],responses:{'1':{description:'g'}},schemes:['h'],deprecated:true,security:[{i1:['i2']}],'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, Operation.class));
    }
}

