/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.net.URI;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class LicenseTest {
    @Test
    public void testName() {
        License t = new License();
        t.name((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        t.name((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getName());
        TestUtils.assertInstanceOf(String.class, t.getName());
        t.name(null);
        Assert.assertNull((Object)t.getName());
    }

    @Test
    public void testUrl() {
        License t = new License();
        t.url((Object)URI.create("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getUrl().toString());
        t.url((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getUrl().toString());
        TestUtils.assertInstanceOf(URI.class, t.getUrl());
        t.url(null);
        Assert.assertNull((Object)t.getUrl());
    }

    @Test
    public void testSet() throws Exception {
        License t = new License();
        t.set("name", (Object)"a").set("url", (Object)URI.create("b")).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{name:'a',url:'b','$ref':'ref'}", t);
        t.set("name", (Object)"a").set("url", (Object)"b").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{name:'a',url:'b','$ref':'ref'}", t);
        t.set("name", (Object)new StringBuilder("a")).set("url", (Object)new StringBuilder("b")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{name:'a',url:'b','$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("name", String.class));
        Assert.assertEquals((Object)"b", (Object)t.get("url", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(String.class, t.get("name", Object.class));
        TestUtils.assertInstanceOf(URI.class, t.get("url", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{name:'a',url:'b','$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, License.class));
    }
}

