/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class InfoTest {
    @Test
    public void testTitle() {
        Info t = new Info();
        t.title((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getTitle());
        t.title((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getTitle());
        TestUtils.assertInstanceOf(String.class, t.getTitle());
        t.title(null);
        Assert.assertNull((Object)t.getTitle());
    }

    @Test
    public void testDescription() {
        Info t = new Info();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testTermsOfService() {
        Info t = new Info();
        t.termsOfService((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getTermsOfService());
        t.termsOfService((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getTermsOfService());
        TestUtils.assertInstanceOf(String.class, t.getTermsOfService());
        t.termsOfService(null);
        Assert.assertNull((Object)t.getTermsOfService());
    }

    @Test
    public void testContact() {
        Info t = new Info();
        t.contact((Object)SwaggerBuilder.contact((String)"foo"));
        TestUtils.assertObjectEquals("{name:'foo'}", t.getContact());
        t.contact((Object)"{name:'foo'}");
        TestUtils.assertObjectEquals("{name:'foo'}", t.getContact());
        TestUtils.assertInstanceOf(Contact.class, t.getContact());
        t.contact(null);
        Assert.assertNull((Object)t.getContact());
    }

    @Test
    public void testLicense() {
        Info t = new Info();
        t.license((Object)SwaggerBuilder.license((String)"foo"));
        TestUtils.assertObjectEquals("{name:'foo'}", t.getLicense());
        t.license((Object)"{name:'foo'}");
        TestUtils.assertObjectEquals("{name:'foo'}", t.getLicense());
        TestUtils.assertInstanceOf(License.class, t.getLicense());
        t.license(null);
        Assert.assertNull((Object)t.getLicense());
    }

    @Test
    public void testVersion() {
        Info t = new Info();
        t.version((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getVersion());
        t.version((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getVersion());
        TestUtils.assertInstanceOf(String.class, t.getVersion());
        t.version(null);
        Assert.assertNull((Object)t.getVersion());
    }

    @Test
    public void testSet() throws Exception {
        Info t = new Info();
        t.set("contact", (Object)SwaggerBuilder.contact((String)"a")).set("description", (Object)"b").set("license", (Object)SwaggerBuilder.license((String)"c")).set("termsOfService", (Object)"d").set("title", (Object)"e").set("version", (Object)"f").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{title:'e',description:'b',version:'f',contact:{name:'a'},license:{name:'c'},termsOfService:'d','$ref':'ref'}", t);
        t.set("contact", (Object)"{name:'a'}").set("description", (Object)"b").set("license", (Object)"{name:'c'}").set("termsOfService", (Object)"d").set("title", (Object)"e").set("version", (Object)"f").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{title:'e',description:'b',version:'f',contact:{name:'a'},license:{name:'c'},termsOfService:'d','$ref':'ref'}", t);
        t.set("contact", (Object)new StringBuilder("{name:'a'}")).set("description", (Object)new StringBuilder("b")).set("license", (Object)new StringBuilder("{name:'c'}")).set("termsOfService", (Object)new StringBuilder("d")).set("title", (Object)new StringBuilder("e")).set("version", (Object)new StringBuilder("f")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{title:'e',description:'b',version:'f',contact:{name:'a'},license:{name:'c'},termsOfService:'d','$ref':'ref'}", t);
        Assert.assertEquals((Object)"{name:'a'}", (Object)t.get("contact", String.class));
        Assert.assertEquals((Object)"b", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"{name:'c'}", (Object)t.get("license", String.class));
        Assert.assertEquals((Object)"d", (Object)t.get("termsOfService", String.class));
        Assert.assertEquals((Object)"e", (Object)t.get("title", String.class));
        Assert.assertEquals((Object)"f", (Object)t.get("version", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(Contact.class, t.get("contact", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(License.class, t.get("license", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("termsOfService", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("title", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("version", Object.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{title:'e',description:'b',version:'f',contact:{name:'a'},license:{name:'c'},termsOfService:'d','$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, Info.class));
    }
}

