/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Collection;
import java.util.List;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class HeaderInfoTest {
    @Test
    public void testDescription() {
        HeaderInfo t = new HeaderInfo();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testType() {
        HeaderInfo t = new HeaderInfo();
        t.type((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        t.type((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getType());
        TestUtils.assertInstanceOf(String.class, t.getType());
        t.type(null);
        Assert.assertNull((Object)t.getType());
    }

    @Test
    public void testFormat() {
        HeaderInfo t = new HeaderInfo();
        t.format((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getFormat());
        t.format((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getFormat());
        TestUtils.assertInstanceOf(String.class, t.getFormat());
        t.format(null);
        Assert.assertNull((Object)t.getFormat());
    }

    @Test
    public void testItems() {
        HeaderInfo t = new HeaderInfo();
        t.items((Object)SwaggerBuilder.items((String)"foo"));
        TestUtils.assertObjectEquals("{type:'foo'}", t.getItems());
        t.items((Object)"{type:'foo'}");
        TestUtils.assertObjectEquals("{type:'foo'}", t.getItems());
        TestUtils.assertInstanceOf(Items.class, t.getItems());
        t.items(null);
        Assert.assertNull((Object)t.getItems());
    }

    @Test
    public void testCollectionFormat() {
        HeaderInfo t = new HeaderInfo();
        t.collectionFormat((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getCollectionFormat());
        t.collectionFormat((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getCollectionFormat());
        TestUtils.assertInstanceOf(String.class, t.getCollectionFormat());
        t.collectionFormat(null);
        Assert.assertNull((Object)t.getCollectionFormat());
    }

    @Test
    public void test_default() {
        HeaderInfo t = new HeaderInfo();
        t._default((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDefault());
        t._default((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDefault().toString());
        TestUtils.assertInstanceOf(StringBuilder.class, t.getDefault());
        t._default(null);
        Assert.assertNull((Object)t.getDefault());
    }

    @Test
    public void testMaximum() {
        HeaderInfo t = new HeaderInfo();
        t.maximum((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Float.class, t.getMaximum());
        t.maximum((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMaximum());
        TestUtils.assertInstanceOf(Integer.class, t.getMaximum());
        t.maximum(null);
        Assert.assertNull((Object)t.getMaximum());
    }

    @Test
    public void testExclusiveMaximum() {
        HeaderInfo t = new HeaderInfo();
        t.exclusiveMaximum((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMaximum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMaximum());
        t.exclusiveMaximum(null);
        Assert.assertNull((Object)t.getExclusiveMaximum());
    }

    @Test
    public void testMinimum() {
        HeaderInfo t = new HeaderInfo();
        t.minimum((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Float.class, t.getMinimum());
        t.minimum((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMinimum());
        TestUtils.assertInstanceOf(Integer.class, t.getMinimum());
        t.minimum(null);
        Assert.assertNull((Object)t.getMinimum());
    }

    @Test
    public void testExclusiveMinimum() {
        HeaderInfo t = new HeaderInfo();
        t.exclusiveMinimum((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getExclusiveMinimum());
        TestUtils.assertInstanceOf(Boolean.class, t.getExclusiveMinimum());
        t.exclusiveMinimum(null);
        Assert.assertNull((Object)t.getExclusiveMinimum());
    }

    @Test
    public void testMaxLength() {
        HeaderInfo t = new HeaderInfo();
        t.maxLength((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMaxLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxLength());
        t.maxLength(null);
        Assert.assertNull((Object)t.getMaxLength());
    }

    @Test
    public void testMinLength() {
        HeaderInfo t = new HeaderInfo();
        t.minLength((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMinLength().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinLength());
        t.minLength(null);
        Assert.assertNull((Object)t.getMinLength());
    }

    @Test
    public void testPattern() {
        HeaderInfo t = new HeaderInfo();
        t.pattern((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getPattern());
        t.pattern((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getPattern());
        TestUtils.assertInstanceOf(String.class, t.getPattern());
        t.pattern(null);
        Assert.assertNull((Object)t.getPattern());
    }

    @Test
    public void testMaxItems() {
        HeaderInfo t = new HeaderInfo();
        t.maxItems((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMaxItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMaxItems());
        t.maxItems(null);
        Assert.assertNull((Object)t.getMaxItems());
    }

    @Test
    public void testMinItems() {
        HeaderInfo t = new HeaderInfo();
        t.minItems((Object)123);
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)Float.valueOf(123.0f));
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)"123");
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems((Object)new StringBuilder("123"));
        Assert.assertEquals((long)123L, (long)t.getMinItems().intValue());
        TestUtils.assertInstanceOf(Integer.class, t.getMinItems());
        t.minItems(null);
        Assert.assertNull((Object)t.getMinItems());
    }

    @Test
    public void testUniqueItems() {
        HeaderInfo t = new HeaderInfo();
        t.uniqueItems((Object)true);
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems((Object)"true");
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems((Object)new StringBuilder("true"));
        Assert.assertEquals((Object)true, (Object)t.getUniqueItems());
        TestUtils.assertInstanceOf(Boolean.class, t.getUniqueItems());
        t.uniqueItems(null);
        Assert.assertNull((Object)t.getUniqueItems());
    }

    @Test
    public void testSetEnum() {
        HeaderInfo t = new HeaderInfo();
        t.setEnum((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum((Collection)new ASet());
        TestUtils.assertObjectEquals("[]", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum(null);
        Assert.assertNull((Object)t.getEnum());
    }

    @Test
    public void testAddEnum() {
        HeaderInfo t = new HeaderInfo();
        t.addEnum((Collection)new ASet().appendAll(new Object[]{"foo", "bar"}));
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.addEnum((Collection)new ASet().appendAll(new Object[]{"baz"}));
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.addEnum(null);
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
    }

    @Test
    public void test_enum() {
        HeaderInfo t = new HeaderInfo();
        t._enum(new Object[]{new ASet().appendAll(new Object[]{"foo", "bar"})});
        TestUtils.assertObjectEquals("['foo','bar']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t._enum(new Object[]{new ASet().appendAll(new Object[]{"baz"})});
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t._enum((Object[])null);
        TestUtils.assertObjectEquals("['foo','bar','baz']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
        t.setEnum(null);
        t._enum(new Object[]{"foo"})._enum(new Object[]{new StringBuilder("bar")})._enum(new Object[]{"['baz','qux']"})._enum(new Object[]{new String[]{"quux"}});
        TestUtils.assertObjectEquals("['foo','bar','baz','qux','quux']", t.getEnum());
        TestUtils.assertInstanceOf(List.class, t.getEnum());
    }

    @Test
    public void testMultipleOf() {
        HeaderInfo t = new HeaderInfo();
        t.multipleOf((Object)123);
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Float.class, t.getMultipleOf());
        t.multipleOf((Object)"123");
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf((Object)new StringBuilder("123"));
        Assert.assertEquals((Object)123, (Object)t.getMultipleOf());
        TestUtils.assertInstanceOf(Integer.class, t.getMultipleOf());
        t.multipleOf(null);
        Assert.assertNull((Object)t.getMultipleOf());
    }

    @Test
    public void testSet() throws Exception {
        HeaderInfo t = new HeaderInfo();
        t.set("default", (Object)"a").set("enum", (Object)new ASet().append((Object)"b")).set("collectionFormat", (Object)"c").set("description", (Object)"d").set("exclusiveMaximum", (Object)true).set("exclusiveMinimum", (Object)true).set("format", (Object)"g").set("items", (Object)SwaggerBuilder.items((String)"h")).set("maximum", (Object)Float.valueOf(123.0f)).set("maxItems", (Object)123).set("maxLength", (Object)123).set("minimum", (Object)Float.valueOf(123.0f)).set("minItems", (Object)123).set("minLength", (Object)123).set("multipleOf", (Object)Float.valueOf(123.0f)).set("pattern", (Object)"i").set("type", (Object)"j").set("uniqueItems", (Object)true).set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{description:'d',type:'j',format:'g',items:{type:'h'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}", t);
        t.set("default", (Object)"a").set("enum", (Object)"['b']").set("collectionFormat", (Object)"c").set("description", (Object)"d").set("exclusiveMaximum", (Object)"true").set("exclusiveMinimum", (Object)"true").set("format", (Object)"g").set("items", (Object)"{type:'h'}").set("maximum", (Object)"123f").set("maxItems", (Object)"123").set("maxLength", (Object)"123").set("minimum", (Object)"123f").set("minItems", (Object)"123").set("minLength", (Object)"123").set("multipleOf", (Object)"123f").set("pattern", (Object)"i").set("type", (Object)"j").set("uniqueItems", (Object)"true").set("$ref", (Object)"ref");
        TestUtils.assertObjectEquals("{description:'d',type:'j',format:'g',items:{type:'h'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}", t);
        t.set("default", (Object)new StringBuilder("a")).set("enum", (Object)new StringBuilder("['b']")).set("collectionFormat", (Object)new StringBuilder("c")).set("description", (Object)new StringBuilder("d")).set("exclusiveMaximum", (Object)new StringBuilder("true")).set("exclusiveMinimum", (Object)new StringBuilder("true")).set("format", (Object)new StringBuilder("g")).set("items", (Object)new StringBuilder("{type:'h'}")).set("maximum", (Object)new StringBuilder("123f")).set("maxItems", (Object)new StringBuilder("123")).set("maxLength", (Object)new StringBuilder("123")).set("minimum", (Object)new StringBuilder("123f")).set("minItems", (Object)new StringBuilder("123")).set("minLength", (Object)new StringBuilder("123")).set("multipleOf", (Object)new StringBuilder("123f")).set("pattern", (Object)new StringBuilder("i")).set("type", (Object)new StringBuilder("j")).set("uniqueItems", (Object)new StringBuilder("true")).set("$ref", (Object)new StringBuilder("ref"));
        TestUtils.assertObjectEquals("{description:'d',type:'j',format:'g',items:{type:'h'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}", t);
        Assert.assertEquals((Object)"a", (Object)t.get("default", String.class));
        Assert.assertEquals((Object)"['b']", (Object)t.get("enum", String.class));
        Assert.assertEquals((Object)"c", (Object)t.get("collectionFormat", String.class));
        Assert.assertEquals((Object)"d", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("exclusiveMaximum", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("exclusiveMinimum", String.class));
        Assert.assertEquals((Object)"g", (Object)t.get("format", String.class));
        Assert.assertEquals((Object)"{type:'h'}", (Object)t.get("items", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("maximum", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("maxItems", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("maxLength", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("minimum", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("minItems", String.class));
        Assert.assertEquals((Object)"123", (Object)t.get("minLength", String.class));
        Assert.assertEquals((Object)"123.0", (Object)t.get("multipleOf", String.class));
        Assert.assertEquals((Object)"i", (Object)t.get("pattern", String.class));
        Assert.assertEquals((Object)"j", (Object)t.get("type", String.class));
        Assert.assertEquals((Object)"true", (Object)t.get("uniqueItems", String.class));
        Assert.assertEquals((Object)"ref", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(StringBuilder.class, t.get("default", Object.class));
        TestUtils.assertInstanceOf(List.class, t.get("enum", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("collectionFormat", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("exclusiveMaximum", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("exclusiveMinimum", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("format", Object.class));
        TestUtils.assertInstanceOf(Items.class, t.get("items", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("maximum", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("maxItems", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("maxLength", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("minimum", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("minItems", Object.class));
        TestUtils.assertInstanceOf(Integer.class, t.get("minLength", Object.class));
        TestUtils.assertInstanceOf(Float.class, t.get("multipleOf", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("pattern", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("type", Object.class));
        TestUtils.assertInstanceOf(Boolean.class, t.get("uniqueItems", Object.class));
        TestUtils.assertInstanceOf(String.class, t.get("$ref", Object.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        String s = "{description:'d',type:'j',format:'g',items:{type:'h'},collectionFormat:'c','default':'a',maximum:123.0,exclusiveMaximum:true,minimum:123.0,exclusiveMinimum:true,maxLength:123,minLength:123,pattern:'i',maxItems:123,minItems:123,uniqueItems:true,'enum':['b'],multipleOf:123.0,'$ref':'ref'}";
        TestUtils.assertObjectEquals(s, JsonParser.DEFAULT.parse(s, HeaderInfo.class));
    }
}

