/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.net.URI;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ExternalDocumentationTest {
    @Test
    public void testDescription() {
        ExternalDocumentation t = new ExternalDocumentation();
        t.description((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        t.description((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getDescription());
        TestUtils.assertInstanceOf(String.class, t.getDescription());
        t.description(null);
        Assert.assertNull((Object)t.getDescription());
    }

    @Test
    public void testUrl() {
        ExternalDocumentation t = new ExternalDocumentation();
        t.url((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)t.getUrl().toString());
        t.url((Object)new StringBuilder("foo"));
        Assert.assertEquals((Object)"foo", (Object)t.getUrl().toString());
        TestUtils.assertInstanceOf(URI.class, t.getUrl());
        t.url(null);
        Assert.assertNull((Object)t.getUrl());
    }

    @Test
    public void testSet() throws Exception {
        ExternalDocumentation t = new ExternalDocumentation();
        t.set("description", (Object)"foo").set("url", (Object)"bar").set("$ref", (Object)"baz");
        TestUtils.assertObjectEquals("{description:'foo',url:'bar','$ref':'baz'}", t);
        t.set("description", (Object)new StringBuilder("foo")).set("url", (Object)new StringBuilder("bar")).set("$ref", (Object)new StringBuilder("baz"));
        TestUtils.assertObjectEquals("{description:'foo',url:'bar','$ref':'baz'}", t);
        Assert.assertEquals((Object)"foo", (Object)t.get("description", String.class));
        Assert.assertEquals((Object)"bar", (Object)((URI)t.get("url", URI.class)).toString());
        Assert.assertEquals((Object)"baz", (Object)t.get("$ref", String.class));
        TestUtils.assertInstanceOf(String.class, t.get("description", String.class));
        TestUtils.assertInstanceOf(URI.class, t.get("url", URI.class));
        TestUtils.assertInstanceOf(String.class, t.get("$ref", String.class));
        t.set("null", null).set(null, (Object)"null");
        Assert.assertNull((Object)t.get("null", Object.class));
        Assert.assertNull((Object)t.get(null, Object.class));
        Assert.assertNull((Object)t.get("foo", Object.class));
        TestUtils.assertObjectEquals("{description:'foo',url:'bar','$ref':'baz'}", JsonParser.DEFAULT.parse("{description:'foo',url:'bar','$ref':'baz'}", ExternalDocumentation.class));
    }
}

