/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.jsonschema;

import java.net.URI;
import org.apache.juneau.dto.jsonschema.JsonSchema;
import org.apache.juneau.dto.jsonschema.JsonSchemaArray;
import org.apache.juneau.dto.jsonschema.JsonSchemaProperty;
import org.apache.juneau.dto.jsonschema.JsonSchemaRef;
import org.apache.juneau.dto.jsonschema.JsonType;
import org.apache.juneau.dto.jsonschema.JsonTypeArray;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.junit.Assert;
import org.junit.Test;

public class JsonSchemaTest {
    @Test
    public void testSchema1() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().ws().addBeanTypes(false).build();
        JsonParser p = JsonParser.DEFAULT;
        String expected = "{\n\tid: 'http://id',\n\t'$schema': 'http://schemaVersionUri',\n\ttitle: 'title',\n\tdescription: 'description',\n\ttype: 'number',\n\tdefinitions: {\n\t\tdefinition: {\n\t\t\t'$ref': 'http://definition'\n\t\t}\n\t},\n\tproperties: {\n\t\tproperty: {\n\t\t\ttype: 'number'\n\t\t}\n\t},\n\tpatternProperties: {\n\t\t'/pattern/': {\n\t\t\ttype: 'number'\n\t\t}\n\t},\n\tdependencies: {\n\t\tdependency: {\n\t\t\t'$ref': 'http://dependency'\n\t\t}\n\t},\n\titems: [\n\t\t{\n\t\t\ttype: 'number'\n\t\t}\n\t],\n\tmultipleOf: 1,\n\tmaximum: 2,\n\texclusiveMaximum: true,\n\tminimum: 3,\n\texclusiveMinimum: true,\n\tmaxLength: 4,\n\tminLength: 5,\n\tpattern: '/pattern/',\n\tadditionalItems: [\n\t\t{\n\t\t\ttype: 'number'\n\t\t}\n\t],\n\tmaxItems: 6,\n\tminItems: 7,\n\tuniqueItems: true,\n\tmaxProperties: 8,\n\tminProperties: 9,\n\trequired: [\n\t\t'required'\n\t],\n\tadditionalProperties: {\n\t\t'$ref': 'http://additionalProperty'\n\t},\n\t'enum': [\n\t\t'enum'\n\t],\n\tallOf: [\n\t\t{\n\t\t\t'$ref': 'http://allOf'\n\t\t}\n\t],\n\tanyOf: [\n\t\t{\n\t\t\t'$ref': 'http://anyOf'\n\t\t}\n\t],\n\toneOf: [\n\t\t{\n\t\t\t'$ref': 'http://oneOf'\n\t\t}\n\t],\n\tnot: {\n\t\t'$ref': 'http://not'\n\t}\n}";
        JsonSchema t = JsonSchemaTest.getTest1();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)expected, (Object)r);
        JsonSchema t2 = (JsonSchema)p.parse(r, JsonSchema.class);
        r = s.serialize((Object)t2);
        Assert.assertEquals((Object)expected, (Object)r);
    }

    @Test
    public void testSchema2() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().ws().addBeanTypes(false).build();
        JsonParser p = JsonParser.DEFAULT;
        String expected = "{\n\tid: 'http://id',\n\t'$schema': 'http://schemaVersionUri',\n\ttype: [\n\t\t'string',\n\t\t'number'\n\t],\n\tdefinitions: {\n\t\tdefinition: {\n\t\t\tid: 'http://definition'\n\t\t}\n\t},\n\titems: [\n\t\t{\n\t\t\t'$ref': 'http://items'\n\t\t}\n\t],\n\tadditionalItems: true,\n\tadditionalProperties: true\n}";
        JsonSchema t = JsonSchemaTest.getTest2();
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)expected, (Object)r);
        JsonSchema t2 = (JsonSchema)p.parse(r, JsonSchema.class);
        r = s.serialize((Object)t2);
        Assert.assertEquals((Object)expected, (Object)r);
    }

    @Test
    public void testToString() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().ws().addBeanTypes(false).build();
        JsonParser p = JsonParser.DEFAULT;
        String expected = "{\n\tid: 'http://id',\n\t'$schema': 'http://schemaVersionUri',\n\ttitle: 'title',\n\tdescription: 'description',\n\ttype: 'number',\n\tdefinitions: {\n\t\tdefinition: {\n\t\t\t'$ref': 'http://definition'\n\t\t}\n\t},\n\tproperties: {\n\t\tproperty: {\n\t\t\ttype: 'number'\n\t\t}\n\t},\n\tpatternProperties: {\n\t\t'/pattern/': {\n\t\t\ttype: 'number'\n\t\t}\n\t},\n\tdependencies: {\n\t\tdependency: {\n\t\t\t'$ref': 'http://dependency'\n\t\t}\n\t},\n\titems: [\n\t\t{\n\t\t\ttype: 'number'\n\t\t}\n\t],\n\tmultipleOf: 1,\n\tmaximum: 2,\n\texclusiveMaximum: true,\n\tminimum: 3,\n\texclusiveMinimum: true,\n\tmaxLength: 4,\n\tminLength: 5,\n\tpattern: '/pattern/',\n\tadditionalItems: [\n\t\t{\n\t\t\ttype: 'number'\n\t\t}\n\t],\n\tmaxItems: 6,\n\tminItems: 7,\n\tuniqueItems: true,\n\tmaxProperties: 8,\n\tminProperties: 9,\n\trequired: [\n\t\t'required'\n\t],\n\tadditionalProperties: {\n\t\t'$ref': 'http://additionalProperty'\n\t},\n\t'enum': [\n\t\t'enum'\n\t],\n\tallOf: [\n\t\t{\n\t\t\t'$ref': 'http://allOf'\n\t\t}\n\t],\n\tanyOf: [\n\t\t{\n\t\t\t'$ref': 'http://anyOf'\n\t\t}\n\t],\n\toneOf: [\n\t\t{\n\t\t\t'$ref': 'http://oneOf'\n\t\t}\n\t],\n\tnot: {\n\t\t'$ref': 'http://not'\n\t}\n}";
        JsonSchema t = JsonSchemaTest.getTest1();
        String r = t.toString();
        JsonSchema t2 = (JsonSchema)p.parse(r, JsonSchema.class);
        r = s.serialize((Object)t2);
        Assert.assertEquals((Object)expected, (Object)r);
    }

    public static JsonSchema getTest1() {
        return new JsonSchema().setId((Object)"http://id").setSchemaVersionUri((Object)"http://schemaVersionUri").setTitle("title").setDescription("description").setType((Object)JsonType.NUMBER).addDefinition("definition", (JsonSchema)new JsonSchemaRef((Object)"http://definition")).addProperties(new JsonSchema[]{new JsonSchemaProperty("property", JsonType.NUMBER)}).addPatternProperties(new JsonSchemaProperty[]{new JsonSchemaProperty("/pattern/", JsonType.NUMBER)}).addDependency("dependency", (JsonSchema)new JsonSchemaRef((Object)"http://dependency")).addItems(new JsonSchema[]{new JsonSchema().setType((Object)JsonType.NUMBER)}).setMultipleOf((Number)1).setMaximum((Number)2).setExclusiveMaximum(Boolean.valueOf(true)).setMinimum((Number)3).setExclusiveMinimum(Boolean.valueOf(true)).setMaxLength(Integer.valueOf(4)).setMinLength(Integer.valueOf(5)).setPattern("/pattern/").addAdditionalItems(new JsonSchema[]{new JsonSchemaProperty("additionalItem", JsonType.NUMBER)}).setMaxItems(Integer.valueOf(6)).setMinItems(Integer.valueOf(7)).setUniqueItems(Boolean.valueOf(true)).setMaxProperties(Integer.valueOf(8)).setMinProperties(Integer.valueOf(9)).addRequired(new String[]{"required"}).setAdditionalProperties((Object)new JsonSchemaRef((Object)"http://additionalProperty")).addEnum(new String[]{"enum"}).addAllOf(new JsonSchema[]{new JsonSchemaRef((Object)"http://allOf")}).addAnyOf(new JsonSchema[]{new JsonSchemaRef((Object)"http://anyOf")}).addOneOf(new JsonSchema[]{new JsonSchemaRef((Object)"http://oneOf")}).setNot((JsonSchema)new JsonSchemaRef((Object)"http://not"));
    }

    public static JsonSchema getTest2() {
        return new JsonSchema().setId((Object)URI.create("http://id")).setSchemaVersionUri((Object)URI.create("http://schemaVersionUri")).setType((Object)new JsonTypeArray(new JsonType[]{JsonType.STRING, JsonType.NUMBER})).addDefinition("definition", new JsonSchema().setId((Object)"http://definition")).setItems((Object)new JsonSchemaArray(new JsonSchema[]{new JsonSchemaRef((Object)"http://items")})).setAdditionalItems((Object)Boolean.TRUE).setAdditionalProperties((Object)Boolean.TRUE);
    }
}

