/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.html5;

import java.util.Arrays;
import java.util.Collection;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ComboInput;
import org.apache.juneau.ComboRoundTripTest;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.html5.Form;
import org.apache.juneau.dto.html5.HtmlBeanDictionary;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.dto.html5.Input;
import org.apache.juneau.testutils.TestUtils;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Html5TemplateComboTest
extends ComboRoundTripTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList(new Object[][]{{new ComboInput<FormTemplate>("FormTemplate-1", FormTemplate.class, new FormTemplate("http://myaction", 123, true), "{a:{action:'http://myaction'},c:[{_type:'input',a:{type:'text',name:'v1',value:123}},{_type:'input',a:{type:'text',name:'v2',value:true}}]}", "{a:{action:'http://myaction'},c:[{t:'input',a:{type:'text',name:'v1',value:123}},{t:'input',a:{type:'text',name:'v2',value:true}}]}", "{\n\ta: {\n\t\taction: 'http://myaction'\n\t},\n\tc: [\n\t\t{\n\t\t\t_type: 'input',\n\t\t\ta: {\n\t\t\t\ttype: 'text',\n\t\t\t\tname: 'v1',\n\t\t\t\tvalue: 123\n\t\t\t}\n\t\t},\n\t\t{\n\t\t\t_type: 'input',\n\t\t\ta: {\n\t\t\t\ttype: 'text',\n\t\t\t\tname: 'v2',\n\t\t\t\tvalue: true\n\t\t\t}\n\t\t}\n\t]\n}", "<form action='http://myaction'><input type='text' name='v1' value='123'/><input type='text' name='v2' value='true'/></form>", "<form action='http://myaction'><input type='text' name='v1' value='123'/><input type='text' name='v2' value='true'/></form>", "<form action='http://myaction'><input type='text' name='v1' value='123'/><input type='text' name='v2' value='true'/></form>\n", "<form action='http://myaction'><input type='text' name='v1' value='123'/><input type='text' name='v2' value='true'/></form>", "<form action='http://myaction'><input type='text' name='v1' value='123'/><input type='text' name='v2' value='true'/></form>", "<form action='http://myaction'><input type='text' name='v1' value='123'/><input type='text' name='v2' value='true'/></form>", "<form action='http://myaction'><input type='text' name='v1' value='123'/><input type='text' name='v2' value='true'/></form>\n", "(a=(action=http://myaction),c=@((_type=input,a=(type=text,name=v1,value=123)),(_type=input,a=(type=text,name=v2,value=true))))", "(a=(action=http://myaction),c=@((t=input,a=(type=text,name=v1,value=123)),(t=input,a=(type=text,name=v2,value=true))))", "(\n\ta=(\n\t\taction=http://myaction\n\t),\n\tc=@(\n\t\t(\n\t\t\t_type=input,\n\t\t\ta=(\n\t\t\t\ttype=text,\n\t\t\t\tname=v1,\n\t\t\t\tvalue=123\n\t\t\t)\n\t\t),\n\t\t(\n\t\t\t_type=input,\n\t\t\ta=(\n\t\t\t\ttype=text,\n\t\t\t\tname=v2,\n\t\t\t\tvalue=true\n\t\t\t)\n\t\t)\n\t)\n)", "a=(action=http://myaction)&c=@((_type=input,a=(type=text,name=v1,value=123)),(_type=input,a=(type=text,name=v2,value=true)))", "a=(action=http://myaction)&c=@((t=input,a=(type=text,name=v1,value=123)),(t=input,a=(type=text,name=v2,value=true)))", "a=(\n\taction=http://myaction\n)\n&c=@(\n\t(\n\t\t_type=input,\n\t\ta=(\n\t\t\ttype=text,\n\t\t\tname=v1,\n\t\t\tvalue=123\n\t\t)\n\t),\n\t(\n\t\t_type=input,\n\t\ta=(\n\t\t\ttype=text,\n\t\t\tname=v2,\n\t\t\tvalue=true\n\t\t)\n\t)\n)", "82A16181A6616374696F6EAF687474703A2F2F6D79616374696F6EA1639282A55F74797065A5696E707574A16183A474797065A474657874A46E616D65A27631A576616C75657B82A55F74797065A5696E707574A16183A474797065A474657874A46E616D65A27632A576616C7565C3", "82A16181A6616374696F6EAF687474703A2F2F6D79616374696F6EA1639282A174A5696E707574A16183A474797065A474657874A46E616D65A27631A576616C75657B82A174A5696E707574A16183A474797065A474657874A46E616D65A27632A576616C7565C3", "<rdf:RDF>\n<rdf:Description>\n<jp:a rdf:parseType='Resource'>\n<jp:action rdf:resource='http://myaction'/>\n</jp:a>\n<jp:c>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>input</jp:_type>\n<jp:a rdf:parseType='Resource'>\n<jp:type>text</jp:type>\n<jp:name>v1</jp:name>\n<jp:value>123</jp:value>\n</jp:a>\n</rdf:li>\n<rdf:li rdf:parseType='Resource'>\n<jp:_type>input</jp:_type>\n<jp:a rdf:parseType='Resource'>\n<jp:type>text</jp:type>\n<jp:name>v2</jp:name>\n<jp:value>true</jp:value>\n</jp:a>\n</rdf:li>\n</rdf:Seq>\n</jp:c>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:a rdf:parseType='Resource'>\n<jp:action rdf:resource='http://myaction'/>\n</jp:a>\n<jp:c>\n<rdf:Seq>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>input</jp:t>\n<jp:a rdf:parseType='Resource'>\n<jp:type>text</jp:type>\n<jp:name>v1</jp:name>\n<jp:value>123</jp:value>\n</jp:a>\n</rdf:li>\n<rdf:li rdf:parseType='Resource'>\n<jp:t>input</jp:t>\n<jp:a rdf:parseType='Resource'>\n<jp:type>text</jp:type>\n<jp:name>v2</jp:name>\n<jp:value>true</jp:value>\n</jp:a>\n</rdf:li>\n</rdf:Seq>\n</jp:c>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:a rdf:parseType='Resource'>\n      <jp:action rdf:resource='http://myaction'/>\n    </jp:a>\n    <jp:c>\n      <rdf:Seq>\n        <rdf:li rdf:parseType='Resource'>\n          <jp:_type>input</jp:_type>\n          <jp:a rdf:parseType='Resource'>\n            <jp:type>text</jp:type>\n            <jp:name>v1</jp:name>\n            <jp:value>123</jp:value>\n          </jp:a>\n        </rdf:li>\n        <rdf:li rdf:parseType='Resource'>\n          <jp:_type>input</jp:_type>\n          <jp:a rdf:parseType='Resource'>\n            <jp:type>text</jp:type>\n            <jp:name>v2</jp:name>\n            <jp:value>true</jp:value>\n          </jp:a>\n        </rdf:li>\n      </rdf:Seq>\n    </jp:c>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(FormTemplate o) {
                TestUtils.assertInstanceOf(FormTemplate.class, o);
            }
        }}});
    }

    public Html5TemplateComboTest(ComboInput<?> comboInput) {
        super(comboInput);
    }

    @Bean(dictionary={HtmlBeanDictionary.class})
    public static class FormTemplate {
        private String action;
        private int value1;
        private boolean value2;

        public FormTemplate(Form f) {
            this.action = f.getAttr("action");
            this.value1 = (Integer)((Input)f.getChild(Input.class, 0)).getAttr(Integer.TYPE, "value");
            this.value2 = (Boolean)((Input)f.getChild(Input.class, 1)).getAttr(Boolean.TYPE, "value");
        }

        public FormTemplate(String action, int value1, boolean value2) {
            this.action = action;
            this.value1 = value1;
            this.value2 = value2;
        }

        public Form swap(BeanSession session) {
            return HtmlBuilder.form((String)this.action, (Object[])new Object[]{HtmlBuilder.input((String)"text").name("v1").value((Object)this.value1), HtmlBuilder.input((String)"text").name("v2").value((Object)this.value2)});
        }
    }
}

