/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.cognos;

import java.util.LinkedList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.cognos.Column;
import org.apache.juneau.dto.cognos.DataSet;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;

public class CognosXmlTest {
    @Test
    public void test() throws Exception {
        String expected = "<dataset xmlns='http://developer.cognos.com/schemas/xmldata/1/'>\n\t<metadata>\n\t\t<item name='asOfDate' type='xs:string' length='12'/>\n\t\t<item name='rateOfReturn' type='xs:double'/>\n\t\t<item name='famAcctIndex' type='xs:string' length='3'/>\n\t\t<item name='rowID' type='xs:string' length='1'/>\n\t\t<item name='brM' type='xs:string' length='1'/>\n\t\t<item name='productLineCode' type='xs:int'/>\n\t</metadata>\n\t<data>\n\t\t<row>\n\t\t\t<value>Apr 26, 2002</value>\n\t\t\t<value>0.21006642</value>\n\t\t\t<value>JA1</value>\n\t\t\t<value>F</value>\n\t\t\t<value>B</value>\n\t\t\t<value>1</value>\n\t\t</row>\n\t\t<row>\n\t\t\t<value>Apr 27, 2002</value>\n\t\t\t<value>0.1111111</value>\n\t\t\t<value>BBB</value>\n\t\t\t<value>G</value>\n\t\t\t<value>B</value>\n\t\t\t<value>2</value>\n\t\t</row>\n\t</data>\n</dataset>\n";
        LinkedList<Object> rows = new LinkedList<Object>();
        rows.add(new ObjectMap((CharSequence)"{asOfDate:'Apr 26, 2002',rateOfReturn:0.21006642,famAcctIndex:'JA1',rowID:'F',brM:'B',productLineCode:1}"));
        rows.add(new Item("Apr 27, 2002", 0.1111111, "BBB", "G", "B", 2));
        Column[] c = new Column[]{new Column("asOfDate", "xs:string", Integer.valueOf(12)), new Column("rateOfReturn", "xs:double"), new Column("famAcctIndex", "xs:string", Integer.valueOf(3)), new Column("rowID", "xs:string", Integer.valueOf(1)), new Column("brM", "xs:string", Integer.valueOf(1)), new Column("productLineCode", "xs:int")};
        XmlSerializer s = XmlSerializer.create().ws().sq().defaultNamespace("cognos").ns().addNamespaceUrisToRoot().build();
        DataSet ds = new DataSet(c, rows, BeanContext.DEFAULT.createSession());
        String out = s.serialize((Object)ds);
        Assert.assertEquals((Object)expected, (Object)out);
        DataSet ds2 = (DataSet)XmlParser.DEFAULT.parse(out, DataSet.class);
        TestUtils.assertEqualObjects(ds, ds2);
    }

    public static class Item {
        public String asOfDate;
        public double rateOfReturn;
        public String famAcctIndex;
        public String rowID;
        public String brM;
        public int productLineCode;

        public Item(String asOfDate, double rateOfReturn, String famAcctIndex, String rowID, String brM, int productLineCode) {
            this.asOfDate = asOfDate;
            this.rateOfReturn = rateOfReturn;
            this.famAcctIndex = famAcctIndex;
            this.rowID = rowID;
            this.brM = brM;
            this.productLineCode = productLineCode;
        }
    }
}

