/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.net.URI;
import org.apache.juneau.dto.atom.AtomBuilder;
import org.apache.juneau.dto.atom.Entry;
import org.apache.juneau.dto.atom.Feed;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;

public class AtomTest {
    public Feed createFeed() throws Exception {
        return AtomBuilder.feed((String)"tag:foo.org", (String)"Title", (String)"2016-12-31T05:02:03Z").subtitle(AtomBuilder.text((String)"html").text("Subtitle")).links(new Link[]{AtomBuilder.link((String)"alternate", (String)"text/html", (String)"http://foo.org/").hreflang("en"), AtomBuilder.link((String)"self", (String)"application/atom+xml", (String)"http://foo.org/feed.atom")}).generator(AtomBuilder.generator((String)"Example Toolkit").uri((Object)"http://www.foo.org/").version("1.0")).entries(new Entry[]{AtomBuilder.entry((String)"tag:foo.org", (String)"Title", (String)"2016-12-31T05:02:03Z").links(new Link[]{AtomBuilder.link((String)"alternate", (String)"text/html", (String)"http://foo.org/2005/04/02/atom"), AtomBuilder.link((String)"enclosure", (String)"audio/mpeg", (String)"http://foo.org/audio/foobar.mp3").length(Integer.valueOf(1337))}).published("2016-12-31T05:02:03Z").authors(new Person[]{AtomBuilder.person((String)"John Smith").uri((Object)new URI("http://foo.org/")).email("foo@foo.org")}).contributors(new Person[]{AtomBuilder.person((String)"John Smith"), AtomBuilder.person((String)"Jane Smith")}).content(AtomBuilder.content((String)"xhtml").lang("en").base((Object)"http://foo.org/").text("<div><p><i>[Sample content]</i></p></div>"))});
    }

    @Test
    public void testNormal() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        Feed f = this.createFeed();
        String expected = "<feed>\n\t<entry>\n\t\t<author>\n\t\t\t<email>foo@foo.org</email>\n\t\t\t<name>John Smith</name>\n\t\t\t<uri>http://foo.org/</uri>\n\t\t</author>\n\t\t<content base='http://foo.org/' lang='en' type='xhtml'><div><p><i>[Sample content]</i></p></div></content>\n\t\t<contributor>\n\t\t\t<name>John Smith</name>\n\t\t</contributor>\n\t\t<contributor>\n\t\t\t<name>Jane Smith</name>\n\t\t</contributor>\n\t\t<id>tag:foo.org</id>\n\t\t<link href='http://foo.org/2005/04/02/atom' rel='alternate' type='text/html'/>\n\t\t<link href='http://foo.org/audio/foobar.mp3' length='1337' rel='enclosure' type='audio/mpeg'/>\n\t\t<published>2016-12-31T05:02:03Z</published>\n\t\t<title>Title</title>\n\t\t<updated>2016-12-31T05:02:03Z</updated>\n\t</entry>\n\t<generator uri='http://www.foo.org/' version='1.0'>Example Toolkit</generator>\n\t<id>tag:foo.org</id>\n\t<link href='http://foo.org/' hreflang='en' rel='alternate' type='text/html'/>\n\t<link href='http://foo.org/feed.atom' rel='self' type='application/atom+xml'/>\n\t<subtitle type='html'>Subtitle</subtitle>\n\t<title>Title</title>\n\t<updated>2016-12-31T05:02:03Z</updated>\n</feed>\n";
        XmlSerializer s = XmlSerializer.create().sq().ws().enableNamespaces(false).sortProperties().build();
        String r = s.serialize((Object)f);
        Assert.assertEquals((Object)expected, (Object)r);
        Feed f2 = (Feed)p.parse(r, Feed.class);
        TestUtils.assertEqualObjects(f, f2);
    }

    @Test
    public void testWithNamespaces() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        Feed f = this.createFeed();
        String expected = "<atom:feed xmlns='http://www.apache.org/2013/Juneau' xmlns:atom='http://www.w3.org/2005/Atom/' xmlns:xml='http://www.w3.org/XML/1998/namespace'>\n\t<atom:entry>\n\t\t<atom:author>\n\t\t\t<atom:email>foo@foo.org</atom:email>\n\t\t\t<atom:name>John Smith</atom:name>\n\t\t\t<atom:uri>http://foo.org/</atom:uri>\n\t\t</atom:author>\n\t\t<atom:content xml:base='http://foo.org/' xml:lang='en' type='xhtml'><div><p><i>[Sample content]</i></p></div></atom:content>\n\t\t<atom:contributor>\n\t\t\t<atom:name>John Smith</atom:name>\n\t\t</atom:contributor>\n\t\t<atom:contributor>\n\t\t\t<atom:name>Jane Smith</atom:name>\n\t\t</atom:contributor>\n\t\t<atom:id>tag:foo.org</atom:id>\n\t\t<atom:link href='http://foo.org/2005/04/02/atom' rel='alternate' type='text/html'/>\n\t\t<atom:link href='http://foo.org/audio/foobar.mp3' length='1337' rel='enclosure' type='audio/mpeg'/>\n\t\t<atom:published>2016-12-31T05:02:03Z</atom:published>\n\t\t<atom:title>Title</atom:title>\n\t\t<atom:updated>2016-12-31T05:02:03Z</atom:updated>\n\t</atom:entry>\n\t<atom:generator uri='http://www.foo.org/' version='1.0'>Example Toolkit</atom:generator>\n\t<atom:id>tag:foo.org</atom:id>\n\t<atom:link href='http://foo.org/' hreflang='en' rel='alternate' type='text/html'/>\n\t<atom:link href='http://foo.org/feed.atom' rel='self' type='application/atom+xml'/>\n\t<atom:subtitle type='html'>Subtitle</atom:subtitle>\n\t<atom:title>Title</atom:title>\n\t<atom:updated>2016-12-31T05:02:03Z</atom:updated>\n</atom:feed>\n";
        XmlSerializer s = XmlSerializer.create().sq().ws().enableNamespaces(true).addNamespaceUrisToRoot().sortProperties().build();
        String r = s.serialize((Object)f);
        Assert.assertEquals((Object)expected, (Object)r);
        Feed f2 = (Feed)p.parse(r, Feed.class);
        TestUtils.assertEqualObjects(f, f2);
    }

    @Test
    public void testWithNamespacesWithAtomAsDefault() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        Feed f = this.createFeed();
        String expected = "<feed xmlns='http://www.w3.org/2005/Atom/' xmlns:xml='http://www.w3.org/XML/1998/namespace'>\n\t<entry>\n\t\t<author>\n\t\t\t<email>foo@foo.org</email>\n\t\t\t<name>John Smith</name>\n\t\t\t<uri>http://foo.org/</uri>\n\t\t</author>\n\t\t<content xml:base='http://foo.org/' xml:lang='en' type='xhtml'><div><p><i>[Sample content]</i></p></div></content>\n\t\t<contributor>\n\t\t\t<name>John Smith</name>\n\t\t</contributor>\n\t\t<contributor>\n\t\t\t<name>Jane Smith</name>\n\t\t</contributor>\n\t\t<id>tag:foo.org</id>\n\t\t<link href='http://foo.org/2005/04/02/atom' rel='alternate' type='text/html'/>\n\t\t<link href='http://foo.org/audio/foobar.mp3' length='1337' rel='enclosure' type='audio/mpeg'/>\n\t\t<published>2016-12-31T05:02:03Z</published>\n\t\t<title>Title</title>\n\t\t<updated>2016-12-31T05:02:03Z</updated>\n\t</entry>\n\t<generator uri='http://www.foo.org/' version='1.0'>Example Toolkit</generator>\n\t<id>tag:foo.org</id>\n\t<link href='http://foo.org/' hreflang='en' rel='alternate' type='text/html'/>\n\t<link href='http://foo.org/feed.atom' rel='self' type='application/atom+xml'/>\n\t<subtitle type='html'>Subtitle</subtitle>\n\t<title>Title</title>\n\t<updated>2016-12-31T05:02:03Z</updated>\n</feed>\n";
        XmlSerializer s = XmlSerializer.create().sq().ws().defaultNamespace("atom").enableNamespaces(true).addNamespaceUrisToRoot().sortProperties().build();
        String r = s.serialize((Object)f);
        Assert.assertEquals((Object)expected, (Object)r);
        Feed f2 = (Feed)p.parse(r, Feed.class);
        TestUtils.assertEqualObjects(f, f2);
    }

    @Test
    public void testToString() throws Exception {
        XmlParser p = XmlParser.DEFAULT;
        Feed f = this.createFeed();
        String r = f.toString();
        Feed f2 = (Feed)p.parse(r, Feed.class);
        TestUtils.assertEqualObjects(f, f2);
    }
}

