/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.juneau.config.store.ConfigMemoryStore;
import org.apache.juneau.config.store.ConfigStoreListener;
import org.junit.Assert;
import org.junit.Test;

public class ConfigMemoryStoreTest {
    @Test
    public void testNoFile() throws Exception {
        ConfigMemoryStore fs = ConfigMemoryStore.create().build();
        Assert.assertEquals((Object)"", (Object)fs.read("X"));
    }

    @Test
    public void testSimpleCreate() throws Exception {
        ConfigMemoryStore fs = ConfigMemoryStore.create().build();
        Assert.assertNull((Object)fs.write("X", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
    }

    @Test
    public void testFailOnMismatch() throws Exception {
        ConfigMemoryStore fs = ConfigMemoryStore.create().build();
        Assert.assertNotNull((Object)fs.write("X", "xxx", "foo"));
        Assert.assertEquals((Object)"", (Object)fs.read("X"));
        Assert.assertNull((Object)fs.write("X", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        Assert.assertNotNull((Object)fs.write("X", "xxx", "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        Assert.assertNull((Object)fs.write("X", "foo", "bar"));
        Assert.assertEquals((Object)"bar", (Object)fs.read("X"));
    }

    @Test
    public void testUpdate() throws Exception {
        ConfigMemoryStore fs = ConfigMemoryStore.create().build();
        final CountDownLatch latch = new CountDownLatch(2);
        fs.register("X", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("xxx".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("Y", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("yyy".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.update("X", "xxx");
        fs.update("Y", "yyy");
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new Exception("CountDownLatch never reached zero.");
        }
    }

    @Test
    public void testExists() {
        ConfigMemoryStore.DEFAULT.write("foo", null, "foo");
        Assert.assertTrue((boolean)ConfigMemoryStore.DEFAULT.exists("foo"));
        Assert.assertFalse((boolean)ConfigMemoryStore.DEFAULT.exists("foo2"));
        ConfigMemoryStore.DEFAULT.write("foo", "foo", null);
        Assert.assertFalse((boolean)ConfigMemoryStore.DEFAULT.exists("foo"));
        Assert.assertFalse((boolean)ConfigMemoryStore.DEFAULT.exists("foo2"));
    }
}

