/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.juneau.config.store.ConfigFileStore;
import org.apache.juneau.config.store.ConfigStoreListener;
import org.apache.juneau.config.store.WatcherSensitivity;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ConfigFileStoreTest {
    private static final File DIR = new File("./config");

    @After
    public void cleanUp() {
        FileUtils.delete((File)DIR);
    }

    @Test
    public void testNoFile() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).build();
        Assert.assertEquals((Object)"", (Object)fs.read("X.cfg"));
        this.assertFileNotExists("X.cfg");
    }

    @Test
    public void testDifferentExtension() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).build();
        Assert.assertEquals((Object)"", (Object)fs.read("X.xxx"));
        this.assertFileNotExists("X.xxx");
    }

    @Test
    public void testSimpleCreateAndDelete() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).build();
        Assert.assertNull((Object)fs.write("X.cfg", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        this.assertFileExists("X.cfg");
        fs.write("X.cfg", "foo", null);
        this.assertFileNotExists("X.cfg");
    }

    @Test
    public void testSimpleCreateAndDeleteWithNoExtension() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).build();
        Assert.assertNull((Object)fs.write("X", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        this.assertFileExists("X.cfg");
        fs.write("X", "foo", null);
        this.assertFileNotExists("X.cfg");
    }

    @Test
    public void testSimpleCreateAndDeleteWithNonStandardExtension() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).extensions("xxx").build();
        Assert.assertNull((Object)fs.write("X", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        this.assertFileExists("X.xxx");
        fs.write("X", "foo", null);
        this.assertFileNotExists("X.xxx");
    }

    @Test
    public void testSimpleCreateAndDeleteWithMultipleSpecialExtension() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).extensions("foo1,foo2").build();
        Assert.assertNull((Object)fs.write("X", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        this.assertFileExists("X.foo1");
        fs.write("X", "foo", null);
        this.assertFileNotExists("X.foo1");
    }

    @Test
    public void testFailOnMismatch() throws Exception {
        this.assertFileNotExists("X.cfg");
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).build();
        Assert.assertNotNull((Object)fs.write("X.cfg", "xxx", "foo"));
        this.assertFileNotExists("X.cfg");
        Assert.assertEquals((Object)"", (Object)fs.read("X.cfg"));
        this.assertFileNotExists("X.cfg");
        Assert.assertNull((Object)fs.write("X.cfg", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        Assert.assertNotNull((Object)fs.write("X.cfg", "xxx", "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        Assert.assertNull((Object)fs.write("X.cfg", "foo", "bar"));
        Assert.assertEquals((Object)"bar", (Object)fs.read("X.cfg"));
    }

    @Test
    public void testFailOnMismatchNoExtension() throws Exception {
        this.assertFileNotExists("X.cfg");
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).build();
        Assert.assertNotNull((Object)fs.write("X", "xxx", "foo"));
        this.assertFileNotExists("X.cfg");
        Assert.assertEquals((Object)"", (Object)fs.read("X"));
        Assert.assertEquals((Object)"", (Object)fs.read("X.cfg"));
        this.assertFileNotExists("X.cfg");
        Assert.assertNull((Object)fs.write("X", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        Assert.assertNotNull((Object)fs.write("X", "xxx", "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        Assert.assertNull((Object)fs.write("X", "foo", "bar"));
        Assert.assertEquals((Object)"bar", (Object)fs.read("X"));
        Assert.assertEquals((Object)"bar", (Object)fs.read("X.cfg"));
    }

    @Test
    public void testCharset() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).charset("UTF-8").build();
        Assert.assertNull((Object)fs.write("X.cfg", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
    }

    @Test
    public void testCharsetNoExtension() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).charset("UTF-8").build();
        Assert.assertNull((Object)fs.write("X", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
    }

    @Test
    public void testWatcher_LONGRUNNING() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).useWatcher().watcherSensitivity(WatcherSensitivity.HIGH).build();
        final CountDownLatch latch = new CountDownLatch(4);
        fs.register("X.cfg", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("xxx".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("X", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("xxx".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("Y.cfg", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("yyy".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("Y", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("yyy".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        IOUtils.write((File)new File(DIR, "Z.ini"), (Reader)new StringReader("zzz"));
        IOUtils.write((File)new File(DIR, "X.cfg"), (Reader)new StringReader("xxx"));
        IOUtils.write((File)new File(DIR, "Y.cfg"), (Reader)new StringReader("yyy"));
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new Exception("CountDownLatch never reached zero.");
        }
    }

    @Test
    public void testUpdate() throws Exception {
        ConfigFileStore fs = ConfigFileStore.create().directory(DIR).build();
        final CountDownLatch latch = new CountDownLatch(4);
        fs.register("X.cfg", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("xxx".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("X", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("xxx".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("Y.cfg", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("yyy".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("Y", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("yyy".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.update("X.cfg", "xxx");
        fs.update("Y.cfg", "yyy");
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new Exception("CountDownLatch never reached zero.");
        }
    }

    @Test
    public void testExists() throws IOException {
        ConfigFileStore cs = ConfigFileStore.DEFAULT;
        Assert.assertTrue((boolean)cs.exists("test.cfg"));
        Assert.assertTrue((boolean)cs.exists("test"));
        Assert.assertFalse((boolean)cs.exists("test2.cfg"));
        Assert.assertFalse((boolean)cs.exists("foo.cfg"));
        cs.write("foo.cfg", null, "foo");
        Assert.assertTrue((boolean)cs.exists("foo.cfg"));
        Assert.assertTrue((boolean)cs.exists("foo"));
        cs.write("foo.cfg", "foo", null);
        Assert.assertFalse((boolean)cs.exists("foo.cfg"));
        Assert.assertFalse((boolean)cs.exists("foo"));
        IOUtils.write((File)new File("Foox.cfg"), (Reader)new StringReader("xxx"));
        Assert.assertTrue((boolean)cs.exists("Foox.cfg"));
        Assert.assertTrue((boolean)cs.exists("Foox"));
        new File("Foox.cfg").delete();
        Assert.assertFalse((boolean)cs.exists("Foox.cfg"));
        Assert.assertFalse((boolean)cs.exists("Foox"));
    }

    private void assertFileExists(String name) {
        Assert.assertTrue((boolean)new File(DIR, name).exists());
    }

    private void assertFileNotExists(String name) {
        Assert.assertTrue((!new File(DIR, name).exists() ? 1 : 0) != 0);
    }
}

