/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.juneau.config.store.ConfigClasspathStore;
import org.apache.juneau.config.store.ConfigStoreListener;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConfigClasspathStoreTest {
    @Test
    public void testNoFile() throws Exception {
        ConfigClasspathStore fs = ConfigClasspathStore.create().build();
        Assert.assertEquals((Object)"", (Object)fs.read("X.cfg"));
    }

    @Test
    public void testRealFiles() throws Exception {
        ConfigClasspathStore fs = ConfigClasspathStore.create().build();
        TestUtils.assertContains(fs.read("foo1.cfg"), "bar1");
        TestUtils.assertContains(fs.read("sub/foo2.cfg"), "bar2");
        Assert.assertEquals((Object)"", (Object)fs.read("sub/bad.cfg"));
        Assert.assertEquals((Object)"", (Object)fs.read("bad/bad.cfg"));
    }

    @Test
    public void testOverwriteRealFiles() throws Exception {
        ConfigClasspathStore fs = ConfigClasspathStore.create().build();
        TestUtils.assertContains(fs.read("foo1.cfg"), "bar1");
        fs.write("foo1.cfg", fs.read("foo1.cfg"), "xxx");
        Assert.assertEquals((Object)"xxx", (Object)fs.read("foo1.cfg"));
    }

    @Test
    public void testSimpleCreate() throws Exception {
        ConfigClasspathStore fs = ConfigClasspathStore.create().build();
        Assert.assertNull((Object)fs.write("X.cfg", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
    }

    @Test
    public void testFailOnMismatch() throws Exception {
        ConfigClasspathStore fs = ConfigClasspathStore.create().build();
        Assert.assertNotNull((Object)fs.write("X.cfg", "xxx", "foo"));
        Assert.assertEquals((Object)"", (Object)fs.read("X.cfg"));
        Assert.assertNull((Object)fs.write("X.cfg", null, "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        Assert.assertNotNull((Object)fs.write("X.cfg", "xxx", "foo"));
        Assert.assertEquals((Object)"foo", (Object)fs.read("X.cfg"));
        Assert.assertNull((Object)fs.write("X.cfg", "foo", "bar"));
        Assert.assertEquals((Object)"bar", (Object)fs.read("X.cfg"));
    }

    @Test
    public void testUpdate() throws Exception {
        ConfigClasspathStore fs = ConfigClasspathStore.create().build();
        final CountDownLatch latch = new CountDownLatch(2);
        fs.register("X.cfg", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("xxx".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.register("Y.cfg", new ConfigStoreListener(){

            public void onChange(String contents) {
                if ("yyy".equals(contents)) {
                    latch.countDown();
                }
            }
        });
        fs.update("X.cfg", "xxx");
        fs.update("Y.cfg", "yyy");
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new Exception("CountDownLatch never reached zero.");
        }
    }

    @Test
    public void testExists() throws Exception {
        ConfigClasspathStore.DEFAULT.write("foo.cfg", null, "foo");
        Assert.assertTrue((boolean)ConfigClasspathStore.DEFAULT.exists("foo.cfg"));
        Assert.assertFalse((boolean)ConfigClasspathStore.DEFAULT.exists("foo2.cfg"));
        ConfigClasspathStore.DEFAULT.write("foo.cfg", "foo", null);
        Assert.assertFalse((boolean)ConfigClasspathStore.DEFAULT.exists("foo.cfg"));
        Assert.assertFalse((boolean)ConfigClasspathStore.DEFAULT.exists("foo2.cfg"));
    }
}

