/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.ConfigMod;
import org.apache.juneau.config.encode.ConfigXorEncoder;
import org.apache.juneau.config.event.ConfigEvent;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEventType;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.store.ConfigMemoryStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.svl.SimpleVar;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class ConfigTest {
    private ConfigBuilder cb = new ConfigBuilder().store((ConfigStore)ConfigMemoryStore.DEFAULT).name("Test.cfg");

    private Config init(String ... lines) {
        ConfigMemoryStore.DEFAULT.update("Test.cfg", lines);
        return this.cb.build().rollback();
    }

    @Test
    public void get() throws Exception {
        Config c = this.init("a=1", "[S]", "b=2");
        Assert.assertEquals((Object)"1", (Object)c.get("a"));
        Assert.assertEquals((Object)"1", (Object)c.get("a"));
        Assert.assertEquals((Object)"2", (Object)c.get("S/b"));
        Assert.assertNull((Object)c.get("b"));
        Assert.assertNull((Object)c.get("S/c"));
        Assert.assertNull((Object)c.get("T/d"));
        try {
            Assert.assertNull((Object)c.get(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'key' cannot be null.", (Object)e.getLocalizedMessage());
        }
        c.close();
    }

    @Test
    public void set1() throws Exception {
        Config c = this.init("a1=1", "[S]", "b1=1");
        c.set("a1", "2");
        c.set("a2", "3");
        c.set("a3", "4");
        c.set("S/b1", "5");
        c.set("S/b2", "6");
        c.set("T/c1", "7");
        Assert.assertEquals((Object)"2", (Object)c.get("a1"));
        Assert.assertEquals((Object)"3", (Object)c.get("a2"));
        Assert.assertEquals((Object)"4", (Object)c.get("a3"));
        Assert.assertEquals((Object)"5", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"6", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"7", (Object)c.get("T/c1"));
        c.commit();
        Assert.assertEquals((Object)"2", (Object)c.get("a1"));
        Assert.assertEquals((Object)"3", (Object)c.get("a2"));
        Assert.assertEquals((Object)"4", (Object)c.get("a3"));
        Assert.assertEquals((Object)"5", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"6", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"7", (Object)c.get("T/c1"));
        c = this.cb.build();
        Assert.assertEquals((Object)"2", (Object)c.get("a1"));
        Assert.assertEquals((Object)"3", (Object)c.get("a2"));
        Assert.assertEquals((Object)"4", (Object)c.get("a3"));
        Assert.assertEquals((Object)"5", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"6", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"7", (Object)c.get("T/c1"));
        TestUtils.assertTextEquals("a1 = 2|a2 = 3|a3 = 4|[S]|b1 = 5|b2 = 6|[T]|c1 = 7|", c.toString());
    }

    @Test
    public void set2() throws Exception {
        Config c = this.init("a1=1", "[S]", "b1=1");
        c.set("a1", (Object)2);
        c.set("a2", (Object)3);
        c.set("a3", (Object)4);
        c.set("S/b1", (Object)5);
        c.set("S/b2", (Object)6);
        c.set("T/c1", (Object)7);
        Assert.assertEquals((Object)"2", (Object)c.get("a1"));
        Assert.assertEquals((Object)"3", (Object)c.get("a2"));
        Assert.assertEquals((Object)"4", (Object)c.get("a3"));
        Assert.assertEquals((Object)"5", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"6", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"7", (Object)c.get("T/c1"));
        c.commit();
        Assert.assertEquals((Object)"2", (Object)c.get("a1"));
        Assert.assertEquals((Object)"3", (Object)c.get("a2"));
        Assert.assertEquals((Object)"4", (Object)c.get("a3"));
        Assert.assertEquals((Object)"5", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"6", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"7", (Object)c.get("T/c1"));
        c = this.cb.build();
        Assert.assertEquals((Object)"2", (Object)c.get("a1"));
        Assert.assertEquals((Object)"3", (Object)c.get("a2"));
        Assert.assertEquals((Object)"4", (Object)c.get("a3"));
        Assert.assertEquals((Object)"5", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"6", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"7", (Object)c.get("T/c1"));
        TestUtils.assertTextEquals("a1 = 2|a2 = 3|a3 = 4|[S]|b1 = 5|b2 = 6|[T]|c1 = 7|", c.toString());
    }

    @Test
    public void set3() throws Exception {
        Config c = this.init("a1=1", "[S]", "b1=1");
        ABean b = new ABean().init();
        c.set("a1", (Object)b, (Serializer)UonSerializer.DEFAULT);
        c.set("a2", (Object)b, (Serializer)UonSerializer.DEFAULT);
        c.set("a3", (Object)b, (Serializer)UonSerializer.DEFAULT);
        c.set("S/b1", (Object)b, (Serializer)UonSerializer.DEFAULT);
        c.set("S/b2", (Object)b, (Serializer)UonSerializer.DEFAULT);
        c.set("T/c1", (Object)b, (Serializer)UonSerializer.DEFAULT);
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("a1"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("a2"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("a3"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("T/c1"));
    }

    @Test
    public void set4() throws Exception {
        Config c = this.init("a1=1", "[S]", "b1=1");
        ABean b = new ABean().init();
        c.set("a1", (Object)b, (Serializer)UonSerializer.DEFAULT, ConfigMod.ENCODED, "comment", Arrays.asList("#c1", "#c2"));
        c.set("a2", (Object)b, (Serializer)UonSerializer.DEFAULT, ConfigMod.ENCODED, "comment", Arrays.asList("#c1", "#c2"));
        c.set("a3", (Object)b, (Serializer)UonSerializer.DEFAULT, ConfigMod.ENCODED, "comment", Arrays.asList("#c1", "#c2"));
        c.set("S/b1", (Object)b, (Serializer)UonSerializer.DEFAULT, ConfigMod.ENCODED, "comment", Arrays.asList("#c1", "#c2"));
        c.set("S/b2", (Object)b, (Serializer)UonSerializer.DEFAULT, ConfigMod.ENCODED, "comment", Arrays.asList("#c1", "#c2"));
        c.set("T/c1", (Object)b, (Serializer)UonSerializer.DEFAULT, ConfigMod.ENCODED, "comment", Arrays.asList("#c1", "#c2"));
        TestUtils.assertTextEquals("#c1|#c2|a1* = {RhMWWFIFVksf} # comment|#c1|#c2|a2* = {RhMWWFIFVksf} # comment|#c1|#c2|a3* = {RhMWWFIFVksf} # comment|[S]|#c1|#c2|b1* = {RhMWWFIFVksf} # comment|#c1|#c2|b2* = {RhMWWFIFVksf} # comment|[T]|#c1|#c2|c1* = {RhMWWFIFVksf} # comment|", c.toString());
        c.commit();
        TestUtils.assertTextEquals("#c1|#c2|a1* = {RhMWWFIFVksf} # comment|#c1|#c2|a2* = {RhMWWFIFVksf} # comment|#c1|#c2|a3* = {RhMWWFIFVksf} # comment|[S]|#c1|#c2|b1* = {RhMWWFIFVksf} # comment|#c1|#c2|b2* = {RhMWWFIFVksf} # comment|[T]|#c1|#c2|c1* = {RhMWWFIFVksf} # comment|", c.toString());
        c = this.cb.build();
        TestUtils.assertTextEquals("#c1|#c2|a1* = {RhMWWFIFVksf} # comment|#c1|#c2|a2* = {RhMWWFIFVksf} # comment|#c1|#c2|a3* = {RhMWWFIFVksf} # comment|[S]|#c1|#c2|b1* = {RhMWWFIFVksf} # comment|#c1|#c2|b2* = {RhMWWFIFVksf} # comment|[T]|#c1|#c2|c1* = {RhMWWFIFVksf} # comment|", c.toString());
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("a1"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("a2"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("a3"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("S/b1"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("S/b2"));
        Assert.assertEquals((Object)"(foo=bar)", (Object)c.get("T/c1"));
    }

    @Test
    public void remove() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1");
        c.remove("a1");
        c.remove("a2");
        c.remove("a3");
        c.remove("S/b1");
        c.remove("T/c1");
        TestUtils.assertTextEquals("[S]|", c.toString());
        c.commit();
        TestUtils.assertTextEquals("[S]|", c.toString());
        c = this.cb.build();
        TestUtils.assertTextEquals("[S]|", c.toString());
    }

    @Test
    public void xgetString1() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1", "b2=");
        Assert.assertEquals((Object)"1", (Object)c.getString("a1"));
        Assert.assertEquals((Object)"2", (Object)c.getString("a2"));
        Assert.assertEquals(null, (Object)c.getString("a3"));
        Assert.assertEquals((Object)"1", (Object)c.getString("S/b1"));
        Assert.assertEquals((Object)"", (Object)c.getString("S/b2"));
        Assert.assertEquals(null, (Object)c.getString("S/b3"));
        Assert.assertEquals(null, (Object)c.getString("T/c1"));
    }

    @Test
    public void getString2() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1", "b2=");
        Assert.assertEquals((Object)"1", (Object)c.getString("a1", "foo"));
        Assert.assertEquals((Object)"2", (Object)c.getString("a2", "foo"));
        Assert.assertEquals((Object)"foo", (Object)c.getString("a3", "foo"));
        Assert.assertEquals((Object)"1", (Object)c.getString("S/b1", "foo"));
        Assert.assertEquals((Object)"foo", (Object)c.getString("S/b2", "foo"));
        Assert.assertEquals((Object)"foo", (Object)c.getString("S/b3", "foo"));
        Assert.assertEquals((Object)"foo", (Object)c.getString("T/c1", "foo"));
    }

    @Test
    public void getStringArray1() throws Exception {
        Config c = this.init("a1=1,2", "a2= 2 , 3 ", "[S]", "b1=1", "b2=");
        TestUtils.assertObjectEquals("['1','2']", c.getStringArray("a1"));
        TestUtils.assertObjectEquals("['2','3']", c.getStringArray("a2"));
        TestUtils.assertObjectEquals("[]", c.getStringArray("a3"));
        TestUtils.assertObjectEquals("['1']", c.getStringArray("S/b1"));
        TestUtils.assertObjectEquals("[]", c.getStringArray("S/b2"));
        TestUtils.assertObjectEquals("[]", c.getStringArray("S/b3"));
        TestUtils.assertObjectEquals("[]", c.getStringArray("T/c1"));
    }

    @Test
    public void getStringArray2() throws Exception {
        Config c = this.init("a1=1,2", "a2= 2 , 3 ", "[S]", "b1=1", "b2=");
        TestUtils.assertObjectEquals("['1','2']", c.getStringArray("a1", new String[]{"foo"}));
        TestUtils.assertObjectEquals("['2','3']", c.getStringArray("a2", new String[]{"foo"}));
        TestUtils.assertObjectEquals("['foo']", c.getStringArray("a3", new String[]{"foo"}));
        TestUtils.assertObjectEquals("['1']", c.getStringArray("S/b1", new String[]{"foo"}));
        TestUtils.assertObjectEquals("['foo']", c.getStringArray("S/b2", new String[]{"foo"}));
        TestUtils.assertObjectEquals("['foo']", c.getStringArray("S/b3", new String[]{"foo"}));
        TestUtils.assertObjectEquals("['foo']", c.getStringArray("T/c1", new String[]{"foo"}));
    }

    @Test
    public void getInt1() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1", "b2=");
        Assert.assertEquals((long)1L, (long)c.getInt("a1"));
        Assert.assertEquals((long)2L, (long)c.getInt("a2"));
        Assert.assertEquals((long)0L, (long)c.getInt("a3"));
        Assert.assertEquals((long)1L, (long)c.getInt("S/b1"));
        Assert.assertEquals((long)0L, (long)c.getInt("S/b2"));
        Assert.assertEquals((long)0L, (long)c.getInt("S/b3"));
        Assert.assertEquals((long)0L, (long)c.getInt("T/c1"));
    }

    @Test
    public void getInt1BadValues() throws Exception {
        Config c = this.init("a1=foo", "a2=2.3", "a3=[1]", "a4=false");
        try {
            c.getInt("a1");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getInt("a2");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getInt("a3");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getInt("a4");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void getInt2() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1", "b2=");
        Assert.assertEquals((long)1L, (long)c.getInt("a1", -1));
        Assert.assertEquals((long)2L, (long)c.getInt("a2", -1));
        Assert.assertEquals((long)-1L, (long)c.getInt("a3", -1));
        Assert.assertEquals((long)1L, (long)c.getInt("S/b1", -1));
        Assert.assertEquals((long)-1L, (long)c.getInt("S/b2", -1));
        Assert.assertEquals((long)-1L, (long)c.getInt("S/b3", -1));
        Assert.assertEquals((long)-1L, (long)c.getInt("T/c1", -1));
    }

    @Test
    public void getInt2BadValues() throws Exception {
        Config c = this.init("a1=foo", "a2=2.3", "a3=[1]", "a4=false");
        try {
            c.getInt("a1", -1);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getInt("a2", -1);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getInt("a3", -1);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getInt("a4", -1);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void getBoolean1() throws Exception {
        Config c = this.init("a1=true", "a2=false", "[S]", "b1=TRUE", "b2=");
        Assert.assertEquals((Object)true, (Object)c.getBoolean("a1"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a2"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a3"));
        Assert.assertEquals((Object)true, (Object)c.getBoolean("S/b1"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("S/b2"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("S/b3"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("T/c1"));
    }

    @Test
    public void getBoolean1BadValues() throws Exception {
        Config c = this.init("a1=foo", "a2=2.3", "a3=[1]", "a4=T");
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a1"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a2"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a3"));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a4"));
    }

    @Test
    public void getBoolean2() throws Exception {
        Config c = this.init("a1=true", "a2=false", "[S]", "b1=TRUE", "b2=");
        Assert.assertEquals((Object)true, (Object)c.getBoolean("a1", true));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a2", true));
        Assert.assertEquals((Object)true, (Object)c.getBoolean("a3", true));
        Assert.assertEquals((Object)true, (Object)c.getBoolean("S/b1", true));
        Assert.assertEquals((Object)true, (Object)c.getBoolean("S/b2", true));
        Assert.assertEquals((Object)true, (Object)c.getBoolean("S/b3", true));
        Assert.assertEquals((Object)true, (Object)c.getBoolean("T/c1", true));
    }

    @Test
    public void getBoolean2BadValues() throws Exception {
        Config c = this.init("a1=foo", "a2=2.3", "a3=[1]", "a4=T");
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a1", true));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a2", true));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a3", true));
        Assert.assertEquals((Object)false, (Object)c.getBoolean("a4", true));
    }

    @Test
    public void getLong1() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1", "b2=");
        Assert.assertEquals((long)1L, (long)c.getLong("a1"));
        Assert.assertEquals((long)2L, (long)c.getLong("a2"));
        Assert.assertEquals((long)0L, (long)c.getLong("a3"));
        Assert.assertEquals((long)1L, (long)c.getLong("S/b1"));
        Assert.assertEquals((long)0L, (long)c.getLong("S/b2"));
        Assert.assertEquals((long)0L, (long)c.getLong("S/b3"));
        Assert.assertEquals((long)0L, (long)c.getLong("T/c1"));
    }

    @Test
    public void getLong1BadValues() throws Exception {
        Config c = this.init("a1=foo", "a2=2.3", "a3=[1]", "a4=false");
        try {
            c.getLong("a1");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getLong("a2");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getLong("a3");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getLong("a4");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void getLong2() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1", "b2=");
        Assert.assertEquals((long)1L, (long)c.getLong("a1", Long.MAX_VALUE));
        Assert.assertEquals((long)2L, (long)c.getLong("a2", Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)c.getLong("a3", Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)c.getLong("S/b1", Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)c.getLong("S/b2", Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)c.getLong("S/b3", Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)c.getLong("T/c1", Long.MAX_VALUE));
    }

    @Test
    public void getLong2BadValues() throws Exception {
        Config c = this.init("a1=foo", "a2=2.3", "a3=[1]", "a4=false");
        try {
            c.getLong("a1", -1L);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getLong("a2", -1L);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getLong("a3", -1L);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            c.getLong("a4", -1L);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void getBytes1() throws Exception {
        Config c = this.init("a1=Zm9v", "a2=Zm", "\t9v", "a3=");
        TestUtils.assertObjectEquals("[102,111,111]", c.getBytes("a1"));
        TestUtils.assertObjectEquals("[102,111,111]", c.getBytes("a2"));
        TestUtils.assertObjectEquals("[]", c.getBytes("a3"));
        Assert.assertNull(null, (Object)c.getBytes("a4"));
    }

    @Test
    public void getBytes2() throws Exception {
        Config c = this.init("a1=Zm9v", "a2=Zm", "\t9v", "a3=");
        TestUtils.assertObjectEquals("[102,111,111]", c.getBytes("a1", new byte[]{1}));
        TestUtils.assertObjectEquals("[102,111,111]", c.getBytes("a2", new byte[]{1}));
        TestUtils.assertObjectEquals("[1]", c.getBytes("a3", new byte[]{1}));
        TestUtils.assertObjectEquals("[1]", c.getBytes("a4", new byte[]{1}));
    }

    @Test
    public void getObject1() throws Exception {
        Config c = this.init("a1={foo:123}", "a2=[{foo:123}]", "a3=", "a4=\t{", "\t foo : 123 /* comment */", "\t}");
        Map a1 = (Map)c.getObject("a1", Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        List a2a = (List)c.getObject("a2", List.class, new Type[]{Map.class, String.class, Integer.class});
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        List a2b = (List)c.getObject("a2", List.class, new Type[]{ABean.class});
        TestUtils.assertObjectEquals("[{foo:'123'}]", a2b);
        TestUtils.assertInstanceOf(ABean.class, a2b.get(0));
        Map a3 = (Map)c.getObject("a3", Map.class, new Type[]{String.class, Integer.class});
        Assert.assertNull((Object)a3);
        Map a4a = (Map)c.getObject("a4", Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        ABean a4b = (ABean)c.getObject("a4", ABean.class);
        TestUtils.assertObjectEquals("{foo:'123'}", a4b);
        TestUtils.assertInstanceOf(ABean.class, a4b);
    }

    @Test
    public void getObject2() throws Exception {
        Config c = this.init("a1=(foo=123)", "a2=@((foo=123))", "a3=", "a4=\t(", "\t foo = 123", "\t)");
        Map a1 = (Map)c.getObject("a1", (Parser)UonParser.DEFAULT, Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        List a2a = (List)c.getObject("a2", (Parser)UonParser.DEFAULT, List.class, new Type[]{Map.class, String.class, Integer.class});
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        List a2b = (List)c.getObject("a2", (Parser)UonParser.DEFAULT, List.class, new Type[]{ABean.class});
        TestUtils.assertObjectEquals("[{foo:'123'}]", a2b);
        TestUtils.assertInstanceOf(ABean.class, a2b.get(0));
        Map a3 = (Map)c.getObject("a3", (Parser)UonParser.DEFAULT, Map.class, new Type[]{String.class, Integer.class});
        Assert.assertNull((Object)a3);
        Map a4a = (Map)c.getObject("a4", (Parser)UonParser.DEFAULT, Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        ABean a4b = (ABean)c.getObject("a4", (Parser)UonParser.DEFAULT, ABean.class);
        TestUtils.assertObjectEquals("{foo:'123'}", a4b);
        TestUtils.assertInstanceOf(ABean.class, a4b);
    }

    @Test
    public void getObject3() throws Exception {
        Config c = this.init("a1={foo:123}", "a2=[{foo:123}]", "a3=", "a4=\t{", "\t foo : 123 /* comment */", "\t}");
        Map a1 = (Map)c.getObject("a1", Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        List a2a = (List)c.getObject("a2", List.class);
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        Map a3 = (Map)c.getObject("a3", Map.class);
        Assert.assertNull((Object)a3);
        Map a4a = (Map)c.getObject("a4", Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        ABean a4b = (ABean)c.getObject("a4", ABean.class);
        TestUtils.assertObjectEquals("{foo:'123'}", a4b);
        TestUtils.assertInstanceOf(ABean.class, a4b);
    }

    @Test
    public void getObject4() throws Exception {
        Config c = this.init("a1=(foo=123)", "a2=@((foo=123))", "a3=", "a4=\t(", "\t foo = 123", "\t)");
        Map a1 = (Map)c.getObject("a1", (Parser)UonParser.DEFAULT, Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        List a2a = (List)c.getObject("a2", (Parser)UonParser.DEFAULT, List.class);
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        Map a3 = (Map)c.getObject("a3", (Parser)UonParser.DEFAULT, Map.class);
        Assert.assertNull((Object)a3);
        Map a4a = (Map)c.getObject("a4", (Parser)UonParser.DEFAULT, Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        ABean a4b = (ABean)c.getObject("a4", (Parser)UonParser.DEFAULT, ABean.class);
        TestUtils.assertObjectEquals("{foo:'123'}", a4b);
        TestUtils.assertInstanceOf(ABean.class, a4b);
    }

    @Test
    public void getObjectWithDefault1() throws Exception {
        Config c = this.init("a1={foo:123}", "a2=[{foo:123}]", "a3=", "a4=\t{", "\t foo : 123 /* comment */", "\t}");
        Map a1 = (Map)c.getObjectWithDefault("a1", (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        Map a1b = (Map)c.getObjectWithDefault("a1b", (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{}", a1b);
        List a2a = (List)c.getObjectWithDefault("a2", (Object)new ObjectList(), List.class);
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        List a2b = (List)c.getObjectWithDefault("a2b", (Object)new ObjectList(), List.class);
        TestUtils.assertObjectEquals("[]", a2b);
        Map a3 = (Map)c.getObjectWithDefault("a3", (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{}", a3);
        Map a4a = (Map)c.getObjectWithDefault("a4", (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        Map a4b = (Map)c.getObjectWithDefault("a4b", (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{}", a4b);
        ABean a4c = (ABean)c.getObjectWithDefault("a4c", (Object)new ABean().init(), ABean.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", a4c);
        TestUtils.assertInstanceOf(ABean.class, a4c);
    }

    @Test
    public void getObjectWithDefault2() throws Exception {
        Config c = this.init("a1=(foo=123)", "a2=@((foo=123))", "a3=", "a4=\t(", "\t foo = 123", "\t)");
        Map a1 = (Map)c.getObjectWithDefault("a1", (Parser)UonParser.DEFAULT, (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        Map a1b = (Map)c.getObjectWithDefault("a1b", (Parser)UonParser.DEFAULT, (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{}", a1b);
        List a2a = (List)c.getObjectWithDefault("a2", (Parser)UonParser.DEFAULT, (Object)new ObjectList(), List.class);
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        List a2b = (List)c.getObjectWithDefault("a2b", (Parser)UonParser.DEFAULT, (Object)new ObjectList(), List.class);
        TestUtils.assertObjectEquals("[]", a2b);
        Map a3 = (Map)c.getObjectWithDefault("a3", (Parser)UonParser.DEFAULT, (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{}", a3);
        Map a4a = (Map)c.getObjectWithDefault("a4", (Parser)UonParser.DEFAULT, (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        Map a4b = (Map)c.getObjectWithDefault("a4b", (Parser)UonParser.DEFAULT, (Object)new ObjectMap(), Map.class);
        TestUtils.assertObjectEquals("{}", a4b);
        ABean a4c = (ABean)c.getObjectWithDefault("a4c", (Parser)UonParser.DEFAULT, (Object)new ABean().init(), ABean.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", a4c);
        TestUtils.assertInstanceOf(ABean.class, a4c);
    }

    @Test
    public void getObjectWithDefault3() throws Exception {
        Config c = this.init("a1={foo:123}", "a2=[{foo:123}]", "a3=", "a4=\t{", "\t foo : 123 /* comment */", "\t}");
        Map a1 = (Map)c.getObjectWithDefault("a1", new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        Map a1b = (Map)c.getObjectWithDefault("a1b", new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{}", a1b);
        List a2a = (List)c.getObjectWithDefault("a2", new ArrayList(), List.class, new Type[]{Map.class, String.class, Integer.class});
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        List a2b = (List)c.getObjectWithDefault("a2b", new ArrayList(), List.class, new Type[]{ABean.class});
        TestUtils.assertObjectEquals("[]", a2b);
        Map a3 = (Map)c.getObjectWithDefault("a3", (Object)new ObjectMap(), Map.class, new Type[]{String.class, Object.class});
        TestUtils.assertObjectEquals("{}", a3);
        Map a4a = (Map)c.getObjectWithDefault("a4", new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        Map a4b = (Map)c.getObjectWithDefault("a4b", new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{}", a4b);
        ABean a4c = (ABean)c.getObjectWithDefault("a4c", (Object)new ABean().init(), ABean.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", a4c);
        TestUtils.assertInstanceOf(ABean.class, a4c);
    }

    @Test
    public void getObjectWithDefault4() throws Exception {
        Config c = this.init("a1=(foo=123)", "a2=@((foo=123))", "a3=", "a4=\t(", "\t foo = 123", "\t)");
        Map a1 = (Map)c.getObjectWithDefault("a1", (Parser)UonParser.DEFAULT, new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a1);
        TestUtils.assertInstanceOf(String.class, a1.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a1.values().iterator().next());
        Map a1b = (Map)c.getObjectWithDefault("a1b", (Parser)UonParser.DEFAULT, new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{}", a1b);
        List a2a = (List)c.getObjectWithDefault("a2", (Parser)UonParser.DEFAULT, new ArrayList(), List.class, new Type[]{Map.class, String.class, Integer.class});
        TestUtils.assertObjectEquals("[{foo:123}]", a2a);
        TestUtils.assertInstanceOf(String.class, ((Map)a2a.get(0)).keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, ((Map)a2a.get(0)).values().iterator().next());
        List a2b = (List)c.getObjectWithDefault("a2b", (Parser)UonParser.DEFAULT, new ArrayList(), List.class, new Type[]{ABean.class});
        TestUtils.assertObjectEquals("[]", a2b);
        Map a3 = (Map)c.getObjectWithDefault("a3", (Parser)UonParser.DEFAULT, (Object)new ObjectMap(), Map.class, new Type[]{String.class, Object.class});
        TestUtils.assertObjectEquals("{}", a3);
        Map a4a = (Map)c.getObjectWithDefault("a4", (Parser)UonParser.DEFAULT, new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{foo:123}", a4a);
        TestUtils.assertInstanceOf(String.class, a4a.keySet().iterator().next());
        TestUtils.assertInstanceOf(Integer.class, a4a.values().iterator().next());
        Map a4b = (Map)c.getObjectWithDefault("a4b", (Parser)UonParser.DEFAULT, new HashMap(), Map.class, new Type[]{String.class, Integer.class});
        TestUtils.assertObjectEquals("{}", a4b);
        ABean a4c = (ABean)c.getObjectWithDefault("a4c", (Parser)UonParser.DEFAULT, (Object)new ABean().init(), ABean.class);
        TestUtils.assertObjectEquals("{foo:'bar'}", a4c);
        TestUtils.assertInstanceOf(ABean.class, a4c);
    }

    @Test
    public void getKeys() throws Exception {
        Config c = this.init("a1=1", "a2=2", "[S]", "b1=1", "b2=");
        TestUtils.assertObjectEquals("['a1','a2']", c.getKeys(""));
        TestUtils.assertObjectEquals("['a1','a2']", c.getKeys(""));
        TestUtils.assertObjectEquals("['b1','b2']", c.getKeys("S"));
        Assert.assertTrue((boolean)c.getKeys("T").isEmpty());
        try {
            c.getKeys(null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getMessage());
        }
    }

    @Test
    public void writeProperties() throws Exception {
        ABean a = new ABean().init();
        BBean b = new BBean().init();
        Config c = this.init("foo=qux", "[S]", "foo=baz", "bar=baz");
        c.writeProperties("S", (Object)a, true);
        TestUtils.assertObjectEquals("{foo:'baz'}", a);
        c.writeProperties("S", (Object)b, true);
        TestUtils.assertObjectEquals("{foo:'baz'}", b);
        try {
            c.writeProperties("S", (Object)a, false);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Unknown property 'bar' encountered in configuration section 'S'.", (Object)e.getMessage());
        }
        try {
            c.writeProperties("S", (Object)b, false);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Unknown property 'bar' encountered in configuration section 'S'.", (Object)e.getMessage());
        }
        try {
            c.writeProperties("T", (Object)a, false);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Section 'T' not found in configuration.", (Object)e.getMessage());
        }
        c.writeProperties("", (Object)b, true);
        TestUtils.assertObjectEquals("{foo:'qux'}", b);
        c.writeProperties("", (Object)a, true);
        TestUtils.assertObjectEquals("{foo:'qux'}", a);
        try {
            c.writeProperties(null, (Object)a, true);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void getSectionAsBean1() throws Exception {
        Config c = this.init("foo=qux", "[S]", "foo=baz", "[T]", "foo=qux", "bar=qux");
        ABean a = null;
        BBean b = null;
        a = (ABean)c.getSectionAsBean("", ABean.class);
        TestUtils.assertObjectEquals("{foo:'qux'}", a);
        a = (ABean)c.getSectionAsBean("", ABean.class);
        TestUtils.assertObjectEquals("{foo:'qux'}", a);
        a = (ABean)c.getSectionAsBean("S", ABean.class);
        TestUtils.assertObjectEquals("{foo:'baz'}", a);
        b = (BBean)c.getSectionAsBean("", BBean.class);
        TestUtils.assertObjectEquals("{foo:'qux'}", b);
        b = (BBean)c.getSectionAsBean("", BBean.class);
        TestUtils.assertObjectEquals("{foo:'qux'}", b);
        b = (BBean)c.getSectionAsBean("S", BBean.class);
        TestUtils.assertObjectEquals("{foo:'baz'}", b);
        try {
            a = (ABean)c.getSectionAsBean("T", ABean.class);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Unknown property 'bar' encountered in configuration section 'T'.", (Object)e.getMessage());
        }
        try {
            b = (BBean)c.getSectionAsBean("T", BBean.class);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Unknown property 'bar' encountered in configuration section 'T'.", (Object)e.getMessage());
        }
        try {
            a = (ABean)c.getSectionAsBean("U", ABean.class);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Section 'U' not found in configuration.", (Object)e.getMessage());
        }
        try {
            c.getSectionAsBean(null, ABean.class);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getMessage());
        }
        try {
            c.getSectionAsBean(null, BBean.class);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getMessage());
        }
    }

    @Test
    public void getSectionAsBean2() throws Exception {
        Config c = this.init("foo=qux", "[S]", "foo=baz", "[T]", "foo=qux", "bar=qux");
        ABean a = null;
        BBean b = null;
        a = (ABean)c.getSectionAsBean("T", ABean.class, true);
        TestUtils.assertObjectEquals("{foo:'qux'}", a);
        b = (BBean)c.getSectionAsBean("T", BBean.class, true);
        TestUtils.assertObjectEquals("{foo:'qux'}", b);
        try {
            a = (ABean)c.getSectionAsBean("T", ABean.class, false);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Unknown property 'bar' encountered in configuration section 'T'.", (Object)e.getMessage());
        }
        try {
            b = (BBean)c.getSectionAsBean("T", BBean.class, false);
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Unknown property 'bar' encountered in configuration section 'T'.", (Object)e.getMessage());
        }
        try {
            a = (ABean)c.getSectionAsBean("U", ABean.class, true);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Section 'U' not found in configuration.", (Object)e.getMessage());
        }
    }

    @Test
    public void getSectionAsMap() throws Exception {
        Config c = this.init("a=1", "[S]", "b=2", "[T]");
        TestUtils.assertObjectEquals("{a:'1'}", c.getSectionAsMap(""));
        TestUtils.assertObjectEquals("{a:'1'}", c.getSectionAsMap(""));
        TestUtils.assertObjectEquals("{b:'2'}", c.getSectionAsMap("S"));
        TestUtils.assertObjectEquals("{}", c.getSectionAsMap("T"));
        Assert.assertNull((Object)c.getSectionAsMap("U"));
        try {
            c.getSectionAsMap(null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void getSectionAsInterface() throws Exception {
        Config c = this.init("foo=qux", "[S]", "foo=baz", "[T]", "foo=qux", "bar=qux");
        AInterface a = null;
        a = (AInterface)c.getSectionAsInterface("", AInterface.class);
        Assert.assertEquals((Object)"qux", (Object)a.getFoo());
        a = (AInterface)c.getSectionAsInterface("", AInterface.class);
        Assert.assertEquals((Object)"qux", (Object)a.getFoo());
        a = (AInterface)c.getSectionAsInterface("S", AInterface.class);
        Assert.assertEquals((Object)"baz", (Object)a.getFoo());
        a = (AInterface)c.getSectionAsInterface("T", AInterface.class);
        Assert.assertEquals((Object)"qux", (Object)a.getFoo());
        try {
            c.getSectionAsInterface("T", ABean.class);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Class 'org.apache.juneau.config.ConfigTest$ABean' passed to getSectionAsInterface() is not an interface.", (Object)e.getMessage());
        }
        try {
            c.getSectionAsInterface(null, AInterface.class);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void exists() throws Exception {
        Config c = this.init("a=1", "[S]", "b=2", "c=", "[T]");
        Assert.assertTrue((boolean)c.exists("a"));
        Assert.assertFalse((boolean)c.exists("b"));
        Assert.assertTrue((boolean)c.exists("S/b"));
        Assert.assertFalse((boolean)c.exists("S/c"));
        Assert.assertFalse((boolean)c.exists("T/d"));
        Assert.assertFalse((boolean)c.exists("U/e"));
    }

    @Test
    public void setSection1() throws Exception {
        Config c = this.init(new String[0]);
        c.setSection("", Arrays.asList("#C1", "#C2"));
        TestUtils.assertTextEquals("#C1|#C2||", c);
        c.setSection("", Arrays.asList("#C3", "#C4"));
        TestUtils.assertTextEquals("#C3|#C4||", c);
        c.setSection("S1", Arrays.asList("", "#C5", "#C6"));
        TestUtils.assertTextEquals("#C3|#C4|||#C5|#C6|[S1]|", c);
        c.setSection("S1", null);
        TestUtils.assertTextEquals("#C3|#C4|||#C5|#C6|[S1]|", c);
        c.setSection("S1", Collections.emptyList());
        TestUtils.assertTextEquals("#C3|#C4||[S1]|", c);
        try {
            c.setSection(null, Arrays.asList("", "#C5", "#C6"));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void setSection2() throws Exception {
        Config c = this.init(new String[0]);
        ObjectMap m = new ObjectMap().append("a", (Object)"b");
        c.setSection("", Arrays.asList("#C1", "#C2"), (Map)m);
        TestUtils.assertTextEquals("#C1|#C2||a = b|", c);
        c.setSection("", Arrays.asList("#C3", "#C4"), (Map)m);
        TestUtils.assertTextEquals("#C3|#C4||a = b|", c);
        c.setSection("S1", Arrays.asList("", "#C5", "#C6"), (Map)m);
        TestUtils.assertTextEquals("#C3|#C4||a = b||#C5|#C6|[S1]|a = b|", c);
        c.setSection("S1", null, (Map)m);
        TestUtils.assertTextEquals("#C3|#C4||a = b||#C5|#C6|[S1]|a = b|", c);
        c.setSection("S1", Collections.emptyList(), (Map)m);
        TestUtils.assertTextEquals("#C3|#C4||a = b|[S1]|a = b|", c);
        try {
            c.setSection(null, Arrays.asList("", "#C5", "#C6"), (Map)m);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Field 'section' cannot be null.", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void removeSection() throws Exception {
        Config c = this.init("a=1", "[S]", "b=2", "c=", "[T]");
        c.removeSection("S");
        c.removeSection("T");
        TestUtils.assertTextEquals("a=1|", c);
        c.removeSection("");
        TestUtils.assertTextEquals("", c);
    }

    @Test
    public void writeTo() throws Exception {
        Config c = this.init("a=1", "[S]", "b=2", "c=", "[T]");
        TestUtils.assertTextEquals("a=1|[S]|b=2|c=|[T]|", c.writeTo((Writer)new StringWriter()).toString());
    }

    @Test
    public void testExampleInConfig() throws Exception {
        Config cf = this.init("# Default section", "key1 = 1", "key2 = true", "key3 = [1,2,3]", "key4 = http://foo", "", "# section1", "# Section 1", "[section1]", "key1 = 2", "key2 = false", "key3 = [4,5,6]", "key4 = http://bar");
        Assert.assertEquals((long)1L, (long)cf.getInt("key1"));
        Assert.assertEquals((Object)true, (Object)cf.getBoolean("key2"));
        Assert.assertEquals((long)3L, (long)((int[])cf.getObject("key3", int[].class))[2]);
        Assert.assertEquals((long)6L, (long)((int[])cf.getObjectWithDefault("xkey3", (Object)new int[]{4, 5, 6}, int[].class))[2]);
        Assert.assertEquals((long)6L, (long)((int[])cf.getObjectWithDefault("X/key3", (Object)new int[]{4, 5, 6}, int[].class))[2]);
        Assert.assertEquals((Object)new URL("http://foo").toString(), (Object)((URL)cf.getObject("key4", URL.class)).toString());
        Assert.assertEquals((long)2L, (long)cf.getInt("section1/key1"));
        Assert.assertEquals((Object)false, (Object)cf.getBoolean("section1/key2"));
        Assert.assertEquals((long)6L, (long)((int[])cf.getObject("section1/key3", int[].class))[2]);
        Assert.assertEquals((Object)new URL("http://bar").toString(), (Object)((URL)cf.getObject("section1/key4", URL.class)).toString());
        cf = this.init("# Default section", "[section1]", "# Section 1");
        cf.set("key1", (Object)1);
        cf.set("key2", (Object)true);
        cf.set("key3", (Object)new int[]{1, 2, 3});
        cf.set("key4", (Object)new URL("http://foo"));
        cf.set("section1/key1", (Object)2);
        cf.set("section1/key2", (Object)false);
        cf.set("section1/key3", (Object)new int[]{4, 5, 6});
        cf.set("section1/key4", (Object)new URL("http://bar"));
        cf.commit();
        Assert.assertEquals((long)1L, (long)cf.getInt("key1"));
        Assert.assertEquals((Object)true, (Object)cf.getBoolean("key2"));
        Assert.assertEquals((long)3L, (long)((int[])cf.getObject("key3", int[].class))[2]);
        Assert.assertEquals((Object)new URL("http://foo").toString(), (Object)((URL)cf.getObject("key4", URL.class)).toString());
        Assert.assertEquals((long)2L, (long)cf.getInt("section1/key1"));
        Assert.assertEquals((Object)false, (Object)cf.getBoolean("section1/key2"));
        Assert.assertEquals((long)6L, (long)((int[])cf.getObject("section1/key3", int[].class))[2]);
        Assert.assertEquals((Object)new URL("http://bar").toString(), (Object)((URL)cf.getObject("section1/key4", URL.class)).toString());
    }

    @Test
    public void testEnum() throws Exception {
        Config cf = this.init("key1 = MINUTES");
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)cf.getObject("key1", TimeUnit.class));
        cf.commit();
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)cf.getObject("key1", TimeUnit.class));
    }

    @Test
    public void testEncodedValues() throws Exception {
        Config cf = this.init("[s1]", "", "foo* = ");
        cf.set("s1/foo", "mypassword");
        Assert.assertEquals((Object)"mypassword", (Object)cf.getString("s1/foo"));
        cf.commit();
        String expected = "[s1]||foo* = {AwwJVhwUQFZEMg==}|";
        TestUtils.assertTextEquals(expected, cf);
        Assert.assertEquals((Object)"mypassword", (Object)cf.getString("s1/foo"));
        cf.load((Reader)new StringReader("[s1]\nfoo* = mypassword2\n"), true);
        Assert.assertEquals((Object)"mypassword2", (Object)cf.getString("s1/foo"));
        cf.set("s1/foo", "mypassword");
        StringWriter sw = new StringWriter();
        cf.writeTo((Writer)new PrintWriter(sw));
        expected = "[s1]|foo* = {AwwJVhwUQFZEMg==}|";
        TestUtils.assertTextEquals(expected, sw);
    }

    @Test
    public void testEncodeEntries() throws Exception {
        Config cf = this.init("[s1]", "", "foo* = mypassword");
        cf.encodeEntries();
        cf.commit();
        String expected = "[s1]||foo* = {AwwJVhwUQFZEMg==}|";
        TestUtils.assertTextEquals(expected, ConfigMemoryStore.DEFAULT.read("Test.cfg"));
    }

    @Test
    public void testVariables() throws Exception {
        Config cf = this.init("[s1]", "f1 = $S{foo}", "f2 = $S{foo,bar}", "f3 = $S{$S{baz,bing},bar}");
        System.getProperties().remove("foo");
        System.getProperties().remove("bar");
        System.getProperties().remove("baz");
        System.getProperties().remove("bing");
        Assert.assertEquals((Object)"", (Object)cf.getString("s1/f1"));
        Assert.assertEquals((Object)"bar", (Object)cf.getString("s1/f2"));
        Assert.assertEquals((Object)"bar", (Object)cf.getString("s1/f3"));
        System.setProperty("foo", "123");
        Assert.assertEquals((Object)"123", (Object)cf.getString("s1/f1"));
        Assert.assertEquals((Object)"123", (Object)cf.getString("s1/f2"));
        Assert.assertEquals((Object)"bar", (Object)cf.getString("s1/f3"));
        System.setProperty("foo", "$S{bar}");
        System.setProperty("bar", "baz");
        Assert.assertEquals((Object)"baz", (Object)cf.getString("s1/f1"));
        Assert.assertEquals((Object)"baz", (Object)cf.getString("s1/f2"));
        Assert.assertEquals((Object)"bar", (Object)cf.getString("s1/f3"));
        System.setProperty("bing", "$S{foo}");
        Assert.assertEquals((Object)"baz", (Object)cf.getString("s1/f3"));
        System.setProperty("baz", "foo");
        System.setProperty("foo", "123");
        Assert.assertEquals((Object)"123", (Object)cf.getString("s1/f3"));
    }

    @Test
    public void testXorEncoder() throws Exception {
        this.testXor("foo");
        this.testXor("");
        this.testXor("123");
        this.testXor("\u20ac");
        this.testXor("\ud852\udf62");
    }

    private void testXor(String in) {
        ConfigXorEncoder e = new ConfigXorEncoder();
        String s = e.encode("", in);
        String s2 = e.decode("", s);
        Assert.assertEquals((Object)in, (Object)s2);
    }

    @Test
    public void testHex() throws Exception {
        Config cf = this.init(new String[0]).builder().binaryFormat(BinaryFormat.HEX).build();
        cf.set("foo", (Object)"bar".getBytes("UTF-8"));
        Assert.assertEquals((Object)"626172", (Object)cf.get("foo"));
        TestUtils.assertObjectEquals("[98,97,114]", cf.getBytes("foo"));
    }

    @Test
    public void testSpacedHex() throws Exception {
        Config cf = this.init(new String[0]).builder().binaryFormat(BinaryFormat.SPACED_HEX).build();
        cf.set("foo", (Object)"bar".getBytes("UTF-8"));
        Assert.assertEquals((Object)"62 61 72", (Object)cf.get("foo"));
        TestUtils.assertObjectEquals("[98,97,114]", cf.getBytes("foo"));
    }

    @Test
    public void testMultiLines() throws Exception {
        Config cf = this.init("[s1]", "f1 = x \n\ty \n\tz");
        Assert.assertEquals((Object)"x \ny \nz", (Object)cf.getString("s1/f1"));
        StringWriter sw = new StringWriter();
        cf.writeTo((Writer)sw);
        String expected = "[s1]|f1 = x |\ty |\tz|";
        TestUtils.assertTextEquals(expected, sw);
    }

    @Test
    public void testNumberShortcuts() throws Exception {
        Config cf = this.init("[s1]", "f1 = 1M", "f2 = 1K", "f3 = 1 M", "f4 = 1 K");
        Assert.assertEquals((long)0x100000L, (long)cf.getInt("s1/f1"));
        Assert.assertEquals((long)1024L, (long)cf.getInt("s1/f2"));
        Assert.assertEquals((long)0x100000L, (long)cf.getInt("s1/f3"));
        Assert.assertEquals((long)1024L, (long)cf.getInt("s1/f4"));
    }

    @Test
    public void testListeners() throws Exception {
        Config cf = this.init(new String[0]);
        final TreeSet changes = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        cf.addListener(new ConfigEventListener(){

            public void onConfigChange(ConfigEvents events) {
                for (ConfigEvent ce : events) {
                    String key = (ce.getSection().equals("") ? "" : ce.getSection() + '/') + ce.getKey();
                    if (ce.getType() == ConfigEventType.REMOVE_ENTRY) {
                        changes.add("REMOVE_ENTRY(" + key + ")");
                        continue;
                    }
                    if (ce.getType() == ConfigEventType.REMOVE_SECTION) {
                        changes.add("REMOVE_SECTION(" + ce.getSection() + ")");
                        continue;
                    }
                    if (ce.getType() == ConfigEventType.SET_SECTION) {
                        changes.add("SET_SECTION(" + ce.getSection() + ")");
                        continue;
                    }
                    changes.add(key + '=' + ce.getValue());
                }
            }
        });
        changes.clear();
        cf.set("a1", (Object)3);
        cf.set("a3", (Object)3);
        cf.set("B/b1", (Object)3);
        cf.set("B/b3", (Object)3);
        TestUtils.assertObjectEquals("[]", changes);
        cf.commit();
        TestUtils.assertObjectEquals("['a1=3','a3=3','B/b1=3','B/b3=3']", changes);
        changes.clear();
        cf.set("a1", (Object)3);
        cf.set("a3", (Object)3);
        cf.set("B/b1", (Object)3);
        cf.set("B/b3", (Object)3);
        TestUtils.assertObjectEquals("[]", changes);
        cf.rollback();
        cf.commit();
        TestUtils.assertObjectEquals("[]", changes);
        changes.clear();
        cf.set("a1", "2");
        cf.set("B/b1", "2");
        cf.set("a2", "2");
        cf.set("B/b2", "2");
        cf.set("C/c1", "2");
        cf.set("C/c2", "2");
        cf.commit();
        TestUtils.assertObjectEquals("['a1=2','a2=2','B/b1=2','B/b2=2','C/c1=2','C/c2=2']", changes);
        changes.clear();
        cf.set("a4", (Object)"4", null, ConfigMod.ENCODED, null, null);
        cf.set("B/b4", (Object)"4", null, ConfigMod.ENCODED, null, null);
        cf.commit();
        TestUtils.assertObjectEquals("['a4={Wg==}','B/b4={Wg==}']", changes);
        changes.clear();
        cf.set("a4", "5");
        cf.set("B/b4", "5");
        cf.commit();
        TestUtils.assertObjectEquals("['a4={Ww==}','B/b4={Ww==}']", changes);
        changes.clear();
        cf.remove("a4");
        cf.remove("ax");
        cf.remove("B/b4");
        cf.remove("B/bx");
        cf.remove("X/bx");
        cf.commit();
        TestUtils.assertObjectEquals("['REMOVE_ENTRY(a4)','REMOVE_ENTRY(B/b4)']", changes);
        changes.clear();
        cf.setSection("D", Arrays.asList("#comment"));
        cf.commit();
        TestUtils.assertObjectEquals("[]", changes);
        changes.clear();
        cf.setSection("E", null, (Map)new AMap().append((Object)"e1", (Object)"1").append((Object)"e2", (Object)"2"));
        cf.commit();
        TestUtils.assertObjectEquals("['E/e1=1','E/e2=2']", changes);
        changes.clear();
        cf.removeSection("E");
        cf.commit();
        TestUtils.assertObjectEquals("['REMOVE_ENTRY(E/e1)','REMOVE_ENTRY(E/e2)']", changes);
        changes.clear();
        cf.removeSection("E");
        cf.commit();
        TestUtils.assertObjectEquals("[]", changes);
    }

    @Test
    public void testGetObjectArray() throws Exception {
        Config cf = this.init("[A]", "a1=[1,2,3]");
        TestUtils.assertObjectEquals("[1,2,3]", cf.getObject("A/a1", Integer[].class));
        TestUtils.assertObjectEquals("[4,5,6]", cf.getObjectWithDefault("A/a2", (Object)new Integer[]{4, 5, 6}, Integer[].class));
        TestUtils.assertObjectEquals("[7,8,9]", cf.getObjectWithDefault("B/a1", (Object)new Integer[]{7, 8, 9}, Integer[].class));
        Assert.assertNull((Object)cf.getObject("B/a1", Integer[].class));
        cf = this.init("[A]", "a1 = [1 ,\n\t2 ,\n\t3] ");
        TestUtils.assertObjectEquals("[1,2,3]", cf.getObject("A/a1", Integer[].class));
        TestUtils.assertObjectEquals("[1,2,3]", cf.getObject("A/a1", int[].class));
        Assert.assertEquals((Object)"int", (Object)((int[])cf.getObject("A/a1", int[].class)).getClass().getComponentType().getSimpleName());
        Assert.assertNull((Object)cf.getObject("B/a1", int[].class));
        Assert.assertEquals((Object)"int", (Object)((int[])cf.getObjectWithDefault("B/a1", (Object)new int[0], int[].class)).getClass().getComponentType().getSimpleName());
        Assert.assertNull((Object)cf.getObject("A/a2", int[].class));
        Assert.assertEquals((Object)"int", (Object)((int[])cf.getObjectWithDefault("A/a2", (Object)new int[0], int[].class)).getClass().getComponentType().getSimpleName());
        TestUtils.assertObjectEquals("[1,2,3]", cf.getObjectWithDefault("A/a1", (Object)new int[]{4}, int[].class));
        Assert.assertEquals((Object)"int", (Object)((int[])cf.getObjectWithDefault("A/a1", (Object)new int[]{4}, int[].class)).getClass().getComponentType().getSimpleName());
        TestUtils.assertObjectEquals("[4]", cf.getObjectWithDefault("B/a1", (Object)new int[]{4}, int[].class));
        Assert.assertEquals((Object)"int", (Object)((int[])cf.getObjectWithDefault("B/a1", (Object)new int[]{4}, int[].class)).getClass().getComponentType().getSimpleName());
        TestUtils.assertObjectEquals("[4]", cf.getObjectWithDefault("A/a2", (Object)new int[]{4}, int[].class));
        Assert.assertEquals((Object)"int", (Object)((int[])cf.getObjectWithDefault("A/a2", (Object)new int[]{4}, int[].class)).getClass().getComponentType().getSimpleName());
        System.setProperty("X", "[4,5,6]");
        cf = this.init("x1=$C{A/a1}", "x2=$S{X}", "x3=$S{Y}", "[A]", "a1=[1,2,3]");
        TestUtils.assertObjectEquals("[1,2,3]", cf.getObjectWithDefault("x1", (Object)new int[]{9}, int[].class));
        TestUtils.assertObjectEquals("[4,5,6]", cf.getObjectWithDefault("x2", (Object)new int[]{9}, int[].class));
        TestUtils.assertObjectEquals("[9]", cf.getObjectWithDefault("x3", (Object)new int[]{9}, int[].class));
        System.clearProperty("X");
    }

    @Test
    public void testGetStringArray() throws Exception {
        Config cf = this.init("[A]", "a1=1,2,3");
        TestUtils.assertObjectEquals("['1','2','3']", cf.getStringArray("A/a1"));
        TestUtils.assertObjectEquals("['4','5','6']", cf.getStringArray("A/a2", new String[]{"4", "5", "6"}));
        TestUtils.assertObjectEquals("['7','8','9']", cf.getStringArray("B/a1", new String[]{"7", "8", "9"}));
        TestUtils.assertObjectEquals("[]", cf.getStringArray("B/a1"));
        cf = this.init("[A]", "a1 = 1 ,\n\t2 ,\n\t3 ");
        TestUtils.assertObjectEquals("['1','2','3']", cf.getStringArray("A/a1"));
        System.setProperty("X", "4,5,6");
        cf = this.init(null, "x1=$C{A/a1}", "x2=$S{X}", "x3=$S{Y}", "x4=$S{Y,$S{X}}", "[A]", "a1=1,2,3");
        TestUtils.assertObjectEquals("['1','2','3']", cf.getStringArray("x1", new String[]{"9"}));
        TestUtils.assertObjectEquals("['4','5','6']", cf.getStringArray("x2", new String[]{"9"}));
        TestUtils.assertObjectEquals("['9']", cf.getStringArray("x3", new String[]{"9"}));
        System.clearProperty("X");
    }

    @Test
    public void testGetSectionMap() throws Exception {
        Config cf = this.init("[A]", "a1=1", "", "[D]", "d1=$C{A/a1}", "d2=$S{X}");
        TestUtils.assertObjectEquals("{a1:'1'}", cf.getSectionAsMap("A"));
        Assert.assertNull((Object)cf.getSectionAsMap("B"));
        TestUtils.assertObjectEquals("null", cf.getSectionAsMap("C"));
        ObjectMap m = cf.getSectionAsMap("A");
        TestUtils.assertObjectEquals("{a1:'1'}", m);
        System.setProperty("X", "x");
        m = cf.getSectionAsMap("D");
        TestUtils.assertObjectEquals("{d1:'1',d2:'x'}", m);
        System.clearProperty("X");
    }

    @Test
    public void testToWritable() throws Exception {
        Config cf = this.init("a = b");
        StringWriter sw = new StringWriter();
        cf.writeTo((Writer)sw);
        TestUtils.assertTextEquals("a = b|", sw);
        Assert.assertEquals((Object)"text/plain", (Object)cf.getMediaType().toString());
    }

    @Test
    public void testResolvingWithOverride() throws Exception {
        Config cf = this.init(new String[0]);
        cf.set("a", "$A{X}");
        cf.set("b", "$B{X}");
        cf.set("c", "$A{$B{X}}");
        cf.set("d", "$B{$A{X}}");
        cf.set("e", "$D{X}");
        VarResolver vr = new VarResolverBuilder().defaultVars().vars(new Class[]{ALVar.class, BLVar.class}).build();
        cf = cf.resolving(vr.createSession());
        Assert.assertEquals((Object)"aXa", (Object)cf.getString("a"));
        Assert.assertEquals((Object)"bXb", (Object)cf.getString("b"));
        Assert.assertEquals((Object)"abXba", (Object)cf.getString("c"));
        Assert.assertEquals((Object)"baXab", (Object)cf.getString("d"));
        Assert.assertEquals((Object)"$D{X}", (Object)cf.getString("e"));
        VarResolver vr2 = vr.builder().vars(new Class[]{AUVar.class, DUVar.class}).build();
        cf = cf.resolving(vr2.createSession());
        Assert.assertEquals((Object)"AXA", (Object)cf.getString("a"));
        Assert.assertEquals((Object)"bXb", (Object)cf.getString("b"));
        Assert.assertEquals((Object)"AbXbA", (Object)cf.getString("c"));
        Assert.assertEquals((Object)"bAXAb", (Object)cf.getString("d"));
        Assert.assertEquals((Object)"DXD", (Object)cf.getString("e"));
    }

    @Test
    public void testPoundSignEscape() throws Exception {
        Config cf = this.init(new String[0]);
        cf.set("a", "a,#b,=c");
        cf.set("A/a", "a,#b,=c");
        TestUtils.assertTextEquals("a = a,\\u0023b,=c|[A]|a = a,\\u0023b,=c|", cf);
        cf.commit();
        TestUtils.assertTextEquals("a = a,\\u0023b,=c|[A]|a = a,\\u0023b,=c|", cf);
        Assert.assertEquals((Object)"a,#b,=c", (Object)cf.getString("a"));
        Assert.assertEquals((Object)"a,#b,=c", (Object)cf.getString("A/a"));
        cf.set("a", (Object)"a,#b,=c", null, (ConfigMod)null, "comment#comment", null);
        TestUtils.assertTextEquals("a = a,\\u0023b,=c # comment#comment|[A]|a = a,\\u0023b,=c|", cf);
        Assert.assertEquals((Object)"a,#b,=c", (Object)cf.getString("a"));
    }

    @Test
    public void testGetCandidateSystemDefaultConfigNames() {
        System.setProperty("juneau.configFile", "foo.txt");
        TestUtils.assertObjectEquals("['foo.txt']", Config.getCandidateSystemDefaultConfigNames());
        System.clearProperty("juneau.configFile");
        TestUtils.assertObjectEquals("['test.cfg','juneau.cfg','default.cfg','application.cfg','app.cfg','settings.cfg','application.properties']", Config.getCandidateSystemDefaultConfigNames());
    }

    @Test
    public void setSystemProperties() throws Exception {
        Config c = this.init("a=1", "[S]", "b=2");
        c.setSystemProperties();
        Assert.assertEquals((Object)"1", (Object)System.getProperty("a"));
        Assert.assertEquals((Object)"2", (Object)System.getProperty("S/b"));
    }

    public static class BBean {
        private String foo;

        public String getFoo() {
            return this.foo;
        }

        public BBean setFoo(String foo) {
            this.foo = foo;
            return this;
        }

        public BBean init() {
            this.foo = "bar";
            return this;
        }
    }

    public static class ABean {
        public String foo;

        public ABean init() {
            this.foo = "bar";
            return this;
        }
    }

    public static class DUVar
    extends SimpleVar {
        public DUVar() {
            super("D");
        }

        public String resolve(VarResolverSession session, String key) {
            return 'D' + key + 'D';
        }
    }

    public static class BLVar
    extends SimpleVar {
        public BLVar() {
            super("B");
        }

        public String resolve(VarResolverSession session, String key) {
            return 'b' + key + 'b';
        }
    }

    public static class AUVar
    extends SimpleVar {
        public AUVar() {
            super("A");
        }

        public String resolve(VarResolverSession session, String key) {
            return 'A' + key + 'A';
        }
    }

    public static class ALVar
    extends SimpleVar {
        public ALVar() {
            super("A");
        }

        public String resolve(VarResolverSession session, String key) {
            return 'a' + key + 'a';
        }
    }

    public static interface AInterface {
        public String getFoo();
    }
}

