/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.juneau.ConfigException;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.store.ConfigMemoryStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConfigMapTest {
    static final String ENCODED = "*";
    static final String BASE64 = "^";

    @Test
    public void testNonExistentConfig() throws Exception {
        ConfigMemoryStore s = ConfigMemoryStore.create().build();
        ConfigMap cm = s.getMap("Foo.cfg");
        Assert.assertEquals((Object)"", (Object)cm.toString());
    }

    @Test
    public void testBlankConfig() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "");
        ConfigMap cm = s.getMap("Foo.cfg");
        Assert.assertEquals((Object)"", (Object)cm.toString());
        s.update("Foo.cfg", "   \n   \n   ");
        cm = s.getMap("Foo.cfg");
    }

    @Test
    public void testSimpleOneLine() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "foo=bar");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("foo=bar|", cm);
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getPreLines(""), (char)'|'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getEntry("", "foo").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"bar", (Object)cm.getEntry("", "foo").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("foo=bar|", cm);
    }

    @Test
    public void testSimpleOneLineWithComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "#comment", "foo=bar");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#comment|foo=bar|", cm);
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getPreLines(""), (char)'|'));
        Assert.assertEquals((Object)"#comment", (Object)StringUtils.join((Collection)cm.getEntry("", "foo").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"bar", (Object)cm.getEntry("", "foo").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#comment|foo=bar|", cm);
    }

    @Test
    public void testSimpleSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[MySection]", "foo=bar");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[MySection]|foo=bar|", cm);
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getPreLines(""), (char)'|'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getPreLines("MySection"), (char)'|'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getEntry("MySection", "foo").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"bar", (Object)cm.getEntry("MySection", "foo").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[MySection]|foo=bar|", cm);
    }

    @Test
    public void testNonExistentValues() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[MySection]", "foo=bar");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[MySection]|foo=bar|", cm);
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getPreLines(""), (char)'|'));
        Assert.assertNull((Object)cm.getPreLines("XXX"));
        Assert.assertNull((Object)cm.getEntry("XXX", "yyy"));
        Assert.assertNull((Object)cm.getEntry("MySection", "yyy"));
    }

    @Test
    public void testSimpleSectionWithComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "#S1", "[S1]", "#k1", "k1=v1", "#S2", "[S2]", "#k2", "k2=v2");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#S1|[S1]|#k1|k1=v1|#S2|[S2]|#k2|k2=v2|", cm);
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getPreLines(""), (char)'|'));
        Assert.assertEquals((Object)"#S1", (Object)StringUtils.join((Collection)cm.getPreLines("S1"), (char)'|'));
        Assert.assertEquals((Object)"#k1", (Object)StringUtils.join((Collection)cm.getEntry("S1", "k1").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"#S2", (Object)StringUtils.join((Collection)cm.getPreLines("S2"), (char)'|'));
        Assert.assertEquals((Object)"#k2", (Object)StringUtils.join((Collection)cm.getEntry("S2", "k2").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"v1", (Object)cm.getEntry("S1", "k1").getValue());
        Assert.assertEquals((Object)"v2", (Object)cm.getEntry("S2", "k2").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#S1|[S1]|#k1|k1=v1|#S2|[S2]|#k2|k2=v2|", cm);
    }

    @Test
    public void testSimpleAndDefaultSectionsWithComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "#D", "", "#k", "k=v", "#S1", "[S1]", "#k1", "k1=v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#D||#k|k=v|#S1|[S1]|#k1|k1=v1|", cm);
        Assert.assertEquals((Object)"#D", (Object)StringUtils.join((Collection)cm.getPreLines(""), (char)'|'));
        Assert.assertEquals((Object)"#k", (Object)StringUtils.join((Collection)cm.getEntry("", "k").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"#S1", (Object)StringUtils.join((Collection)cm.getPreLines("S1"), (char)'|'));
        Assert.assertEquals((Object)"#k1", (Object)StringUtils.join((Collection)cm.getEntry("S1", "k1").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"v", (Object)cm.getEntry("", "k").getValue());
        Assert.assertEquals((Object)"v1", (Object)cm.getEntry("S1", "k1").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#D||#k|k=v|#S1|[S1]|#k1|k1=v1|", cm);
    }

    @Test
    public void testSimpleAndDefaultSectionsWithCommentsAndExtraSpaces() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "#Da", "#Db", "", "#ka", "", "#kb", "", "k=v", "", "#S1a", "", "#S1b", "", "[S1]", "", "#k1a", "", "#k1b", "", "k1=v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#Da|#Db||#ka||#kb||k=v||#S1a||#S1b||[S1]||#k1a||#k1b||k1=v1|", cm);
        Assert.assertEquals((Object)"#Da|#Db", (Object)StringUtils.join((Collection)cm.getPreLines(""), (char)'|'));
        Assert.assertEquals((Object)"#ka||#kb|", (Object)StringUtils.join((Collection)cm.getEntry("", "k").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"|#S1a||#S1b|", (Object)StringUtils.join((Collection)cm.getPreLines("S1"), (char)'|'));
        Assert.assertEquals((Object)"|#k1a||#k1b|", (Object)StringUtils.join((Collection)cm.getEntry("S1", "k1").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"v", (Object)cm.getEntry("", "k").getValue());
        Assert.assertEquals((Object)"v1", (Object)cm.getEntry("S1", "k1").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("#Da|#Db||#ka||#kb||k=v||#S1a||#S1b||[S1]||#k1a||#k1b||k1=v1|", cm);
    }

    @Test
    public void testMalformedSectionHeaders() throws Exception {
        String[] test;
        for (String t : test = new String[]{"[]", "[  ]", "[/]", "[[]", "[]]", "[\\]", "[foo/bar]", "[foo[bar]", "[foo]bar]", "[foo\\bar]", "[]", "[ ]", "[\t]"}) {
            ConfigStore s = ConfigMapTest.initStore("Foo.cfg", t);
            try {
                s.getMap("Foo.cfg");
                Assert.fail((String)("Exception expected on t=[" + t + "]."));
            }
            catch (ConfigException e) {
                Assert.assertTrue((boolean)e.getLocalizedMessage().startsWith("Invalid section name"));
            }
        }
    }

    @Test
    public void testDuplicateSectionNames() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "[S1]");
        try {
            s.getMap("Foo.cfg");
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Duplicate section found in configuration:  [S1]", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testDuplicateEntryNames() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "foo=v1", "foo=v2");
        try {
            s.getMap("Foo.cfg");
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Duplicate entry found in section [S1] of configuration:  foo", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testMultipleLines() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "k1 = v1a,", "\tv1b,", "\tv1c", "k2 = v2a,", "\tv2b,", "\tv2c");
        ConfigMap cm = s.getMap("Foo.cfg");
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getEntry("", "k1").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getEntry("", "k2").getPreLines(), (char)'|'));
        TestUtils.assertTextEquals("k1 = v1a,|\tv1b,|\tv1c|k2 = v2a,|\tv2b,|\tv2c|", cm);
        Assert.assertEquals((Object)"v1a,\nv1b,\nv1c", (Object)cm.getEntry("", "k1").getValue());
        Assert.assertEquals((Object)"v2a,\nv2b,\nv2c", (Object)cm.getEntry("", "k2").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("k1 = v1a,|\tv1b,|\tv1c|k2 = v2a,|\tv2b,|\tv2c|", cm);
    }

    @Test
    public void testMultipleLinesWithSpacesAndComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "", "#k1", "", "k1 = v1a,", "\tv1b,", "\tv1c", "", "#k2", "", "k2 = v2a,", "\tv2b,", "\tv2c");
        ConfigMap cm = s.getMap("Foo.cfg");
        Assert.assertEquals((Object)"|#k1|", (Object)StringUtils.join((Collection)cm.getEntry("", "k1").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"|#k2|", (Object)StringUtils.join((Collection)cm.getEntry("", "k2").getPreLines(), (char)'|'));
        TestUtils.assertTextEquals("|#k1||k1 = v1a,|\tv1b,|\tv1c||#k2||k2 = v2a,|\tv2b,|\tv2c|", cm);
        Assert.assertEquals((Object)"v1a,\nv1b,\nv1c", (Object)cm.getEntry("", "k1").getValue());
        Assert.assertEquals((Object)"v2a,\nv2b,\nv2c", (Object)cm.getEntry("", "k2").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("|#k1||k1 = v1a,|\tv1b,|\tv1c||#k2||k2 = v2a,|\tv2b,|\tv2c|", cm);
    }

    @Test
    public void testMultipleLinesInSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1a,", "\tv1b,", "\tv1c", "k2 = v2a,", "\tv2b,", "\tv2c");
        ConfigMap cm = s.getMap("Foo.cfg");
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getEntry("S1", "k1").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"", (Object)StringUtils.join((Collection)cm.getEntry("S1", "k2").getPreLines(), (char)'|'));
        TestUtils.assertTextEquals("[S1]|k1 = v1a,|\tv1b,|\tv1c|k2 = v2a,|\tv2b,|\tv2c|", cm);
        Assert.assertEquals((Object)"v1a,\nv1b,\nv1c", (Object)cm.getEntry("S1", "k1").getValue());
        Assert.assertEquals((Object)"v2a,\nv2b,\nv2c", (Object)cm.getEntry("S1", "k2").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[S1]|k1 = v1a,|\tv1b,|\tv1c|k2 = v2a,|\tv2b,|\tv2c|", cm);
    }

    @Test
    public void testMultipleLinesInSectionWithSpacesAndPrelines() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "", "#S1", "", "[S1]", "", "#k1", "", "k1 = v1a,", "\tv1b,", "\tv1c", "", "#k2", "", "k2 = v2a,", "\tv2b,", "\tv2c");
        ConfigMap cm = s.getMap("Foo.cfg");
        Assert.assertEquals((Object)"|#S1|", (Object)StringUtils.join((Collection)cm.getPreLines("S1"), (char)'|'));
        Assert.assertEquals((Object)"|#k1|", (Object)StringUtils.join((Collection)cm.getEntry("S1", "k1").getPreLines(), (char)'|'));
        Assert.assertEquals((Object)"|#k2|", (Object)StringUtils.join((Collection)cm.getEntry("S1", "k2").getPreLines(), (char)'|'));
        TestUtils.assertTextEquals("|#S1||[S1]||#k1||k1 = v1a,|\tv1b,|\tv1c||#k2||k2 = v2a,|\tv2b,|\tv2c|", cm);
        Assert.assertEquals((Object)"v1a,\nv1b,\nv1c", (Object)cm.getEntry("S1", "k1").getValue());
        Assert.assertEquals((Object)"v2a,\nv2b,\nv2c", (Object)cm.getEntry("S1", "k2").getValue());
        s.update("Foo.cfg", cm.toString());
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("|#S1||[S1]||#k1||k1 = v1a,|\tv1b,|\tv1c||#k2||k2 = v2a,|\tv2b,|\tv2c|", cm);
    }

    @Test
    public void testEntriesWithComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = foo # comment");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[S1]|k1 = foo # comment|", cm);
        Assert.assertEquals((Object)"foo", (Object)cm.getEntry("S1", "k1").getValue());
        Assert.assertEquals((Object)"comment", (Object)cm.getEntry("S1", "k1").getComment());
        cm.setEntry("S1", "k1", null, null, "newcomment", null);
        TestUtils.assertTextEquals("[S1]|k1 = foo # newcomment|", cm);
        Assert.assertEquals((Object)"foo", (Object)cm.getEntry("S1", "k1").getValue());
        Assert.assertEquals((Object)"newcomment", (Object)cm.getEntry("S1", "k1").getComment());
        cm.setEntry("S1", "k1", null, null, "", null);
        TestUtils.assertTextEquals("[S1]|k1 = foo|", cm);
        Assert.assertEquals((Object)"foo", (Object)cm.getEntry("S1", "k1").getValue());
        Assert.assertEquals((Object)"", (Object)cm.getEntry("S1", "k1").getComment());
        cm.setEntry("S1", "k1", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = foo|", cm);
        Assert.assertEquals((Object)"foo", (Object)cm.getEntry("S1", "k1").getValue());
        Assert.assertEquals((Object)"", (Object)cm.getEntry("S1", "k1").getComment());
    }

    @Test
    public void testEntriesWithOddComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = foo#", "k2 = foo # ");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[S1]|k1 = foo#|k2 = foo # |", cm);
        Assert.assertEquals((Object)"", (Object)cm.getEntry("S1", "k1").getComment());
        Assert.assertEquals((Object)"", (Object)cm.getEntry("S1", "k2").getComment());
    }

    @Test
    public void testEntriesWithEscapedComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = foo\\#bar", "k2 = foo \\# bar", "k3 = foo \\# bar # real-comment");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[S1]|k1 = foo\\#bar|k2 = foo \\# bar|k3 = foo \\# bar # real-comment|", cm);
        Assert.assertEquals(null, (Object)cm.getEntry("S1", "k1").getComment());
        Assert.assertEquals(null, (Object)cm.getEntry("S1", "k2").getComment());
        Assert.assertEquals((Object)"real-comment", (Object)cm.getEntry("S1", "k3").getComment());
    }

    @Test
    public void testSettingEntries() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1a", "k2 = v2a");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v1b", null, null, null);
        cm.setEntry("S1", "k2", null, null, null, null);
        cm.setEntry("S1", "k3", "v3b", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1b|k2 = v2a|k3 = v3b|", cm);
        cm.commit();
        TestUtils.assertTextEquals("[S1]|k1 = v1b|k2 = v2a|k3 = v3b|", s.read("Foo.cfg"));
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[S1]|k1 = v1b|k2 = v2a|k3 = v3b|", cm);
    }

    @Test
    public void testSettingEntriesWithPreLines() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "", "#S1", "", "[S1]", "", "#k1", "", "k1 = v1a", "", "#k2", "", "k2 = v2a");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v1b", null, null, null);
        cm.setEntry("S1", "k2", null, null, null, null);
        cm.setEntry("S1", "k3", "v3b", null, null, null);
        cm.setEntry("S1", "k4", "v4b", null, null, Arrays.asList("", "#k4", ""));
        TestUtils.assertTextEquals("|#S1||[S1]||#k1||k1 = v1b||#k2||k2 = v2a|k3 = v3b||#k4||k4 = v4b|", cm);
        cm.commit();
        TestUtils.assertTextEquals("|#S1||[S1]||#k1||k1 = v1b||#k2||k2 = v2a|k3 = v3b||#k4||k4 = v4b|", s.read("Foo.cfg"));
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("|#S1||[S1]||#k1||k1 = v1b||#k2||k2 = v2a|k3 = v3b||#k4||k4 = v4b|", cm);
    }

    @Test
    public void testSettingEntriesWithNewlines() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("", "k", "v1\nv2\nv3", null, null, null);
        cm.setEntry("S1", "k1", "v1\nv2\nv3", null, null, null);
        TestUtils.assertTextEquals("k = v1|\tv2|\tv3|[S1]|k1 = v1|\tv2|\tv3|", cm);
        Assert.assertEquals((Object)"v1\nv2\nv3", (Object)cm.getEntry("", "k").getValue());
        Assert.assertEquals((Object)"v1\nv2\nv3", (Object)cm.getEntry("S1", "k1").getValue());
        cm.commit();
        TestUtils.assertTextEquals("k = v1|\tv2|\tv3|[S1]|k1 = v1|\tv2|\tv3|", cm);
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("k = v1|\tv2|\tv3|[S1]|k1 = v1|\tv2|\tv3|", cm);
    }

    @Test
    public void testSettingEntriesWithNewlinesAndSpaces() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("", "k", "v1 \n v2 \n v3", null, null, null);
        cm.setEntry("S1", "k1", "v1\t\n\tv2\t\n\tv3", null, null, null);
        TestUtils.assertTextEquals("k = v1 |\t v2 |\t v3|[S1]|k1 = v1\t|\t\tv2\t|\t\tv3|", cm);
        Assert.assertEquals((Object)"v1 \n v2 \n v3", (Object)cm.getEntry("", "k").getValue());
        Assert.assertEquals((Object)"v1\t\n\tv2\t\n\tv3", (Object)cm.getEntry("S1", "k1").getValue());
        cm.commit();
        TestUtils.assertTextEquals("k = v1 |\t v2 |\t v3|[S1]|k1 = v1\t|\t\tv2\t|\t\tv3|", cm);
        cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("k = v1 |\t v2 |\t v3|[S1]|k1 = v1\t|\t\tv2\t|\t\tv3|", cm);
    }

    @Test
    public void testSetSectionOnExistingSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setSection("S1", Arrays.asList("#S1"));
        TestUtils.assertTextEquals("#S1|[S1]|k1 = v1|", cm);
        cm.setSection("S1", Collections.emptyList());
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setSection("S1", null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
    }

    @Test
    public void testSetSectionOnDefaultSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setSection("", Arrays.asList("#D"));
        TestUtils.assertTextEquals("#D||[S1]|k1 = v1|", cm);
        cm.setSection("", Collections.emptyList());
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setSection("", null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
    }

    @Test
    public void testSetSectionOnNewSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setSection("S2", Arrays.asList("#S2"));
        TestUtils.assertTextEquals("[S1]|k1 = v1|#S2|[S2]|", cm);
        cm.setSection("S3", Collections.emptyList());
        TestUtils.assertTextEquals("[S1]|k1 = v1|#S2|[S2]|[S3]|", cm);
        cm.setSection("S4", null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|#S2|[S2]|[S3]|[S4]|", cm);
    }

    @Test
    public void testSetSectionBadNames() throws Exception {
        String[] test;
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        for (String t : test = new String[]{"/", "[", "]", "foo/bar", "foo[bar", "foo]bar", " ", null}) {
            try {
                cm.setSection(t, null);
                Assert.fail((String)"Exception expected.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getLocalizedMessage().startsWith("Invalid section name"));
            }
        }
    }

    @Test
    public void testSetSectionOkNames() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        String validChars = "~`!@#$%^&*()_-+={}|:;\"'<,>.?";
        for (char c : validChars.toCharArray()) {
            String test = "" + c;
            cm.setSection(test, Arrays.asList("test"));
            cm.commit();
            Assert.assertEquals((Object)"test", cm.getPreLines(test).get(0));
            test = "foo" + c + "bar";
            cm.setSection(test, Arrays.asList("test"));
            cm.commit();
            Assert.assertEquals((Object)"test", cm.getPreLines(test).get(0));
        }
    }

    @Test
    public void testRemoveSectionOnExistingSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1", "[S2]", "k2 = v2");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.removeSection("S1");
        TestUtils.assertTextEquals("[S2]|k2 = v2|", cm);
    }

    @Test
    public void testRemoveSectionOnNonExistingSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1", "[S2]", "k2 = v2");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.removeSection("S3");
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|k2 = v2|", cm);
        try {
            cm.removeSection(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid section name: 'null'", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testRemoveDefaultSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "k = v", "[S1]", "k1 = v1", "[S2]", "k2 = v2");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.removeSection("");
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|k2 = v2|", cm);
    }

    @Test
    public void testRemoveDefaultSectionWithComments() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "#D", "", "#k", "k = v", "[S1]", "k1 = v1", "[S2]", "k2 = v2");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.removeSection("");
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|k2 = v2|", cm);
    }

    @Test
    public void testSetPrelinesOnExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", null, null, null, Arrays.asList("#k1"));
        TestUtils.assertTextEquals("[S1]|#k1|k1 = v1|", cm);
        cm.setEntry("S1", "k1", null, null, null, Collections.emptyList());
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setEntry("S1", "k1", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
    }

    @Test
    public void testSetPrelinesOnExistingEntryWithAtrributes() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "#k1a", "k1 = v1 # comment");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", null, null, null, Arrays.asList("#k1b"));
        TestUtils.assertTextEquals("[S1]|#k1b|k1 = v1 # comment|", cm);
    }

    @Test
    public void testSetPrelinesOnNonExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k2", null, null, null, Arrays.asList("#k2"));
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setEntry("S1", "k2", null, null, null, Collections.emptyList());
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setEntry("S1", "k2", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setEntry("S2", "k2", null, null, null, Arrays.asList("#k2"));
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|", cm);
        cm.setEntry("S2", "k2", null, null, null, Collections.emptyList());
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|", cm);
        cm.setEntry("S2", "k2", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|", cm);
    }

    @Test
    public void testSetValueOnExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v2|", cm);
    }

    @Test
    public void testSetValueOnExistingEntryWithAttributes() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "#k1", "k1 = v1 # comment");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|#k1|k1 = v2 # comment|", cm);
    }

    @Test
    public void testSetValueToNullOnExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
    }

    @Test
    public void testSetValueOnNonExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k2", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|k2 = v2|", cm);
        cm.setEntry("S1", "k2", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|k2 = v2|", cm);
        cm.setEntry("S1", "k2", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|k2 = v2|", cm);
    }

    @Test
    public void testSetValueOnNonExistingEntryOnNonExistentSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S2", "k2", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|k2 = v2|", cm);
    }

    @Test
    public void testSetValueInvalidSectionNames() throws Exception {
        String[] test;
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        for (String t : test = new String[]{"/", "[", "]", "foo/bar", "foo[bar", "foo]bar", " ", null}) {
            try {
                cm.setEntry(t, "k1", "foo", null, null, null);
                Assert.fail((String)"Exception expected.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getLocalizedMessage().startsWith("Invalid section name:"));
            }
        }
    }

    @Test
    public void testSetValueInvalidKeyNames() throws Exception {
        String[] test;
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        for (String t : test = new String[]{"", " ", "\t", "foo=bar", "=", "foo/bar", "/", "foo[bar", "]", "foo]bar", "]", "foo\\bar", "\\", "foo#bar", "#", null}) {
            try {
                cm.setEntry("S1", t, "foo", null, null, null);
                Assert.fail((String)"Exception expected.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getLocalizedMessage().startsWith("Invalid key name"));
            }
        }
    }

    @Test
    public void testSetValueWithCommentChars() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v1 # foo", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1 \\u0023 foo|", cm);
    }

    @Test
    public void testSetCommentOnExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", null, null, "c1", null);
        TestUtils.assertTextEquals("[S1]|k1 = v1 # c1|", cm);
        cm.setEntry("S1", "k1", null, null, "", null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.commit();
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setEntry("S1", "k1", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
    }

    @Test
    public void testSetCommentOnExistingEntryWithAttributes() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "#k1a", "k1 = v1 # c1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", null, null, "c2", null);
        TestUtils.assertTextEquals("[S1]|#k1a|k1 = v1 # c2|", cm);
    }

    @Test
    public void testSetCommentOnNonExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k2", null, null, "foo", null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setEntry("S1", "k2", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
        cm.setEntry("S2", "k2", null, null, "foo", null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|", cm);
        cm.setEntry("S2", "k2", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|", cm);
    }

    @Test
    public void testSetEntryOnExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v2|", cm);
        cm.setEntry("S1", "k1", "v3", ENCODED, "c3", Arrays.asList("#k1a"));
        TestUtils.assertTextEquals("[S1]|#k1a|k1* = v3 # c3|", cm);
        cm.setEntry("S1", "k1", "v4", BASE64, "c4", Arrays.asList("#k1b"));
        TestUtils.assertTextEquals("[S1]|#k1b|k1^ = v4 # c4|", cm);
    }

    @Test
    public void testSetEntryOnExistingEntryWithAttributes() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "#k1", "k1 = v1 # comment");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|#k1|k1 = v2 # comment|", cm);
        cm.setEntry("S1", "k1", "v3", ENCODED, "c3", Arrays.asList("#k1a"));
        TestUtils.assertTextEquals("[S1]|#k1a|k1* = v3 # c3|", cm);
        cm.setEntry("S1", "k1", "v4", BASE64, "c4", Arrays.asList("#k1b"));
        TestUtils.assertTextEquals("[S1]|#k1b|k1^ = v4 # c4|", cm);
    }

    @Test
    public void testSetEntryToNullOnExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|", cm);
    }

    @Test
    public void testSetEntryOnNonExistingEntry() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k2", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|k2 = v2|", cm);
        cm.setEntry("S1", "k2", null, null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|k2 = v2|", cm);
        cm.setEntry("S1", "k2", "", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|k2 = |", cm);
    }

    @Test
    public void testSetEntryOnNonExistingEntryOnNonExistentSection() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S2", "k2", "v2", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1|[S2]|k2 = v2|", cm);
    }

    @Test
    public void testSetEntryInvalidSectionNames() throws Exception {
        String[] test;
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        for (String t : test = new String[]{"/", "[", "]", "foo/bar", "foo[bar", "foo]bar", " ", null}) {
            try {
                cm.setEntry(t, "k1", "foo", null, null, null);
                Assert.fail((String)"Exception expected.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getLocalizedMessage().startsWith("Invalid section name"));
            }
        }
    }

    @Test
    public void testSetEntryInvalidKeyNames() throws Exception {
        String[] test;
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", new String[0]);
        ConfigMap cm = s.getMap("Foo.cfg");
        for (String t : test = new String[]{"", " ", "\t", "foo=bar", "=", "foo/bar", "/", "foo[bar", "]", "foo]bar", "]", "foo\\bar", "\\", "foo#bar", "#", null}) {
            try {
                cm.setEntry("S1", t, "foo", null, null, null);
                Assert.fail((String)"Exception expected.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getLocalizedMessage().startsWith("Invalid key name"));
            }
        }
    }

    @Test
    public void testSetEntryWithCommentChars() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1 = v1");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v1 # foo", null, null, null);
        TestUtils.assertTextEquals("[S1]|k1 = v1 \\u0023 foo|", cm);
    }

    @Test
    public void testModifiers() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1^ = v1", "k2* = v2", "k3*^ = v3");
        ConfigMap cm = s.getMap("Foo.cfg");
        TestUtils.assertTextEquals("[S1]|k1^ = v1|k2* = v2|k3*^ = v3|", cm);
        Assert.assertTrue((boolean)cm.getEntry("S1", "k1").hasModifier('^'));
        Assert.assertFalse((boolean)cm.getEntry("S1", "k1").hasModifier('*'));
        Assert.assertFalse((boolean)cm.getEntry("S1", "k2").hasModifier('^'));
        Assert.assertTrue((boolean)cm.getEntry("S1", "k2").hasModifier('*'));
        Assert.assertTrue((boolean)cm.getEntry("S1", "k3").hasModifier('^'));
        Assert.assertTrue((boolean)cm.getEntry("S1", "k3").hasModifier('*'));
        cm.setEntry("S1", "k1", "v1", "#$%&*+^@~", null, null);
        TestUtils.assertTextEquals("[S1]|k1#$%&*+^@~ = v1|k2* = v2|k3*^ = v3|", cm);
    }

    @Test
    public void testInvalidModifier() throws Exception {
        ConfigStore s = ConfigMapTest.initStore("Foo.cfg", "[S1]", "k1^ = v1", "k2* = v2", "k3*^ = v3");
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.setEntry("S1", "k1", "v1", "", null, null);
        try {
            cm.setEntry("S1", "k1", "v1", "X", null, null);
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Invalid modifiers: X", (Object)e.getLocalizedMessage());
        }
        try {
            cm.setEntry("S1", "k1", "v1", " ", null, null);
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Invalid modifiers:  ", (Object)e.getLocalizedMessage());
        }
    }

    private static ConfigStore initStore(String name, String ... contents) {
        return ConfigMemoryStore.create().build().update(name, contents);
    }
}

