/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.juneau.ConfigException;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.store.ConfigMemoryStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConfigMapListenerTest {
    @Test
    public void testBasicDefaultSection() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "foo=bar");
        CountDownLatch latch = new CountDownLatch(1);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(foo = baz)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setEntry("", "foo", "baz", null, null, null);
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("foo = baz|", cm.toString());
    }

    @Test
    public void testBasicNormalSection() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "[S1]", "foo=bar");
        CountDownLatch latch = new CountDownLatch(1);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(S1/foo = baz)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setEntry("S1", "foo", "baz", null, null, null);
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("[S1]|foo = baz|", cm.toString());
    }

    @Test
    public void testAddNewEntries() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", new String[0]);
        CountDownLatch latch = new CountDownLatch(2);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(k = vb)','SET(S1/k1 = v1b)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setEntry("", "k", "vb", null, null, null);
        cm.setEntry("S1", "k1", "v1b", null, null, null);
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("k = vb|[S1]|k1 = v1b|", cm.toString());
    }

    @Test
    public void testAddNewEntriesWithAttributes() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", new String[0]);
        CountDownLatch latch = new CountDownLatch(2);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(k^* = kb # C)','SET(S1/k1^* = k1b # C1)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setEntry("", "k", "kb", "^*", "C", Arrays.asList("#k"));
        cm.setEntry("S1", "k1", "k1b", "^*", "C1", Arrays.asList("#k1"));
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("#k|k^* = kb # C|[S1]|#k1|k1^* = k1b # C1|", cm.toString());
    }

    @Test
    public void testAddExistingEntriesWithAttributes() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "#ka", "k=va # Ca", "#S1", "[S1]", "#k1a", "k1=v1a # Cb");
        CountDownLatch latch = new CountDownLatch(2);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(k^* = kb # Cb)','SET(S1/k1^* = k1b # Cb1)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setEntry("", "k", "kb", "^*", "Cb", Arrays.asList("#kb"));
        cm.setEntry("S1", "k1", "k1b", "^*", "Cb1", Arrays.asList("#k1b"));
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("#kb|k^* = kb # Cb|#S1|[S1]|#k1b|k1^* = k1b # Cb1|", cm.toString());
    }

    @Test
    public void testRemoveExistingEntries() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "k=v", "[S1]", "k1=v1");
        CountDownLatch latch = new CountDownLatch(2);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['REMOVE_ENTRY(k)','REMOVE_ENTRY(S1/k1)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.removeEntry("", "k");
        cm.removeEntry("S1", "k1");
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("[S1]|", cm.toString());
    }

    @Test
    public void testRemoveExistingEntriesWithAttributes() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "#ka", "k=va # Ca", "#S1", "[S1]", "#k1a", "k1=v1a # Cb");
        CountDownLatch latch = new CountDownLatch(2);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['REMOVE_ENTRY(k)','REMOVE_ENTRY(S1/k1)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.removeEntry("", "k");
        cm.removeEntry("S1", "k1");
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("#S1|[S1]|", cm.toString());
    }

    @Test
    public void testAddNewSections() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", new String[0]);
        CountDownLatch latch = new CountDownLatch(1);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(S3/k3 = v3)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setSection("", Arrays.asList("#D1"));
        cm.setSection("S1", Arrays.asList("#S1"));
        cm.setSection("S2", null);
        cm.setSection("S3", Collections.emptyList());
        cm.setEntry("S3", "k3", "v3", null, null, null);
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("#D1||#S1|[S1]|[S2]|[S3]|k3 = v3|", cm.toString());
    }

    @Test
    public void testModifyExistingSections() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "#Da", "", "#S1a", "[S1]", "[S2]", "[S3]");
        CountDownLatch latch = new CountDownLatch(1);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(S3/k3 = v3)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setSection("", Arrays.asList("#Db"));
        cm.setSection("S1", Arrays.asList("#S1b"));
        cm.setSection("S2", null);
        cm.setSection("S3", Collections.emptyList());
        cm.setEntry("S3", "k3", "v3", null, null, null);
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("#Db||#S1b|[S1]|[S2]|[S3]|k3 = v3|", cm.toString());
    }

    @Test
    public void testRemoveSections() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "#Da", "", "k = v", "", "#S1", "[S1]", "#k1", "k1 = v1", "[S2]", "#k2", "k2 = v2", "[S3]");
        CountDownLatch latch = new CountDownLatch(3);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['REMOVE_ENTRY(k)','REMOVE_ENTRY(S1/k1)','REMOVE_ENTRY(S2/k2)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.removeSection("");
        cm.removeSection("S1");
        cm.removeSection("S2");
        cm.removeSection("S3");
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("", cm.toString());
    }

    @Test
    public void testUpdateFromStore() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", new String[0]);
        CountDownLatch latch = new CountDownLatch(3);
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals("['SET(k = v # cv)','SET(S1/k1 = v1 # cv1)','SET(S2/k2 = v2 # cv2)']", events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        s.update("Foo.cfg", new String[]{"#Da", "", "k = v # cv", "", "#S1", "[S1]", "#k1", "k1 = v1 # cv1", "[S2]", "#k2", "k2 = v2 # cv2", "[S3]"});
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("#Da||k = v # cv||#S1|[S1]|#k1|k1 = v1 # cv1|[S2]|#k2|k2 = v2 # cv2|[S3]|", cm.toString());
    }

    @Test
    public void testMergeNoOverwrite() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "[S1]", "k1 = v1a");
        CountDownLatch latch = new CountDownLatch(2);
        final ConcurrentLinkedQueue<String> eventList = new ConcurrentLinkedQueue<String>();
        eventList.add("['SET(S1/k1 = v1b)']");
        eventList.add("['SET(S2/k2 = v2b)']");
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals((String)eventList.poll(), events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setEntry("S2", "k2", "v2b", null, null, null);
        s.update("Foo.cfg", new String[]{"[S1]", "k1 = v1b"});
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("[S1]|k1 = v1b|[S2]|k2 = v2b|", cm.toString());
    }

    @Test
    public void testMergeWithOverwrite() throws Exception {
        ConfigStore s = ConfigMapListenerTest.initStore("Foo.cfg", "[S1]", "k1 = v1a");
        CountDownLatch latch = new CountDownLatch(2);
        final ConcurrentLinkedQueue<String> eventList = new ConcurrentLinkedQueue<String>();
        eventList.add("['SET(S1/k1 = v1b)']");
        eventList.add("['SET(S1/k1 = v1c)']");
        LatchedListener l = new LatchedListener(latch){

            @Override
            public void check(ConfigEvents events) throws Exception {
                TestUtils.assertObjectEquals((String)eventList.poll(), events);
            }
        };
        ConfigMap cm = s.getMap("Foo.cfg");
        cm.register((ConfigEventListener)l);
        cm.setEntry("S1", "k1", "v1c", null, null, null);
        s.update("Foo.cfg", new String[]{"[S1]", "k1 = v1b"});
        cm.commit();
        ConfigMapListenerTest.wait(latch);
        Assert.assertNull((Object)l.error);
        cm.unregister((ConfigEventListener)l);
        TestUtils.assertTextEquals("[S1]|k1 = v1c|", cm.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeWithOverwriteNoSignal() throws Exception {
        final ConcurrentLinkedQueue<String> contents = new ConcurrentLinkedQueue<String>();
        contents.add("[S1]\nk1 = v1a");
        contents.add("[S1]\nk1 = v1b");
        contents.add("[S1]\nk1 = v1c");
        contents.add("[S1]\nk1 = v1c");
        try (ConfigMemoryStore s = new ConfigMemoryStore(null){

            public synchronized String read(String name) {
                return (String)contents.poll();
            }
        };){
            CountDownLatch latch = new CountDownLatch(2);
            final ConcurrentLinkedQueue<String> eventList = new ConcurrentLinkedQueue<String>();
            eventList.add("['SET(S1/k1 = v1b)']");
            eventList.add("['SET(S1/k1 = v1c)']");
            LatchedListener l = new LatchedListener(latch){

                @Override
                public void check(ConfigEvents events) throws Exception {
                    TestUtils.assertObjectEquals((String)eventList.poll(), events);
                }
            };
            ConfigMap cm = s.getMap("Foo.cfg");
            cm.register((ConfigEventListener)l);
            cm.setEntry("S1", "k1", "v1c", null, null, null);
            cm.commit();
            ConfigMapListenerTest.wait(latch);
            Assert.assertNull((Object)l.error);
            cm.unregister((ConfigEventListener)l);
            TestUtils.assertTextEquals("[S1]|k1 = v1c|", cm.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeWithConstantlyUpdatingFile() throws Exception {
        try (ConfigMemoryStore s = new ConfigMemoryStore(null){
            char c;
            {
                this.c = (char)97;
            }

            public synchronized String read(String name) {
                char c = this.c;
                this.c = (char)(c + '\u0001');
                return "[S1]\nk1 = v1" + c;
            }
        };){
            CountDownLatch latch = new CountDownLatch(10);
            final ConcurrentLinkedQueue<String> eventList = new ConcurrentLinkedQueue<String>();
            eventList.add("['SET(S1/k1 = v1b)']");
            eventList.add("['SET(S1/k1 = v1c)']");
            eventList.add("['SET(S1/k1 = v1d)']");
            eventList.add("['SET(S1/k1 = v1e)']");
            eventList.add("['SET(S1/k1 = v1f)']");
            eventList.add("['SET(S1/k1 = v1g)']");
            eventList.add("['SET(S1/k1 = v1h)']");
            eventList.add("['SET(S1/k1 = v1i)']");
            eventList.add("['SET(S1/k1 = v1j)']");
            eventList.add("['SET(S1/k1 = v1k)']");
            LatchedListener l = new LatchedListener(latch){

                @Override
                public void check(ConfigEvents events) throws Exception {
                    TestUtils.assertObjectEquals((String)eventList.poll(), events);
                }
            };
            ConfigMap cm = s.getMap("Foo.cfg");
            cm.register((ConfigEventListener)l);
            cm.setEntry("S1", "k1", "v1c", null, null, null);
            try {
                cm.commit();
                Assert.fail((String)"Exception expected.");
            }
            catch (ConfigException e) {
                Assert.assertEquals((Object)"Unable to store contents of config to store.", (Object)e.getMessage());
            }
            ConfigMapListenerTest.wait(latch);
            Assert.assertNull((Object)l.error);
            cm.unregister((ConfigEventListener)l);
            TestUtils.assertTextEquals("[S1]|k1 = v1c|", cm.toString());
        }
    }

    private static ConfigStore initStore(String name, String ... contents) {
        return ConfigMemoryStore.create().build().update(name, contents);
    }

    private static void wait(CountDownLatch latch) throws InterruptedException {
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Latch failed.");
        }
    }

    public static class LatchedListener
    implements ConfigEventListener {
        private final CountDownLatch latch;
        private volatile String error = null;

        public LatchedListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onConfigChange(ConfigEvents events) {
            try {
                this.check(events);
            }
            catch (Exception e) {
                this.error = e.getLocalizedMessage();
            }
            for (int i = 0; i < events.size(); ++i) {
                this.latch.countDown();
            }
        }

        public void check(ConfigEvents events) throws Exception {
        }
    }
}

