/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.juneau.config.Config;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.testutils.pojos.ABean;
import org.apache.juneau.testutils.pojos.ImplicitSwappedPojo;
import org.apache.juneau.testutils.pojos.SwappedPojo;
import org.apache.juneau.testutils.pojos.TestEnum;
import org.apache.juneau.testutils.pojos.TypedBean;
import org.apache.juneau.testutils.pojos.TypedBeanImpl;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class ConfigInterfaceTest {
    Config cf = Config.create().serializer((WriterSerializer)SimpleJsonSerializer.DEFAULT.builder().addBeanTypes().addRootType().build()).build();
    ConfigInterface proxy = (ConfigInterface)this.cf.getSectionAsInterface("A", ConfigInterface.class);

    @Test
    public void testString() throws Exception {
        this.proxy.setString("foo");
        Assert.assertEquals((Object)"foo", (Object)this.proxy.getString());
        Assert.assertEquals((Object)"foo", (Object)this.cf.get("A/string"));
    }

    @Test
    public void testInt() throws Exception {
        this.proxy.setInt(1);
        Assert.assertEquals((long)1L, (long)this.proxy.getInt());
        Assert.assertEquals((Object)"1", (Object)this.cf.get("A/int"));
    }

    @Test
    public void testInteger() throws Exception {
        this.proxy.setInteger(2);
        Assert.assertEquals((long)2L, (long)this.proxy.getInteger().intValue());
        Assert.assertEquals((Object)"2", (Object)this.cf.get("A/integer"));
        TestUtils.assertInstanceOf(Integer.class, this.proxy.getInteger());
    }

    @Test
    public void testBoolean() throws Exception {
        this.proxy.setBoolean(true);
        Assert.assertEquals((Object)true, (Object)this.proxy.isBoolean());
        Assert.assertEquals((Object)"true", (Object)this.cf.get("A/boolean"));
    }

    @Test
    public void testBooleanObject() throws Exception {
        this.proxy.setBooleanObject(true);
        Assert.assertEquals((Object)true, (Object)this.proxy.getBooleanObject());
        Assert.assertEquals((Object)"true", (Object)this.cf.get("A/booleanObject"));
        TestUtils.assertInstanceOf(Boolean.class, this.proxy.getBooleanObject());
    }

    @Test
    public void testFloat() throws Exception {
        this.proxy.setFloat(1.0f);
        Assert.assertTrue((1.0f == this.proxy.getFloat() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"1.0", (Object)this.cf.get("A/float"));
    }

    @Test
    public void testFloatObject() throws Exception {
        this.proxy.setFloatObject(Float.valueOf(1.0f));
        Assert.assertTrue((1.0f == this.proxy.getFloatObject().floatValue() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"1.0", (Object)this.cf.get("A/floatObject"));
        TestUtils.assertInstanceOf(Float.class, this.proxy.getFloatObject());
    }

    @Test
    public void testInt3dArray() throws Exception {
        this.proxy.setInt3dArray(new int[][][]{new int[][]{{1, 2}, null}, null});
        Assert.assertEquals((Object)"[[[1,2],null],null]", (Object)this.cf.get("A/int3dArray"));
        TestUtils.assertObjectEquals("[[[1,2],null],null]", this.proxy.getInt3dArray());
        TestUtils.assertInstanceOf(int[][][].class, this.proxy.getInt3dArray());
    }

    @Test
    public void testInteger3dArray() throws Exception {
        this.proxy.setInteger3dArray(new Integer[][][]{{{1, null}, null}, null});
        TestUtils.assertObjectEquals("[[[1,null],null],null]", this.proxy.getInteger3dArray());
        Assert.assertEquals((Object)"[[[1,null],null],null]", (Object)this.cf.get("A/integer3dArray"));
        TestUtils.assertInstanceOf(Integer.class, this.proxy.getInteger3dArray()[0][0][0]);
    }

    @Test
    public void testString3dArray() throws Exception {
        this.proxy.setString3dArray(new String[][][]{{{"foo", null}, null}, null});
        TestUtils.assertObjectEquals("[[['foo',null],null],null]", this.proxy.getString3dArray());
        Assert.assertEquals((Object)"[[['foo',null],null],null]", (Object)this.cf.get("A/string3dArray"));
    }

    @Test
    public void testIntegerList() throws Exception {
        this.proxy.setIntegerList((List<Integer>)new AList().append((Object)1).append(null));
        TestUtils.assertObjectEquals("[1,null]", this.proxy.getIntegerList());
        Assert.assertEquals((Object)"[1,null]", (Object)this.cf.get("A/integerList"));
        TestUtils.assertInstanceOf(Integer.class, this.proxy.getIntegerList().get(0));
    }

    @Test
    public void testInteger3dList() throws Exception {
        this.proxy.setInteger3dList((List<List<List<Integer>>>)new AList().append((Object)new AList().append((Object)new AList().append((Object)1).append(null)).append(null)).append(null));
        TestUtils.assertObjectEquals("[[[1,null],null],null]", this.proxy.getInteger3dList());
        Assert.assertEquals((Object)"[[[1,null],null],null]", (Object)this.cf.get("A/integer3dList"));
        TestUtils.assertInstanceOf(Integer.class, this.proxy.getInteger3dList().get(0).get(0).get(0));
    }

    @Test
    public void testInteger1d3dList() throws Exception {
        this.proxy.setInteger1d3dList((List<Integer[][][]>)new AList().append((Object)new Integer[][][]{{{1, null}, null}, null}).append(null));
        TestUtils.assertObjectEquals("[[[[1,null],null],null],null]", this.proxy.getInteger1d3dList());
        Assert.assertEquals((Object)"[[[[1,null],null],null],null]", (Object)this.cf.get("A/integer1d3dList"));
        TestUtils.assertInstanceOf(Integer.class, this.proxy.getInteger1d3dList().get(0)[0][0][0]);
    }

    @Test
    public void testInt1d3dList() throws Exception {
        this.proxy.setInt1d3dList((List<int[][][]>)new AList().append((Object)new int[][][]{new int[][]{{1, 2}, null}, null}).append(null));
        TestUtils.assertObjectEquals("[[[[1,2],null],null],null]", this.proxy.getInt1d3dList());
        Assert.assertEquals((Object)"[[[[1,2],null],null],null]", (Object)this.cf.get("A/int1d3dList"));
        TestUtils.assertInstanceOf(int[][][].class, this.proxy.getInt1d3dList().get(0));
    }

    @Test
    public void testStringList() throws Exception {
        this.proxy.setStringList(Arrays.asList("foo", "bar", null));
        TestUtils.assertObjectEquals("['foo','bar',null]", this.proxy.getStringList());
        Assert.assertEquals((Object)"['foo','bar',null]", (Object)this.cf.get("A/stringList"));
    }

    @Test
    public void testBean() throws Exception {
        this.proxy.setBean(new ABean().init());
        TestUtils.assertObjectEquals("{a:1,b:'foo'}", this.proxy.getBean());
        Assert.assertEquals((Object)"{a:1,b:'foo'}", (Object)this.cf.get("A/bean"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBean());
    }

    @Test
    public void testBean3dArray() throws Exception {
        this.proxy.setBean3dArray(new ABean[][][]{{{new ABean().init(), null}, null}, null});
        TestUtils.assertObjectEquals("[[[{a:1,b:'foo'},null],null],null]", this.proxy.getBean3dArray());
        Assert.assertEquals((Object)"[[[{a:1,b:'foo'},null],null],null]", (Object)this.cf.get("A/bean3dArray"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBean3dArray()[0][0][0]);
    }

    @Test
    public void testBeanList() throws Exception {
        this.proxy.setBeanList(Arrays.asList(new ABean().init()));
        TestUtils.assertObjectEquals("[{a:1,b:'foo'}]", this.proxy.getBeanList());
        Assert.assertEquals((Object)"[{a:1,b:'foo'}]", (Object)this.cf.get("A/beanList"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBeanList().get(0));
    }

    @Test
    public void testBean1d3dList() throws Exception {
        this.proxy.setBean1d3dList((List<ABean[][][]>)new AList().append((Object)new ABean[][][]{{{new ABean().init(), null}, null}, null}).append(null));
        TestUtils.assertObjectEquals("[[[[{a:1,b:'foo'},null],null],null],null]", this.proxy.getBean1d3dList());
        Assert.assertEquals((Object)"[[[[{a:1,b:'foo'},null],null],null],null]", (Object)this.cf.get("A/bean1d3dList"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBean1d3dList().get(0)[0][0][0]);
    }

    @Test
    public void testBeanMap() throws Exception {
        this.proxy.setBeanMap((Map<String, ABean>)new AMap().append((Object)"foo", (Object)new ABean().init()));
        TestUtils.assertObjectEquals("{foo:{a:1,b:'foo'}}", this.proxy.getBeanMap());
        Assert.assertEquals((Object)"{foo:{a:1,b:'foo'}}", (Object)this.cf.get("A/beanMap"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBeanMap().get("foo"));
    }

    @Test
    public void testBeanListMap() throws Exception {
        this.proxy.setBeanListMap((Map<String, List<ABean>>)new AMap().append((Object)"foo", Arrays.asList(new ABean().init())));
        TestUtils.assertObjectEquals("{foo:[{a:1,b:'foo'}]}", this.proxy.getBeanListMap());
        Assert.assertEquals((Object)"{foo:[{a:1,b:'foo'}]}", (Object)this.cf.get("A/beanListMap"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBeanListMap().get("foo").get(0));
    }

    @Test
    public void testBean1d3dListMap() throws Exception {
        this.proxy.setBean1d3dListMap((Map<String, List<ABean[][][]>>)new AMap().append((Object)"foo", (Object)new AList().append((Object)new ABean[][][]{{{new ABean().init(), null}, null}, null}).append(null)));
        TestUtils.assertObjectEquals("{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", this.proxy.getBean1d3dListMap());
        Assert.assertEquals((Object)"{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", (Object)this.cf.get("A/bean1d3dListMap"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBean1d3dListMap().get("foo").get(0)[0][0][0]);
    }

    @Test
    public void testBeanListMapIntegerKeys() throws Exception {
        this.proxy.setBeanListMapIntegerKeys((Map<Integer, List<ABean>>)new AMap().append((Object)1, Arrays.asList(new ABean().init())));
        TestUtils.assertObjectEquals("{'1':[{a:1,b:'foo'}]}", this.proxy.getBeanListMapIntegerKeys());
        Assert.assertEquals((Object)"{'1':[{a:1,b:'foo'}]}", (Object)this.cf.get("A/beanListMapIntegerKeys"));
        TestUtils.assertInstanceOf(ABean.class, this.proxy.getBeanListMapIntegerKeys().get(1).get(0));
    }

    @Test
    public void testTypedBean() throws Exception {
        this.proxy.setTypedBean(new TypedBeanImpl().init());
        TestUtils.assertObjectEquals("{_type:'TypedBeanImpl',a:1,b:'foo'}", this.proxy.getTypedBean());
        Assert.assertEquals((Object)"{_type:'TypedBeanImpl',a:1,b:'foo'}", (Object)this.cf.get("A/typedBean"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBean());
    }

    @Test
    public void testTypedBean3dArray() throws Exception {
        this.proxy.setTypedBean3dArray(new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null});
        TestUtils.assertObjectEquals("[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null]", this.proxy.getTypedBean3dArray());
        Assert.assertEquals((Object)"[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null]", (Object)this.cf.get("A/typedBean3dArray"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBean3dArray()[0][0][0]);
    }

    @Test
    public void testTypedBeanList() throws Exception {
        this.proxy.setTypedBeanList(Arrays.asList(new TypedBeanImpl().init()));
        TestUtils.assertObjectEquals("[{_type:'TypedBeanImpl',a:1,b:'foo'}]", this.proxy.getTypedBeanList());
        Assert.assertEquals((Object)"[{_type:'TypedBeanImpl',a:1,b:'foo'}]", (Object)this.cf.get("A/typedBeanList"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBeanList().get(0));
    }

    @Test
    public void testTypedBean1d3dList() throws Exception {
        this.proxy.setTypedBean1d3dList((List<TypedBean[][][]>)new AList().append((Object)new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null}).append(null));
        TestUtils.assertObjectEquals("[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]", this.proxy.getTypedBean1d3dList());
        Assert.assertEquals((Object)"[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]", (Object)this.cf.get("A/typedBean1d3dList"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBean1d3dList().get(0)[0][0][0]);
    }

    @Test
    public void testTypedBeanMap() throws Exception {
        this.proxy.setTypedBeanMap((Map<String, TypedBean>)new AMap().append((Object)"foo", (Object)new TypedBeanImpl().init()));
        TestUtils.assertObjectEquals("{foo:{_type:'TypedBeanImpl',a:1,b:'foo'}}", this.proxy.getTypedBeanMap());
        Assert.assertEquals((Object)"{foo:{_type:'TypedBeanImpl',a:1,b:'foo'}}", (Object)this.cf.get("A/typedBeanMap"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBeanMap().get("foo"));
    }

    @Test
    public void testTypedBeanListMap() throws Exception {
        this.proxy.setTypedBeanListMap((Map<String, List<TypedBean>>)new AMap().append((Object)"foo", Arrays.asList(new TypedBeanImpl().init())));
        TestUtils.assertObjectEquals("{foo:[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", this.proxy.getTypedBeanListMap());
        Assert.assertEquals((Object)"{foo:[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", (Object)this.cf.get("A/typedBeanListMap"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBeanListMap().get("foo").get(0));
    }

    @Test
    public void testTypedBean1d3dListMap() throws Exception {
        this.proxy.setTypedBean1d3dListMap((Map<String, List<TypedBean[][][]>>)new AMap().append((Object)"foo", (Object)new AList().append((Object)new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null}).append(null)));
        TestUtils.assertObjectEquals("{foo:[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]}", this.proxy.getTypedBean1d3dListMap());
        Assert.assertEquals((Object)"{foo:[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]}", (Object)this.cf.get("A/typedBean1d3dListMap"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBean1d3dListMap().get("foo").get(0)[0][0][0]);
    }

    @Test
    public void testTypedBeanListMapIntegerKeys() throws Exception {
        this.proxy.setTypedBeanListMapIntegerKeys((Map<Integer, List<TypedBean>>)new AMap().append((Object)1, Arrays.asList(new TypedBeanImpl().init())));
        TestUtils.assertObjectEquals("{'1':[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", this.proxy.getTypedBeanListMapIntegerKeys());
        Assert.assertEquals((Object)"{'1':[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", (Object)this.cf.get("A/typedBeanListMapIntegerKeys"));
        TestUtils.assertInstanceOf(TypedBeanImpl.class, this.proxy.getTypedBeanListMapIntegerKeys().get(1).get(0));
    }

    @Test
    public void testSwappedPojo() throws Exception {
        this.proxy.setSwappedPojo(new SwappedPojo());
        TestUtils.assertObjectEquals("'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", this.proxy.getSwappedPojo());
        Assert.assertEquals((Object)"swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/", (Object)this.cf.get("A/swappedPojo"));
        TestUtils.assertInstanceOf(SwappedPojo.class, this.proxy.getSwappedPojo());
    }

    @Test
    public void testSwappedPojo3dArray() throws Exception {
        this.proxy.setSwappedPojo3dArray(new SwappedPojo[][][]{{{new SwappedPojo(), null}, null}, null});
        TestUtils.assertObjectEquals("[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", this.proxy.getSwappedPojo3dArray());
        Assert.assertEquals((Object)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)this.cf.get("A/swappedPojo3dArray"));
        TestUtils.assertInstanceOf(SwappedPojo.class, this.proxy.getSwappedPojo3dArray()[0][0][0]);
    }

    @Test
    public void testSwappedPojoMap() throws Exception {
        this.proxy.setSwappedPojoMap((Map<SwappedPojo, SwappedPojo>)new AMap().append((Object)new SwappedPojo(), (Object)new SwappedPojo()));
        TestUtils.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", this.proxy.getSwappedPojoMap());
        Assert.assertEquals((Object)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", (Object)this.cf.get("A/swappedPojoMap"));
        TestUtils.assertInstanceOf(SwappedPojo.class, this.proxy.getSwappedPojoMap().keySet().iterator().next());
        TestUtils.assertInstanceOf(SwappedPojo.class, this.proxy.getSwappedPojoMap().values().iterator().next());
    }

    @Test
    public void testSwappedPojo3dMap() throws Exception {
        this.proxy.setSwappedPojo3dMap((Map<SwappedPojo, SwappedPojo[][][]>)new AMap().append((Object)new SwappedPojo(), (Object)new SwappedPojo[][][]{{{new SwappedPojo(), null}, null}, null}));
        TestUtils.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", this.proxy.getSwappedPojo3dMap());
        Assert.assertEquals((Object)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", (Object)this.cf.get("A/swappedPojo3dMap"));
        TestUtils.assertInstanceOf(SwappedPojo.class, this.proxy.getSwappedPojo3dMap().keySet().iterator().next());
        TestUtils.assertInstanceOf(SwappedPojo.class, this.proxy.getSwappedPojo3dMap().values().iterator().next()[0][0][0]);
    }

    @Test
    public void testImplicitSwappedPojo() throws Exception {
        this.proxy.setImplicitSwappedPojo(new ImplicitSwappedPojo());
        TestUtils.assertObjectEquals("'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", this.proxy.getImplicitSwappedPojo());
        Assert.assertEquals((Object)"swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/", (Object)this.cf.get("A/implicitSwappedPojo"));
        TestUtils.assertInstanceOf(ImplicitSwappedPojo.class, this.proxy.getImplicitSwappedPojo());
    }

    @Test
    public void testImplicitSwappedPojo3dArray() throws Exception {
        this.proxy.setImplicitSwappedPojo3dArray(new ImplicitSwappedPojo[][][]{{{new ImplicitSwappedPojo(), null}, null}, null});
        TestUtils.assertObjectEquals("[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", this.proxy.getImplicitSwappedPojo3dArray());
        Assert.assertEquals((Object)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)this.cf.get("A/implicitSwappedPojo3dArray"));
        TestUtils.assertInstanceOf(ImplicitSwappedPojo.class, this.proxy.getImplicitSwappedPojo3dArray()[0][0][0]);
    }

    @Test
    public void testImplicitSwappedPojoMap() throws Exception {
        this.proxy.setImplicitSwappedPojoMap((Map<ImplicitSwappedPojo, ImplicitSwappedPojo>)new AMap().append((Object)new ImplicitSwappedPojo(), (Object)new ImplicitSwappedPojo()));
        TestUtils.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", this.proxy.getImplicitSwappedPojoMap());
        Assert.assertEquals((Object)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", (Object)this.cf.get("A/implicitSwappedPojoMap"));
        TestUtils.assertInstanceOf(ImplicitSwappedPojo.class, this.proxy.getImplicitSwappedPojoMap().keySet().iterator().next());
        TestUtils.assertInstanceOf(ImplicitSwappedPojo.class, this.proxy.getImplicitSwappedPojoMap().values().iterator().next());
    }

    @Test
    public void testImplicitSwappedPojo3dMap() throws Exception {
        this.proxy.setImplicitSwappedPojo3dMap((Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]>)new AMap().append((Object)new ImplicitSwappedPojo(), (Object)new ImplicitSwappedPojo[][][]{{{new ImplicitSwappedPojo(), null}, null}, null}));
        TestUtils.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", this.proxy.getImplicitSwappedPojo3dMap());
        Assert.assertEquals((Object)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", (Object)this.cf.get("A/implicitSwappedPojo3dMap"));
        TestUtils.assertInstanceOf(ImplicitSwappedPojo.class, this.proxy.getImplicitSwappedPojo3dMap().keySet().iterator().next());
        TestUtils.assertInstanceOf(ImplicitSwappedPojo.class, this.proxy.getImplicitSwappedPojo3dMap().values().iterator().next()[0][0][0]);
    }

    @Test
    public void testEnum() throws Exception {
        this.proxy.setEnum(TestEnum.TWO);
        TestUtils.assertObjectEquals("'TWO'", (Object)this.proxy.getEnum());
        Assert.assertEquals((Object)"TWO", (Object)this.cf.get("A/enum"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum());
    }

    @Test
    public void testEnum3d() throws Exception {
        this.proxy.setEnum3d(new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null});
        TestUtils.assertObjectEquals("[[['TWO',null],null],null]", this.proxy.getEnum3d());
        Assert.assertEquals((Object)"[[['TWO',null],null],null]", (Object)this.cf.get("A/enum3d"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum3d()[0][0][0]);
    }

    @Test
    public void testEnumList() throws Exception {
        this.proxy.setEnumList((List<TestEnum>)new AList().append((Object)TestEnum.TWO).append(null));
        TestUtils.assertObjectEquals("['TWO',null]", this.proxy.getEnumList());
        Assert.assertEquals((Object)"['TWO',null]", (Object)this.cf.get("A/enumList"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnumList().get(0));
    }

    @Test
    public void testEnum3dList() throws Exception {
        this.proxy.setEnum3dList((List<List<List<TestEnum>>>)new AList().append((Object)new AList().append((Object)new AList().append((Object)TestEnum.TWO).append(null)).append(null).append(null)));
        TestUtils.assertObjectEquals("[[['TWO',null],null,null]]", this.proxy.getEnum3dList());
        Assert.assertEquals((Object)"[[['TWO',null],null,null]]", (Object)this.cf.get("A/enum3dList"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum3dList().get(0).get(0).get(0));
    }

    @Test
    public void testEnum1d3dList() throws Exception {
        this.proxy.setEnum1d3dList((List<TestEnum[][][]>)new AList().append((Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null}).append(null));
        TestUtils.assertObjectEquals("[[[['TWO',null],null],null],null]", this.proxy.getEnum1d3dList());
        Assert.assertEquals((Object)"[[[['TWO',null],null],null],null]", (Object)this.cf.get("A/enum1d3dList"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum1d3dList().get(0)[0][0][0]);
    }

    @Test
    public void testEnumMap() throws Exception {
        this.proxy.setEnumMap((Map<TestEnum, TestEnum>)new AMap().append((Object)TestEnum.ONE, (Object)TestEnum.TWO));
        TestUtils.assertObjectEquals("{ONE:'TWO'}", this.proxy.getEnumMap());
        Assert.assertEquals((Object)"{ONE:'TWO'}", (Object)this.cf.get("A/enumMap"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnumMap().keySet().iterator().next());
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnumMap().values().iterator().next());
    }

    @Test
    public void testEnum3dArrayMap() throws Exception {
        this.proxy.setEnum3dArrayMap((Map<TestEnum, TestEnum[][][]>)new AMap().append((Object)TestEnum.ONE, (Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null}));
        TestUtils.assertObjectEquals("{ONE:[[['TWO',null],null],null]}", this.proxy.getEnum3dArrayMap());
        Assert.assertEquals((Object)"{ONE:[[['TWO',null],null],null]}", (Object)this.cf.get("A/enum3dArrayMap"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum3dArrayMap().keySet().iterator().next());
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum3dArrayMap().values().iterator().next()[0][0][0]);
    }

    @Test
    public void testEnum1d3dListMap() throws Exception {
        this.proxy.setEnum1d3dListMap((Map<TestEnum, List<TestEnum[][][]>>)new AMap().append((Object)TestEnum.ONE, (Object)new AList().append((Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null}).append(null)));
        TestUtils.assertObjectEquals("{ONE:[[[['TWO',null],null],null],null]}", this.proxy.getEnum1d3dListMap());
        Assert.assertEquals((Object)"{ONE:[[[['TWO',null],null],null],null]}", (Object)this.cf.get("A/enum1d3dListMap"));
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum1d3dListMap().keySet().iterator().next());
        TestUtils.assertInstanceOf(TestEnum.class, (Object)this.proxy.getEnum1d3dListMap().values().iterator().next().get(0)[0][0][0]);
    }

    public static interface ConfigInterface {
        public String getString();

        public void setString(String var1);

        public int getInt();

        public void setInt(int var1);

        public Integer getInteger();

        public void setInteger(Integer var1);

        public boolean isBoolean();

        public void setBoolean(boolean var1);

        public Boolean getBooleanObject();

        public void setBooleanObject(Boolean var1);

        public float getFloat();

        public void setFloat(float var1);

        public Float getFloatObject();

        public void setFloatObject(Float var1);

        public int[][][] getInt3dArray();

        public void setInt3dArray(int[][][] var1);

        public Integer[][][] getInteger3dArray();

        public void setInteger3dArray(Integer[][][] var1);

        public String[][][] getString3dArray();

        public void setString3dArray(String[][][] var1);

        public List<Integer> getIntegerList();

        public void setIntegerList(List<Integer> var1);

        public List<List<List<Integer>>> getInteger3dList();

        public void setInteger3dList(List<List<List<Integer>>> var1);

        public List<Integer[][][]> getInteger1d3dList();

        public void setInteger1d3dList(List<Integer[][][]> var1);

        public List<int[][][]> getInt1d3dList();

        public void setInt1d3dList(List<int[][][]> var1);

        public List<String> getStringList();

        public void setStringList(List<String> var1);

        public ABean getBean();

        public void setBean(ABean var1);

        public ABean[][][] getBean3dArray();

        public void setBean3dArray(ABean[][][] var1);

        public List<ABean> getBeanList();

        public void setBeanList(List<ABean> var1);

        public List<ABean[][][]> getBean1d3dList();

        public void setBean1d3dList(List<ABean[][][]> var1);

        public Map<String, ABean> getBeanMap();

        public void setBeanMap(Map<String, ABean> var1);

        public Map<String, List<ABean>> getBeanListMap();

        public void setBeanListMap(Map<String, List<ABean>> var1);

        public Map<String, List<ABean[][][]>> getBean1d3dListMap();

        public void setBean1d3dListMap(Map<String, List<ABean[][][]>> var1);

        public Map<Integer, List<ABean>> getBeanListMapIntegerKeys();

        public void setBeanListMapIntegerKeys(Map<Integer, List<ABean>> var1);

        public TypedBean getTypedBean();

        public void setTypedBean(TypedBean var1);

        public TypedBean[][][] getTypedBean3dArray();

        public void setTypedBean3dArray(TypedBean[][][] var1);

        public List<TypedBean> getTypedBeanList();

        public void setTypedBeanList(List<TypedBean> var1);

        public List<TypedBean[][][]> getTypedBean1d3dList();

        public void setTypedBean1d3dList(List<TypedBean[][][]> var1);

        public Map<String, TypedBean> getTypedBeanMap();

        public void setTypedBeanMap(Map<String, TypedBean> var1);

        public Map<String, List<TypedBean>> getTypedBeanListMap();

        public void setTypedBeanListMap(Map<String, List<TypedBean>> var1);

        public Map<String, List<TypedBean[][][]>> getTypedBean1d3dListMap();

        public void setTypedBean1d3dListMap(Map<String, List<TypedBean[][][]>> var1);

        public Map<Integer, List<TypedBean>> getTypedBeanListMapIntegerKeys();

        public void setTypedBeanListMapIntegerKeys(Map<Integer, List<TypedBean>> var1);

        public SwappedPojo getSwappedPojo();

        public void setSwappedPojo(SwappedPojo var1);

        public SwappedPojo[][][] getSwappedPojo3dArray();

        public void setSwappedPojo3dArray(SwappedPojo[][][] var1);

        public Map<SwappedPojo, SwappedPojo> getSwappedPojoMap();

        public void setSwappedPojoMap(Map<SwappedPojo, SwappedPojo> var1);

        public Map<SwappedPojo, SwappedPojo[][][]> getSwappedPojo3dMap();

        public void setSwappedPojo3dMap(Map<SwappedPojo, SwappedPojo[][][]> var1);

        public ImplicitSwappedPojo getImplicitSwappedPojo();

        public void setImplicitSwappedPojo(ImplicitSwappedPojo var1);

        public ImplicitSwappedPojo[][][] getImplicitSwappedPojo3dArray();

        public void setImplicitSwappedPojo3dArray(ImplicitSwappedPojo[][][] var1);

        public Map<ImplicitSwappedPojo, ImplicitSwappedPojo> getImplicitSwappedPojoMap();

        public void setImplicitSwappedPojoMap(Map<ImplicitSwappedPojo, ImplicitSwappedPojo> var1);

        public Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> getImplicitSwappedPojo3dMap();

        public void setImplicitSwappedPojo3dMap(Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> var1);

        public TestEnum getEnum();

        public void setEnum(TestEnum var1);

        public TestEnum[][][] getEnum3d();

        public void setEnum3d(TestEnum[][][] var1);

        public List<TestEnum> getEnumList();

        public void setEnumList(List<TestEnum> var1);

        public List<List<List<TestEnum>>> getEnum3dList();

        public void setEnum3dList(List<List<List<TestEnum>>> var1);

        public List<TestEnum[][][]> getEnum1d3dList();

        public void setEnum1d3dList(List<TestEnum[][][]> var1);

        public Map<TestEnum, TestEnum> getEnumMap();

        public void setEnumMap(Map<TestEnum, TestEnum> var1);

        public Map<TestEnum, TestEnum[][][]> getEnum3dArrayMap();

        public void setEnum3dArrayMap(Map<TestEnum, TestEnum[][][]> var1);

        public Map<TestEnum, List<TestEnum[][][]>> getEnum1d3dListMap();

        public void setEnum1d3dListMap(Map<TestEnum, List<TestEnum[][][]>> var1);
    }
}

