/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import org.apache.juneau.config.Config;
import org.apache.juneau.config.event.ConfigEvent;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.store.ConfigMemoryStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.internal.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConfigImportsTest {
    @Test
    public void oneSimpleImport() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1");
        ms.write("B", "", "<A>");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"1", (Object)c.getString("x"));
        c.set("x", "2");
        c.commit();
        Assert.assertEquals((Object)"x=1", (Object)ms.read("A"));
        Assert.assertEquals((Object)"x = 2\n", (Object)ms.read("B"));
    }

    @Test
    public void twoSimpleImports() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A1", "", "x=1");
        ms.write("A2", "", "y=2");
        ms.write("B", "", "<A1>\n<A2>");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"1", (Object)c.getString("x"));
        Assert.assertEquals((Object)"2", (Object)c.getString("y"));
        c.set("x", "3");
        c.set("y", "4");
        c.commit();
        Assert.assertEquals((Object)"x=1", (Object)ms.read("A1"));
        Assert.assertEquals((Object)"y=2", (Object)ms.read("A2"));
        Assert.assertEquals((Object)"x = 3\ny = 4\n", (Object)ms.read("B"));
    }

    @Test
    public void nestedImports() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A1", "", "x=1");
        ms.write("A2", "", "<A1>\ny=2");
        ms.write("B", "", "<A2>");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"1", (Object)c.getString("x"));
        Assert.assertEquals((Object)"2", (Object)c.getString("y"));
        c.set("x", "3");
        c.set("y", "4");
        c.commit();
        Assert.assertEquals((Object)"x=1", (Object)ms.read("A1"));
        Assert.assertEquals((Object)"<A1>\ny=2", (Object)ms.read("A2"));
        Assert.assertEquals((Object)"x = 3\ny = 4\n", (Object)ms.read("B"));
    }

    @Test
    public void nestedImportsLoop() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A1", "", "<A2>\nx=1");
        ms.write("A2", "", "<A1>\ny=2");
        ms.write("B", "", "<A2>");
        try {
            Config.create((String)"B").store((ConfigStore)ms).build();
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void importNotFound() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("B", "", "<A>\nx=1");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"1", (Object)c.getString("x"));
    }

    @Test
    public void noOverwriteOnImports() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1");
        ms.write("B", "", "<A>");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"1", (Object)c.getString("x"));
        c.set("x", "2");
        Assert.assertEquals((Object)"2", (Object)c.getString("x"));
        Assert.assertEquals((Object)"1", (Object)Config.create((String)"A").store((ConfigStore)ms).build().getString("x"));
    }

    @Test
    public void overlappingSections() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "<A>\n[A]\na2=2");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"1", (Object)c.getString("A/a1"));
        Assert.assertEquals((Object)"2", (Object)c.getString("A/a2"));
    }

    @Test
    public void overlappingSectionsImportAtEnd() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "[A]\na2=2\n<A>");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"1", (Object)c.getString("A/a1"));
        Assert.assertEquals((Object)"2", (Object)c.getString("A/a2"));
    }

    @Test
    public void overlappingSectionsAndValues() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "<A>\n[A]\na1=2");
        Config c = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((Object)"2", (Object)c.getString("A/a1"));
    }

    @Test
    public void testUpdateOnParent() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "<A>\n[B]\nb1=2");
        Config ca = Config.create((String)"A").store((ConfigStore)ms).build();
        Config cb = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((long)2L, (long)ca.getConfigMap().getListeners().size());
        Assert.assertEquals((long)1L, (long)cb.getConfigMap().getListeners().size());
        TestListener l = new TestListener();
        cb.addListener((ConfigEventListener)l);
        Assert.assertEquals((long)0L, (long)ca.getListeners().size());
        Assert.assertEquals((long)1L, (long)cb.getListeners().size());
        ms.write("A", "x=1\n[A]\na1=1", "x=1\n[A]\na1=2");
        Assert.assertTrue((boolean)l.isTriggered());
        Assert.assertEquals((long)1L, (long)l.getEvents().size());
        Assert.assertEquals((Object)"2", (Object)l.getNewValue("A", "a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("B/b1"));
        l.reset();
        cb.removeListener((ConfigEventListener)l);
        Assert.assertEquals((long)0L, (long)ca.getListeners().size());
        Assert.assertEquals((long)0L, (long)cb.getListeners().size());
        ms.write("A", "x=1\n[A]\na1=2", "x=1\n[A]\na1=3");
        Assert.assertFalse((boolean)l.isTriggered());
        Assert.assertEquals((Object)"3", (Object)cb.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("B/b1"));
    }

    @Test
    public void testUpdateOnGrandParent() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "<A>\n[B]\nb1=2");
        ms.write("C", "", "<B>\n[C]\nc1=3");
        Config ca = Config.create((String)"A").store((ConfigStore)ms).build();
        Config cb = Config.create((String)"B").store((ConfigStore)ms).build();
        Config cc = Config.create((String)"C").store((ConfigStore)ms).build();
        Assert.assertEquals((long)3L, (long)ca.getConfigMap().getListeners().size());
        Assert.assertEquals((long)2L, (long)cb.getConfigMap().getListeners().size());
        Assert.assertEquals((long)1L, (long)cc.getConfigMap().getListeners().size());
        TestListener l = new TestListener();
        cc.addListener((ConfigEventListener)l);
        Assert.assertEquals((long)0L, (long)ca.getListeners().size());
        Assert.assertEquals((long)0L, (long)cb.getListeners().size());
        Assert.assertEquals((long)1L, (long)cc.getListeners().size());
        ms.write("A", "x=1\n[A]\na1=1", "x=1\n[A]\na1=2");
        Assert.assertTrue((boolean)l.isTriggered());
        Assert.assertEquals((long)1L, (long)l.getEvents().size());
        Assert.assertEquals((Object)"2", (Object)l.getNewValue("A", "a1"));
        Assert.assertEquals((Object)"2", (Object)cc.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cc.get("B/b1"));
        Assert.assertEquals((Object)"3", (Object)cc.get("C/c1"));
        l.reset();
        cc.removeListener((ConfigEventListener)l);
        Assert.assertEquals((long)0L, (long)ca.getListeners().size());
        Assert.assertEquals((long)0L, (long)cb.getListeners().size());
        Assert.assertEquals((long)0L, (long)cc.getListeners().size());
        ms.write("A", "x=1\n[A]\na1=2", "x=1\n[A]\na1=3");
        Assert.assertFalse((boolean)l.isTriggered());
        Assert.assertEquals((Object)"3", (Object)cc.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cc.get("B/b1"));
        Assert.assertEquals((Object)"3", (Object)cc.get("C/c1"));
    }

    @Test
    public void testUpdateOnParentSameSection() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "<A>\n[A]\nb1=2");
        Config ca = Config.create((String)"A").store((ConfigStore)ms).build();
        Config cb = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((long)2L, (long)ca.getConfigMap().getListeners().size());
        Assert.assertEquals((long)1L, (long)cb.getConfigMap().getListeners().size());
        TestListener l = new TestListener();
        cb.addListener((ConfigEventListener)l);
        ms.write("A", "x=1\n[A]\na1=1", "x=1\n[A]\na1=2");
        Assert.assertTrue((boolean)l.isTriggered());
        Assert.assertEquals((long)1L, (long)l.getEvents().size());
        Assert.assertEquals((Object)"2", (Object)l.getNewValue("A", "a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("A/b1"));
        l.reset();
        cb.removeListener((ConfigEventListener)l);
        Assert.assertEquals((long)0L, (long)ca.getListeners().size());
        Assert.assertEquals((long)0L, (long)cb.getListeners().size());
        ms.write("A", "x=1\n[A]\na1=2", "x=1\n[A]\na1=3");
        Assert.assertFalse((boolean)l.isTriggered());
        Assert.assertEquals((Object)"3", (Object)cb.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("A/b1"));
    }

    @Test
    public void testUpdateOnParentSameSectionSameKey() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "<A>\n[A]\na1=2");
        Config ca = Config.create((String)"A").store((ConfigStore)ms).build();
        Config cb = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((long)2L, (long)ca.getConfigMap().getListeners().size());
        Assert.assertEquals((long)1L, (long)cb.getConfigMap().getListeners().size());
        TestListener l = new TestListener();
        cb.addListener((ConfigEventListener)l);
        ms.write("A", "x=1\n[A]\na1=1", "x=1\n[A]\na1=3");
        Assert.assertFalse((boolean)l.isTriggered());
        Assert.assertEquals((Object)"2", (Object)cb.get("A/a1"));
    }

    @Test
    public void testUpdateOnGrandParentSameSection() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\n[A]\na1=1");
        ms.write("B", "", "<A>\n[A]\na1=2");
        ms.write("C", "", "<B>\n[A]\na1=3");
        Config ca = Config.create((String)"A").store((ConfigStore)ms).build();
        Config cb = Config.create((String)"B").store((ConfigStore)ms).build();
        Config cc = Config.create((String)"C").store((ConfigStore)ms).build();
        Assert.assertEquals((long)3L, (long)ca.getConfigMap().getListeners().size());
        Assert.assertEquals((long)2L, (long)cb.getConfigMap().getListeners().size());
        Assert.assertEquals((long)1L, (long)cc.getConfigMap().getListeners().size());
        TestListener l = new TestListener();
        cc.addListener((ConfigEventListener)l);
        ms.write("A", "x=1\n[A]\na1=1", "x=1\n[A]\na1=4");
        Assert.assertFalse((boolean)l.isTriggered());
        Assert.assertEquals((Object)"3", (Object)cc.get("A/a1"));
    }

    @Test
    public void testUpdateOnParentDynamic() throws Exception {
        ConfigMemoryStore ms = ConfigMemoryStore.create().build();
        ms.write("A", "", "x=1\ny=1\n[A]\na1=1");
        ms.write("B", "", "x=2\n[B]\nb1=2");
        Config ca = Config.create((String)"A").store((ConfigStore)ms).build();
        Config cb = Config.create((String)"B").store((ConfigStore)ms).build();
        Assert.assertEquals((long)1L, (long)ca.getConfigMap().getListeners().size());
        Assert.assertEquals((long)1L, (long)cb.getConfigMap().getListeners().size());
        TestListener l = new TestListener();
        cb.addListener((ConfigEventListener)l);
        Assert.assertEquals((long)0L, (long)ca.getListeners().size());
        Assert.assertEquals((long)1L, (long)cb.getListeners().size());
        ms.write("B", "x=2\n[B]\nb1=2", "x=2\n<A>\n[B]\nb1=2");
        Assert.assertTrue((boolean)l.isTriggered());
        Assert.assertEquals((long)2L, (long)l.getEvents().size());
        Assert.assertEquals((Object)"1", (Object)l.getNewValue("A", "a1"));
        Assert.assertEquals((Object)"1", (Object)cb.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("B/b1"));
        Assert.assertEquals((long)2L, (long)ca.getConfigMap().getListeners().size());
        Assert.assertEquals((long)1L, (long)cb.getConfigMap().getListeners().size());
        l.reset();
        ms.write("B", "x=2\n<A>\n[B]\nb1=2", "x=2\n[B]\nb1=2");
        Assert.assertTrue((boolean)l.isTriggered());
        Assert.assertEquals((long)2L, (long)l.getEvents().size());
        Assert.assertEquals(null, (Object)l.getNewValue("A", "a1"));
        Assert.assertNull((Object)cb.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("B/b1"));
        l.reset();
        cb.removeListener((ConfigEventListener)l);
        Assert.assertEquals((long)0L, (long)ca.getListeners().size());
        Assert.assertEquals((long)0L, (long)cb.getListeners().size());
        ms.write("B", "x=2\n[B]\nb1=2", "x=2\n<A>\n[B]\nb1=2");
        Assert.assertFalse((boolean)l.isTriggered());
        Assert.assertEquals((Object)"1", (Object)cb.get("A/a1"));
        Assert.assertEquals((Object)"2", (Object)cb.get("B/b1"));
    }

    public static class TestListener
    implements ConfigEventListener {
        private boolean triggered;
        private ConfigEvents events;

        public void onConfigChange(ConfigEvents events) {
            this.triggered = true;
            this.events = events;
        }

        public TestListener reset() {
            this.triggered = false;
            this.events = null;
            return this;
        }

        public boolean isTriggered() {
            return this.triggered;
        }

        public ConfigEvents getEvents() {
            return this.events;
        }

        public String getNewValue(String section, String key) {
            if (this.events.size() == 0) {
                return null;
            }
            for (ConfigEvent ce : this.events) {
                if (!StringUtils.isEquals((String)section, (String)ce.getSection()) || !StringUtils.isEquals((String)key, (String)ce.getKey())) continue;
                return ce.getValue();
            }
            return null;
        }
    }
}

