/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.io.File;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.store.ConfigFileStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.WatcherSensitivity;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.testutils.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConfigBuilderTest {
    private static File tempDir;
    private static String TEMP_DIR;

    @BeforeClass
    public static void setup() {
        tempDir = new File(System.getProperty("java.io.tmpdir"), StringUtils.generateUUID((int)12));
        TEMP_DIR = tempDir.getAbsolutePath();
    }

    @AfterClass
    public static void teardown() {
        FileUtils.delete((File)tempDir);
    }

    @Test
    public void testGet_LONGRUNNING() throws Exception {
        ConfigFileStore cfs = ConfigFileStore.create().directory(TEMP_DIR).useWatcher().watcherSensitivity(WatcherSensitivity.HIGH).build();
        ConfigBuilder cb = Config.create().store((ConfigStore)cfs).name("TestGet.cfg");
        Config cf = cb.build();
        cf.set("Test/A", "a");
        File f = new File(tempDir, "TestGet.cfg");
        Assert.assertFalse((boolean)f.exists());
        cf.commit();
        TestUtils.assertObjectEquals("{'':{},Test:{A:'a'}}", cf.toMap());
        String NL = System.getProperty("line.separator");
        cf = cf.load("[Test]" + NL + "A = b" + NL, true);
        TestUtils.assertObjectEquals("{'':{},Test:{A:'b'}}", cf.toMap());
    }
}

