/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class BeanIgnoreTest {
    @Test
    public void testBeanIgnoreOnProperties() throws Exception {
        TestUtils.assertObjectEquals("{c:'c',a:'a'}", new A());
    }

    @Test
    public void testBeanIgnoreOnProperties_usingConfig() throws Exception {
        TestUtils.assertObjectEquals("{c:'c',a:'a'}", new Ac(), (WriterSerializer)SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{Ac.class}).build());
    }

    @Test
    public void testBeanIgnoreOnBean() throws Exception {
        TestUtils.assertObjectEquals("{f2:2,f3:'xxx',f4:'xxx'}", new B());
    }

    @Test
    public void testBeanIgnoreOnBean_usingConfig() throws Exception {
        TestUtils.assertObjectEquals("{f2:2,f3:'xxx',f4:'xxx'}", new Bc(), (WriterSerializer)SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{B1c.class}).build());
    }

    public static class Bc {
        public int f2 = 2;
        public B1c f3 = new B1c();

        public B1c getF4() {
            return new B1c();
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="B1c")})
    public static class B1c {
        public int f = 1;

        public String toString() {
            return "xxx";
        }
    }

    public static class B {
        public int f2 = 2;
        public B1 f3 = new B1();

        public B1 getF4() {
            return new B1();
        }
    }

    @BeanIgnore
    public static class B1 {
        public int f = 1;

        public String toString() {
            return "xxx";
        }
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="Ac.getB"), @BeanIgnore(on="Ac.d")})
    public static class Ac {
        public String c = "c";
        public String d = "d";

        public String getA() {
            return "a";
        }

        public String getB() {
            return "b";
        }
    }

    public static class A {
        public String c = "c";
        @BeanIgnore
        public String d = "d";

        public String getA() {
            return "a";
        }

        @BeanIgnore
        public String getB() {
            return "b";
        }
    }
}

