/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class RountTripBeansWithBuilders
extends RoundTripTest {
    public RountTripBeansWithBuilders(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
        this.applyAnnotations(Ac.class);
    }

    @Test
    public void simple() throws Exception {
        A a = A.create().f1(1).build();
        a = this.roundTrip(a, (Type)((Object)A.class), new Type[0]);
        TestUtils.assertObjectEquals("{f1:1}", a);
    }

    @Test
    public void simple_usingConfig() throws Exception {
        Ac a = Ac.create().f1(1).build();
        a = this.roundTrip(a, (Type)((Object)Ac.class), new Type[0]);
        TestUtils.assertObjectEquals("{f1:1}", a);
    }

    @Test
    public void beanPropertyBuilder_simple() throws Exception {
        A2 a = A2.create().f1(A.create().f1(1).build()).build();
        a = this.roundTrip(a, (Type)((Object)A2.class), new Type[0]);
        TestUtils.assertObjectEquals("{f1:{f1:1}}", a);
    }

    @Test
    public void beanPropertyBuilder_collections() throws Exception {
        if (this.label.equals("UrlEncoding - expanded params")) {
            return;
        }
        A3 a = A3.create().f1(new A[]{A.create().f1(1).build()}).f2(Collections.singletonList(A.create().f1(2).build())).f3(Collections.singletonList(Collections.singletonList(A.create().f1(3).build()))).f4(Collections.singletonList(new A[]{A.create().f1(4).build()})).f5(Collections.singletonList(Collections.singletonList(new A[]{A.create().f1(5).build()}))).f6(Collections.singletonMap("foo", A.create().f1(6).build())).f7(Collections.singletonMap("foo", Collections.singletonMap("bar", A.create().f1(7).build()))).f8(Collections.singletonMap("foo", new A[]{A.create().f1(8).build()})).f9(Collections.singletonMap("foo", Collections.singletonList(new A[]{A.create().f1(9).build()}))).build();
        a = this.roundTrip(a, (Type)((Object)A3.class), new Type[0]);
        TestUtils.assertObjectEquals("{f1:[{f1:1}],f2:[{f1:2}],f3:[[{f1:3}]],f4:[[{f1:4}]],f5:[[[{f1:5}]]],f6:{foo:{f1:6}},f7:{foo:{bar:{f1:7}}},f8:{foo:[{f1:8}]},f9:{foo:[[{f1:9}]]}}", a);
    }

    @Bean(sort=true)
    public static class A3 {
        private final A[] f1;
        private final List<A> f2;
        private final List<List<A>> f3;
        private final List<A[]> f4;
        private final List<List<A[]>> f5;
        private final Map<String, A> f6;
        private final Map<String, Map<String, A>> f7;
        private final Map<String, A[]> f8;
        private final Map<String, List<A[]>> f9;

        public A3(Builder b) {
            this.f1 = b.f1;
            this.f2 = b.f2;
            this.f3 = b.f3;
            this.f4 = b.f4;
            this.f5 = b.f5;
            this.f6 = b.f6;
            this.f7 = b.f7;
            this.f8 = b.f8;
            this.f9 = b.f9;
        }

        public static Builder create() {
            return new Builder();
        }

        public A[] getF1() {
            return this.f1;
        }

        public List<A> getF2() {
            return this.f2;
        }

        public List<List<A>> getF3() {
            return this.f3;
        }

        public List<A[]> getF4() {
            return this.f4;
        }

        public List<List<A[]>> getF5() {
            return this.f5;
        }

        public Map<String, A> getF6() {
            return this.f6;
        }

        public Map<String, Map<String, A>> getF7() {
            return this.f7;
        }

        public Map<String, A[]> getF8() {
            return this.f8;
        }

        public Map<String, List<A[]>> getF9() {
            return this.f9;
        }

        @Bean(fluentSetters=true)
        public static class Builder {
            private A[] f1;
            private List<A> f2;
            private List<List<A>> f3;
            private List<A[]> f4;
            private List<List<A[]>> f5;
            private Map<String, A> f6;
            private Map<String, Map<String, A>> f7;
            private Map<String, A[]> f8;
            private Map<String, List<A[]>> f9;

            public Builder f1(A[] f1) {
                this.f1 = f1;
                return this;
            }

            public Builder f2(List<A> f2) {
                this.f2 = f2;
                return this;
            }

            public Builder f3(List<List<A>> f3) {
                this.f3 = f3;
                return this;
            }

            public Builder f4(List<A[]> f4) {
                this.f4 = f4;
                return this;
            }

            public Builder f5(List<List<A[]>> f5) {
                this.f5 = f5;
                return this;
            }

            public Builder f6(Map<String, A> f6) {
                this.f6 = f6;
                return this;
            }

            public Builder f7(Map<String, Map<String, A>> f7) {
                this.f7 = f7;
                return this;
            }

            public Builder f8(Map<String, A[]> f8) {
                this.f8 = f8;
                return this;
            }

            public Builder f9(Map<String, List<A[]>> f9) {
                this.f9 = f9;
                return this;
            }

            public A3 build() {
                return new A3(this);
            }
        }
    }

    public static class A2 {
        private final A f1;

        public A2(Builder b) {
            this.f1 = b.f1;
        }

        public static Builder create() {
            return new Builder();
        }

        public A getF1() {
            return this.f1;
        }

        @Bean(fluentSetters=true)
        public static class Builder {
            private A f1;

            public Builder f1(A f1) {
                this.f1 = f1;
                return this;
            }

            public A2 build() {
                return new A2(this);
            }
        }
    }

    @BeanConfig(applyBean={@Bean(on="Builder", fluentSetters=true)})
    public static class Ac {
        private final int f1;

        public Ac(Builder b) {
            this.f1 = b.f1;
        }

        public static Builder create() {
            return new Builder();
        }

        public int getF1() {
            return this.f1;
        }

        public static class Builder {
            private int f1;

            public Builder f1(int f1) {
                this.f1 = f1;
                return this;
            }

            public Ac build() {
                return new Ac(this);
            }
        }
    }

    public static class A {
        private final int f1;

        public A(Builder b) {
            this.f1 = b.f1;
        }

        public static Builder create() {
            return new Builder();
        }

        public int getF1() {
            return this.f1;
        }

        @Bean(fluentSetters=true)
        public static class Builder {
            private int f1;

            public Builder f1(int f1) {
                this.f1 = f1;
                return this;
            }

            public A build() {
                return new A(this);
            }
        }
    }
}

