/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class RoundTripTrimStringsTest
extends RoundTripTest {
    public RoundTripTrimStringsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void test() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        Serializer s2 = s.builder().trimStrings().build();
        Parser p2 = p.builder().trimStrings().build();
        Object in = " foo bar ";
        Object e = "foo bar";
        Object a = p.parse(s2.serialize(in), String.class);
        TestUtils.assertEqualObjects(e, a);
        a = p2.parse(s.serialize(in), String.class);
        TestUtils.assertEqualObjects(e, a);
        in = new ObjectMap((CharSequence)"{' foo ': ' bar '}");
        e = new ObjectMap((CharSequence)"{foo:'bar'}");
        a = p.parse(s2.serialize(in), ObjectMap.class);
        TestUtils.assertEqualObjects(e, a);
        a = p2.parse(s.serialize(in), ObjectMap.class);
        TestUtils.assertEqualObjects(e, a);
        in = new ObjectList((CharSequence)"[' foo ', {' foo ': ' bar '}]");
        e = new ObjectList((CharSequence)"['foo',{foo:'bar'}]");
        a = p.parse(s2.serialize(in), ObjectList.class);
        TestUtils.assertEqualObjects(e, a);
        a = p2.parse(s.serialize(in), ObjectList.class);
        TestUtils.assertEqualObjects(e, a);
        in = new A().init1();
        e = new A().init2();
        a = p.parse(s2.serialize(in), A.class);
        TestUtils.assertEqualObjects(e, a);
        a = p2.parse(s.serialize(in), A.class);
        TestUtils.assertEqualObjects(e, a);
    }

    public static class A {
        public String f1;
        public String[] f2;
        public ObjectList f3;
        public ObjectMap f4;

        public A init1() throws Exception {
            this.f1 = " f1 ";
            this.f2 = new String[]{" f2a ", " f2b "};
            this.f3 = new ObjectList((CharSequence)"[' f3a ',' f3b ']");
            this.f4 = new ObjectMap((CharSequence)"{' foo ':' bar '}");
            return this;
        }

        public A init2() throws Exception {
            this.f1 = "f1";
            this.f2 = new String[]{"f2a", "f2b"};
            this.f3 = new ObjectList((CharSequence)"['f3a','f3b']");
            this.f4 = new ObjectMap((CharSequence)"{'foo':'bar'}");
            return this;
        }
    }
}

