/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.StringSwap;
import org.apache.juneau.transform.Surrogate;
import org.apache.juneau.transforms.ByteArraySwap;
import org.apache.juneau.transforms.TemporalCalendarSwap;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripTransformBeansTest
extends RoundTripTest {
    public RoundTripTransformBeansTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s == null ? null : s.applyAnnotations(new Class[]{Bc.class, E1c.class, F1c.class, F2ac.class}), p == null ? null : p.applyAnnotations(new Class[]{Bc.class, E1c.class, F1c.class, F2ac.class}), flags);
    }

    @Test
    public void testSwapBeans1() throws Exception {
        Class[] f = new Class[]{ByteArraySwap.Base64.class};
        this.pojoSwaps(f);
        A t = new A().init();
        t = this.roundTrip(t, (Type)((Object)A.class), new Type[0]);
        Assert.assertEquals((long)3L, (long)t.fByte[3]);
        Assert.assertNull((Object)t.fnByte);
        Assert.assertEquals((long)5L, (long)t.faByte[2][1]);
        Assert.assertEquals((long)6L, (long)t.flByte.get(1)[2]);
        Assert.assertNull((Object)t.flByte.get(2));
        Assert.assertEquals((long)6L, (long)t.fmByte.get("bar")[2]);
        Assert.assertNull((Object)t.fmByte.get("baz"));
        t.fCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Assert.assertEquals((long)2001L, (long)t.fCalendar.get(1));
        Assert.assertEquals((long)1L, (long)t.fCalendar.get(2));
        Assert.assertEquals((long)2L, (long)t.fCalendar.get(5));
        Assert.assertEquals((long)3L, (long)t.fCalendar.get(10));
        Assert.assertEquals((long)4L, (long)t.fCalendar.get(12));
        Assert.assertEquals((long)5L, (long)t.fCalendar.get(13));
        t.faCalendar[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        Assert.assertEquals((long)2001L, (long)t.faCalendar[0].get(1));
        Assert.assertEquals((long)1L, (long)t.faCalendar[0].get(2));
        Assert.assertEquals((long)2L, (long)t.faCalendar[0].get(5));
        Assert.assertEquals((long)3L, (long)t.faCalendar[0].get(10));
        Assert.assertEquals((long)4L, (long)t.faCalendar[0].get(12));
        Assert.assertEquals((long)5L, (long)t.faCalendar[0].get(13));
        Assert.assertNull((Object)t.fnCalendar);
        Assert.assertNull((Object)t.fn2Calendar);
        Assert.assertEquals((long)1000L, (long)t.fDate.getTime());
        Assert.assertNull((Object)t.fnDate);
        Assert.assertEquals((long)3000L, (long)t.faDate[2].getTime());
        Assert.assertEquals((long)4000L, (long)t.flDate.get(0).getTime());
        Assert.assertNull((Object)t.flDate.get(1));
        Assert.assertEquals((long)5000L, (long)t.fmDate.get("foo").getTime());
        Assert.assertNull((Object)t.fmDate.get("bar"));
    }

    @Test
    public void testSwapBeans2() throws Exception {
        Class[] f = new Class[]{ByteArraySwap.Base64.class};
        this.pojoSwaps(f);
        A t = new A().init();
        t = this.roundTrip(t, (Type)((Object)A.class), new Type[0]);
        Assert.assertEquals((long)3L, (long)t.fByte[3]);
        Assert.assertNull((Object)t.fnByte);
        Assert.assertEquals((long)5L, (long)t.faByte[2][1]);
        Assert.assertEquals((long)6L, (long)t.flByte.get(1)[2]);
        Assert.assertNull((Object)t.flByte.get(2));
        Assert.assertEquals((long)6L, (long)t.fmByte.get("bar")[2]);
        Assert.assertNull((Object)t.fmByte.get("baz"));
        t.fCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Assert.assertEquals((long)2001L, (long)t.fCalendar.get(1));
        Assert.assertEquals((long)1L, (long)t.fCalendar.get(2));
        t.faCalendar[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        Assert.assertEquals((long)2001L, (long)t.faCalendar[0].get(1));
        Assert.assertEquals((long)1L, (long)t.faCalendar[0].get(2));
        Assert.assertNull((Object)t.fnCalendar);
        Assert.assertNull((Object)t.fn2Calendar);
        Assert.assertEquals((long)1000L, (long)(t.fDate.getTime() % 3600000L));
        Assert.assertNull((Object)t.fnDate);
        Assert.assertEquals((long)3000L, (long)(t.faDate[2].getTime() % 3600000L));
        Assert.assertEquals((long)4000L, (long)(t.flDate.get(0).getTime() % 3600000L));
        Assert.assertNull((Object)t.flDate.get(1));
        Assert.assertEquals((long)5000L, (long)(t.fmDate.get("foo").getTime() % 3600000L));
        Assert.assertNull((Object)t.fmDate.get("bar"));
    }

    @Test
    public void testSwaps() throws Exception {
        B t = new B();
        t.f1 = "bar";
        t = this.roundTrip(t, (Type)((Object)B.class), new Type[0]);
        Assert.assertEquals((Object)"bar", (Object)t.f1);
    }

    @Test
    public void testSwaps_usingConfig() throws Exception {
        Bc t = new Bc();
        t.f1 = "bar";
        t = this.roundTrip(t, (Type)((Object)Bc.class), new Type[0]);
        Assert.assertEquals((Object)"bar", (Object)t.f1);
    }

    @Test
    public void testXMLGregorianCalendar() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        GregorianCalendar gc = new GregorianCalendar();
        XMLGregorianCalendar c = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        Object r = s.serialize((Object)c);
        XMLGregorianCalendar c2 = (XMLGregorianCalendar)p.parse(r, XMLGregorianCalendar.class);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @Test
    public void testSubTypeWithGenerics() throws Exception {
        JsonSerializer s = JsonSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
        C3 c1 = C3.create();
        String r = s.serialize((Object)c1);
        Assert.assertEquals((Object)"{\"_type\":\"C3\",\"f1\":{\"f2\":\"f2\",\"f3\":3}}", (Object)r);
    }

    @Test
    public void testSurrogates() throws Exception {
        this.pojoSwaps(D2.class);
        JsonSerializer s = JsonSerializer.create().ssq().pojoSwaps(new Class[]{D2.class}).build();
        JsonParser p = JsonParser.create().pojoSwaps(new Class[]{D2.class}).build();
        D1 x = D1.create();
        Object r = s.serialize((Object)x);
        Assert.assertEquals((Object)"{f2:'f1'}", (Object)r);
        x = (D1)p.parse(r, D1.class);
        Assert.assertEquals((Object)"f1", (Object)x.f1);
        r = this.getSerializer().serialize((Object)x);
        Assert.assertTrue((boolean)TestUtils.toString(r).contains("f2"));
        x = this.roundTrip(x, (Type)((Object)D1.class), new Type[0]);
    }

    @Test
    public void testSurrogatesThroughAnnotation() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        JsonParser p = JsonParser.DEFAULT;
        E1 x = E1.create();
        Object r = s.serialize((Object)x);
        Assert.assertEquals((Object)"{f2:'f1'}", (Object)r);
        x = (E1)p.parse(r, E1.class);
        Assert.assertEquals((Object)"f1", (Object)x.f1);
        r = this.getSerializer().serialize((Object)x);
        Assert.assertTrue((boolean)TestUtils.toString(r).contains("f2"));
        x = this.roundTrip(x, (Type)((Object)E1.class), new Type[0]);
    }

    @Test
    public void testSurrogatesThroughAnnotation_usingConfig() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{E1c.class}).build();
        JsonParser p = JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{E1c.class}).build();
        E1c x = E1c.create();
        Object r = s.serialize((Object)x);
        Assert.assertEquals((Object)"{f2:'f1'}", (Object)r);
        x = (E1c)p.parse(r, E1c.class);
        Assert.assertEquals((Object)"f1", (Object)x.f1);
        r = this.getSerializer().serialize((Object)x);
        Assert.assertTrue((boolean)TestUtils.toString(r).contains("f2"));
        x = this.roundTrip(x, (Type)((Object)E1c.class), new Type[0]);
    }

    @Test
    public void testSwapOnPrivateField() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        JsonParser p = JsonParser.DEFAULT;
        F1 x = F1.create();
        String r = null;
        r = s.serialize((Object)x);
        Assert.assertEquals((Object)"{c:'2018-12-12T05:12:00'}", (Object)r);
        x = (F1)p.parse(r, F1.class);
        TestUtils.assertObjectEquals("{c:'2018-12-12T05:12:00'}", x);
        x = this.roundTrip(x, (Type)((Object)F1.class), new Type[0]);
    }

    @Test
    public void testSwapOnPrivateField_usingConfig() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{F1c.class}).build();
        JsonParser p = JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{F1c.class}).build();
        F1c x = F1c.create();
        String r = null;
        r = s.serialize((Object)x);
        Assert.assertEquals((Object)"{c:'2018-12-12T05:12:00'}", (Object)r);
        x = (F1c)p.parse(r, F1c.class);
        TestUtils.assertObjectEquals("{c:'2018-12-12T05:12:00'}", x, (WriterSerializer)s);
        x = this.roundTrip(x, (Type)((Object)F1c.class), new Type[0]);
    }

    @Test
    public void testSwapOnPrivateField_Inherited() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        JsonParser p = JsonParser.DEFAULT;
        F2 x = F2.create();
        String r = null;
        r = s.serialize((Object)x);
        Assert.assertEquals((Object)"{c:'2018-12-12T05:12:00'}", (Object)r);
        x = (F2)p.parse(r, F2.class);
        TestUtils.assertObjectEquals("{c:'2018-12-12T05:12:00'}", x);
        x = this.roundTrip(x, (Type)((Object)F2.class), new Type[0]);
    }

    @Test
    public void testSwapOnPrivateField_Inherited_usingConfig() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{F2ac.class}).build();
        JsonParser p = JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{F2ac.class}).build();
        F2 x = F2.create();
        String r = null;
        r = s.serialize((Object)x);
        Assert.assertEquals((Object)"{c:'2018-12-12T05:12:00'}", (Object)r);
        x = (F2)p.parse(r, F2.class);
        TestUtils.assertObjectEquals("{c:'2018-12-12T05:12:00'}", x, (WriterSerializer)s);
        x = this.roundTrip(x, (Type)((Object)F2.class), new Type[0]);
    }

    public static class F2c
    extends F2ac {
        public void setC(Calendar c) {
            this.c = c;
        }

        public Calendar getC() {
            return this.c;
        }

        public static F2c create() {
            F2c x = new F2c();
            x.setC(DateUtils.parseISO8601Calendar((String)"2018-12-12T05:12:00"));
            return x;
        }
    }

    @BeanConfig(applySwap={@Swap(on="F2ac.c", value=TemporalCalendarSwap.IsoLocalDateTime.class)})
    public static class F2ac {
        protected Calendar c;
    }

    public static class F2
    extends F2a {
        public void setC(Calendar c) {
            this.c = c;
        }

        public Calendar getC() {
            return this.c;
        }

        public static F2 create() {
            F2 x = new F2();
            x.setC(DateUtils.parseISO8601Calendar((String)"2018-12-12T05:12:00"));
            return x;
        }
    }

    public static class F2a {
        @Swap(value=TemporalCalendarSwap.IsoLocalDateTime.class)
        protected Calendar c;
    }

    @BeanConfig(applySwap={@Swap(on="F1c.c", value=TemporalCalendarSwap.IsoLocalDateTime.class)})
    public static class F1c {
        private Calendar c;

        public void setC(Calendar c) {
            this.c = c;
        }

        public Calendar getC() {
            return this.c;
        }

        public static F1c create() {
            F1c x = new F1c();
            x.setC(DateUtils.parseISO8601Calendar((String)"2018-12-12T05:12:00"));
            return x;
        }
    }

    public static class F1 {
        @Swap(value=TemporalCalendarSwap.IsoLocalDateTime.class)
        private Calendar c;

        public void setC(Calendar c) {
            this.c = c;
        }

        public Calendar getC() {
            return this.c;
        }

        public static F1 create() {
            F1 x = new F1();
            x.setC(DateUtils.parseISO8601Calendar((String)"2018-12-12T05:12:00"));
            return x;
        }
    }

    public static class E2c
    implements Surrogate {
        public String f2;

        public E2c(E1c x) {
            this.f2 = x.f1;
        }

        public E2c() {
        }

        public E1c create() {
            E1c x = new E1c();
            x.f1 = this.f2;
            return x;
        }
    }

    @BeanConfig(applySwap={@Swap(on="E1c", value=E2c.class)})
    public static class E1c {
        public String f1;

        public static E1c create() {
            E1c x = new E1c();
            x.f1 = "f1";
            return x;
        }
    }

    public static class E2
    implements Surrogate {
        public String f2;

        public E2(E1 x) {
            this.f2 = x.f1;
        }

        public E2() {
        }

        public E1 create() {
            E1 x = new E1();
            x.f1 = this.f2;
            return x;
        }
    }

    @Swap(value=E2.class)
    public static class E1 {
        public String f1;

        public static E1 create() {
            E1 x = new E1();
            x.f1 = "f1";
            return x;
        }
    }

    public static class D2
    implements Surrogate {
        public String f2;

        public D2(D1 x) {
            this.f2 = x.f1;
        }

        public D2() {
        }

        public D1 create() {
            D1 x = new D1();
            x.f1 = this.f2;
            return x;
        }
    }

    public static class D1 {
        public String f1;

        public static D1 create() {
            D1 x = new D1();
            x.f1 = "f1";
            return x;
        }
    }

    public static class CDTO {
        public String f2;
        public int f3;
    }

    @Bean(typeName="C3")
    public static class C3<T>
    extends C2<T> {
        public static C3 create() {
            C3 c3 = new C3();
            CDTO cdto = new CDTO();
            cdto.f2 = "f2";
            cdto.f3 = 3;
            c3.f1 = cdto;
            return c3;
        }

        @Override
        public void setF1(T f1) {
            this.f1 = f1;
        }

        @Override
        public T getF1() {
            return (T)this.f1;
        }
    }

    public static abstract class C2<T>
    implements C1<T> {
        protected T f1;

        @Override
        public void setF1(T f1) {
            this.f1 = f1;
        }

        @Override
        public T getF1() {
            return this.f1;
        }
    }

    @Bean(dictionary={C3.class})
    public static interface C1<T>
    extends Serializable {
        public void setF1(T var1);

        public T getF1();
    }

    public static class BcSwap
    extends StringSwap<Bc> {
        public String swap(BeanSession session, Bc o) throws SerializeException {
            return o.f1;
        }

        public Bc unswap(BeanSession session, String f, ClassMeta<?> hint) throws ParseException {
            Bc b1 = new Bc();
            b1.f1 = f;
            return b1;
        }
    }

    @BeanConfig(applySwap={@Swap(on="Bc", value=BcSwap.class)})
    public static class Bc {
        public String f1;
    }

    public static class BSwap
    extends StringSwap<B> {
        public String swap(BeanSession session, B o) throws SerializeException {
            return o.f1;
        }

        public B unswap(BeanSession session, String f, ClassMeta<?> hint) throws ParseException {
            B b1 = new B();
            b1.f1 = f;
            return b1;
        }
    }

    @Swap(value=BSwap.class)
    public static class B {
        public String f1;
    }

    public static class A {
        public byte[] fByte;
        public byte[] fnByte;
        public byte[][] faByte;
        public List<byte[]> flByte;
        public Map<String, byte[]> fmByte;
        public GregorianCalendar fCalendar;
        public GregorianCalendar fnCalendar;
        public Calendar fn2Calendar;
        public GregorianCalendar[] faCalendar;
        public Date fDate;
        public Date fnDate;
        public Date[] faDate;
        public List<Date> flDate;
        public Map<String, Date> fmDate;

        public A init() {
            this.fByte = new byte[]{0, 1, 2, 3};
            this.fnByte = null;
            this.faByte = new byte[][]{{0, 1}, {2, 3}, {4, 5}};
            this.flByte = new AList().append((Object)new byte[]{1, 2, 3}).append((Object)new byte[]{4, 5, 6}).append(null);
            this.fmByte = new AMap().append((Object)"foo", (Object)new byte[]{1, 2, 3}).append((Object)"bar", (Object)new byte[]{4, 5, 6}).append((Object)"baz", null);
            this.fCalendar = new GregorianCalendar(){
                {
                    this.set(2001, 1, 2, 3, 4, 5);
                    this.setTimeZone(TimeZone.getTimeZone("GMT"));
                }
            };
            this.fnCalendar = null;
            this.fn2Calendar = null;
            this.faCalendar = new GregorianCalendar[]{new GregorianCalendar(){
                {
                    this.set(2001, 1, 2, 3, 4, 5);
                    this.setTimeZone(TimeZone.getTimeZone("GMT"));
                }
            }};
            this.fDate = new Date(1000L);
            this.fnDate = null;
            this.faDate = new Date[]{new Date(1000L), new Date(2000L), new Date(3000L)};
            this.flDate = new AList().append((Object)new Date(4000L)).append(null);
            this.fmDate = new AMap().append((Object)"foo", (Object)new Date(5000L)).append((Object)"bar", null);
            return this;
        }
    }
}

