/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripToObjectMapsTest
extends RoundTripTest {
    public RoundTripToObjectMapsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void test() throws Exception {
        A a = new A(new ObjectMap((CharSequence)"{f1:'a',f2:2}"));
        a = this.roundTrip(a, (Type)((Object)A.class), new Type[0]);
        Assert.assertEquals((Object)"a", (Object)a.f1);
        Assert.assertEquals((long)2L, (long)a.f2);
        A[] aa = new A[]{a};
        aa = this.roundTrip(aa, (Type)((Object)A[].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)aa.length);
        Assert.assertEquals((Object)"a", (Object)aa[0].f1);
        Assert.assertEquals((long)2L, (long)aa[0].f2);
        Object a2 = new AList().append((Object)new A(new ObjectMap((CharSequence)"{f1:'a',f2:2}")));
        a2 = (List)this.roundTrip(a2, (Type)((Object)List.class), new Type[]{A.class});
        Assert.assertEquals((long)1L, (long)a2.size());
        Assert.assertEquals((Object)"a", (Object)((A)a2.get(0)).f1);
        Assert.assertEquals((long)2L, (long)((A)a2.get(0)).f2);
        Object a3 = new AMap().append((Object)"a", (Object)new A(new ObjectMap((CharSequence)"{f1:'a',f2:2}")));
        a3 = (Map)this.roundTrip(a3, (Type)((Object)Map.class), new Type[]{String.class, A.class});
        Assert.assertEquals((long)1L, (long)a3.size());
        Assert.assertEquals((Object)"a", (Object)((A)a3.get("a")).f1);
        Assert.assertEquals((long)2L, (long)((A)a3.get("a")).f2);
    }

    public static class A {
        private String f1;
        private int f2;

        public A(ObjectMap m) {
            this.f1 = m.getString("f1");
            this.f2 = m.getInt("f2");
        }

        public ObjectMap swap(BeanSession session) {
            return new ObjectMap().append("f1", (Object)this.f1).append("f2", (Object)this.f2);
        }
    }
}

